/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.util.Log;
import android.view.MenuItem;
import android.widget.Toast;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserContract;

public class SearchPreferenceActivity
extends PreferenceActivity {
    private static final String LOG_TAG = "SearchPreferenceActivity";
    public static final String PREF_CLEAR_HISTORY_KEY = "search.not_a_preference.clear_history";

    protected void onCreate(Bundle bundle) {
        Locales.initializeLocale((Context)this.getApplicationContext());
        super.onCreate(bundle);
        this.getPreferenceManager().setSharedPreferencesName("GeckoApp");
        if (Build.VERSION.SDK_INT >= 11 && this.getActionBar() != null) {
            this.getActionBar().setDisplayHomeAsUpEnabled(true);
        }
    }

    protected void onPostCreate(Bundle bundle) {
        super.onPostCreate(bundle);
        this.setupPrefsScreen();
    }

    private void setupPrefsScreen() {
        this.addPreferencesFromResource(R.xml.search_preferences);
        Preference preference = this.findPreference(PREF_CLEAR_HISTORY_KEY);
        preference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

            public boolean onPreferenceClick(Preference preference) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)SearchPreferenceActivity.this);
                builder.setNegativeButton(0x1040000, null);
                builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        Telemetry.sendUIEvent((TelemetryContract.Event)TelemetryContract.Event.SANITIZE, (TelemetryContract.Method)TelemetryContract.Method.MENU, (String)"search-history");
                        SearchPreferenceActivity.this.clearHistory();
                    }
                });
                builder.setMessage(R.string.pref_clearHistory_dialogMessage);
                builder.show();
                return false;
            }
        });
    }

    private void clearHistory() {
        AsyncTask<Void, Void, Boolean> asyncTask = new AsyncTask<Void, Void, Boolean>(){

            protected Boolean doInBackground(Void ... voidArray) {
                int n = SearchPreferenceActivity.this.getContentResolver().delete(BrowserContract.SearchHistory.CONTENT_URI, null, null);
                return n >= 0;
            }

            protected void onPostExecute(Boolean bl) {
                if (bl.booleanValue()) {
                    SearchPreferenceActivity.this.getContentResolver().notifyChange(BrowserContract.SearchHistory.CONTENT_URI, null);
                    Toast.makeText((Context)SearchPreferenceActivity.this, (CharSequence)SearchPreferenceActivity.this.getResources().getString(R.string.pref_clearHistory_confirmation), (int)0).show();
                } else {
                    Log.e((String)SearchPreferenceActivity.LOG_TAG, (String)"Error clearing search history.");
                }
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == 16908332) {
            this.finish();
            return true;
        }
        return false;
    }
}

