/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.Context;
import android.content.Intent;
import org.mozilla.gecko.AppConstants;

public class InputOptionsUtils {
    public static boolean supportsVoiceRecognizer(Context context, String string) {
        if (AppConstants.Versions.preICS) {
            return false;
        }
        Intent intent = InputOptionsUtils.createVoiceRecognizerIntent(string);
        return intent.resolveActivity(context.getPackageManager()) != null;
    }

    public static Intent createVoiceRecognizerIntent(String string) {
        Intent intent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        intent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        intent.putExtra("android.speech.extra.MAX_RESULTS", 1);
        intent.putExtra("android.speech.extra.PROMPT", string);
        return intent;
    }

    public static boolean supportsIntent(Intent intent, Context context) {
        return intent.resolveActivity(context.getPackageManager()) != null;
    }

    public static boolean supportsQrCodeReader(Context context) {
        Intent intent = InputOptionsUtils.createQRCodeReaderIntent();
        return InputOptionsUtils.supportsIntent(intent, context);
    }

    public static Intent createQRCodeReaderIntent() {
        Intent intent = new Intent("com.google.zxing.client.android.SCAN");
        intent.setPackage("com.google.zxing.client.android");
        intent.putExtra("SCAN_MODE", "QR_CODE_MODE");
        intent.addFlags(0x4000000);
        return intent;
    }
}

