/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.Restrictions;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.Engaged;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.sync.SyncConfiguration;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;

public class AccountsHelper
implements NativeEventListener {
    public static final String LOGTAG = "GeckoAccounts";
    protected final Context mContext;
    protected final GeckoProfile mProfile;

    public AccountsHelper(Context context, GeckoProfile geckoProfile) {
        this.mContext = context;
        this.mProfile = geckoProfile;
        EventDispatcher eventDispatcher = EventDispatcher.getInstance();
        if (eventDispatcher == null) {
            Log.e((String)LOGTAG, (String)"Gecko event dispatcher must not be null", (Throwable)new RuntimeException());
            return;
        }
        eventDispatcher.registerGeckoThreadListener(this, "Accounts:CreateFirefoxAccountFromJSON", "Accounts:UpdateFirefoxAccountFromJSON", "Accounts:Create", "Accounts:DeleteFirefoxAccount", "Accounts:Exist", "Accounts:ProfileUpdated", "Accounts:ShowSyncPreferences");
    }

    public synchronized void uninit() {
        EventDispatcher eventDispatcher = EventDispatcher.getInstance();
        if (eventDispatcher == null) {
            Log.e((String)LOGTAG, (String)"Gecko event dispatcher must not be null", (Throwable)new RuntimeException());
            return;
        }
        eventDispatcher.unregisterGeckoThreadListener(this, "Accounts:CreateFirefoxAccountFromJSON", "Accounts:UpdateFirefoxAccountFromJSON", "Accounts:Create", "Accounts:DeleteFirefoxAccount", "Accounts:Exist", "Accounts:ProfileUpdated", "Accounts:ShowSyncPreferences");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMessage(String string2, NativeJSObject nativeJSObject, final EventCallback eventCallback) {
        if (!Restrictions.isAllowed(this.mContext, Restrictable.MODIFY_ACCOUNTS)) {
            Log.e((String)LOGTAG, (String)("Profile is not allowed to modify accounts!  Ignoring event: " + string2));
            if (eventCallback == null) return;
            eventCallback.sendError((Object)"Profile is not allowed to modify accounts!");
            return;
        }
        if ("Accounts:CreateFirefoxAccountFromJSON".equals(string2)) {
            AndroidFxAccount androidFxAccount;
            block33: {
                androidFxAccount = null;
                try {
                    NativeJSObject nativeJSObject2 = nativeJSObject.getObject("json");
                    String string3 = nativeJSObject2.getString("email");
                    String string4 = nativeJSObject2.getString("uid");
                    boolean bl = nativeJSObject2.optBoolean("verified", false);
                    byte[] byArray = Utils.hex2Byte((String)nativeJSObject2.getString("unwrapBKey"));
                    byte[] byArray2 = Utils.hex2Byte((String)nativeJSObject2.getString("sessionToken"));
                    byte[] byArray3 = Utils.hex2Byte((String)nativeJSObject2.getString("keyFetchToken"));
                    String string5 = nativeJSObject2.optString("authServerEndpoint", "https://api.accounts.firefox.com/v1");
                    String string6 = nativeJSObject2.optString("tokenServerEndpoint", "https://token.services.mozilla.com/1.0/sync/1.5");
                    String string7 = nativeJSObject2.optString("profileServerEndpoint", "https://profile.accounts.firefox.com/v1");
                    Engaged engaged = new Engaged(string3, string4, bl, byArray, byArray2, byArray3);
                    androidFxAccount = AndroidFxAccount.addAndroidAccount((Context)this.mContext, (String)string3, (String)this.mProfile.getName(), (String)string5, (String)string6, (String)string7, (State)engaged, (Map)AndroidFxAccount.DEFAULT_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP);
                    String[] stringArray = nativeJSObject2.optStringArray("declinedSyncEngines", null);
                    if (stringArray != null) {
                        Log.i((String)LOGTAG, (String)"User has selected engines; storing to prefs.");
                        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                        for (String string8 : SyncConfiguration.validEngineNames()) {
                            hashMap.put(string8, true);
                        }
                        for (String string9 : stringArray) {
                            hashMap.put(string9, false);
                        }
                        hashMap.put("forms", (Boolean)hashMap.get("history"));
                        FxAccountUtils.pii((String)LOGTAG, (String)("User selected engines: " + ((Object)hashMap).toString()));
                        try {
                            SyncConfiguration.storeSelectedEnginesToPrefs((SharedPreferences)androidFxAccount.getSyncPrefs(), hashMap);
                        }
                        catch (UnsupportedEncodingException | GeneralSecurityException exception) {
                            Log.e((String)LOGTAG, (String)"Got exception storing selected engines; ignoring.", (Throwable)exception);
                        }
                    }
                }
                catch (UnsupportedEncodingException | URISyntaxException | GeneralSecurityException exception) {
                    Log.w((String)LOGTAG, (String)"Got exception creating Firefox Account from JSON; ignoring.", (Throwable)exception);
                    if (eventCallback == null) break block33;
                    eventCallback.sendError((Object)("Could not create Firefox Account from JSON: " + exception.toString()));
                    return;
                }
            }
            if (eventCallback == null) return;
            eventCallback.sendSuccess((Object)(androidFxAccount != null ? 1 : 0));
            return;
        }
        if ("Accounts:UpdateFirefoxAccountFromJSON".equals(string2)) {
            try {
                Account account = FirefoxAccounts.getFirefoxAccount((Context)this.mContext);
                if (account == null) {
                    if (eventCallback == null) return;
                    eventCallback.sendError((Object)"Could not update Firefox Account since none exists");
                    return;
                }
                NativeJSObject nativeJSObject3 = nativeJSObject.getObject("json");
                String string10 = nativeJSObject3.getString("email");
                String string11 = nativeJSObject3.getString("uid");
                if (account.name == null || !account.name.equals(string10)) {
                    Log.e((String)LOGTAG, (String)"Cannot update Firefox Account from JSON: datum has different email address!");
                    if (eventCallback == null) return;
                    eventCallback.sendError((Object)"Cannot update Firefox Account from JSON: datum has different email address!");
                    return;
                }
                boolean bl = nativeJSObject3.optBoolean("verified", false);
                byte[] byArray = Utils.hex2Byte((String)nativeJSObject3.getString("unwrapBKey"));
                byte[] byArray4 = Utils.hex2Byte((String)nativeJSObject3.getString("sessionToken"));
                byte[] byArray5 = Utils.hex2Byte((String)nativeJSObject3.getString("keyFetchToken"));
                Engaged engaged = new Engaged(string10, string11, bl, byArray, byArray4, byArray5);
                AndroidFxAccount androidFxAccount = new AndroidFxAccount(this.mContext, account);
                androidFxAccount.setState((State)engaged);
                if (eventCallback == null) return;
                eventCallback.sendSuccess((Object)true);
                return;
            }
            catch (NativeJSObject.InvalidPropertyException invalidPropertyException) {
                Log.w((String)LOGTAG, (String)"Got exception updating Firefox Account from JSON; ignoring.", (Throwable)invalidPropertyException);
                if (eventCallback == null) return;
                eventCallback.sendError((Object)("Could not update Firefox Account from JSON: " + invalidPropertyException.toString()));
                return;
            }
        }
        if ("Accounts:Create".equals(string2)) {
            Intent intent = new Intent("org.mozilla.fennec.ACTION_FXA_GET_STARTED");
            intent.setFlags(0x10000000);
            NativeJSObject nativeJSObject4 = nativeJSObject.optObject("extras", null);
            if (nativeJSObject4 != null) {
                intent.putExtra("extras", nativeJSObject4.toString());
            }
            this.mContext.startActivity(intent);
            return;
        }
        if ("Accounts:DeleteFirefoxAccount".equals(string2)) {
            try {
                final Account account = FirefoxAccounts.getFirefoxAccount((Context)this.mContext);
                if (account == null) {
                    Log.w((String)LOGTAG, (String)"Could not delete Firefox Account since none exists!");
                    if (eventCallback == null) return;
                    eventCallback.sendError((Object)"Could not delete Firefox Account since none exists");
                    return;
                }
                AccountManagerCallback<Boolean> accountManagerCallback = new AccountManagerCallback<Boolean>(){

                    public void run(AccountManagerFuture<Boolean> accountManagerFuture) {
                        block3: {
                            try {
                                boolean bl = (Boolean)accountManagerFuture.getResult();
                                Log.i((String)AccountsHelper.LOGTAG, (String)("Account named like " + Utils.obfuscateEmail((String)account.name) + " removed: " + bl));
                                if (eventCallback != null) {
                                    eventCallback.sendSuccess((Object)bl);
                                }
                            }
                            catch (AuthenticatorException | OperationCanceledException | IOException throwable) {
                                if (eventCallback == null) break block3;
                                eventCallback.sendError((Object)("Could not delete Firefox Account: " + throwable.toString()));
                            }
                        }
                    }
                };
                AccountManager.get((Context)this.mContext).removeAccount(account, (AccountManagerCallback)accountManagerCallback, null);
                return;
            }
            catch (Exception exception) {
                Log.w((String)LOGTAG, (String)"Got exception updating Firefox Account from JSON; ignoring.", (Throwable)exception);
                if (eventCallback == null) return;
                eventCallback.sendError((Object)("Could not update Firefox Account from JSON: " + exception.toString()));
                return;
            }
        }
        if ("Accounts:Exist".equals(string2)) {
            if (eventCallback == null) {
                Log.w((String)LOGTAG, (String)"Accounts:Exist requires a callback");
                return;
            }
            String string12 = nativeJSObject.optString("kind", null);
            JSONObject jSONObject = new JSONObject();
            try {
                if ("any".equals(string12)) {
                    jSONObject.put("exists", FirefoxAccounts.firefoxAccountsExist((Context)this.mContext));
                    eventCallback.sendSuccess((Object)jSONObject);
                    return;
                }
                if ("fxa".equals(string12)) {
                    Account account = FirefoxAccounts.getFirefoxAccount((Context)this.mContext);
                    jSONObject.put("exists", account != null);
                    if (account != null) {
                        jSONObject.put("email", (Object)account.name);
                        AndroidFxAccount androidFxAccount = new AndroidFxAccount(this.mContext, account);
                        jSONObject.put("authServerEndpoint", (Object)androidFxAccount.getAccountServerURI());
                        jSONObject.put("profileServerEndpoint", (Object)androidFxAccount.getProfileServerURI());
                        jSONObject.put("tokenServerEndpoint", (Object)androidFxAccount.getTokenServerURI());
                        try {
                            State state = androidFxAccount.getState();
                            jSONObject.put("uid", (Object)state.uid);
                        }
                        catch (Exception exception) {
                            Log.w((String)LOGTAG, (String)"Got exception extracting account UID; ignoring.", (Throwable)exception);
                        }
                    }
                    eventCallback.sendSuccess((Object)jSONObject);
                    return;
                }
                eventCallback.sendError((Object)"Could not query account existence: unknown kind.");
                return;
            }
            catch (JSONException jSONException) {
                Log.w((String)LOGTAG, (String)"Got exception querying account existence; ignoring.", (Throwable)jSONException);
                eventCallback.sendError((Object)("Could not query account existence: " + jSONException.toString()));
                return;
            }
        }
        if ("Accounts:ProfileUpdated".equals(string2)) {
            Account account = FirefoxAccounts.getFirefoxAccount((Context)this.mContext);
            if (account == null) {
                Log.w((String)LOGTAG, (String)"Can't change profile of non-existent Firefox Account!; ignored");
                return;
            }
            AndroidFxAccount androidFxAccount = new AndroidFxAccount(this.mContext, account);
            androidFxAccount.fetchProfileJSON();
            return;
        } else {
            if (!"Accounts:ShowSyncPreferences".equals(string2)) return;
            Account account = FirefoxAccounts.getFirefoxAccount((Context)this.mContext);
            if (account == null) {
                Log.w((String)LOGTAG, (String)"Can't change show Sync preferences of non-existent Firefox Account!; ignored");
                return;
            }
            Intent intent = new Intent("org.mozilla.fennec.ACTION_FXA_STATUS");
            intent.setFlags(65536);
            intent.setFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
    }
}

