/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.text.format.Formatter;
import android.util.Log;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.annotation.JNITarget;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;

public class GeckoNetworkManager
extends BroadcastReceiver
implements NativeEventListener {
    private static final String LOGTAG = "GeckoNetworkManager";
    private static GeckoNetworkManager sInstance;
    private volatile ConnectionType mConnectionType = ConnectionType.NONE;
    private final IntentFilter mNetworkFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
    private boolean mShouldBeListening;
    private boolean mShouldNotify;
    private volatile Context mApplicationContext;
    private boolean mIsListening;

    public static void destroy() {
        if (sInstance != null) {
            sInstance.onDestroy();
            sInstance = null;
        }
    }

    private GeckoNetworkManager() {
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Wifi:Enable", "Wifi:GetIPAddress");
    }

    private void onDestroy() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Wifi:Enable", "Wifi:GetIPAddress");
    }

    public static GeckoNetworkManager getInstance() {
        if (sInstance == null) {
            sInstance = new GeckoNetworkManager();
        }
        return sInstance;
    }

    public void onReceive(Context context, Intent intent) {
        this.updateConnectionType();
    }

    public void start(Context context) {
        this.mApplicationContext = context.getApplicationContext();
        if (this.mConnectionType == ConnectionType.NONE) {
            this.mConnectionType = this.getConnectionType();
        }
        this.mShouldBeListening = true;
        this.updateConnectionType();
        if (this.mShouldNotify) {
            this.startListening();
        }
    }

    private void startListening() {
        if (this.mIsListening) {
            Log.w((String)LOGTAG, (String)"Already started!");
            return;
        }
        Context context = this.mApplicationContext;
        if (context == null) {
            Log.w((String)LOGTAG, (String)"Not registering receiver: no context!");
            return;
        }
        if (context.registerReceiver((BroadcastReceiver)this, this.mNetworkFilter) == null) {
            Log.e((String)LOGTAG, (String)"Registering receiver failed");
        } else {
            this.mIsListening = true;
        }
    }

    public void stop() {
        this.mShouldBeListening = false;
        if (this.mShouldNotify) {
            this.stopListening();
        }
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        switch (string2) {
            case "Wifi:Enable": {
                WifiManager wifiManager = (WifiManager)this.mApplicationContext.getSystemService("wifi");
                if (!wifiManager.isWifiEnabled()) {
                    wifiManager.setWifiEnabled(true);
                    break;
                }
                Intent intent = new Intent("android.settings.WIFI_SETTINGS");
                intent.addFlags(0x10000000);
                this.mApplicationContext.startActivity(intent);
                break;
            }
            case "Wifi:GetIPAddress": {
                this.getWifiIPAddress(eventCallback);
            }
        }
    }

    private void getWifiIPAddress(EventCallback eventCallback) {
        WifiManager wifiManager = (WifiManager)this.mApplicationContext.getSystemService("wifi");
        if (wifiManager == null) {
            eventCallback.sendError((Object)"Cannot get WifiManager");
            return;
        }
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        if (wifiInfo == null) {
            eventCallback.sendError((Object)"Cannot get connection info");
            return;
        }
        int n = wifiInfo.getIpAddress();
        if (n == 0) {
            eventCallback.sendError((Object)"Cannot get IPv4 address");
            return;
        }
        eventCallback.sendSuccess((Object)Formatter.formatIpAddress((int)n));
    }

    private void stopListening() {
        if (null == this.mApplicationContext) {
            return;
        }
        if (!this.mIsListening) {
            Log.w((String)LOGTAG, (String)"Already stopped!");
            return;
        }
        this.mApplicationContext.unregisterReceiver((BroadcastReceiver)this);
        this.mIsListening = false;
    }

    private int wifiDhcpGatewayAddress() {
        if (this.mConnectionType != ConnectionType.WIFI) {
            return 0;
        }
        if (null == this.mApplicationContext) {
            return 0;
        }
        try {
            WifiManager wifiManager = (WifiManager)this.mApplicationContext.getSystemService("wifi");
            DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
            if (dhcpInfo == null) {
                return 0;
            }
            return dhcpInfo.gateway;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void updateConnectionType() {
        ConnectionType connectionType = this.mConnectionType;
        ConnectionType connectionType2 = this.getConnectionType();
        if (connectionType2 == connectionType) {
            return;
        }
        this.mConnectionType = connectionType2;
        if (!this.mShouldNotify) {
            return;
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createNetworkEvent(connectionType2.value, connectionType2 == ConnectionType.WIFI, this.wifiDhcpGatewayAddress()));
    }

    public double[] getCurrentInformation() {
        ConnectionType connectionType = this.mConnectionType;
        return new double[]{connectionType.value, connectionType == ConnectionType.WIFI ? 1.0 : 0.0, this.wifiDhcpGatewayAddress()};
    }

    public void enableNotifications() {
        this.mConnectionType = ConnectionType.NONE;
        this.updateConnectionType();
        this.mShouldNotify = true;
        if (this.mShouldBeListening) {
            this.startListening();
        }
    }

    public void disableNotifications() {
        this.mShouldNotify = false;
        if (this.mShouldBeListening) {
            this.stopListening();
        }
    }

    private ConnectionType getConnectionType() {
        Context context = this.mApplicationContext;
        if (null == context) {
            return ConnectionType.NONE;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            Log.e((String)LOGTAG, (String)"Connectivity service does not exist");
            return ConnectionType.NONE;
        }
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (networkInfo == null) {
            return ConnectionType.NONE;
        }
        switch (networkInfo.getType()) {
            case 7: {
                return ConnectionType.BLUETOOTH;
            }
            case 9: {
                return ConnectionType.ETHERNET;
            }
            case 0: 
            case 6: {
                return ConnectionType.CELLULAR;
            }
            case 1: {
                return ConnectionType.WIFI;
            }
        }
        Log.w((String)LOGTAG, (String)"Ignoring the current network type.");
        return ConnectionType.OTHER;
    }

    private static int getNetworkOperator(InfoType infoType, Context context) {
        if (null == context) {
            return -1;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            Log.e((String)LOGTAG, (String)"Telephony service does not exist");
            return -1;
        }
        String string2 = telephonyManager.getNetworkOperator();
        if (string2 == null || string2.length() <= 3) {
            return -1;
        }
        if (infoType == InfoType.MNC) {
            return Integer.parseInt(string2.substring(3));
        }
        if (infoType == InfoType.MCC) {
            return Integer.parseInt(string2.substring(0, 3));
        }
        return -1;
    }

    @JNITarget
    public static int getMCC() {
        return GeckoNetworkManager.getNetworkOperator(InfoType.MCC, GeckoAppShell.getContext().getApplicationContext());
    }

    @JNITarget
    public static int getMNC() {
        return GeckoNetworkManager.getNetworkOperator(InfoType.MNC, GeckoAppShell.getContext().getApplicationContext());
    }

    private static enum InfoType {
        MCC,
        MNC;

    }

    private static enum ConnectionType {
        CELLULAR(0),
        BLUETOOTH(1),
        ETHERNET(2),
        WIFI(3),
        OTHER(4),
        NONE(5);

        public final int value;

        private ConnectionType(int n2) {
            this.value = n2;
        }
    }
}

