/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.dlc.catalog;

import android.content.Context;
import android.support.v4.util.AtomicFile;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.dlc.catalog.DownloadContent;
import org.mozilla.gecko.dlc.catalog.DownloadContentBootstrap;

public class DownloadContentCatalog {
    private static final String LOGTAG = "GeckoDLCCatalog";
    private static final String FILE_NAME = "download_content_catalog";
    private static final String JSON_KEY_CONTENT = "content";
    private static final int MAX_FAILURES_UNTIL_PERMANENTLY_FAILED = 10;
    private final AtomicFile file;
    private List<DownloadContent> content = Collections.emptyList();
    private boolean hasLoadedCatalog;
    private boolean hasCatalogChanged;

    public DownloadContentCatalog(Context context) {
        this(new AtomicFile(new File(context.getApplicationInfo().dataDir, FILE_NAME)));
        this.startLoadFromDisk();
    }

    protected DownloadContentCatalog(AtomicFile atomicFile) {
        this.file = atomicFile;
    }

    public synchronized List<DownloadContent> getContentWithoutState() {
        this.awaitLoadingCatalogLocked();
        ArrayList<DownloadContent> arrayList = new ArrayList<DownloadContent>();
        for (DownloadContent downloadContent : this.content) {
            if (0 != downloadContent.getState()) continue;
            arrayList.add(downloadContent);
        }
        return arrayList;
    }

    public synchronized List<DownloadContent> getDownloadedContent() {
        this.awaitLoadingCatalogLocked();
        ArrayList<DownloadContent> arrayList = new ArrayList<DownloadContent>();
        for (DownloadContent downloadContent : this.content) {
            if (2 != downloadContent.getState()) continue;
            arrayList.add(downloadContent);
        }
        return arrayList;
    }

    public synchronized List<DownloadContent> getScheduledDownloads() {
        this.awaitLoadingCatalogLocked();
        ArrayList<DownloadContent> arrayList = new ArrayList<DownloadContent>();
        for (DownloadContent downloadContent : this.content) {
            if (1 != downloadContent.getState()) continue;
            arrayList.add(downloadContent);
        }
        return arrayList;
    }

    public synchronized boolean hasScheduledDownloads() {
        this.awaitLoadingCatalogLocked();
        for (DownloadContent downloadContent : this.content) {
            if (1 != downloadContent.getState()) continue;
            return true;
        }
        return false;
    }

    public synchronized void scheduleDownload(DownloadContent downloadContent) {
        downloadContent.setState(1);
        this.hasCatalogChanged = true;
    }

    public synchronized void markAsDownloaded(DownloadContent downloadContent) {
        downloadContent.setState(2);
        downloadContent.resetFailures();
        this.hasCatalogChanged = true;
    }

    public synchronized void markAsPermanentlyFailed(DownloadContent downloadContent) {
        downloadContent.setState(3);
        this.hasCatalogChanged = true;
    }

    public synchronized void markAsIgnored(DownloadContent downloadContent) {
        downloadContent.setState(4);
        this.hasCatalogChanged = true;
    }

    public synchronized void rememberFailure(DownloadContent downloadContent, int n) {
        if (downloadContent.getFailures() >= 10) {
            Log.d((String)LOGTAG, (String)"Maximum number of failures reached. Marking content has permanently failed.");
            this.markAsPermanentlyFailed(downloadContent);
        } else {
            downloadContent.rememberFailure(n);
            this.hasCatalogChanged = true;
        }
    }

    public void persistChanges() {
        new Thread("GeckoDLCCatalog-Persist"){

            @Override
            public void run() {
                DownloadContentCatalog.this.writeToDisk();
            }
        }.start();
    }

    private void startLoadFromDisk() {
        new Thread("GeckoDLCCatalog-Load"){

            @Override
            public void run() {
                DownloadContentCatalog.this.loadFromDisk();
            }
        }.start();
    }

    private void awaitLoadingCatalogLocked() {
        while (!this.hasLoadedCatalog) {
            try {
                Log.v((String)LOGTAG, (String)"Waiting for catalog to be loaded");
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized boolean hasCatalogChanged() {
        return this.hasCatalogChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loadFromDisk() {
        Log.d((String)LOGTAG, (String)"Loading from disk");
        if (this.hasLoadedCatalog) {
            return;
        }
        ArrayList<DownloadContent> arrayList = new ArrayList();
        try {
            JSONObject jSONObject;
            AtomicFile atomicFile = this.file;
            synchronized (atomicFile) {
                jSONObject = new JSONObject(new String(this.file.readFully(), "UTF-8"));
            }
            atomicFile = jSONObject.getJSONArray(JSON_KEY_CONTENT);
            for (int i = 0; i < atomicFile.length(); ++i) {
                arrayList.add(DownloadContent.fromJSON(atomicFile.getJSONObject(i)));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.d((String)LOGTAG, (String)"Catalog file does not exist: Bootstrapping initial catalog");
            arrayList = DownloadContentBootstrap.createInitialDownloadContentList();
        }
        catch (JSONException jSONException) {
            Log.w((String)LOGTAG, (String)"Unable to parse catalog JSON. Re-creating catalog.", (Throwable)jSONException);
            arrayList = DownloadContentBootstrap.createInitialDownloadContentList();
            this.hasCatalogChanged = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            AssertionError assertionError = new AssertionError((Object)"Should not happen: This device does not speak UTF-8");
            ((Throwable)((Object)assertionError)).initCause(unsupportedEncodingException);
            throw assertionError;
        }
        catch (IOException iOException) {
            Log.d((String)LOGTAG, (String)"Can't read catalog due to IOException", (Throwable)iOException);
        }
        this.onCatalogLoaded(arrayList);
        this.notifyAll();
        Log.d((String)LOGTAG, (String)("Loaded " + arrayList.size() + " elements"));
    }

    protected void onCatalogLoaded(List<DownloadContent> list) {
        this.content = list;
        this.hasLoadedCatalog = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeToDisk() {
        if (!this.hasCatalogChanged) {
            Log.v((String)LOGTAG, (String)"Not persisting: Catalog has not changed");
            return;
        }
        Log.d((String)LOGTAG, (String)"Writing to disk");
        FileOutputStream fileOutputStream = null;
        AtomicFile atomicFile = this.file;
        synchronized (atomicFile) {
            block8: {
                try {
                    fileOutputStream = this.file.startWrite();
                    JSONArray jSONArray = new JSONArray();
                    for (DownloadContent downloadContent : this.content) {
                        jSONArray.put((Object)downloadContent.toJSON());
                    }
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put(JSON_KEY_CONTENT, (Object)jSONArray);
                    fileOutputStream.write(jSONObject.toString().getBytes("UTF-8"));
                    this.file.finishWrite(fileOutputStream);
                    this.hasCatalogChanged = false;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    AssertionError assertionError = new AssertionError((Object)"Should not happen: This device does not speak UTF-8");
                    ((Throwable)((Object)assertionError)).initCause(unsupportedEncodingException);
                    throw assertionError;
                }
                catch (IOException | JSONException throwable) {
                    Log.e((String)LOGTAG, (String)"IOException during writing catalog", (Throwable)throwable);
                    if (fileOutputStream == null) break block8;
                    this.file.failWrite(fileOutputStream);
                }
            }
        }
    }
}

