/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import android.provider.BaseColumns;
import android.util.Log;
import java.util.ArrayList;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.db.LocalBrowserDB;

public class AndroidImport
implements Runnable {
    public static final Uri SAMSUNG_BOOKMARKS_URI = Uri.parse((String)"content://com.sec.android.app.sbrowser.browser/bookmarks");
    public static final Uri SAMSUNG_HISTORY_URI = Uri.parse((String)"content://com.sec.android.app.sbrowser.browser/history");
    public static final String SAMSUNG_MANUFACTURER = "samsung";
    private static final String LOGTAG = "AndroidImport";
    private final Context mContext;
    private final Runnable mOnDoneRunnable;
    private final ArrayList<ContentProviderOperation> mOperations;
    private final ContentResolver mCr;
    private final LocalBrowserDB mDB;
    private final boolean mImportBookmarks;
    private final boolean mImportHistory;

    public AndroidImport(Context context, Runnable runnable, boolean bl, boolean bl2) {
        this.mContext = context;
        this.mOnDoneRunnable = runnable;
        this.mOperations = new ArrayList();
        this.mCr = this.mContext.getContentResolver();
        this.mDB = new LocalBrowserDB(GeckoProfile.get(context).getName());
        this.mImportBookmarks = bl;
        this.mImportHistory = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeBookmarks() {
        try (Cursor cursor = null;){
            cursor = this.query(LegacyBrowserProvider.BOOKMARKS_URI, SAMSUNG_BOOKMARKS_URI, "bookmark = 1");
            if (cursor != null) {
                int n = cursor.getColumnIndexOrThrow("favicon");
                int n2 = cursor.getColumnIndexOrThrow("title");
                int n3 = cursor.getColumnIndexOrThrow("url");
                int n4 = cursor.getColumnIndex("created");
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    String string2 = cursor.getString(n3);
                    String string3 = cursor.getString(n2);
                    long l = n4 >= 0 ? cursor.getLong(n4) : System.currentTimeMillis();
                    long l2 = System.currentTimeMillis();
                    byte[] byArray = cursor.getBlob(n);
                    this.mDB.updateBookmarkInBatch(this.mCr, this.mOperations, string2, string3, null, -1L, l, l2, Long.MIN_VALUE, null, 1);
                    if (byArray != null) {
                        this.mDB.updateFaviconInBatch(this.mCr, this.mOperations, string2, null, null, byArray);
                    }
                    cursor.moveToNext();
                }
            }
        }
        this.flushBatchOperations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeHistory() {
        try (Cursor cursor = null;){
            cursor = this.query(LegacyBrowserProvider.BOOKMARKS_URI, SAMSUNG_HISTORY_URI, "bookmark = 0 AND visits > 0");
            if (cursor != null) {
                int n = cursor.getColumnIndexOrThrow("date");
                int n2 = cursor.getColumnIndexOrThrow("favicon");
                int n3 = cursor.getColumnIndexOrThrow("title");
                int n4 = cursor.getColumnIndexOrThrow("url");
                int n5 = cursor.getColumnIndexOrThrow("visits");
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    String string2 = cursor.getString(n4);
                    String string3 = cursor.getString(n3);
                    long l = cursor.getLong(n);
                    int n6 = cursor.getInt(n5);
                    byte[] byArray = cursor.getBlob(n2);
                    this.mDB.updateHistoryInBatch(this.mCr, this.mOperations, string2, string3, l, n6);
                    if (byArray != null) {
                        this.mDB.updateFaviconInBatch(this.mCr, this.mOperations, string2, null, null, byArray);
                    }
                    cursor.moveToNext();
                }
            }
        }
        this.flushBatchOperations();
    }

    protected Cursor query(Uri uri, Uri uri2, String string2) {
        Cursor cursor = this.mCr.query(uri, null, string2, null, null);
        if (Build.MANUFACTURER.equals(SAMSUNG_MANUFACTURER) && (cursor == null || cursor.getCount() == 0)) {
            cursor = this.mCr.query(uri2, null, null, null, null);
        }
        return cursor;
    }

    protected void flushBatchOperations() {
        Log.d((String)LOGTAG, (String)("Flushing " + this.mOperations.size() + " DB operations"));
        try {
            this.mCr.applyBatch("org.mozilla.fennec.db.browser", this.mOperations);
        }
        catch (RemoteException remoteException) {
            Log.e((String)LOGTAG, (String)"Remote exception while updating db: ", (Throwable)remoteException);
        }
        catch (OperationApplicationException operationApplicationException) {
            Log.d((String)LOGTAG, (String)"Error while applying database updates: ", (Throwable)operationApplicationException);
        }
        this.mOperations.clear();
    }

    @Override
    public void run() {
        if (this.mImportBookmarks) {
            this.mergeBookmarks();
        }
        if (this.mImportHistory) {
            this.mergeHistory();
        }
        this.mOnDoneRunnable.run();
    }

    private static class LegacyBrowserProvider {
        public static final Uri BOOKMARKS_URI = Uri.parse((String)"content://browser/bookmarks");

        private LegacyBrowserProvider() {
        }

        public static class BookmarkColumns
        implements BaseColumns {
            public static final String URL = "url";
            public static final String VISITS = "visits";
            public static final String DATE = "date";
            public static final String BOOKMARK = "bookmark";
            public static final String TITLE = "title";
            public static final String CREATED = "created";
            public static final String FAVICON = "favicon";
        }
    }
}

