/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.app.AlertDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.DialogPreference;
import android.preference.Preference;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;

public class SetHomepagePreference
extends DialogPreference {
    private static final String DEFAULT_HOMEPAGE = "about:home";
    private final SharedPreferences prefs;
    private RadioGroup homepageLayout;
    private RadioButton defaultRadio;
    private RadioButton userAddressRadio;
    private EditText homepageEditText;
    private String storedUrl;

    public SetHomepagePreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.prefs = GeckoSharedPrefs.forProfile(context);
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        builder.setInverseBackgroundForced(true);
    }

    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
        this.homepageLayout = (RadioGroup)view.findViewById(R.id.homepage_layout);
        this.defaultRadio = (RadioButton)view.findViewById(R.id.radio_default);
        this.userAddressRadio = (RadioButton)view.findViewById(R.id.radio_user_address);
        this.homepageEditText = (EditText)view.findViewById(R.id.edittext_user_address);
        this.storedUrl = this.prefs.getString("android.not_a_preference.homepage", DEFAULT_HOMEPAGE);
        this.homepageLayout.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup radioGroup, int n) {
                if (n == R.id.radio_user_address) {
                    SetHomepagePreference.this.homepageEditText.setVisibility(0);
                    SetHomepagePreference.openKeyboardAndSelectAll(SetHomepagePreference.this.getContext(), (View)SetHomepagePreference.this.homepageEditText);
                } else {
                    SetHomepagePreference.this.homepageEditText.setVisibility(8);
                }
            }
        });
        this.setUIState(this.storedUrl);
    }

    private void setUIState(String string2) {
        if (this.isUrlDefaultHomepage(string2)) {
            this.defaultRadio.setChecked(true);
        } else {
            this.userAddressRadio.setChecked(true);
            this.homepageEditText.setText((CharSequence)string2);
        }
    }

    private boolean isUrlDefaultHomepage(String string2) {
        return TextUtils.isEmpty((CharSequence)string2) || DEFAULT_HOMEPAGE.equals(string2);
    }

    private static void openKeyboardAndSelectAll(final Context context, final View view) {
        view.requestFocus();
        view.post(new Runnable(){

            @Override
            public void run() {
                InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
                inputMethodManager.showSoftInput(view, 1);
                if (view instanceof EditText) {
                    ((EditText)view).selectAll();
                }
            }
        });
    }

    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        if (bl) {
            String string2;
            SharedPreferences.Editor editor = this.prefs.edit();
            String string3 = this.homepageEditText.getText().toString();
            if (this.homepageLayout.getCheckedRadioButtonId() == R.id.radio_default || this.isUrlDefaultHomepage(string3)) {
                string2 = "";
                editor.remove("android.not_a_preference.homepage");
            } else {
                string2 = string3;
                editor.putString("android.not_a_preference.homepage", string2);
            }
            editor.apply();
            if (this.getOnPreferenceChangeListener() != null) {
                this.getOnPreferenceChangeListener().onPreferenceChange((Preference)this, (Object)string2);
            }
        }
    }
}

