/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.prompts;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.gfx.BitmapUtils;

public class PromptListItem {
    private static final String LOGTAG = "GeckoPromptListItem";
    public final String label;
    public final boolean isGroup;
    public final boolean inGroup;
    public final boolean disabled;
    public final int id;
    public final boolean showAsActions;
    public final boolean isParent;
    public Intent mIntent;
    public boolean mSelected;
    public Drawable mIcon;

    PromptListItem(JSONObject jSONObject) {
        String string2;
        Context context = GeckoAppShell.getContext();
        this.label = jSONObject.isNull("label") ? "" : jSONObject.optString("label");
        this.isGroup = jSONObject.optBoolean("isGroup");
        this.inGroup = jSONObject.optBoolean("inGroup");
        this.disabled = jSONObject.optBoolean("disabled");
        this.id = jSONObject.optInt("id");
        this.mSelected = jSONObject.optBoolean("selected");
        JSONObject jSONObject2 = jSONObject.optJSONObject("showAsActions");
        if (jSONObject2 != null) {
            this.showAsActions = true;
            string2 = jSONObject2.isNull("uri") ? "" : jSONObject2.optString("uri");
            String string3 = jSONObject2.isNull("type") ? "text/plain" : jSONObject2.optString("type", "text/plain");
            this.mIntent = GeckoAppShell.getShareIntent(context, string2, string3, "");
            this.isParent = true;
        } else {
            this.mIntent = null;
            this.showAsActions = false;
            this.isParent = jSONObject.optBoolean("isParent") || jSONObject.optBoolean("menu");
        }
        string2 = jSONObject.optString("icon");
        if (string2 != null) {
            BitmapUtils.getDrawable(context, string2, new BitmapUtils.BitmapLoader(){

                @Override
                public void onBitmapFound(Drawable drawable2) {
                    PromptListItem.this.mIcon = drawable2;
                }
            });
        }
    }

    public void setIntent(Intent intent) {
        this.mIntent = intent;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public void setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
    }

    public Drawable getIcon() {
        return this.mIcon;
    }

    public void setSelected(boolean bl) {
        this.mSelected = bl;
    }

    public boolean getSelected() {
        return this.mSelected;
    }

    public PromptListItem(String string2) {
        this.label = string2;
        this.isGroup = false;
        this.inGroup = false;
        this.isParent = false;
        this.disabled = false;
        this.id = 0;
        this.showAsActions = false;
    }

    static PromptListItem[] getArray(JSONArray jSONArray) {
        if (jSONArray == null) {
            return new PromptListItem[0];
        }
        int n = jSONArray.length();
        ArrayList<PromptListItem> arrayList = new ArrayList<PromptListItem>(n);
        for (int i = 0; i < n; ++i) {
            try {
                PromptListItem promptListItem = new PromptListItem(jSONArray.getJSONObject(i));
                arrayList.add(promptListItem);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList.toArray(new PromptListItem[n]);
    }
}

