/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.permissions.Permissions;
import org.mozilla.gecko.util.ThreadUtils;

public class ScreenshotObserver {
    private static final String LOGTAG = "GeckoScreenshotObserver";
    public Context context;
    private OnScreenshotListener listener;
    private MediaObserver mediaObserver;
    private String[] mediaProjections = new String[]{"_data", "_display_name", "bucket_display_name", "datetaken", "title"};

    public void setListener(Context context, OnScreenshotListener onScreenshotListener) {
        this.context = context;
        this.listener = onScreenshotListener;
    }

    public void start() {
        if (!AppConstants.Versions.feature14Plus) {
            return;
        }
        Permissions.from(this.context).withPermissions("android.permission.WRITE_EXTERNAL_STORAGE").doNotPrompt().run(this.startObserverRunnable());
    }

    private Runnable startObserverRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (ScreenshotObserver.this.mediaObserver == null) {
                        ScreenshotObserver.this.mediaObserver = new MediaObserver();
                        ScreenshotObserver.this.context.getContentResolver().registerContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, false, (ContentObserver)ScreenshotObserver.this.mediaObserver);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)ScreenshotObserver.LOGTAG, (String)"Failure to start watching media: ", (Throwable)exception);
                }
            }
        };
    }

    public void stop() {
        if (!AppConstants.Versions.feature14Plus) {
            return;
        }
        if (this.mediaObserver == null) {
            return;
        }
        try {
            this.context.getContentResolver().unregisterContentObserver((ContentObserver)this.mediaObserver);
            this.mediaObserver = null;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Failure to stop watching media: ", (Throwable)exception);
        }
    }

    public void onMediaChange(final Uri uri) {
        final ContentResolver contentResolver = this.context.getContentResolver();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Cursor cursor = contentResolver.query(uri, ScreenshotObserver.this.mediaProjections, null, null, "date_added DESC LIMIT 1");
                    if (cursor == null) {
                        return;
                    }
                    while (cursor.moveToNext()) {
                        String string2 = cursor.getString(0);
                        Log.i((String)ScreenshotObserver.LOGTAG, (String)("data: " + string2));
                        String string3 = cursor.getString(1);
                        Log.i((String)ScreenshotObserver.LOGTAG, (String)("display: " + string3));
                        String string4 = cursor.getString(2);
                        Log.i((String)ScreenshotObserver.LOGTAG, (String)("album: " + string4));
                        long l = cursor.getLong(3);
                        String string5 = cursor.getString(4);
                        Log.i((String)ScreenshotObserver.LOGTAG, (String)("title: " + string5));
                        if (string4 == null || !string4.toLowerCase().contains("screenshot") || ScreenshotObserver.this.listener == null) continue;
                        ScreenshotObserver.this.listener.onScreenshotTaken(string2, string5);
                        break;
                    }
                    cursor.close();
                }
                catch (Exception exception) {
                    Log.e((String)ScreenshotObserver.LOGTAG, (String)"Failure to process media change: ", (Throwable)exception);
                }
            }
        });
    }

    private class MediaObserver
    extends ContentObserver {
        public MediaObserver() {
            super(null);
        }

        public void onChange(boolean bl) {
            super.onChange(bl);
            ScreenshotObserver.this.onMediaChange(MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        }
    }

    public static interface OnScreenshotListener {
        public void onScreenshotTaken(String var1, String var2);
    }
}

