/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.PointF;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.gfx.DisplayPortMetrics;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.Overscroll;
import org.mozilla.gecko.gfx.PanZoomController;
import org.mozilla.gecko.gfx.PanZoomTarget;
import org.mozilla.gecko.mozglue.JNIObject;
import org.mozilla.gecko.util.ThreadUtils;

class NativePanZoomController
extends JNIObject
implements PanZoomController {
    private final PanZoomTarget mTarget;
    private final LayerView mView;
    private boolean mDestroyed;
    private Overscroll mOverscroll;
    boolean mNegateWheelScroll;
    private float mPointerScrollFactor;
    private final PrefsHelper.PrefHandler mPrefsObserver;
    private long mLastDownTime;
    private static final float MAX_SCROLL = 0.075f * (float)GeckoAppShell.getDpi();

    @WrapForJNI
    private native boolean handleMotionEvent(int var1, int var2, long var3, int var5, int[] var6, float[] var7, float[] var8, float[] var9, float[] var10, float[] var11, float[] var12);

    @WrapForJNI
    private native boolean handleScrollEvent(long var1, int var3, float var4, float var5, float var6, float var7);

    private boolean handleMotionEvent(MotionEvent motionEvent, boolean bl) {
        if (this.mDestroyed) {
            return false;
        }
        int n = motionEvent.getActionMasked();
        int n2 = motionEvent.getPointerCount();
        if (n == 0) {
            this.mLastDownTime = motionEvent.getDownTime();
        } else if (this.mLastDownTime != motionEvent.getDownTime()) {
            return false;
        }
        int[] nArray = new int[n2];
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n2];
        float[] fArray4 = new float[n2];
        float[] fArray5 = new float[n2];
        float[] fArray6 = new float[n2];
        MotionEvent.PointerCoords pointerCoords = new MotionEvent.PointerCoords();
        PointF pointF = !bl ? new PointF() : null;
        float f = !bl ? this.mView.getViewportMetrics().zoomFactor : 1.0f;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = motionEvent.getPointerId(i);
            motionEvent.getPointerCoords(i, pointerCoords);
            if (bl) {
                fArray[i] = pointerCoords.x;
                fArray2[i] = pointerCoords.y;
            } else {
                pointF.x = pointerCoords.x;
                pointF.y = pointerCoords.y;
                PointF pointF2 = this.mView.convertViewPointToLayerPoint(pointF);
                fArray[i] = pointF2.x;
                fArray2[i] = pointF2.y;
            }
            fArray3[i] = pointerCoords.orientation;
            fArray4[i] = pointerCoords.pressure;
            fArray5[i] = pointerCoords.toolMajor / f;
            fArray6[i] = pointerCoords.toolMinor / f;
        }
        return this.handleMotionEvent(n, motionEvent.getActionIndex(), motionEvent.getEventTime(), motionEvent.getMetaState(), nArray, fArray, fArray2, fArray3, fArray4, fArray5, fArray6);
    }

    private boolean handleScrollEvent(MotionEvent motionEvent) {
        if (this.mDestroyed) {
            return false;
        }
        int n = motionEvent.getPointerCount();
        if (n <= 0) {
            return false;
        }
        MotionEvent.PointerCoords pointerCoords = new MotionEvent.PointerCoords();
        motionEvent.getPointerCoords(0, pointerCoords);
        float f = pointerCoords.x;
        float f2 = pointerCoords.y;
        float f3 = this.mNegateWheelScroll ? -1.0f : 1.0f;
        float f4 = motionEvent.getAxisValue(10) * f3 * this.mPointerScrollFactor;
        float f5 = motionEvent.getAxisValue(9) * f3 * this.mPointerScrollFactor;
        return this.handleScrollEvent(motionEvent.getEventTime(), motionEvent.getMetaState(), f, f2, f4, f5);
    }

    NativePanZoomController(PanZoomTarget panZoomTarget, View view) {
        this.mTarget = panZoomTarget;
        this.mView = (LayerView)view;
        String[] stringArray = new String[]{"ui.scrolling.negate_wheel_scroll"};
        this.mPrefsObserver = new PrefsHelper.PrefHandlerBase(){

            @Override
            public void prefValue(String string2, boolean bl) {
                if (string2.equals("ui.scrolling.negate_wheel_scroll")) {
                    NativePanZoomController.this.mNegateWheelScroll = bl;
                }
            }
        };
        PrefsHelper.addObserver(stringArray, this.mPrefsObserver);
        TypedValue typedValue = new TypedValue();
        this.mPointerScrollFactor = view.getContext().getTheme().resolveAttribute(16842829, typedValue, true) ? typedValue.getDimension(view.getContext().getResources().getDisplayMetrics()) : MAX_SCROLL;
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.handleMotionEvent(motionEvent, true);
    }

    @Override
    public boolean onMotionEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 8 && motionEvent.getDownTime() >= this.mLastDownTime) {
            this.mLastDownTime = motionEvent.getDownTime();
            return this.handleScrollEvent(motionEvent);
        }
        return false;
    }

    @Override
    public boolean onKeyEvent(KeyEvent keyEvent) {
        return false;
    }

    @Override
    public PointF getVelocityVector() {
        return new PointF(0.0f, 0.0f);
    }

    @Override
    public void pageRectUpdated() {
    }

    @Override
    public void abortPanning() {
    }

    @Override
    public void notifyDefaultActionPrevented(boolean bl) {
    }

    @WrapForJNI(stubName="AbortAnimation")
    private native void nativeAbortAnimation();

    @Override
    public void abortAnimation() {
        if (!this.mDestroyed) {
            this.nativeAbortAnimation();
        }
    }

    @Override
    public boolean getRedrawHint() {
        return true;
    }

    @Override
    @WrapForJNI(allowMultithread=true)
    public void destroy() {
        if (this.mDestroyed) {
            return;
        }
        this.mDestroyed = true;
        this.disposeNative();
    }

    @WrapForJNI
    protected native void disposeNative();

    @Override
    public void setOverScrollMode(int n) {
    }

    @Override
    public int getOverScrollMode() {
        return 0;
    }

    @WrapForJNI(allowMultithread=true, stubName="RequestContentRepaintWrapper")
    private void requestContentRepaint(float f, float f2, float f3, float f4, float f5) {
        this.mTarget.forceRedraw(new DisplayPortMetrics(f, f2, f + f3, f2 + f4, f5));
    }

    @Override
    public void setOverscrollHandler(Overscroll overscroll) {
        this.mOverscroll = overscroll;
    }

    @WrapForJNI(stubName="SetIsLongpressEnabled")
    private native void nativeSetIsLongpressEnabled(boolean var1);

    @Override
    public void setIsLongpressEnabled(boolean bl) {
        if (!this.mDestroyed) {
            this.nativeSetIsLongpressEnabled(bl);
        }
    }

    @WrapForJNI(stubName="AdjustScrollForSurfaceShift")
    private native void adjustScrollForSurfaceShift(float var1, float var2);

    @Override
    public ImmutableViewportMetrics adjustScrollForSurfaceShift(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF) {
        this.adjustScrollForSurfaceShift(pointF.x, pointF.y);
        return immutableViewportMetrics.offsetViewportByAndClamp(pointF.x, pointF.y);
    }

    @WrapForJNI(allowMultithread=true)
    private void updateOverscrollVelocity(final float f, final float f2) {
        if (this.mOverscroll != null) {
            if (ThreadUtils.isOnUiThread()) {
                this.mOverscroll.setVelocity(f * 1000.0f, Overscroll.Axis.X);
                this.mOverscroll.setVelocity(f2 * 1000.0f, Overscroll.Axis.Y);
            } else {
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NativePanZoomController.this.mOverscroll.setVelocity(f * 1000.0f, Overscroll.Axis.X);
                        NativePanZoomController.this.mOverscroll.setVelocity(f2 * 1000.0f, Overscroll.Axis.Y);
                    }
                });
            }
        }
    }

    @WrapForJNI(allowMultithread=true)
    private void updateOverscrollOffset(final float f, final float f2) {
        if (this.mOverscroll != null) {
            if (ThreadUtils.isOnUiThread()) {
                this.mOverscroll.setDistance(f, Overscroll.Axis.X);
                this.mOverscroll.setDistance(f2, Overscroll.Axis.Y);
            } else {
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NativePanZoomController.this.mOverscroll.setDistance(f, Overscroll.Axis.X);
                        NativePanZoomController.this.mOverscroll.setDistance(f2, Overscroll.Axis.Y);
                    }
                });
            }
        }
    }
}

