/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.accounts.Account;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.widget.SwipeRefreshLayout;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.RemoteClientsDialogFragment;
import org.mozilla.gecko.RemoteTabsExpandableListAdapter;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.SyncStatusListener;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.RemoteTabsExpandableListState;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.home.TransitionAwareCursorLoaderCallbacks;

public abstract class RemoteTabsBaseFragment
extends HomeFragment
implements RemoteClientsDialogFragment.RemoteClientsListener {
    private static final String LOGTAG = "GeckoRemoteTabsBaseFragment";
    private static final String[] STAGES_TO_SYNC_ON_REFRESH = new String[]{"clients", "tabs"};
    private static final long LAST_SYNCED_TIME_UPDATE_INTERVAL_IN_MILLISECONDS = 60000L;
    protected static final int LOADER_ID_REMOTE_TABS = 0;
    protected static final String DIALOG_TAG_REMOTE_TABS = "dialog_tag_remote_tabs";
    protected static RemoteTabsExpandableListState sState;
    protected RemoteTabsExpandableListAdapter mAdapter;
    protected final List<RemoteClient> mHiddenClients = new ArrayList<RemoteClient>();
    protected CursorLoaderCallbacks mCursorLoaderCallbacks;
    protected SwipeRefreshLayout mRefreshLayout;
    protected RemoteTabsSyncListener mSyncStatusListener;
    protected View mEmptyView;
    protected View mFooterView;
    protected Handler mHandler;
    protected Runnable mLastSyncedTimeUpdateRunnable;

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.mRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.remote_tabs_refresh_layout);
        this.mRefreshLayout.setColorSchemeResources(new int[]{R.color.fennec_ui_orange, R.color.action_orange});
        this.mRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)new RemoteTabsRefreshListener());
        this.mSyncStatusListener = new RemoteTabsSyncListener();
        FirefoxAccounts.addSyncStatusListener((SyncStatusListener)this.mSyncStatusListener);
        this.mHandler = new Handler();
        this.mLastSyncedTimeUpdateRunnable = new LastSyncTimeUpdateRunnable();
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        if (sState == null) {
            sState = new RemoteTabsExpandableListState(GeckoSharedPrefs.forProfile((Context)this.getActivity()));
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mSyncStatusListener != null) {
            FirefoxAccounts.removeSyncStatusListener((SyncStatusListener)this.mSyncStatusListener);
            this.mSyncStatusListener = null;
        }
        if (this.mLastSyncedTimeUpdateRunnable != null) {
            this.mHandler.removeCallbacks(this.mLastSyncedTimeUpdateRunnable);
            this.mLastSyncedTimeUpdateRunnable = null;
            this.mHandler = null;
        }
    }

    @Override
    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        if (!(contextMenuInfo instanceof RemoteTabsClientContextMenuInfo)) {
            super.onCreateContextMenu(contextMenu, view, contextMenuInfo);
            return;
        }
        MenuInflater menuInflater = new MenuInflater(view.getContext());
        menuInflater.inflate(R.menu.home_remote_tabs_client_contextmenu, (Menu)contextMenu);
        RemoteTabsClientContextMenuInfo remoteTabsClientContextMenuInfo = (RemoteTabsClientContextMenuInfo)contextMenuInfo;
        contextMenu.setHeaderTitle((CharSequence)remoteTabsClientContextMenuInfo.client.name);
        boolean bl = sState.isClientHidden(remoteTabsClientContextMenuInfo.client.guid);
        MenuItem menuItem = contextMenu.findItem(bl ? R.id.home_remote_tabs_hide_client : R.id.home_remote_tabs_show_client);
        menuItem.setVisible(false);
    }

    @Override
    public boolean onContextItemSelected(MenuItem menuItem) {
        if (super.onContextItemSelected(menuItem)) {
            return true;
        }
        ContextMenu.ContextMenuInfo contextMenuInfo = menuItem.getMenuInfo();
        if (!(contextMenuInfo instanceof RemoteTabsClientContextMenuInfo)) {
            return false;
        }
        RemoteTabsClientContextMenuInfo remoteTabsClientContextMenuInfo = (RemoteTabsClientContextMenuInfo)contextMenuInfo;
        int n = menuItem.getItemId();
        if (n == R.id.home_remote_tabs_hide_client) {
            sState.setClientHidden(remoteTabsClientContextMenuInfo.client.guid, true);
            this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
            return true;
        }
        if (n == R.id.home_remote_tabs_show_client) {
            sState.setClientHidden(remoteTabsClientContextMenuInfo.client.guid, false);
            this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
            return true;
        }
        return false;
    }

    @Override
    public void onClients(List<RemoteClient> list) {
        for (RemoteClient remoteClient : list) {
            sState.setClientHidden(remoteClient.guid, false);
            sState.setClientCollapsed(remoteClient.guid, false);
        }
        this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    @Override
    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    protected abstract void updateUiFromClients(List<RemoteClient> var1, List<RemoteClient> var2);

    protected void scheduleLastSyncedTime() {
        this.mHandler.postDelayed(this.mLastSyncedTimeUpdateRunnable, 60000L);
    }

    protected void updateAndScheduleLastSyncedTime() {
        this.mAdapter.notifyDataSetChanged();
        this.scheduleLastSyncedTime();
    }

    protected class LastSyncTimeUpdateRunnable
    implements Runnable {
        protected LastSyncTimeUpdateRunnable() {
        }

        @Override
        public void run() {
            RemoteTabsBaseFragment.this.updateAndScheduleLastSyncedTime();
        }
    }

    protected static class RemoteTabsClientContextMenuInfo
    extends HomeContextMenuInfo {
        protected final RemoteClient client;

        public RemoteTabsClientContextMenuInfo(View view, int n, long l, RemoteClient remoteClient) {
            super(view, n, l);
            this.client = remoteClient;
        }
    }

    protected class RemoteTabsSyncListener
    implements SyncStatusListener {
        protected RemoteTabsSyncListener() {
        }

        public Context getContext() {
            return RemoteTabsBaseFragment.this.getActivity();
        }

        public Account getAccount() {
            return FirefoxAccounts.getFirefoxAccount((Context)this.getContext());
        }

        public void onSyncStarted() {
        }

        public void onSyncFinished() {
            RemoteTabsBaseFragment.this.mRefreshLayout.setRefreshing(false);
        }
    }

    protected class RemoteTabsRefreshListener
    implements SwipeRefreshLayout.OnRefreshListener {
        protected RemoteTabsRefreshListener() {
        }

        public void onRefresh() {
            if (FirefoxAccounts.firefoxAccountsExist((Context)RemoteTabsBaseFragment.this.getActivity())) {
                Account account = FirefoxAccounts.getFirefoxAccount((Context)RemoteTabsBaseFragment.this.getActivity());
                FirefoxAccounts.requestImmediateSync((Account)account, (String[])STAGES_TO_SYNC_ON_REFRESH, null);
            } else {
                Log.wtf((String)RemoteTabsBaseFragment.LOGTAG, (String)"No Firefox Account found; this should never happen. Ignoring.");
                RemoteTabsBaseFragment.this.mRefreshLayout.setRefreshing(false);
            }
        }
    }

    protected class CursorLoaderCallbacks
    extends TransitionAwareCursorLoaderCallbacks {
        private BrowserDB mDB;

        protected CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            this.mDB = GeckoProfile.get((Context)RemoteTabsBaseFragment.this.getActivity()).getDB();
            return new RemoteTabsCursorLoader((Context)RemoteTabsBaseFragment.this.getActivity());
        }

        @Override
        public void onLoadFinishedAfterTransitions(Loader<Cursor> loader, Cursor cursor) {
            List<RemoteClient> list = this.mDB.getTabsAccessor().getClientsFromCursor(cursor);
            RemoteTabsBaseFragment.this.mHiddenClients.clear();
            Iterator<RemoteClient> iterator = list.iterator();
            while (iterator.hasNext()) {
                RemoteClient remoteClient = iterator.next();
                if (!sState.isClientHidden(remoteClient.guid)) continue;
                iterator.remove();
                RemoteTabsBaseFragment.this.mHiddenClients.add(remoteClient);
            }
            RemoteTabsBaseFragment.this.mAdapter.replaceClients(list);
            RemoteTabsBaseFragment.this.updateUiFromClients(list, RemoteTabsBaseFragment.this.mHiddenClients);
            RemoteTabsBaseFragment.this.scheduleLastSyncedTime();
        }

        @Override
        public void onLoaderReset(Loader<Cursor> loader) {
            super.onLoaderReset(loader);
            RemoteTabsBaseFragment.this.mAdapter.replaceClients(null);
        }
    }

    private static class RemoteTabsCursorLoader
    extends SimpleCursorLoader {
        private final GeckoProfile mProfile;

        public RemoteTabsCursorLoader(Context context) {
            super(context);
            this.mProfile = GeckoProfile.get(context);
        }

        @Override
        public Cursor loadCursor() {
            return this.mProfile.getDB().getTabsAccessor().getRemoteTabsCursor(this.getContext());
        }
    }
}

