/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mdns;

import android.annotation.TargetApi;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.mdns.NsdMulticastDNSManager;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.GeckoRequest;
import org.mozilla.gecko.util.NativeJSObject;

@TargetApi(value=16)
class DiscoveryListener
implements NsdManager.DiscoveryListener {
    private static final String LOGTAG = "GeckoMDNSManager";
    private final NsdManager nsdManager;
    private EventCallback mStartCallback = null;
    private EventCallback mStopCallback = null;

    DiscoveryListener(NsdManager nsdManager) {
        this.nsdManager = nsdManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverServices(String string2, EventCallback eventCallback) {
        DiscoveryListener discoveryListener = this;
        synchronized (discoveryListener) {
            this.mStartCallback = eventCallback;
        }
        this.nsdManager.discoverServices(string2, 1, (NsdManager.DiscoveryListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServiceDiscovery(EventCallback eventCallback) {
        DiscoveryListener discoveryListener = this;
        synchronized (discoveryListener) {
            this.mStopCallback = eventCallback;
        }
        this.nsdManager.stopServiceDiscovery((NsdManager.DiscoveryListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onDiscoveryStarted(String string2) {
        EventCallback eventCallback;
        Log.d((String)LOGTAG, (String)("onDiscoveryStarted: " + string2));
        DiscoveryListener discoveryListener = this;
        synchronized (discoveryListener) {
            eventCallback = this.mStartCallback;
        }
        if (eventCallback == null) {
            return;
        }
        eventCallback.sendSuccess((Object)string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onStartDiscoveryFailed(String string2, int n) {
        EventCallback eventCallback;
        Log.e((String)LOGTAG, (String)("onStartDiscoveryFailed: " + string2 + "(" + n + ")"));
        DiscoveryListener discoveryListener = this;
        synchronized (discoveryListener) {
            eventCallback = this.mStartCallback;
        }
        eventCallback.sendError((Object)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onDiscoveryStopped(String string2) {
        EventCallback eventCallback;
        Log.d((String)LOGTAG, (String)("onDiscoveryStopped: " + string2));
        DiscoveryListener discoveryListener = this;
        synchronized (discoveryListener) {
            eventCallback = this.mStopCallback;
        }
        if (eventCallback == null) {
            return;
        }
        eventCallback.sendSuccess((Object)string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onStopDiscoveryFailed(String string2, int n) {
        EventCallback eventCallback;
        Log.e((String)LOGTAG, (String)("onStopDiscoveryFailed: " + string2 + "(" + n + ")"));
        DiscoveryListener discoveryListener = this;
        synchronized (discoveryListener) {
            eventCallback = this.mStopCallback;
        }
        if (eventCallback == null) {
            return;
        }
        eventCallback.sendError((Object)n);
    }

    public void onServiceFound(NsdServiceInfo nsdServiceInfo) {
        JSONObject jSONObject;
        Log.d((String)LOGTAG, (String)("onServiceFound: " + nsdServiceInfo.getServiceName()));
        try {
            jSONObject = NsdMulticastDNSManager.toJSON(nsdServiceInfo);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        GeckoAppShell.sendRequestToGecko(new GeckoRequest("NsdManager:ServiceFound", jSONObject){

            public void onResponse(NativeJSObject nativeJSObject) {
            }
        });
    }

    public void onServiceLost(NsdServiceInfo nsdServiceInfo) {
        JSONObject jSONObject;
        Log.d((String)LOGTAG, (String)("onServiceLost: " + nsdServiceInfo.getServiceName()));
        try {
            jSONObject = NsdMulticastDNSManager.toJSON(nsdServiceInfo);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        GeckoAppShell.sendRequestToGecko(new GeckoRequest("NsdManager:ServiceLost", jSONObject){

            public void onResponse(NativeJSObject nativeJSObject) {
            }
        });
    }
}

