/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabqueue;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.mozglue.ContextUtils;
import org.mozilla.gecko.tabqueue.TabQueueHelper;

public class TabQueueService
extends Service {
    private static final String LOGTAG = "Gecko" + TabQueueService.class.getSimpleName();
    private static final long TOAST_TIMEOUT = 3000L;
    private static final long TOAST_DOUBLE_TAP_TIMEOUT_MILLIS = 6000L;
    private WindowManager windowManager;
    private View toastLayout;
    private Button openNowButton;
    private Handler tabQueueHandler;
    private WindowManager.LayoutParams toastLayoutParams;
    private volatile StopServiceRunnable stopServiceRunnable;
    private HandlerThread handlerThread;
    private ExecutorService executorService;

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        this.executorService = Executors.newSingleThreadExecutor();
        this.handlerThread = new HandlerThread("TabQueueHandlerThread");
        this.handlerThread.start();
        this.tabQueueHandler = new Handler(this.handlerThread.getLooper());
        this.windowManager = (WindowManager)this.getSystemService("window");
        LayoutInflater layoutInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        this.toastLayout = layoutInflater.inflate(R.layout.tab_queue_toast, null);
        Resources resources = this.getResources();
        TextView textView = (TextView)this.toastLayout.findViewById(R.id.toast_message);
        textView.setText(resources.getText(R.string.tab_queue_toast_message));
        this.openNowButton = (Button)this.toastLayout.findViewById(R.id.toast_button);
        this.openNowButton.setText(resources.getText(R.string.tab_queue_toast_action));
        this.toastLayoutParams = new WindowManager.LayoutParams(-1, -2, 2002, 262184, -3);
        this.toastLayoutParams.gravity = 81;
    }

    public int onStartCommand(final Intent intent, int n, final int n2) {
        if (n != 1) {
            boolean bl;
            final Context context = this.getApplicationContext();
            SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(context);
            String string2 = sharedPreferences.getString("android.not_a_preference.last_site", "");
            final ContextUtils.SafeIntent safeIntent = new ContextUtils.SafeIntent(intent);
            final String string3 = safeIntent.getDataString();
            long l = sharedPreferences.getLong("android.not_a_preference.last_time", 0L);
            boolean bl2 = bl = System.currentTimeMillis() - l < 6000L;
            if (!TextUtils.isEmpty((CharSequence)string2) && string2.equals(string3) && bl) {
                this.tabQueueHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (TabQueueService.this.stopServiceRunnable != null) {
                            TabQueueService.this.tabQueueHandler.removeCallbacks((Runnable)TabQueueService.this.stopServiceRunnable);
                            TabQueueService.this.stopSelfResult(TabQueueService.this.stopServiceRunnable.getStartId());
                            TabQueueService.this.stopServiceRunnable = null;
                            TabQueueService.this.removeView();
                        } else {
                            TabQueueHelper.removeURLFromFile(context, string3, "tab_queue_url_list.json");
                        }
                        TabQueueService.this.openNow(safeIntent.getUnsafe());
                        Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.INTENT, "tabqueue-doubletap");
                        TabQueueService.this.stopSelfResult(n2);
                    }
                });
                return 3;
            }
            sharedPreferences.edit().putString("android.not_a_preference.last_site", string3).putLong("android.not_a_preference.last_time", System.currentTimeMillis()).apply();
        }
        if (this.stopServiceRunnable != null) {
            this.tabQueueHandler.removeCallbacks((Runnable)this.stopServiceRunnable);
            this.stopServiceRunnable.run(false);
        } else {
            try {
                this.windowManager.addView(this.toastLayout, (ViewGroup.LayoutParams)this.toastLayoutParams);
            }
            catch (SecurityException securityException) {
                Toast.makeText((Context)this, (CharSequence)this.getText(R.string.tab_queue_toast_message), (int)0).show();
                this.showSettingsNotification();
            }
        }
        this.stopServiceRunnable = new StopServiceRunnable(n2){

            @Override
            public void onRun() {
                TabQueueService.this.addURLToTabQueue(intent, "tab_queue_url_list.json");
                TabQueueService.this.stopServiceRunnable = null;
            }
        };
        this.openNowButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TabQueueService.this.tabQueueHandler.removeCallbacks((Runnable)TabQueueService.this.stopServiceRunnable);
                TabQueueService.this.stopServiceRunnable = null;
                TabQueueService.this.removeView();
                TabQueueService.this.openNow(intent);
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.INTENT, "tabqueue-now");
                TabQueueService.this.stopSelfResult(n2);
            }
        });
        this.tabQueueHandler.postDelayed((Runnable)this.stopServiceRunnable, 3000L);
        return 3;
    }

    private void openNow(Intent intent) {
        Intent intent2 = new Intent(intent);
        intent2.setClassName(this.getApplicationContext(), "org.mozilla.gecko.BrowserApp");
        intent2.setFlags(0x10000000);
        this.startActivity(intent2);
        TabQueueHelper.removeNotification(this.getApplicationContext());
        GeckoSharedPrefs.forApp(this.getApplicationContext()).edit().remove("android.not_a_preference.last_site").remove("android.not_a_preference.last_time").apply();
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                int n = TabQueueHelper.getTabQueueLength((Context)TabQueueService.this);
                Telemetry.addToHistogram("FENNEC_TABQUEUE_QUEUESIZE", n);
            }
        });
    }

    @TargetApi(value=23)
    private void showSettingsNotification() {
        if (AppConstants.Versions.preM) {
            return;
        }
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)intent.hashCode(), (Intent)intent, (int)0);
        String string2 = this.getString(R.string.tab_queue_notification_settings);
        NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle().bigText((CharSequence)string2);
        Notification notification = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)this.getString(R.string.pref_tab_queue_title)).setContentText((CharSequence)string2).setCategory("err").setStyle((NotificationCompat.Style)bigTextStyle).setSmallIcon(R.drawable.ic_status_logo).setContentIntent(pendingIntent).setPriority(2).setAutoCancel(true).addAction(R.drawable.ic_action_settings, (CharSequence)this.getString(R.string.tab_queue_prompt_settings_button), pendingIntent).build();
        NotificationManagerCompat.from((Context)this).notify(R.id.tabQueueSettingsNotification, notification);
    }

    private void removeView() {
        try {
            this.windowManager.removeView(this.toastLayout);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            Log.e((String)LOGTAG, (String)"Error removing Tab Queue toast from service", (Throwable)runtimeException);
        }
    }

    private void addURLToTabQueue(Intent intent, final String string2) {
        if (intent == null) {
            Log.w((String)LOGTAG, (String)"Error adding URL to tab queue - invalid intent passed in.");
            return;
        }
        ContextUtils.SafeIntent safeIntent = new ContextUtils.SafeIntent(intent);
        final String string3 = safeIntent.getDataString();
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                Context context = TabQueueService.this.getApplicationContext();
                GeckoProfile geckoProfile = GeckoProfile.get(context);
                int n = TabQueueHelper.queueURL(geckoProfile, string3, string2);
                List<String> list = TabQueueHelper.getLastURLs(context, string2);
                TabQueueHelper.showNotification(context, n, list);
                SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(context);
                sharedPreferences.edit().putInt("tab_queue_count", n).apply();
            }
        });
    }

    public void onDestroy() {
        super.onDestroy();
        this.handlerThread.quit();
    }

    private abstract class StopServiceRunnable
    implements Runnable {
        private final int startId;

        public StopServiceRunnable(int n) {
            this.startId = n;
        }

        @Override
        public void run() {
            this.run(true);
        }

        public void run(boolean bl) {
            this.onRun();
            if (bl) {
                TabQueueService.this.removeView();
            }
            TabQueueService.this.stopSelfResult(this.startId);
        }

        public int getStartId() {
            return this.startId;
        }

        public abstract void onRun();
    }
}

