/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.tabs.TabsLayoutAdapter;
import org.mozilla.gecko.tabs.TabsLayoutItemView;
import org.mozilla.gecko.tabs.TabsPanel;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.TwoWayView;
import org.mozilla.gecko.widget.themed.ThemedRelativeLayout;

class TabsListLayout
extends TwoWayView
implements TabsPanel.TabsLayout,
Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "Gecko" + TabsListLayout.class.getSimpleName();
    private static final int ANIMATION_DURATION = 250;
    private static final int ANIMATION_CASCADE_DELAY = 75;
    private final boolean isPrivate;
    private final TabsLayoutAdapter tabsAdapter;
    private final List<View> pendingClosedTabs = new ArrayList<View>();
    private TabsPanel tabsPanel;
    private int closeAnimationCount;
    private int closeAllAnimationCount;
    private int originalSize;

    public TabsListLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setItemsCanFocus(true);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TabsLayout);
        this.isPrivate = typedArray.getInt(R.styleable.TabsLayout_tabs, 0) == 1;
        typedArray.recycle();
        this.tabsAdapter = new TabsListLayoutAdapter(context);
        this.setAdapter((ListAdapter)this.tabsAdapter);
        TabSwipeGestureListener tabSwipeGestureListener = new TabSwipeGestureListener();
        this.setOnTouchListener(tabSwipeGestureListener);
        this.setOnScrollListener(tabSwipeGestureListener.makeScrollListener());
        this.setRecyclerListener(new TwoWayView.RecyclerListener(){

            @Override
            public void onMovedToScrapHeap(View view) {
                TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)view;
                tabsLayoutItemView.setThumbnail(null);
                tabsLayoutItemView.setCloseVisible(true);
            }
        });
    }

    @Override
    public void setTabsPanel(TabsPanel tabsPanel) {
        this.tabsPanel = tabsPanel;
    }

    @Override
    public void show() {
        this.setVisibility(0);
        Tabs.getInstance().refreshThumbnails();
        Tabs.registerOnTabsChangedListener(this);
        this.refreshTabsData();
    }

    @Override
    public void hide() {
        this.setVisibility(8);
        Tabs.unregisterOnTabsChangedListener(this);
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Tab:Screenshot:Cancel", ""));
        this.tabsAdapter.clear();
    }

    @Override
    public boolean shouldExpand() {
        return this.isVertical();
    }

    private void autoHidePanel() {
        this.tabsPanel.autoHidePanel();
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case ADDED: {
                this.refreshTabsData();
                break;
            }
            case CLOSED: {
                if (tab.isPrivate() != this.isPrivate || this.tabsAdapter.getCount() <= 0 || !this.tabsAdapter.removeTab(tab)) break;
                int n = this.tabsAdapter.getPositionForTab(Tabs.getInstance().getSelectedTab());
                this.updateSelectedStyle(n);
                break;
            }
            case SELECTED: {
                this.updateSelectedPosition();
            }
            case UNSELECTED: 
            case THUMBNAIL: 
            case TITLE: 
            case RECORDING_CHANGE: 
            case AUDIO_PLAYING_CHANGE: {
                View view = this.getChildAt(this.tabsAdapter.getPositionForTab(tab) - this.getFirstVisiblePosition());
                if (view == null) {
                    return;
                }
                TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)view;
                tabsLayoutItemView.assignValues(tab);
            }
        }
    }

    private void updateSelectedPosition() {
        int n = this.tabsAdapter.getPositionForTab(Tabs.getInstance().getSelectedTab());
        this.updateSelectedStyle(n);
        if (n != -1) {
            this.setSelection(n);
        }
    }

    private void updateSelectedStyle(int n) {
        for (int i = 0; i < this.tabsAdapter.getCount(); ++i) {
            this.setItemChecked(i, i == n);
        }
    }

    private void refreshTabsData() {
        ArrayList<Tab> arrayList = new ArrayList<Tab>();
        Iterable<Tab> iterable = Tabs.getInstance().getTabsInOrder();
        for (Tab tab : iterable) {
            if (tab.isPrivate() != this.isPrivate) continue;
            arrayList.add(tab);
        }
        this.tabsAdapter.setTabs(arrayList);
        this.updateSelectedPosition();
    }

    public void resetTransforms(View view) {
        ViewHelper.setAlpha(view, 1.0f);
        if (this.isVertical()) {
            ViewHelper.setTranslationX(view, 0.0f);
        } else {
            ViewHelper.setTranslationY(view, 0.0f);
        }
        if (this.originalSize != 0) {
            if (this.isVertical()) {
                ViewHelper.setHeight(view, this.originalSize);
            } else {
                ViewHelper.setWidth(view, this.originalSize);
            }
        }
    }

    private boolean isVertical() {
        return this.getOrientation().compareTo(TwoWayView.Orientation.VERTICAL) == 0;
    }

    @Override
    public void closeAll() {
        int n = this.getChildCount();
        if (n == 0) {
            this.autoHidePanel();
            return;
        }
        this.setEnabled(false);
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            View view = this.getChildAt(i);
            final PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
            propertyAnimator.attach(view, PropertyAnimator.Property.ALPHA, 0.0f);
            if (this.isVertical()) {
                propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_X, view.getWidth());
            } else {
                propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_Y, view.getHeight());
            }
            ++this.closeAllAnimationCount;
            propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

                @Override
                public void onPropertyAnimationStart() {
                }

                @Override
                public void onPropertyAnimationEnd() {
                    TabsListLayout.this.closeAllAnimationCount--;
                    if (TabsListLayout.this.closeAllAnimationCount > 0) {
                        return;
                    }
                    TabsListLayout.this.autoHidePanel();
                    TabsListLayout.this.setEnabled(true);
                    Iterable<Tab> iterable = Tabs.getInstance().getTabsInOrder();
                    for (Tab tab : iterable) {
                        if (TabsListLayout.this.isPrivate && !tab.isPrivate()) continue;
                        Tabs.getInstance().closeTab(tab, false);
                    }
                }
            });
            ThreadUtils.getUiHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    propertyAnimator.start();
                }
            }, (long)n2);
            n2 += 75;
        }
    }

    private void animateClose(View view, int n) {
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        propertyAnimator.attach(view, PropertyAnimator.Property.ALPHA, 0.0f);
        if (this.isVertical()) {
            propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_X, n);
        } else {
            propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_Y, n);
        }
        ++this.closeAnimationCount;
        this.pendingClosedTabs.add(view);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
            }

            @Override
            public void onPropertyAnimationEnd() {
                TabsListLayout.this.closeAnimationCount--;
                if (TabsListLayout.this.closeAnimationCount > 0) {
                    return;
                }
                for (View view : TabsListLayout.this.pendingClosedTabs) {
                    TabsListLayout.this.animateFinishClose(view);
                }
                TabsListLayout.this.pendingClosedTabs.clear();
            }
        });
        if (this.tabsAdapter.getCount() == 1) {
            this.autoHidePanel();
        }
        propertyAnimator.start();
    }

    private void animateFinishClose(View view) {
        boolean bl = this.isVertical();
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        if (bl) {
            propertyAnimator.attach(view, PropertyAnimator.Property.HEIGHT, 1.0f);
        } else {
            propertyAnimator.attach(view, PropertyAnimator.Property.WIDTH, 1.0f);
        }
        final int n = ((TabsLayoutItemView)view).getTabId();
        if (this.originalSize == 0) {
            this.originalSize = bl ? view.getHeight() : view.getWidth();
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
            }

            @Override
            public void onPropertyAnimationEnd() {
                Tabs tabs = Tabs.getInstance();
                Tab tab = tabs.getTab(n);
                tabs.closeTab(tab, true);
            }
        });
        propertyAnimator.start();
    }

    private void animateCancel(final View view) {
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        propertyAnimator.attach(view, PropertyAnimator.Property.ALPHA, 1.0f);
        if (this.isVertical()) {
            propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        } else {
            propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_Y, 0.0f);
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
            }

            @Override
            public void onPropertyAnimationEnd() {
                TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)view;
                tabsLayoutItemView.setCloseVisible(true);
            }
        });
        propertyAnimator.start();
    }

    private class TabSwipeGestureListener
    implements View.OnTouchListener {
        private static final float MIN_VELOCITY = 750.0f;
        private final int swipeThreshold;
        private final int minFlingVelocity;
        private final int maxFlingVelocity;
        private VelocityTracker velocityTracker;
        private int listWidth = 1;
        private int listHeight = 1;
        private View swipeView;
        private Runnable pendingCheckForTap;
        private float swipeStartX;
        private float swipeStartY;
        private boolean swiping;
        private boolean enabled = true;

        public TabSwipeGestureListener() {
            ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)TabsListLayout.this.getContext());
            this.swipeThreshold = viewConfiguration.getScaledTouchSlop();
            this.minFlingVelocity = (int)(TabsListLayout.this.getContext().getResources().getDisplayMetrics().density * 750.0f);
            this.maxFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public TwoWayView.OnScrollListener makeScrollListener() {
            return new TwoWayView.OnScrollListener(){

                @Override
                public void onScrollStateChanged(TwoWayView twoWayView, int n) {
                    TabSwipeGestureListener.this.setEnabled(n != 1);
                }

                @Override
                public void onScroll(TwoWayView twoWayView, int n, int n2, int n3) {
                }
            };
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (!this.enabled) {
                return false;
            }
            if (this.listWidth < 2 || this.listHeight < 2) {
                this.listWidth = TabsListLayout.this.getWidth();
                this.listHeight = TabsListLayout.this.getHeight();
            }
            switch (motionEvent.getActionMasked()) {
                case 0: {
                    this.triggerCheckForTap();
                    float f = motionEvent.getRawX();
                    float f2 = motionEvent.getRawY();
                    this.swipeView = this.findViewAt(f, f2);
                    if (this.swipeView != null) {
                        this.swipeStartX = motionEvent.getRawX();
                        this.swipeStartY = motionEvent.getRawY();
                        this.velocityTracker = VelocityTracker.obtain();
                        this.velocityTracker.addMovement(motionEvent);
                    }
                    view.onTouchEvent(motionEvent);
                    return true;
                }
                case 1: {
                    int n;
                    if (this.swipeView == null) break;
                    this.cancelCheckForTap();
                    this.swipeView.setPressed(false);
                    if (!this.swiping) {
                        TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)this.swipeView;
                        Tabs.getInstance().selectTab(tabsLayoutItemView.getTabId());
                        TabsListLayout.this.autoHidePanel();
                        this.velocityTracker.recycle();
                        this.velocityTracker = null;
                        break;
                    }
                    this.velocityTracker.addMovement(motionEvent);
                    this.velocityTracker.computeCurrentVelocity(1000, (float)this.maxFlingVelocity);
                    float f = Math.abs(this.velocityTracker.getXVelocity());
                    float f3 = Math.abs(this.velocityTracker.getYVelocity());
                    boolean bl = false;
                    boolean bl2 = false;
                    if (TabsListLayout.this.isVertical()) {
                        float f4 = ViewHelper.getTranslationX(this.swipeView);
                        if (Math.abs(f4) > (float)(this.listWidth / 2)) {
                            bl = true;
                            bl2 = f4 > 0.0f;
                        } else if ((float)this.minFlingVelocity <= f && f <= (float)this.maxFlingVelocity && f3 < f) {
                            bl = this.swiping && f4 * this.velocityTracker.getXVelocity() > 0.0f;
                            bl2 = this.velocityTracker.getXVelocity() > 0.0f;
                        }
                        n = bl2 ? this.listWidth : -this.listWidth;
                    } else {
                        float f5 = ViewHelper.getTranslationY(this.swipeView);
                        if (Math.abs(f5) > (float)(this.listHeight / 2)) {
                            bl = true;
                            bl2 = f5 > 0.0f;
                        } else if ((float)this.minFlingVelocity <= f3 && f3 <= (float)this.maxFlingVelocity && f < f3) {
                            bl = this.swiping && f5 * this.velocityTracker.getYVelocity() > 0.0f;
                            bl2 = this.velocityTracker.getYVelocity() > 0.0f;
                        }
                        int n2 = n = bl2 ? this.listHeight : -this.listHeight;
                    }
                    if (bl) {
                        TabsListLayout.this.animateClose(this.swipeView, n);
                    } else {
                        TabsListLayout.this.animateCancel(this.swipeView);
                    }
                    this.velocityTracker.recycle();
                    this.velocityTracker = null;
                    this.swipeView = null;
                    this.swipeStartX = 0.0f;
                    this.swipeStartY = 0.0f;
                    this.swiping = false;
                    break;
                }
                case 2: {
                    boolean bl;
                    if (this.swipeView == null || this.velocityTracker == null) break;
                    this.velocityTracker.addMovement(motionEvent);
                    boolean bl3 = TabsListLayout.this.isVertical();
                    float f = motionEvent.getRawX() - this.swipeStartX;
                    float f6 = motionEvent.getRawY() - this.swipeStartY;
                    float f7 = bl3 ? f : f6;
                    boolean bl4 = Math.abs(f) > (float)this.swipeThreshold;
                    boolean bl5 = Math.abs(f6) > (float)this.swipeThreshold;
                    boolean bl6 = bl = bl3 ? bl4 : bl5;
                    if (bl4 || bl5) {
                        this.cancelCheckForTap();
                    }
                    if (bl) {
                        this.swiping = true;
                        TabsListLayout.this.requestDisallowInterceptTouchEvent(true);
                        ((TabsLayoutItemView)this.swipeView).setCloseVisible(false);
                        MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                        motionEvent2.setAction(3 | motionEvent.getActionIndex() << 8);
                        TabsListLayout.this.onTouchEvent(motionEvent2);
                        motionEvent2.recycle();
                    }
                    if (!this.swiping) break;
                    if (bl3) {
                        ViewHelper.setTranslationX(this.swipeView, f7);
                    } else {
                        ViewHelper.setTranslationY(this.swipeView, f7);
                    }
                    ViewHelper.setAlpha(this.swipeView, Math.max(0.1f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(f7) / (float)(bl3 ? this.listWidth : this.listHeight))));
                    return true;
                }
            }
            return false;
        }

        private View findViewAt(float f, float f2) {
            Rect rect = new Rect();
            int[] nArray = new int[2];
            TabsListLayout.this.getLocationOnScreen(nArray);
            int n = (int)f - nArray[0];
            int n2 = (int)f2 - nArray[1];
            for (int i = 0; i < TabsListLayout.this.getChildCount(); ++i) {
                View view = TabsListLayout.this.getChildAt(i);
                view.getHitRect(rect);
                if (!rect.contains(n, n2)) continue;
                return view;
            }
            return null;
        }

        private void triggerCheckForTap() {
            if (this.pendingCheckForTap == null) {
                this.pendingCheckForTap = new CheckForTap();
            }
            TabsListLayout.this.postDelayed(this.pendingCheckForTap, ViewConfiguration.getTapTimeout());
        }

        private void cancelCheckForTap() {
            if (this.pendingCheckForTap == null) {
                return;
            }
            TabsListLayout.this.removeCallbacks(this.pendingCheckForTap);
        }

        private class CheckForTap
        implements Runnable {
            private CheckForTap() {
            }

            @Override
            public void run() {
                if (!TabSwipeGestureListener.this.swiping && TabSwipeGestureListener.this.swipeView != null && TabSwipeGestureListener.this.enabled) {
                    TabSwipeGestureListener.this.swipeView.setPressed(true);
                }
            }
        }
    }

    private class TabsListLayoutAdapter
    extends TabsLayoutAdapter {
        private final View.OnClickListener mCloseOnClickListener;

        public TabsListLayoutAdapter(Context context) {
            super(context, R.layout.tabs_list_item_view);
            this.mCloseOnClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)((Object)view.getTag());
                    int n = TabsListLayout.this.isVertical() ? tabsLayoutItemView.getWidth() : 0 - tabsLayoutItemView.getHeight();
                    TabsListLayout.this.animateClose((View)tabsLayoutItemView, n);
                }
            };
        }

        @Override
        public TabsLayoutItemView newView(int n, ViewGroup viewGroup) {
            TabsLayoutItemView tabsLayoutItemView = super.newView(n, viewGroup);
            tabsLayoutItemView.setCloseOnClickListener(this.mCloseOnClickListener);
            ((ThemedRelativeLayout)tabsLayoutItemView.findViewById(R.id.wrapper)).setPrivateMode(TabsListLayout.this.isPrivate);
            return tabsLayoutItemView;
        }

        @Override
        public void bindView(TabsLayoutItemView tabsLayoutItemView, Tab tab) {
            super.bindView(tabsLayoutItemView, tab);
            TabsListLayout.this.resetTransforms((View)tabsLayoutItemView);
        }
    }
}

