/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import org.mozilla.gecko.R;
import org.mozilla.gecko.lwt.LightweightThemeDrawable;
import org.mozilla.gecko.util.ColorUtils;
import org.mozilla.gecko.widget.themed.ThemedFrameLayout;

public class ShapedButtonFrameLayout
extends ThemedFrameLayout {
    public ShapedButtonFrameLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    @Override
    public void onLightweightThemeChanged() {
        int n = ColorUtils.getColor((Context)this.getContext(), (int)R.color.text_and_tabs_tray_grey);
        LightweightThemeDrawable lightweightThemeDrawable = this.getTheme().getColorDrawable((View)this, n);
        if (lightweightThemeDrawable == null) {
            return;
        }
        lightweightThemeDrawable.setAlpha(34, 34);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(PRESSED_ENABLED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_shaped));
        stateListDrawable.addState(FOCUSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_shaped_focused));
        stateListDrawable.addState(PRIVATE_STATE_SET, (Drawable)this.getColorDrawable(R.color.text_and_tabs_tray_grey));
        stateListDrawable.addState(EMPTY_STATE_SET, (Drawable)lightweightThemeDrawable);
        this.setBackgroundDrawable((Drawable)stateListDrawable);
    }

    @Override
    public void onLightweightThemeReset() {
        this.setBackgroundResource(R.drawable.shaped_button);
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        if (this.getBackground() == null || drawable2 == null) {
            super.setBackgroundDrawable(drawable2);
            return;
        }
        int[] nArray = new int[]{this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom()};
        drawable2.setLevel(this.getBackground().getLevel());
        super.setBackgroundDrawable(drawable2);
        this.setPadding(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public void setBackgroundResource(int n) {
        this.setBackgroundDrawable(this.getResources().getDrawable(n));
    }
}

