/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.animation.Animation;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.ColorUtils;
import org.mozilla.gecko.util.WeakReferenceHandler;
import org.mozilla.gecko.widget.themed.ThemedImageView;

public class ToolbarProgressView
extends ThemedImageView {
    private static final int MAX_PROGRESS = 10000;
    private static final int MSG_UPDATE = 0;
    private static final int MSG_HIDE = 1;
    private static final int STEPS = 10;
    private static final int DELAY = 40;
    private int mTargetProgress;
    private int mIncrement;
    private Rect mBounds;
    private Handler mHandler;
    private int mCurrentProgress;
    private PorterDuffColorFilter mPrivateBrowsingColorFilter;

    public ToolbarProgressView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    public ToolbarProgressView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    private void init(Context context) {
        this.mBounds = new Rect(0, 0, 0, 0);
        this.mTargetProgress = 0;
        this.mPrivateBrowsingColorFilter = new PorterDuffColorFilter(ColorUtils.getColor((Context)context, (int)R.color.private_browsing_purple), PorterDuff.Mode.SRC_IN);
        this.mHandler = new ToolbarProgressHandler(this);
    }

    public void setVisibility(int n) {
        if (AppConstants.Versions.preHC && n != 0) {
            this.clearAnimation();
        }
        super.setVisibility(n);
    }

    public void setAnimation(Animation animation) {
        if (AppConstants.Versions.preHC && this.isShown()) {
            super.setAnimation(animation);
        }
    }

    @Override
    public void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.mBounds.left = 0;
        this.mBounds.right = (n3 - n) * this.mCurrentProgress / 10000;
        this.mBounds.top = 0;
        this.mBounds.bottom = n4 - n2;
    }

    public void onDraw(Canvas canvas) {
        Drawable drawable2 = this.getDrawable();
        drawable2.setBounds(this.mBounds);
        drawable2.draw(canvas);
    }

    void setProgress(int n) {
        this.mCurrentProgress = this.mTargetProgress = this.getAbsoluteProgress(n);
        this.updateBounds();
        this.clearMessages();
    }

    void animateProgress(int n) {
        int n2 = this.getAbsoluteProgress(n);
        if (n2 <= this.mTargetProgress) {
            return;
        }
        this.mTargetProgress = n2;
        this.mIncrement = (this.mTargetProgress - this.mCurrentProgress) / 10;
        this.clearMessages();
        this.mHandler.sendEmptyMessage(0);
    }

    private void clearMessages() {
        this.mHandler.removeMessages(0);
        this.mHandler.removeMessages(1);
    }

    private int getAbsoluteProgress(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 100) {
            return 100;
        }
        return n * 10000 / 100;
    }

    private void updateBounds() {
        this.mBounds.right = this.getWidth() * this.mCurrentProgress / 10000;
        this.invalidate();
    }

    @Override
    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        if (bl) {
            this.setColorFilter((ColorFilter)this.mPrivateBrowsingColorFilter);
        } else {
            this.clearColorFilter();
        }
    }

    private static class ToolbarProgressHandler
    extends WeakReferenceHandler<ToolbarProgressView> {
        public ToolbarProgressHandler(ToolbarProgressView toolbarProgressView) {
            super((Object)toolbarProgressView);
        }

        public void handleMessage(Message message) {
            ToolbarProgressView toolbarProgressView = (ToolbarProgressView)this.mTarget.get();
            if (toolbarProgressView == null) {
                return;
            }
            switch (message.what) {
                case 0: {
                    toolbarProgressView.mCurrentProgress = Math.min(toolbarProgressView.mTargetProgress, toolbarProgressView.mCurrentProgress + toolbarProgressView.mIncrement);
                    toolbarProgressView.updateBounds();
                    if (toolbarProgressView.mCurrentProgress < toolbarProgressView.mTargetProgress) {
                        int n = toolbarProgressView.mTargetProgress < 10000 ? 40 : 10;
                        this.sendMessageDelayed(toolbarProgressView.mHandler.obtainMessage(message.what), n);
                        break;
                    }
                    if (toolbarProgressView.mCurrentProgress != 10000) break;
                    this.sendMessageDelayed(toolbarProgressView.mHandler.obtainMessage(1), 40L);
                    break;
                }
                case 1: {
                    toolbarProgressView.setVisibility(8);
                }
            }
        }
    }
}

