/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.prompts.PromptInput;
import org.mozilla.gecko.util.ColorUtils;
import org.mozilla.gecko.widget.DoorHanger;
import org.mozilla.gecko.widget.DoorhangerConfig;

public class DefaultDoorHanger
extends DoorHanger {
    private static final String LOGTAG = "GeckoDefaultDoorHanger";
    private static int sSpinnerTextColor = -1;
    private final TextView mMessage = (TextView)this.findViewById(R.id.doorhanger_message);
    private List<PromptInput> mInputs;
    private CheckBox mCheckBox;

    public DefaultDoorHanger(Context context, DoorhangerConfig doorhangerConfig, DoorHanger.Type type) {
        super(context, doorhangerConfig, type);
        if (sSpinnerTextColor == -1) {
            sSpinnerTextColor = ColorUtils.getColor((Context)context, (int)R.color.text_color_primary_disable_only);
        }
        switch (this.mType) {
            case GEOLOCATION: {
                this.mIcon.setImageResource(R.drawable.location);
                this.mIcon.setVisibility(0);
                break;
            }
            case DESKTOPNOTIFICATION2: {
                this.mIcon.setImageResource(R.drawable.push_notification);
                this.mIcon.setVisibility(0);
            }
        }
        this.loadConfig(doorhangerConfig);
    }

    @Override
    protected void loadConfig(DoorhangerConfig doorhangerConfig) {
        DoorhangerConfig.Link link;
        JSONObject jSONObject;
        String string2 = doorhangerConfig.getMessage();
        if (string2 != null) {
            this.setMessage(string2);
        }
        if ((jSONObject = doorhangerConfig.getOptions()) != null) {
            this.setOptions(jSONObject);
        }
        if ((link = doorhangerConfig.getLink()) != null) {
            this.addLink(link.label, link.url);
        }
        this.addButtonsToLayout(doorhangerConfig);
    }

    @Override
    protected int getContentResource() {
        return R.layout.default_doorhanger;
    }

    private List<PromptInput> getInputs() {
        return this.mInputs;
    }

    private CheckBox getCheckBox() {
        return this.mCheckBox;
    }

    @Override
    public void setOptions(JSONObject jSONObject) {
        String string2;
        super.setOptions(jSONObject);
        JSONArray jSONArray = jSONObject.optJSONArray("inputs");
        if (jSONArray != null) {
            this.mInputs = new ArrayList<PromptInput>();
            string2 = (ViewGroup)this.findViewById(R.id.doorhanger_inputs);
            string2.setVisibility(0);
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    PromptInput promptInput = PromptInput.getInput(jSONArray.getJSONObject(i));
                    this.mInputs.add(promptInput);
                    int n = this.mResources.getDimensionPixelSize(R.dimen.doorhanger_section_padding_medium);
                    View view = promptInput.getView(this.getContext());
                    this.styleInput(promptInput, view);
                    view.setPadding(0, 0, 0, n);
                    string2.addView(view);
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = jSONObject.optString("checkbox")))) {
            this.mCheckBox = (CheckBox)this.findViewById(R.id.doorhanger_checkbox);
            this.mCheckBox.setText((CharSequence)string2);
            this.mCheckBox.setVisibility(0);
        }
    }

    @Override
    protected View.OnClickListener makeOnButtonClickListener(final int n) {
        return new View.OnClickListener(){

            public void onClick(View view) {
                JSONObject jSONObject = new JSONObject();
                try {
                    List list;
                    jSONObject.put("callback", n);
                    CheckBox checkBox = DefaultDoorHanger.this.getCheckBox();
                    if (checkBox != null) {
                        jSONObject.put("checked", checkBox.isChecked());
                    }
                    if ((list = DefaultDoorHanger.this.getInputs()) != null) {
                        JSONObject jSONObject2 = new JSONObject();
                        for (PromptInput promptInput : list) {
                            jSONObject2.put(promptInput.getId(), promptInput.getValue());
                        }
                        jSONObject.put("inputs", (Object)jSONObject2);
                    }
                }
                catch (JSONException jSONException) {
                    Log.e((String)DefaultDoorHanger.LOGTAG, (String)"Error creating onClick response", (Throwable)jSONException);
                }
                DefaultDoorHanger.this.mOnButtonClickListener.onButtonClick(jSONObject, DefaultDoorHanger.this);
            }
        };
    }

    private void setMessage(String string2) {
        Spanned spanned = Html.fromHtml((String)string2);
        this.mMessage.setText((CharSequence)spanned);
    }

    private void styleInput(PromptInput promptInput, View view) {
        if (promptInput instanceof PromptInput.MenulistInput) {
            this.styleDropdownInputs(promptInput, view);
        }
        view.setPadding(0, 0, 0, this.mResources.getDimensionPixelSize(R.dimen.doorhanger_subsection_padding));
    }

    private void styleDropdownInputs(PromptInput promptInput, View view) {
        PromptInput.MenulistInput menulistInput = (PromptInput.MenulistInput)promptInput;
        if (menulistInput.textView != null) {
            menulistInput.textView.setTextColor(sSpinnerTextColor);
        }
    }
}

