/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.util.AttributeSet;
import org.mozilla.gecko.widget.FadedTextView;

public class FadedSingleColorTextView
extends FadedTextView {
    private FadedTextGradient mTextGradient;

    public FadedSingleColorTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    private void updateGradientShader() {
        int n = this.getCurrentTextColor();
        int n2 = this.getAvailableWidth();
        boolean bl = this.mTextGradient == null || this.mTextGradient.getColor() != n || this.mTextGradient.getWidth() != n2;
        boolean bl2 = this.needsEllipsis();
        if (bl2 && bl) {
            this.mTextGradient = new FadedTextGradient(n2, this.fadeWidth, n);
        }
        this.getPaint().setShader((Shader)(bl2 ? this.mTextGradient : null));
    }

    public void onDraw(Canvas canvas) {
        this.updateGradientShader();
        super.onDraw(canvas);
    }

    private static class FadedTextGradient
    extends LinearGradient {
        private final int mWidth;
        private final int mColor;

        public FadedTextGradient(int n, int n2, int n3) {
            super(0.0f, 0.0f, (float)n, 0.0f, new int[]{n3, n3, 0}, new float[]{0.0f, (float)(n - n2) / (float)n, 1.0f}, Shader.TileMode.CLAMP);
            this.mWidth = n;
            this.mColor = n3;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getColor() {
            return this.mColor;
        }
    }
}

