/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;

public class FxAccount20CreateDelegate {
    protected final byte[] emailUTF8;
    protected final byte[] authPW;
    protected final boolean preVerified;

    public FxAccount20CreateDelegate(byte[] byArray, byte[] byArray2, boolean bl) throws UnsupportedEncodingException, GeneralSecurityException {
        this.emailUTF8 = byArray;
        this.authPW = FxAccountUtils.generateAuthPW(byArray2);
        this.preVerified = bl;
    }

    public ExtendedJSONObject getCreateBody() throws FxAccountClientException {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        try {
            extendedJSONObject.put("email", new String(this.emailUTF8, "UTF-8"));
            extendedJSONObject.put("authPW", Utils.byte2Hex(this.authPW));
            if (this.preVerified) {
                extendedJSONObject.put("preVerified", this.preVerified);
            }
            return extendedJSONObject;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new FxAccountClientException(unsupportedEncodingException);
        }
    }
}

