/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.authenticator;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.authenticator.AccountPickler;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.login.StateFactory;
import org.mozilla.gecko.fxa.sync.FxAccountProfileService;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.util.ThreadUtils;

public class AndroidFxAccount {
    protected static final String LOG_TAG = AndroidFxAccount.class.getSimpleName();
    public static final int CURRENT_SYNC_PREFS_VERSION = 1;
    public static final int CURRENT_RL_PREFS_VERSION = 1;
    public static final int CURRENT_ACCOUNT_VERSION = 3;
    public static final String ACCOUNT_KEY_ACCOUNT_VERSION = "version";
    public static final String ACCOUNT_KEY_PROFILE = "profile";
    public static final String ACCOUNT_KEY_IDP_SERVER = "idpServerURI";
    private static final String ACCOUNT_KEY_PROFILE_SERVER = "profileServerURI";
    public static final String ACCOUNT_KEY_TOKEN_SERVER = "tokenServerURI";
    public static final String ACCOUNT_KEY_DESCRIPTOR = "descriptor";
    public static final int CURRENT_BUNDLE_VERSION = 2;
    public static final String BUNDLE_KEY_BUNDLE_VERSION = "version";
    public static final String BUNDLE_KEY_STATE_LABEL = "stateLabel";
    public static final String BUNDLE_KEY_STATE = "state";
    public static final String BUNDLE_KEY_PROFILE_JSON = "profile";
    public static final String PROFILE_OAUTH_TOKEN_TYPE = "oauth::profile";
    private static final List<String> KNOWN_OAUTH_TOKEN_TYPES;
    public static final Map<String, Boolean> DEFAULT_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP;
    private static final String PREF_KEY_LAST_SYNCED_TIMESTAMP = "lastSyncedTimestamp";
    protected final Context context;
    protected final AccountManager accountManager;
    protected final Account account;
    protected static final ConcurrentHashMap<String, ExtendedJSONObject> perAccountBundleCache;
    protected static final Semaphore sLock;
    protected String lockTag = null;
    protected boolean locked = false;

    public static void invalidateCaches() {
        perAccountBundleCache.clear();
    }

    public AndroidFxAccount(Context context, Account account) {
        this.context = context;
        this.account = account;
        this.accountManager = AccountManager.get((Context)this.context);
    }

    public void pickle(String string2) {
        AccountPickler.pickle(this, string2);
    }

    public Account getAndroidAccount() {
        return this.account;
    }

    protected int getAccountVersion() {
        String string2 = this.accountManager.getUserData(this.account, "version");
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2, 10);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected synchronized void persistBundle(ExtendedJSONObject extendedJSONObject) {
        perAccountBundleCache.put(this.account.name, extendedJSONObject);
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_DESCRIPTOR, extendedJSONObject.toJSONString());
    }

    protected ExtendedJSONObject unbundle() {
        return this.unbundle(true);
    }

    protected synchronized ExtendedJSONObject unbundle(boolean bl) {
        ExtendedJSONObject extendedJSONObject;
        if (bl && (extendedJSONObject = perAccountBundleCache.get(this.account.name)) != null) {
            Logger.debug(LOG_TAG, "Returning cached account bundle.");
            return extendedJSONObject;
        }
        int n = this.getAccountVersion();
        if (n < 3) {
            return null;
        }
        if (n > 3) {
            return null;
        }
        String string2 = this.accountManager.getUserData(this.account, ACCOUNT_KEY_DESCRIPTOR);
        if (string2 == null) {
            return null;
        }
        ExtendedJSONObject extendedJSONObject2 = this.unbundleAccountV2(string2);
        perAccountBundleCache.put(this.account.name, extendedJSONObject2);
        Logger.info(LOG_TAG, "Account bundle persisted to cache.");
        return extendedJSONObject2;
    }

    protected String getBundleData(String string2) {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return null;
        }
        return extendedJSONObject.getString(string2);
    }

    protected boolean getBundleDataBoolean(String string2, boolean bl) {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return bl;
        }
        Boolean bl2 = extendedJSONObject.getBoolean(string2);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    protected byte[] getBundleDataBytes(String string2) {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return null;
        }
        return extendedJSONObject.getByteArrayHex(string2);
    }

    protected void updateBundleValues(String string2, String string3, String ... stringArray) {
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("more must be a list of key, value pairs");
        }
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return;
        }
        extendedJSONObject.put(string2, string3);
        int n = 0;
        while (n + 1 < stringArray.length) {
            extendedJSONObject.put(stringArray[n], stringArray[n + 1]);
            n += 2;
        }
        this.persistBundle(extendedJSONObject);
    }

    private ExtendedJSONObject unbundleAccountV1(String string2) {
        ExtendedJSONObject extendedJSONObject;
        try {
            extendedJSONObject = new ExtendedJSONObject(string2);
        }
        catch (Exception exception) {
            return null;
        }
        if (2 == extendedJSONObject.getIntegerSafely("version")) {
            return extendedJSONObject;
        }
        return null;
    }

    private ExtendedJSONObject unbundleAccountV2(String string2) {
        return this.unbundleAccountV1(string2);
    }

    public String getProfile() {
        return this.accountManager.getUserData(this.account, "profile");
    }

    public String getAccountServerURI() {
        return this.accountManager.getUserData(this.account, ACCOUNT_KEY_IDP_SERVER);
    }

    public String getTokenServerURI() {
        return this.accountManager.getUserData(this.account, ACCOUNT_KEY_TOKEN_SERVER);
    }

    public String getProfileServerURI() {
        String string2 = this.accountManager.getUserData(this.account, ACCOUNT_KEY_PROFILE_SERVER);
        if (string2 == null) {
            if (this.isStaging()) {
                return "https://latest.dev.lcip.org/profile/v1";
            }
            return "https://profile.accounts.firefox.com/v1";
        }
        return string2;
    }

    public String getOAuthServerURI() {
        if (this.isStaging()) {
            return "https://oauth-stable.dev.lcip.org/v1";
        }
        return "https://oauth.accounts.firefox.com/v1";
    }

    private boolean isStaging() {
        return "https://stable.dev.lcip.org/auth/v1".equals(this.getAccountServerURI());
    }

    private String constructPrefsPath(String string2, long l, String string3) throws GeneralSecurityException, UnsupportedEncodingException {
        String string4 = this.getProfile();
        String string5 = this.account.name;
        if (string4 == null) {
            throw new IllegalStateException("Missing profile. Cannot fetch prefs.");
        }
        if (string5 == null) {
            throw new IllegalStateException("Missing username. Cannot fetch prefs.");
        }
        String string6 = this.getAccountServerURI();
        if (string6 == null) {
            throw new IllegalStateException("No account server URI. Cannot fetch prefs.");
        }
        String string7 = string6 + "!" + string3;
        return Utils.getPrefsPath(string2, string5, string7, string4, l);
    }

    public String getSyncPrefsPath() throws GeneralSecurityException, UnsupportedEncodingException {
        String string2 = this.getTokenServerURI();
        if (string2 == null) {
            throw new IllegalStateException("No token server URI. Cannot fetch prefs.");
        }
        return this.constructPrefsPath("org.mozilla.fennec.fxa", 1L, string2);
    }

    public String getReadingListPrefsPath() throws GeneralSecurityException, UnsupportedEncodingException {
        return this.constructPrefsPath("org.mozilla.fennec.reading", 1L, "");
    }

    public SharedPreferences getSyncPrefs() throws UnsupportedEncodingException, GeneralSecurityException {
        return this.context.getSharedPreferences(this.getSyncPrefsPath(), 0);
    }

    public SharedPreferences getReadingListPrefs() throws UnsupportedEncodingException, GeneralSecurityException {
        return this.context.getSharedPreferences(this.getReadingListPrefsPath(), 0);
    }

    public ExtendedJSONObject toJSONObject() {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        extendedJSONObject.put("email", this.account.name);
        try {
            extendedJSONObject.put("emailUTF8", Utils.byte2Hex(this.account.name.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return extendedJSONObject;
    }

    public static AndroidFxAccount addAndroidAccount(Context context, String string2, String string3, String string4, String string5, String string6, State state, Map<String, Boolean> map) throws UnsupportedEncodingException, GeneralSecurityException, URISyntaxException {
        return AndroidFxAccount.addAndroidAccount(context, string2, string3, string4, string5, string6, state, map, 3, false, null);
    }

    public static AndroidFxAccount addAndroidAccount(Context context, String string2, String string3, String string4, String string5, String string6, State state, Map<String, Boolean> map, int n, boolean bl, ExtendedJSONObject extendedJSONObject) throws UnsupportedEncodingException, GeneralSecurityException, URISyntaxException {
        if (string2 == null) {
            throw new IllegalArgumentException("email must not be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("profile must not be null");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("idpServerURI must not be null");
        }
        if (string5 == null) {
            throw new IllegalArgumentException("tokenServerURI must not be null");
        }
        if (string6 == null) {
            throw new IllegalArgumentException("profileServerURI must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("state must not be null");
        }
        if (n != 3) {
            throw new IllegalStateException("Could not create account of version " + n + ". Current version is " + 3 + ".");
        }
        Bundle bundle = new Bundle();
        bundle.putString("version", "3");
        bundle.putString(ACCOUNT_KEY_IDP_SERVER, string4);
        bundle.putString(ACCOUNT_KEY_TOKEN_SERVER, string5);
        bundle.putString(ACCOUNT_KEY_PROFILE_SERVER, string6);
        bundle.putString("profile", string3);
        if (extendedJSONObject == null) {
            extendedJSONObject = new ExtendedJSONObject();
            extendedJSONObject.put("version", 2);
        }
        extendedJSONObject.put(BUNDLE_KEY_STATE_LABEL, state.getStateLabel().name());
        extendedJSONObject.put(BUNDLE_KEY_STATE, state.toJSONObject().toJSONString());
        bundle.putString(ACCOUNT_KEY_DESCRIPTOR, extendedJSONObject.toJSONString());
        Account account = new Account(string2, "org.mozilla.fennec_fxaccount");
        AccountManager accountManager = AccountManager.get((Context)context);
        boolean bl2 = accountManager.addAccountExplicitly(account, null, bundle);
        if (!bl2) {
            return null;
        }
        for (String string7 : bundle.keySet()) {
            accountManager.setUserData(account, string7, bundle.getString(string7));
        }
        AndroidFxAccount androidFxAccount = new AndroidFxAccount(context, account);
        if (!bl) {
            androidFxAccount.clearSyncPrefs();
        }
        androidFxAccount.setAuthoritiesToSyncAutomaticallyMap(map);
        return androidFxAccount;
    }

    public void clearSyncPrefs() throws UnsupportedEncodingException, GeneralSecurityException {
        this.getSyncPrefs().edit().clear().commit();
    }

    public void setAuthoritiesToSyncAutomaticallyMap(Map<String, Boolean> map) {
        if (map == null) {
            throw new IllegalArgumentException("authoritiesToSyncAutomaticallyMap must not be null");
        }
        for (String string2 : DEFAULT_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP.keySet()) {
            boolean bl = DEFAULT_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP.get(string2);
            Boolean bl2 = map.get(string2);
            if (bl2 != null) {
                bl = bl2;
            }
            ContentResolver.setIsSyncable((Account)this.account, (String)string2, (int)1);
            ContentResolver.setSyncAutomatically((Account)this.account, (String)string2, (boolean)bl);
        }
    }

    public Map<String, Boolean> getAuthoritiesToSyncAutomaticallyMap() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (String string2 : DEFAULT_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP.keySet()) {
            boolean bl = ContentResolver.getSyncAutomatically((Account)this.account, (String)string2);
            hashMap.put(string2, bl);
        }
        return hashMap;
    }

    public boolean isCurrentlySyncing() {
        boolean bl = false;
        for (String string2 : DEFAULT_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP.keySet()) {
            bl |= ContentResolver.isSyncActive((Account)this.account, (String)string2);
        }
        return bl;
    }

    public void requestImmediateSync(String[] stringArray, String[] stringArray2) {
        FirefoxAccounts.requestImmediateSync(this.getAndroidAccount(), stringArray, stringArray2);
    }

    public void requestEventualSync(String[] stringArray, String[] stringArray2) {
        FirefoxAccounts.requestEventualSync(this.getAndroidAccount(), stringArray, stringArray2);
    }

    public synchronized void setState(State state) {
        if (state == null) {
            throw new IllegalArgumentException("state must not be null");
        }
        Logger.info(LOG_TAG, "Moving account named like " + this.getObfuscatedEmail() + " to state " + state.getStateLabel().toString());
        this.updateBundleValues(BUNDLE_KEY_STATE_LABEL, state.getStateLabel().name(), BUNDLE_KEY_STATE, state.toJSONObject().toJSONString());
        this.broadcastAccountStateChangedIntent();
    }

    protected void broadcastAccountStateChangedIntent() {
        Intent intent = new Intent("org.mozilla.fennec_fxaccount.accounts.ACCOUNT_STATE_CHANGED_ACTION");
        intent.putExtra("account", this.account.name);
        this.context.sendBroadcast(intent, "org.mozilla.fennec_fxaccount.permission.PER_ACCOUNT_TYPE");
    }

    public synchronized State getState() {
        String string2 = this.getBundleData(BUNDLE_KEY_STATE_LABEL);
        String string3 = this.getBundleData(BUNDLE_KEY_STATE);
        if (string2 == null || string3 == null) {
            throw new IllegalStateException("stateLabelString and stateString must not be null, but: (stateLabelString == null) = " + (string2 == null) + " and (stateString == null) = " + (string3 == null));
        }
        try {
            State.StateLabel stateLabel = State.StateLabel.valueOf(string2);
            Logger.debug(LOG_TAG, "Account is in state " + (Object)((Object)stateLabel));
            return StateFactory.fromJSONObject(stateLabel, new ExtendedJSONObject(string3));
        }
        catch (Exception exception) {
            throw new IllegalStateException("could not get state", exception);
        }
    }

    public void dump() {
        if (!FxAccountUtils.LOG_PERSONAL_INFORMATION) {
            return;
        }
        ExtendedJSONObject extendedJSONObject = this.toJSONObject();
        ArrayList<String> arrayList = new ArrayList<String>(extendedJSONObject.keySet());
        Collections.sort(arrayList);
        for (String string2 : arrayList) {
            FxAccountUtils.pii(LOG_TAG, string2 + ": " + extendedJSONObject.get(string2));
        }
    }

    public String getEmail() {
        return this.account.name;
    }

    public String getObfuscatedEmail() {
        return Utils.obfuscateEmail(this.account.name);
    }

    public Intent makeDeletedAccountIntent() {
        Intent intent = new Intent("org.mozilla.fennec_fxaccount.accounts.ACCOUNT_DELETED_ACTION");
        ArrayList<String> arrayList = new ArrayList<String>();
        intent.putExtra("account_deleted_intent_version", (Serializable)Long.valueOf(1L));
        intent.putExtra("account_deleted_intent_account", this.account.name);
        for (String string2 : KNOWN_OAUTH_TOKEN_TYPES) {
            String string3 = this.accountManager.peekAuthToken(this.account, string2);
            if (string3 == null) continue;
            arrayList.add(string3);
        }
        intent.putExtra("account_oauth_service_endpoint", this.getOAuthServerURI());
        intent.putExtra("account_deleted_intent_auth_tokens", arrayList.toArray(new String[arrayList.size()]));
        return intent;
    }

    private Intent makeProfileJSONUpdatedIntent() {
        Intent intent = new Intent();
        intent.setAction("org.mozilla.gecko.fxa.profile.JSON.updated");
        return intent;
    }

    public void setLastSyncedTimestamp(long l) {
        try {
            this.getSyncPrefs().edit().putLong(PREF_KEY_LAST_SYNCED_TIMESTAMP, l).commit();
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception setting last synced time; ignoring.", exception);
        }
    }

    public long getLastSyncedTimestamp() {
        try {
            return this.getSyncPrefs().getLong(PREF_KEY_LAST_SYNCED_TIMESTAMP, -1L);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception getting last synced time; ignoring.", exception);
            return -1L;
        }
    }

    public void unsafeTransitionToDefaultEndpoints() {
        this.unsafeTransitionToStageEndpoints("https://api.accounts.firefox.com/v1", "https://token.services.mozilla.com/1.0/sync/1.5", "https://profile.accounts.firefox.com/v1");
    }

    public void unsafeTransitionToStageEndpoints() {
        this.unsafeTransitionToStageEndpoints("https://stable.dev.lcip.org/auth/v1", "https://stable.dev.lcip.org/syncserver/token/1.0/sync/1.5", "https://latest.dev.lcip.org/profile/v1");
    }

    protected void unsafeTransitionToStageEndpoints(String string2, String string3, String string4) {
        try {
            this.getReadingListPrefs().edit().clear().commit();
        }
        catch (UnsupportedEncodingException | GeneralSecurityException exception) {
            // empty catch block
        }
        try {
            this.getSyncPrefs().edit().clear().commit();
        }
        catch (UnsupportedEncodingException | GeneralSecurityException exception) {
            // empty catch block
        }
        State state = this.getState();
        this.setState(state.makeSeparatedState());
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_IDP_SERVER, string2);
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_TOKEN_SERVER, string3);
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_PROFILE_SERVER, string4);
        ContentResolver.setIsSyncable((Account)this.account, (String)"org.mozilla.fennec.db.readinglist", (int)1);
    }

    public ExtendedJSONObject getProfileJSON() {
        String string2 = this.getBundleData("profile");
        if (string2 == null) {
            return null;
        }
        try {
            return new ExtendedJSONObject(string2);
        }
        catch (Exception exception) {
            Logger.error(LOG_TAG, "Failed to parse profile JSON; ignoring and returning null.", exception);
            return null;
        }
    }

    public void fetchProfileJSON() {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string2;
                try {
                    string2 = AndroidFxAccount.this.accountManager.blockingGetAuthToken(AndroidFxAccount.this.account, AndroidFxAccount.PROFILE_OAUTH_TOKEN_TYPE, true);
                    if (string2 == null) {
                        throw new RuntimeException("Couldn't get oauth token!  Aborting profile fetch.");
                    }
                }
                catch (Exception exception) {
                    Logger.error(LOG_TAG, "Error fetching profile information; ignoring.", exception);
                    return;
                }
                Logger.info(LOG_TAG, "Intent service launched to fetch profile.");
                Intent intent = new Intent(AndroidFxAccount.this.context, FxAccountProfileService.class);
                intent.putExtra("auth_token", string2);
                intent.putExtra(AndroidFxAccount.ACCOUNT_KEY_PROFILE_SERVER, AndroidFxAccount.this.getProfileServerURI());
                intent.putExtra("resultReceiver", (Parcelable)new ProfileResultReceiver(new Handler()));
                AndroidFxAccount.this.context.startService(intent);
            }
        });
    }

    public synchronized void acquireSharedAccountStateLock(String string2) throws InterruptedException {
        long l = Thread.currentThread().getId();
        this.lockTag = string2;
        Log.d((String)"GeckoLogger", (String)("Thread with tag and thread id acquiring lock: " + this.lockTag + ", " + l + " ..."));
        sLock.acquire();
        this.locked = true;
        Log.d((String)"GeckoLogger", (String)("Thread with tag and thread id acquiring lock: " + this.lockTag + ", " + l + " ... ACQUIRED"));
    }

    public synchronized void releaseSharedAccountStateLock() {
        long l = Thread.currentThread().getId();
        Log.d((String)"GeckoLogger", (String)("Thread with tag and thread id releasing lock: " + this.lockTag + ", " + l + " ..."));
        if (this.locked) {
            sLock.release();
            this.locked = false;
            Log.d((String)"GeckoLogger", (String)("Thread with tag and thread id releasing lock: " + this.lockTag + ", " + l + " ... RELEASED"));
        } else {
            Log.d((String)"GeckoLogger", (String)("Thread with tag and thread id releasing lock: " + this.lockTag + ", " + l + " ... NOT LOCKED"));
        }
    }

    protected synchronized void finalize() {
        if (this.locked) {
            sLock.release();
            this.locked = false;
            long l = Thread.currentThread().getId();
            Log.e((String)"GeckoLogger", (String)("Thread with tag and thread id releasing lock: " + this.lockTag + ", " + l + " ... RELEASED DURING FINALIZE"));
        }
    }

    static {
        Cloneable cloneable = new ArrayList<String>();
        cloneable.add(PROFILE_OAUTH_TOKEN_TYPE);
        KNOWN_OAUTH_TOKEN_TYPES = Collections.unmodifiableList(cloneable);
        cloneable = new HashMap();
        ((HashMap)cloneable).put("org.mozilla.fennec.db.browser", true);
        DEFAULT_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP = Collections.unmodifiableMap(cloneable);
        perAccountBundleCache = new ConcurrentHashMap();
        sLock = new Semaphore(1, true);
    }

    private class ProfileResultReceiver
    extends ResultReceiver {
        public ProfileResultReceiver(Handler handler) {
            super(handler);
        }

        protected void onReceiveResult(int n, Bundle bundle) {
            super.onReceiveResult(n, bundle);
            switch (n) {
                case -1: {
                    String string2 = bundle.getString("RESULT_STRING");
                    AndroidFxAccount.this.updateBundleValues("profile", string2, new String[0]);
                    Logger.info(LOG_TAG, "Profile JSON fetch succeeeded!");
                    FxAccountUtils.pii(LOG_TAG, "Profile JSON fetch returned: " + string2);
                    LocalBroadcastManager.getInstance((Context)AndroidFxAccount.this.context).sendBroadcast(AndroidFxAccount.this.makeProfileJSONUpdatedIntent());
                    break;
                }
                case 0: {
                    Logger.warn(LOG_TAG, "Failed to fetch profile JSON; ignoring.");
                    break;
                }
                default: {
                    Logger.warn(LOG_TAG, "Invalid result code received; ignoring.");
                }
            }
        }
    }
}

