/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.push.autopush;

import ch.boye.httpclientandroidlib.HttpResponse;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class AutopushClientException
extends Exception {
    private static final long serialVersionUID = 7953459541558266500L;

    public AutopushClientException(String string) {
        super(string);
    }

    public AutopushClientException(Exception exception) {
        super(exception);
    }

    public static class AutopushClientMalformedResponseException
    extends AutopushClientRemoteException {
        private static final long serialVersionUID = 2209313149952001909L;

        public AutopushClientMalformedResponseException(HttpResponse httpResponse) {
            super(httpResponse, 0L, 999L, "Response malformed", "Response malformed", new ExtendedJSONObject());
        }
    }

    public static class AutopushClientRemoteException
    extends AutopushClientException {
        private static final long serialVersionUID = 2209313149952001000L;
        public final HttpResponse response;
        public final long httpStatusCode;
        public final long apiErrorNumber;
        public final String error;
        public final String message;
        public final ExtendedJSONObject body;

        public AutopushClientRemoteException(HttpResponse httpResponse, long l, long l2, String string, String string2, ExtendedJSONObject extendedJSONObject) {
            super(new HTTPFailureException(new SyncStorageResponse(httpResponse)));
            if (extendedJSONObject == null) {
                throw new IllegalArgumentException("body must not be null");
            }
            this.response = httpResponse;
            this.httpStatusCode = l;
            this.apiErrorNumber = l2;
            this.error = string;
            this.message = string2;
            this.body = extendedJSONObject;
        }

        @Override
        public String toString() {
            return "<AutopushClientRemoteException " + this.httpStatusCode + " [" + this.apiErrorNumber + "]: " + this.message + ">";
        }

        public boolean isInvalidAuthentication() {
            return this.httpStatusCode == 401L;
        }

        public boolean isNotFound() {
            return this.httpStatusCode == 404L;
        }
    }
}

