/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.CommandRunner;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.NonArrayJSONException;
import org.mozilla.gecko.sync.repositories.android.ClientsDatabaseAccessor;
import org.mozilla.gecko.sync.repositories.domain.ClientRecord;

public class CommandProcessor {
    private static final String LOG_TAG = "Command";
    private static final AtomicInteger currentId = new AtomicInteger();
    protected ConcurrentHashMap<String, CommandRunner> commands = new ConcurrentHashMap();
    private static final CommandProcessor processor = new CommandProcessor();

    public static CommandProcessor getProcessor() {
        return processor;
    }

    public void registerCommand(String string, CommandRunner commandRunner) {
        this.commands.put(string, commandRunner);
    }

    public void processCommand(GlobalSession globalSession, ExtendedJSONObject extendedJSONObject) {
        Command command = CommandProcessor.parseCommand(extendedJSONObject);
        if (command == null) {
            Logger.debug(LOG_TAG, "Invalid command: " + extendedJSONObject + " will not be processed.");
            return;
        }
        CommandRunner commandRunner = this.commands.get(command.commandType);
        if (commandRunner == null) {
            Logger.debug(LOG_TAG, "Command \"" + command.commandType + "\" not registered and will not be processed.");
            return;
        }
        commandRunner.executeCommand(globalSession, command.getArgsList());
    }

    protected static Command parseCommand(ExtendedJSONObject extendedJSONObject) {
        String string = (String)extendedJSONObject.get("command");
        if (string == null) {
            return null;
        }
        try {
            JSONArray jSONArray = extendedJSONObject.getArray("args");
            if (jSONArray == null) {
                return null;
            }
            return new Command(string, jSONArray);
        }
        catch (NonArrayJSONException nonArrayJSONException) {
            Logger.debug(LOG_TAG, "Unable to parse args array. Invalid command");
            return null;
        }
    }

    public void sendURIToClientForDisplay(String string, String string2, String string3, String string4, Context context) {
        Logger.info(LOG_TAG, "Sending URI to client " + string2 + ".");
        if (Logger.LOG_PERSONAL_INFORMATION) {
            Logger.pii(LOG_TAG, "URI is " + string + "; title is '" + string3 + "'.");
        }
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)string);
        jSONArray.add((Object)string4);
        jSONArray.add((Object)string3);
        Command command = new Command("displayURI", jSONArray);
        this.sendCommand(string2, command, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommand(String string, Command command, Context context) {
        Logger.debug(LOG_TAG, "In sendCommand.");
        CommandRunner commandRunner = this.commands.get(command.commandType);
        if (commandRunner == null) {
            Logger.error(LOG_TAG, "Unknown command to send: " + command);
            return;
        }
        if (!commandRunner.argumentsAreValid(command.getArgsList())) {
            Logger.error(LOG_TAG, "Expected " + commandRunner.argCount + " args for '" + command + "', but got " + command.args);
            return;
        }
        if (string != null) {
            this.sendCommandToClient(string, command, context);
            return;
        }
        try (ClientsDatabaseAccessor clientsDatabaseAccessor = new ClientsDatabaseAccessor(context);){
            Map<String, ClientRecord> map = clientsDatabaseAccessor.fetchAllClients();
            for (ClientRecord clientRecord : map.values()) {
                this.sendCommandToClient(clientRecord.guid, command, context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCommandToClient(String string, Command command, Context context) {
        Logger.info(LOG_TAG, "Sending " + command.commandType + " to " + string);
        try (ClientsDatabaseAccessor clientsDatabaseAccessor = new ClientsDatabaseAccessor(context);){
            clientsDatabaseAccessor.store(string, command);
        }
    }

    public static void displayURI(List<String> list, Context context) {
        String string = list.get(0);
        String string2 = list.get(1);
        Logger.pii(LOG_TAG, "Received a URI for display: " + string + " from " + string2);
        if (string == null) {
            Logger.pii(LOG_TAG, "URI is null \u2013 ignoring");
            return;
        }
        String string3 = null;
        if (list.size() == 3) {
            string3 = list.get(2);
        }
        Intent intent = new Intent();
        intent.setClassName(context, "org.mozilla.gecko.tabqueue.TabReceivedService");
        intent.setData(Uri.parse((String)string));
        intent.putExtra("android.intent.extra.TITLE", string3);
        intent.putExtra("org.mozilla.gecko.extra.CLIENT_ID", string2);
        ComponentName componentName = context.startService(intent);
    }

    public static class Command {
        public final String commandType;
        public final JSONArray args;
        private List<String> argsList;

        public Command(String string, JSONArray jSONArray) {
            this.commandType = string;
            this.args = jSONArray;
        }

        public synchronized List<String> getArgsList() {
            if (this.argsList == null) {
                ArrayList<String> arrayList = new ArrayList<String>(this.args.size());
                for (int i = 0; i < this.args.size(); ++i) {
                    Object object = this.args.get(i);
                    if (object == null) {
                        arrayList.add(null);
                        continue;
                    }
                    arrayList.add(object.toString());
                }
                this.argsList = arrayList;
            }
            return this.argsList;
        }

        public JSONObject asJSONObject() {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"command", (Object)this.commandType);
            jSONObject.put((Object)"args", (Object)this.args);
            return jSONObject;
        }
    }
}

