/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.Resource;
import org.mozilla.gecko.sync.net.SyncStorageRequestDelegate;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class SyncStorageRequest
implements Resource {
    public static HashMap<String, String> SERVER_ERROR_MESSAGES;
    protected BaseResourceDelegate resourceDelegate;
    public SyncStorageRequestDelegate delegate;
    protected BaseResource resource;

    public static String getServerErrorMessage(String string) {
        if (SERVER_ERROR_MESSAGES.containsKey(string)) {
            return SERVER_ERROR_MESSAGES.get(string);
        }
        return string;
    }

    public SyncStorageRequest(String string) throws URISyntaxException {
        this(new URI(string));
    }

    public SyncStorageRequest(URI uRI) {
        this.resource = new BaseResource(uRI);
        this.resourceDelegate = this.makeResourceDelegate(this);
        this.resource.delegate = this.resourceDelegate;
    }

    @Override
    public URI getURI() {
        return this.resource.getURI();
    }

    @Override
    public String getURIString() {
        return this.resource.getURIString();
    }

    @Override
    public String getHostname() {
        return this.resource.getHostname();
    }

    public SyncStorageRequest() {
    }

    protected BaseResourceDelegate makeResourceDelegate(SyncStorageRequest syncStorageRequest) {
        return new SyncStorageResourceDelegate(syncStorageRequest);
    }

    @Override
    public void get() {
        this.resource.get();
    }

    @Override
    public void delete() {
        this.resource.delete();
    }

    @Override
    public void post(HttpEntity httpEntity) {
        this.resource.post(httpEntity);
    }

    @Override
    public void patch(HttpEntity httpEntity) {
        this.resource.patch(httpEntity);
    }

    @Override
    public void put(HttpEntity httpEntity) {
        this.resource.put(httpEntity);
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("1", "Illegal method/protocol");
        hashMap.put("2", "Incorrect/missing CAPTCHA");
        hashMap.put("3", "Invalid/missing username");
        hashMap.put("4", "Attempt to overwrite data that can't be overwritten (such as creating a user ID that already exists)");
        hashMap.put("5", "User ID does not match account in path");
        hashMap.put("6", "JSON parse failure");
        hashMap.put("7", "Missing password field");
        hashMap.put("8", "Invalid Weave Basic Object");
        hashMap.put("9", "Requested password not strong enough");
        hashMap.put("10", "Invalid/missing password reset code");
        hashMap.put("11", "Unsupported function");
        hashMap.put("12", "No email address on file");
        hashMap.put("13", "Invalid collection");
        hashMap.put("14", "User over quota");
        hashMap.put("15", "The email does not match the username");
        hashMap.put("16", "Client upgrade required");
        hashMap.put("255", "An unexpected server error occurred: pool is empty.");
        hashMap.put("\"server issue: getVS failed\"", "server issue: getVS failed");
        hashMap.put("\"server issue: prefix not set\"", "server issue: prefix not set");
        hashMap.put("\"server issue: host header not received from client\"", "server issue: host header not received from client");
        hashMap.put("\"server issue: database lookup failed\"", "server issue: database lookup failed");
        hashMap.put("\"server issue: database is not healthy\"", "server issue: database is not healthy");
        hashMap.put("\"server issue: database not in pool\"", "server issue: database not in pool");
        hashMap.put("\"server issue: database marked as down\"", "server issue: database marked as down");
        SERVER_ERROR_MESSAGES = hashMap;
    }

    public class SyncStorageResourceDelegate
    extends BaseResourceDelegate {
        private static final String LOG_TAG = "SSResourceDelegate";
        protected SyncStorageRequest request;

        SyncStorageResourceDelegate(SyncStorageRequest syncStorageRequest2) {
            super(syncStorageRequest2);
            this.request = syncStorageRequest2;
        }

        @Override
        public AuthHeaderProvider getAuthHeaderProvider() {
            return this.request.delegate.getAuthHeaderProvider();
        }

        @Override
        public String getUserAgent() {
            return "Firefox AndroidSync 1.47.0a1.0 (Firefox)";
        }

        @Override
        public void handleHttpResponse(HttpResponse httpResponse) {
            Logger.debug(LOG_TAG, "SyncStorageResourceDelegate handling response: " + httpResponse.getStatusLine() + ".");
            SyncStorageRequestDelegate syncStorageRequestDelegate = this.request.delegate;
            SyncStorageResponse syncStorageResponse = new SyncStorageResponse(httpResponse);
            if (syncStorageResponse.wasSuccessful()) {
                syncStorageRequestDelegate.handleRequestSuccess(syncStorageResponse);
            } else {
                Logger.warn(LOG_TAG, "HTTP request failed.");
                try {
                    Logger.warn(LOG_TAG, "HTTP response body: " + syncStorageResponse.getErrorMessage());
                }
                catch (Exception exception) {
                    Logger.error(LOG_TAG, "Can't fetch HTTP response body.", exception);
                }
                syncStorageRequestDelegate.handleRequestFailure(syncStorageResponse);
            }
        }

        @Override
        public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
            this.request.delegate.handleRequestError((Exception)((Object)clientProtocolException));
        }

        @Override
        public void handleHttpIOException(IOException iOException) {
            this.request.delegate.handleRequestError(iOException);
        }

        @Override
        public void handleTransportException(GeneralSecurityException generalSecurityException) {
            this.request.delegate.handleRequestError(generalSecurityException);
        }

        @Override
        public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
            String string = this.request.delegate.ifUnmodifiedSince();
            if (string != null) {
                Logger.debug(LOG_TAG, "Making request with X-If-Unmodified-Since = " + string);
                httpRequestBase.setHeader("x-if-unmodified-since", string);
            }
            if (httpRequestBase.getMethod().equalsIgnoreCase("DELETE")) {
                httpRequestBase.addHeader("x-confirm-delete", "1");
            }
        }
    }
}

