/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.ReaderModeUtils;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.ReadingListAccessor;

@RobocopTarget
public class LocalReadingListAccessor
implements ReadingListAccessor {
    private static final String LOG_TAG = "GeckoReadingListAcc";
    private static final String NOT_DELETED = "is_deleted = 0";
    private static final String NEITHER_DELETED_NOR_ARCHIVED = "is_archived = 0 AND is_deleted = 0";
    private static final String ITEMS_TO_FETCH = "content_status = 0 AND is_archived = 0 AND is_deleted = 0";
    private static final String SORT_ORDER_RECENT_FIRST = "COALESCE(stored_on, added_on) DESC";
    private final Uri mReadingListUriWithProfile;

    public LocalReadingListAccessor(String string2) {
        this.mReadingListUriWithProfile = DBUtils.appendProfile(string2, BrowserContract.ReadingListItems.CONTENT_URI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount(ContentResolver contentResolver) {
        String[] stringArray = new String[]{"_id"};
        try (Cursor cursor = contentResolver.query(this.mReadingListUriWithProfile, stringArray, NOT_DELETED, null, null);){
            int n = cursor.getCount();
            return n;
        }
    }

    @Override
    public Cursor getReadingList(ContentResolver contentResolver) {
        return contentResolver.query(this.mReadingListUriWithProfile, BrowserContract.ReadingListItems.DEFAULT_PROJECTION, NEITHER_DELETED_NOR_ARCHIVED, null, SORT_ORDER_RECENT_FIRST);
    }

    @Override
    public Cursor getReadingListUnfetched(ContentResolver contentResolver) {
        return contentResolver.query(this.mReadingListUriWithProfile, new String[]{"_id", "url"}, ITEMS_TO_FETCH, null, SORT_ORDER_RECENT_FIRST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadingListItem(ContentResolver contentResolver, String string2) {
        string2 = ReaderModeUtils.stripAboutReaderUrl(string2);
        Cursor cursor = contentResolver.query(this.mReadingListUriWithProfile, new String[]{"_id"}, "url = ? OR resolved_url = ?", new String[]{string2, string2}, null);
        if (cursor == null) {
            Log.e((String)LOG_TAG, (String)"Null cursor in isReadingListItem");
            return false;
        }
        try {
            boolean bl = cursor.moveToNext();
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public long addReadingListItem(ContentResolver contentResolver, ContentValues contentValues) {
        for (String string2 : BrowserContract.ReadingListItems.REQUIRED_FIELDS) {
            if (contentValues.containsKey(string2)) continue;
            throw new IllegalArgumentException("Missing required field for reading list item: " + string2);
        }
        String string3 = ReaderModeUtils.stripAboutReaderUrl(contentValues.getAsString("url"));
        contentValues.put("url", string3);
        contentValues.put("added_on", Long.valueOf(System.currentTimeMillis()));
        contentValues.put("added_by", "$local");
        long l = ContentUris.parseId((Uri)contentResolver.insert(this.mReadingListUriWithProfile, contentValues));
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Reader:Added", string3));
        return l;
    }

    @Override
    public long addBasicReadingListItem(ContentResolver contentResolver, String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("URL must not be null.");
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("url", string2);
        if (string3 != null) {
            contentValues.put("title", string3);
        } else {
            contentValues.putNull("title");
        }
        return this.addReadingListItem(contentResolver, contentValues);
    }

    @Override
    public void updateReadingListItem(ContentResolver contentResolver, ContentValues contentValues) {
        if (!contentValues.containsKey("_id")) {
            throw new IllegalArgumentException("Cannot update reading list item without an ID");
        }
        if (contentValues.containsKey("url")) {
            contentValues.put("url", ReaderModeUtils.stripAboutReaderUrl(contentValues.getAsString("url")));
        }
        int n = contentResolver.update(this.mReadingListUriWithProfile, contentValues, "_id = ? ", new String[]{contentValues.getAsString("_id")});
        Log.d((String)LOG_TAG, (String)("Updated " + n + " reading list rows."));
    }

    @Override
    public void removeReadingListItemWithURL(ContentResolver contentResolver, String string2) {
        contentResolver.delete(this.mReadingListUriWithProfile, "url = ? OR resolved_url = ?", new String[]{string2, string2});
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Reader:Removed", string2));
    }

    @Override
    public void deleteItem(ContentResolver contentResolver, long l) {
        contentResolver.delete(ContentUris.appendId((Uri.Builder)this.mReadingListUriWithProfile.buildUpon(), (long)l).build(), null, null);
    }

    @Override
    public void registerContentObserver(Context context, ContentObserver contentObserver) {
        context.getContentResolver().registerContentObserver(this.mReadingListUriWithProfile, false, contentObserver);
    }

    @Override
    public void markAsRead(ContentResolver contentResolver, long l) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("marked_read_by", "$local");
        contentValues.put("marked_read_on", Long.valueOf(System.currentTimeMillis()));
        contentValues.put("is_unread", Integer.valueOf(0));
        contentResolver.update(this.mReadingListUriWithProfile, contentValues, "_id = " + l, null);
    }

    @Override
    public void markAsUnread(ContentResolver contentResolver, long l) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("is_unread", Integer.valueOf(1));
        contentResolver.update(this.mReadingListUriWithProfile, contentValues, "_id = " + l, null);
    }

    @Override
    public void updateContent(ContentResolver contentResolver, long l, String string2, String string3, String string4) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("content_status", Integer.valueOf(4));
        contentValues.put("resolved_url", string3);
        contentValues.put("resolved_title", string2);
        contentValues.put("excerpt", string4);
        contentResolver.update(this.mReadingListUriWithProfile, contentValues, "_id = " + l, null);
    }
}

