/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import java.util.HashMap;
import org.mozilla.gecko.CrashHandler;
import org.mozilla.gecko.GeckoMessageReceiver;
import org.mozilla.gecko.NSSBridge;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.SQLiteBridgeContentProvider;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.sqlite.MatrixBlobCursor;
import org.mozilla.gecko.sqlite.SQLiteBridge;
import org.mozilla.gecko.sync.Utils;

public class PasswordsProvider
extends SQLiteBridgeContentProvider {
    static final String TABLE_PASSWORDS = "moz_logins";
    static final String TABLE_DELETED_PASSWORDS = "moz_deleted_logins";
    private static final String TELEMETRY_TAG = "SQLITEBRIDGE_PROVIDER_PASSWORDS";
    private static final int PASSWORDS = 100;
    private static final int DELETED_PASSWORDS = 101;
    static final String DEFAULT_PASSWORDS_SORT_ORDER = "hostname ASC";
    static final String DEFAULT_DELETED_PASSWORDS_SORT_ORDER = "timeDeleted ASC";
    private static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    private static final HashMap<String, String> PASSWORDS_PROJECTION_MAP;
    private static final HashMap<String, String> DELETED_PASSWORDS_PROJECTION_MAP;
    private static final int DB_VERSION = 5;
    private static final String DB_FILENAME = "signons.sqlite";
    private static final String WHERE_GUID_IS_NULL = "guid IS NULL";
    private static final String WHERE_GUID_IS_VALUE = "guid = ?";
    private static final String LOG_TAG = "GeckoPasswordsProvider";
    private CrashHandler mCrashHandler;

    public PasswordsProvider() {
        super(LOG_TAG);
    }

    @Override
    public boolean onCreate() {
        this.mCrashHandler = CrashHandler.createDefaultCrashHandler(this.getContext());
        GeckoLoader.doLoadLibrary((Context)this.getContext(), (String)"mozglue");
        return super.onCreate();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.mCrashHandler != null) {
            this.mCrashHandler.unregister();
            this.mCrashHandler = null;
        }
    }

    @Override
    protected String getDBName() {
        return DB_FILENAME;
    }

    @Override
    protected String getTelemetryPrefix() {
        return TELEMETRY_TAG;
    }

    @Override
    protected int getDBVersion() {
        return 5;
    }

    @Override
    public String getType(Uri uri) {
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 100: {
                return "vnd.android.cursor.dir/passwords";
            }
            case 101: {
                return "vnd.android.cursor.dir/deleted-passwords";
            }
        }
        throw new UnsupportedOperationException("Unknown type " + uri);
    }

    @Override
    public String getTable(Uri uri) {
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 101: {
                return TABLE_DELETED_PASSWORDS;
            }
            case 100: {
                return TABLE_PASSWORDS;
            }
        }
        throw new UnsupportedOperationException("Unknown table " + uri);
    }

    @Override
    public String getSortOrder(Uri uri, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 101: {
                return DEFAULT_DELETED_PASSWORDS_SORT_ORDER;
            }
            case 100: {
                return DEFAULT_PASSWORDS_SORT_ORDER;
            }
        }
        throw new UnsupportedOperationException("Unknown URI " + uri);
    }

    @Override
    public void setupDefaults(Uri uri, ContentValues contentValues) throws IllegalArgumentException {
        int n = URI_MATCHER.match(uri);
        long l = System.currentTimeMillis();
        switch (n) {
            case 101: {
                contentValues.put("timeDeleted", Long.valueOf(l));
                if (contentValues.containsKey("guid")) break;
                throw new IllegalArgumentException("Must provide a GUID for a deleted password");
            }
            case 100: {
                String string2;
                contentValues.put("timeCreated", Long.valueOf(l));
                if (!contentValues.containsKey("guid")) {
                    string2 = Utils.generateGuid();
                    contentValues.put("guid", string2);
                }
                string2 = Long.toString(l);
                DBUtils.replaceKey(contentValues, null, "hostname", "");
                DBUtils.replaceKey(contentValues, null, "httpRealm", "");
                DBUtils.replaceKey(contentValues, null, "formSubmitURL", "");
                DBUtils.replaceKey(contentValues, null, "usernameField", "");
                DBUtils.replaceKey(contentValues, null, "passwordField", "");
                DBUtils.replaceKey(contentValues, null, "encryptedUsername", "");
                DBUtils.replaceKey(contentValues, null, "encryptedPassword", "");
                DBUtils.replaceKey(contentValues, null, "encType", "0");
                DBUtils.replaceKey(contentValues, null, "timeLastUsed", string2);
                DBUtils.replaceKey(contentValues, null, "timePasswordChanged", string2);
                DBUtils.replaceKey(contentValues, null, "timesUsed", "0");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown URI " + uri);
            }
        }
    }

    @Override
    public void initGecko() {
        Intent intent = new Intent(this.getContext(), GeckoMessageReceiver.class);
        intent.setAction("org.mozilla.gecko.INIT_PW");
        this.mContext.sendBroadcast(intent);
    }

    private String doCrypto(String string2, Uri uri, Boolean bl) {
        String string3 = null;
        if (uri != null) {
            string3 = uri.getQueryParameter("profilePath");
        }
        String string4 = "";
        try {
            string4 = bl.booleanValue() ? (string3 != null ? NSSBridge.encrypt(this.mContext, string3, string2) : NSSBridge.encrypt(this.mContext, string2)) : (string3 != null ? NSSBridge.decrypt(this.mContext, string3, string2) : NSSBridge.decrypt(this.mContext, string2));
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Error in NSSBridge");
            throw new RuntimeException(exception);
        }
        return string4;
    }

    @Override
    public void onPreInsert(ContentValues contentValues, Uri uri, SQLiteBridge sQLiteBridge) {
        String string2;
        if (contentValues.containsKey("guid")) {
            string2 = contentValues.getAsString("guid");
            if (string2 == null) {
                sQLiteBridge.delete(TABLE_DELETED_PASSWORDS, WHERE_GUID_IS_NULL, null);
                return;
            }
            String[] stringArray = new String[]{string2};
            sQLiteBridge.delete(TABLE_DELETED_PASSWORDS, WHERE_GUID_IS_VALUE, stringArray);
        }
        if (contentValues.containsKey("encryptedPassword")) {
            string2 = this.doCrypto(contentValues.getAsString("encryptedPassword"), uri, true);
            contentValues.put("encryptedPassword", string2);
            contentValues.put("encType", Integer.valueOf(1));
        }
        if (contentValues.containsKey("encryptedUsername")) {
            string2 = this.doCrypto(contentValues.getAsString("encryptedUsername"), uri, true);
            contentValues.put("encryptedUsername", string2);
            contentValues.put("encType", Integer.valueOf(1));
        }
    }

    @Override
    public void onPreUpdate(ContentValues contentValues, Uri uri, SQLiteBridge sQLiteBridge) {
        String string2;
        if (contentValues.containsKey("encryptedPassword")) {
            string2 = this.doCrypto(contentValues.getAsString("encryptedPassword"), uri, true);
            contentValues.put("encryptedPassword", string2);
            contentValues.put("encType", Integer.valueOf(1));
        }
        if (contentValues.containsKey("encryptedUsername")) {
            string2 = this.doCrypto(contentValues.getAsString("encryptedUsername"), uri, true);
            contentValues.put("encryptedUsername", string2);
            contentValues.put("encType", Integer.valueOf(1));
        }
    }

    @Override
    public void onPostQuery(Cursor cursor, Uri uri, SQLiteBridge sQLiteBridge) {
        int n = -1;
        int n2 = -1;
        Object var6_6 = null;
        try {
            n = cursor.getColumnIndexOrThrow("encryptedPassword");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n2 = cursor.getColumnIndexOrThrow("encryptedUsername");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n > -1 || n2 > -1) {
            MatrixBlobCursor matrixBlobCursor = (MatrixBlobCursor)cursor;
            if (cursor.moveToFirst()) {
                do {
                    String string2;
                    if (n > -1) {
                        string2 = this.doCrypto(cursor.getString(n), uri, false);
                        matrixBlobCursor.set(n, string2);
                    }
                    if (n2 <= -1) continue;
                    string2 = this.doCrypto(cursor.getString(n2), uri, false);
                    matrixBlobCursor.set(n2, string2);
                } while (cursor.moveToNext());
            }
        }
    }

    static {
        URI_MATCHER.addURI("org.mozilla.fennec.db.passwords", "passwords", 100);
        PASSWORDS_PROJECTION_MAP = new HashMap();
        PASSWORDS_PROJECTION_MAP.put("id", "id");
        PASSWORDS_PROJECTION_MAP.put("hostname", "hostname");
        PASSWORDS_PROJECTION_MAP.put("httpRealm", "httpRealm");
        PASSWORDS_PROJECTION_MAP.put("formSubmitURL", "formSubmitURL");
        PASSWORDS_PROJECTION_MAP.put("usernameField", "usernameField");
        PASSWORDS_PROJECTION_MAP.put("passwordField", "passwordField");
        PASSWORDS_PROJECTION_MAP.put("encryptedUsername", "encryptedUsername");
        PASSWORDS_PROJECTION_MAP.put("encryptedPassword", "encryptedPassword");
        PASSWORDS_PROJECTION_MAP.put("guid", "guid");
        PASSWORDS_PROJECTION_MAP.put("encType", "encType");
        PASSWORDS_PROJECTION_MAP.put("timeCreated", "timeCreated");
        PASSWORDS_PROJECTION_MAP.put("timeLastUsed", "timeLastUsed");
        PASSWORDS_PROJECTION_MAP.put("timePasswordChanged", "timePasswordChanged");
        PASSWORDS_PROJECTION_MAP.put("timesUsed", "timesUsed");
        URI_MATCHER.addURI("org.mozilla.fennec.db.passwords", "deleted-passwords", 101);
        DELETED_PASSWORDS_PROJECTION_MAP = new HashMap();
        DELETED_PASSWORDS_PROJECTION_MAP.put("id", "id");
        DELETED_PASSWORDS_PROJECTION_MAP.put("guid", "guid");
        DELETED_PASSWORDS_PROJECTION_MAP.put("timeDeleted", "timeDeleted");
    }
}

