/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.util.SparseArray;
import android.view.View;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HistoryPanel;
import org.mozilla.gecko.home.MultiTypeCursorAdapter;
import org.mozilla.gecko.home.TwoLinePageRow;

public class HistoryHeaderListCursorAdapter
extends MultiTypeCursorAdapter
implements HistoryPanel.HistoryUrlProvider {
    private static final int ROW_HEADER = 0;
    private static final int ROW_STANDARD = 1;
    private static final int[] VIEW_TYPES = new int[]{1, 0};
    private static final int[] LAYOUT_TYPES = new int[]{R.layout.home_item_row, R.layout.home_header_row};
    private final SparseArray<HistoryPanel.MostRecentSection> mMostRecentSections = new SparseArray();

    public HistoryHeaderListCursorAdapter(Context context) {
        super(context, null, VIEW_TYPES, LAYOUT_TYPES);
    }

    public Object getItem(int n) {
        int n2 = this.getItemViewType(n);
        if (n2 == 0) {
            return null;
        }
        return super.getItem(n - this.getMostRecentSectionsCountBefore(n));
    }

    public int getItemViewType(int n) {
        if (this.mMostRecentSections.get(n) != null) {
            return 0;
        }
        return 1;
    }

    public boolean isEnabled(int n) {
        return this.getItemViewType(n) == 1;
    }

    public int getCount() {
        return super.getCount() + this.mMostRecentSections.size();
    }

    public Cursor swapCursor(Cursor cursor) {
        this.loadMostRecentSections(cursor);
        Cursor cursor2 = super.swapCursor(cursor);
        return cursor2;
    }

    @Override
    public void bindView(View view, Context context, int n) {
        int n2 = this.getItemViewType(n);
        if (n2 == 0) {
            HistoryPanel.MostRecentSection mostRecentSection = (HistoryPanel.MostRecentSection)((Object)this.mMostRecentSections.get(n));
            TextView textView = (TextView)view;
            textView.setText((CharSequence)HistoryPanel.getMostRecentSectionTitle(mostRecentSection));
        } else {
            n -= this.getMostRecentSectionsCountBefore(n);
            Cursor cursor = this.getCursor(n);
            TwoLinePageRow twoLinePageRow = (TwoLinePageRow)view;
            twoLinePageRow.updateFromCursor(cursor);
        }
    }

    private int getMostRecentSectionsCountBefore(int n) {
        int n2;
        int n3 = 0;
        int n4 = this.mMostRecentSections.size();
        for (int i = 0; i < n4 && (n2 = this.mMostRecentSections.keyAt(i)) <= n; ++i) {
            ++n3;
        }
        return n3;
    }

    private void loadMostRecentSections(Cursor cursor) {
        this.mMostRecentSections.clear();
        if (cursor == null || !cursor.moveToFirst()) {
            return;
        }
        HistoryPanel.MostRecentSection mostRecentSection = null;
        do {
            int n = cursor.getPosition();
            long l = cursor.getLong(cursor.getColumnIndexOrThrow("date"));
            HistoryPanel.MostRecentSection mostRecentSection2 = HistoryPanel.getMostRecentSectionForTime(l);
            if (mostRecentSection == mostRecentSection2) continue;
            mostRecentSection = mostRecentSection2;
            this.mMostRecentSections.append(n + this.mMostRecentSections.size(), (Object)mostRecentSection);
        } while (mostRecentSection != HistoryPanel.MostRecentSection.OLDER_THAN_SIX_MONTHS && cursor.moveToNext());
    }

    @Override
    public String getURL(int n) {
        n -= this.getMostRecentSectionsCountBefore(n);
        Cursor cursor = this.getCursor(n);
        return cursor.getString(cursor.getColumnIndexOrThrow("url"));
    }
}

