/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.home.BrowserSearch;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.SearchEngine;
import org.mozilla.gecko.util.DrawableUtil;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.widget.AnimatedHeightLayout;
import org.mozilla.gecko.widget.FaviconView;
import org.mozilla.gecko.widget.FlowLayout;

class SearchEngineRow
extends AnimatedHeightLayout {
    private static final int ANIMATION_DURATION = 250;
    private final FlowLayout mSuggestionView;
    private final FaviconView mIconView;
    private final LinearLayout mUserEnteredView;
    private final TextView mUserEnteredTextView;
    private final LayoutInflater mInflater;
    private SearchEngine mSearchEngine;
    private final View.OnClickListener mClickListener;
    private final View.OnLongClickListener mLongClickListener;
    private HomePager.OnUrlOpenListener mUrlOpenListener;
    private BrowserSearch.OnSearchListener mSearchListener;
    private BrowserSearch.OnEditSuggestionListener mEditSuggestionListener;
    private int mSelectedView;
    private Drawable mSearchHistorySuggestionIcon;
    private int mMaxSavedSuggestions;
    private int mMaxSearchSuggestions;
    private final List<Integer> mOccurrences = new ArrayList<Integer>();

    public SearchEngineRow(Context context) {
        this(context, null);
    }

    public SearchEngineRow(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SearchEngineRow(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = SearchEngineRow.this.getSuggestionTextFromView(view);
                if (view != SearchEngineRow.this.mUserEnteredView && !StringUtils.isSearchQuery((String)string2, (boolean)true)) {
                    if (SearchEngineRow.this.mUrlOpenListener != null) {
                        Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.SUGGESTION, "url");
                        SearchEngineRow.this.mUrlOpenListener.onUrlOpen(string2, EnumSet.noneOf(HomePager.OnUrlOpenListener.Flags.class));
                    }
                } else if (SearchEngineRow.this.mSearchListener != null) {
                    if (view == SearchEngineRow.this.mUserEnteredView) {
                        Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.SUGGESTION, "user");
                    } else {
                        Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.SUGGESTION, (String)view.getTag());
                    }
                    SearchEngineRow.this.mSearchListener.onSearch(SearchEngineRow.this.mSearchEngine, string2);
                }
            }
        };
        this.mLongClickListener = new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (SearchEngineRow.this.mEditSuggestionListener != null) {
                    String string2 = SearchEngineRow.this.getSuggestionTextFromView(view);
                    SearchEngineRow.this.mEditSuggestionListener.onEditSuggestion(string2);
                    return true;
                }
                return false;
            }
        };
        this.mInflater = LayoutInflater.from((Context)context);
        this.mInflater.inflate(R.layout.search_engine_row, (ViewGroup)this);
        this.mSuggestionView = (FlowLayout)this.findViewById(R.id.suggestion_layout);
        this.mIconView = (FaviconView)this.findViewById(R.id.suggestion_icon);
        this.mUserEnteredView = (LinearLayout)this.findViewById(R.id.suggestion_user_entered);
        this.mUserEnteredView.setOnClickListener(this.mClickListener);
        this.mUserEnteredTextView = (TextView)this.findViewById(R.id.suggestion_text);
        this.mSearchHistorySuggestionIcon = DrawableUtil.tintDrawable((Context)this.getContext(), (int)R.drawable.icon_most_recent_empty, (int)R.color.tabs_tray_icon_grey);
        this.mMaxSavedSuggestions = this.getResources().getInteger(R.integer.max_saved_suggestions);
        this.mMaxSearchSuggestions = this.getResources().getInteger(R.integer.max_search_suggestions);
    }

    private void setDescriptionOnSuggestion(View view, String string2) {
        view.setContentDescription((CharSequence)this.getResources().getString(R.string.suggestion_for_engine, new Object[]{this.mSearchEngine.name, string2}));
    }

    private String getSuggestionTextFromView(View view) {
        TextView textView = (TextView)view.findViewById(R.id.suggestion_text);
        return textView.getText().toString();
    }

    private void refreshOccurrencesWith(String string2, String string3) {
        this.mOccurrences.clear();
        int n = string2.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 != -1) {
            n2 = string3.indexOf(string2, n3);
            n3 = n2 + n;
            if (n2 == -1) continue;
            this.mOccurrences.add(n2);
        }
    }

    private void setSuggestionOnView(View view, String string2, boolean bl) {
        ImageView imageView = (ImageView)view.findViewById(R.id.suggestion_item_icon);
        if (bl) {
            imageView.setImageDrawable(this.mSearchHistorySuggestionIcon);
            imageView.setVisibility(0);
        } else {
            imageView.setVisibility(8);
        }
        TextView textView = (TextView)view.findViewById(R.id.suggestion_text);
        String string3 = this.getSuggestionTextFromView((View)this.mUserEnteredView);
        int n = string3.length();
        this.refreshOccurrencesWith(string3, string2);
        if (this.mOccurrences.size() > 0) {
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string2);
            int n2 = 0;
            this.mOccurrences.add(string2.length());
            for (int n3 : this.mOccurrences) {
                StyleSpan styleSpan = new StyleSpan(1);
                spannableStringBuilder.setSpan((Object)styleSpan, n2, n3, 18);
                n2 = n3 + n;
            }
            this.mOccurrences.clear();
            textView.setText((CharSequence)spannableStringBuilder);
        } else {
            textView.setText((CharSequence)string2);
        }
        this.setDescriptionOnSuggestion((View)textView, string2);
    }

    public void performUserEnteredSearch() {
        String string2 = this.getSuggestionTextFromView((View)this.mUserEnteredView);
        if (this.mSearchListener != null) {
            Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.SUGGESTION, "user");
            this.mSearchListener.onSearch(this.mSearchEngine, string2);
        }
    }

    public void setSearchTerm(String string2) {
        this.mUserEnteredTextView.setText((CharSequence)string2);
        if (this.mSearchEngine != null) {
            this.setDescriptionOnSuggestion((View)this.mUserEnteredTextView, string2);
        }
    }

    public void setOnUrlOpenListener(HomePager.OnUrlOpenListener onUrlOpenListener) {
        this.mUrlOpenListener = onUrlOpenListener;
    }

    public void setOnSearchListener(BrowserSearch.OnSearchListener onSearchListener) {
        this.mSearchListener = onSearchListener;
    }

    public void setOnEditSuggestionListener(BrowserSearch.OnEditSuggestionListener onEditSuggestionListener) {
        this.mEditSuggestionListener = onEditSuggestionListener;
    }

    private void bindSuggestionView(String string2, boolean bl, int n, Integer n2, boolean bl2, String string3) {
        View view;
        if (n2 + 1 < n) {
            view = this.mSuggestionView.getChildAt(n2 + 1);
            view.setVisibility(0);
        } else {
            view = this.mInflater.inflate(R.layout.suggestion_item, null);
            view.setOnClickListener(this.mClickListener);
            view.setOnLongClickListener(this.mLongClickListener);
            view.setTag((Object)string3);
            this.mSuggestionView.addView(view);
        }
        this.setSuggestionOnView(view, string2, bl2);
        if (bl) {
            AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
            alphaAnimation.setDuration(250L);
            alphaAnimation.setStartOffset((long)(n2 * 250));
            view.startAnimation((Animation)alphaAnimation);
        }
    }

    private void hideRecycledSuggestions(int n, int n2) {
        for (int i = n + 1; i < n2; ++i) {
            this.mSuggestionView.getChildAt(i).setVisibility(8);
        }
    }

    private void updateFromSavedSearches(List<String> list, boolean bl, int n, int n2) {
        if (list == null || list.isEmpty()) {
            this.hideRecycledSuggestions(n, n2);
            return;
        }
        int n3 = list.size();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            String string2 = "history." + i;
            String string3 = list.get(i);
            n4 = n + i;
            this.bindSuggestionView(string3, bl, n2, n4, true, string2);
        }
        this.hideRecycledSuggestions(n4 + 1, n2);
    }

    private int updateFromSearchEngine(boolean bl, List<String> list, int n, int n2) {
        int n3;
        int n4 = this.mMaxSearchSuggestions;
        if (!HardwareUtils.isTablet() && n2 < this.mMaxSavedSuggestions) {
            n4 += this.mMaxSavedSuggestions - n2;
        }
        int n5 = list.size();
        for (n3 = 0; n3 < n5 && n3 != n4; ++n3) {
            String string2 = "engine." + n3;
            String string3 = list.get(n3);
            this.bindSuggestionView(string3, bl, n, n3, false, string2);
        }
        this.hideRecycledSuggestions(n3 + 1, n);
        if (this.mSelectedView >= this.mSuggestionView.getChildCount()) {
            this.mSelectedView = this.mSuggestionView.getChildCount() - 1;
        }
        return n3;
    }

    public void updateSuggestions(boolean bl, SearchEngine searchEngine, @Nullable List<String> arrayList, boolean bl2) {
        this.mSearchEngine = searchEngine;
        this.mIconView.updateAndScaleImage(this.mSearchEngine.getIcon(), this.mSearchEngine.getEngineIdentifier());
        this.setDescriptionOnSuggestion((View)this.mUserEnteredTextView, this.mUserEnteredTextView.getText().toString());
        int n = this.mSuggestionView.getChildCount();
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(this.getContext());
        boolean bl3 = sharedPreferences.getBoolean("android.not_a_preference.search.search_history.enabled", true);
        ArrayList<String> arrayList2 = arrayList != null ? arrayList : new ArrayList();
        for (String object2 : arrayList2) {
            if (object2.length() <= 50 && !Pattern.matches("^(https?|ftp|file)://.*", object2)) continue;
            arrayList2.remove(object2);
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (String n3 : searchEngine.getSuggestions()) {
            arrayList2.remove(n3);
            arrayList3.add(n3);
        }
        arrayList2.remove(this.getSuggestionTextFromView((View)this.mUserEnteredView));
        if (arrayList2.size() >= this.mMaxSavedSuggestions) {
            arrayList2 = arrayList2.subList(0, this.mMaxSavedSuggestions);
        }
        int n2 = arrayList2.size();
        if (bl && bl3) {
            int n3 = this.updateFromSearchEngine(bl2, arrayList3, n, n2);
            this.updateFromSavedSearches(arrayList2, bl2, n3, n);
        } else if (bl3) {
            this.updateFromSavedSearches(arrayList2, bl2, 0, n);
        } else if (bl) {
            this.updateFromSearchEngine(bl2, arrayList3, n, 0);
        } else {
            this.hideRecycledSuggestions(0, n);
        }
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        View view = this.mSuggestionView.getChildAt(this.mSelectedView);
        if (keyEvent.getAction() != 0) {
            return false;
        }
        switch (keyEvent.getKeyCode()) {
            case 22: {
                View view2 = this.mSuggestionView.getChildAt(this.mSelectedView + 1);
                if (view2 == null) break;
                this.changeSelectedSuggestion(view, view2);
                ++this.mSelectedView;
                return true;
            }
            case 21: {
                View view3 = this.mSuggestionView.getChildAt(this.mSelectedView - 1);
                if (view3 == null) break;
                this.changeSelectedSuggestion(view, view3);
                --this.mSelectedView;
                return true;
            }
            case 96: {
                return view.performClick();
            }
        }
        return false;
    }

    private void changeSelectedSuggestion(View view, View view2) {
        view.setDuplicateParentStateEnabled(false);
        view2.setDuplicateParentStateEnabled(true);
        view.refreshDrawableState();
        view2.refreshDrawableState();
    }

    public void onSelected() {
        this.mSelectedView = 0;
        this.mUserEnteredView.setDuplicateParentStateEnabled(true);
        this.mUserEnteredView.refreshDrawableState();
    }

    public void onDeselected() {
        View view = this.mSuggestionView.getChildAt(this.mSelectedView);
        view.setDuplicateParentStateEnabled(false);
        view.refreshDrawableState();
    }
}

