/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.lwt;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.ViewParent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.lwt.LightweightThemeDrawable;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.WindowUtils;

public class LightweightTheme
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoLightweightTheme";
    private static final String PREFS_URL = "lightweightTheme.headerURL";
    private static final String PREFS_COLOR = "lightweightTheme.color";
    private static final String ASSETS_PREFIX = "resource://android/assets/";
    private final Application mApplication;
    private Bitmap mBitmap;
    private int mColor;
    private boolean mIsLight;
    private final List<OnChangeListener> mListeners;

    public LightweightTheme(Application application) {
        this.mApplication = application;
        this.mListeners = new ArrayList<OnChangeListener>();
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "LightweightTheme:Update", "LightweightTheme:Disable");
        ThreadUtils.postToBackgroundThread((Runnable)new LightweightThemeRunnable());
    }

    public void addListener(OnChangeListener onChangeListener) {
        this.mListeners.add(onChangeListener);
    }

    public void removeListener(OnChangeListener onChangeListener) {
        this.mListeners.remove(onChangeListener);
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("LightweightTheme:Update")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("data");
                String string3 = jSONObject2.getString("headerURL");
                String string4 = jSONObject2.optString("accentcolor");
                ThreadUtils.postToBackgroundThread((Runnable)new LightweightThemeRunnable(string3, string4));
            } else if (string2.equals("LightweightTheme:Disable")) {
                this.clearPrefs();
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LightweightTheme.this.resetLightweightTheme();
                    }
                });
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    private void clearPrefs() {
        GeckoSharedPrefs.forProfile((Context)this.mApplication).edit().remove(PREFS_URL).remove(PREFS_COLOR).apply();
    }

    private void setLightweightTheme(Bitmap bitmap, String string2) {
        if (bitmap == null || bitmap.getWidth() == 0 || bitmap.getHeight() == 0) {
            this.mBitmap = null;
            return;
        }
        int n = WindowUtils.getLargestDimension((Context)this.mApplication);
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        try {
            this.mColor = Color.parseColor((String)string2);
        }
        catch (Exception exception) {
            this.mColor = 0;
        }
        double d = 0.2125 * (double)((this.mColor & 0xFF0000) >> 16) + 0.7154 * (double)((this.mColor & 0xFF00) >> 8) + 0.0721 * (double)(this.mColor & 0xFF);
        boolean bl = this.mIsLight = d > 110.0;
        if (n2 >= n) {
            this.mBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)(n2 - n), (int)0, (int)n, (int)n3);
        } else {
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            this.mBitmap = Bitmap.createBitmap((int)n, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas object = new Canvas(this.mBitmap);
            object.drawColor(this.mColor);
            Rect rect = new Rect();
            Gravity.apply((int)53, (int)n2, (int)n3, (Rect)new Rect(0, 0, n, n3), (Rect)rect);
            object.drawBitmap(bitmap, null, rect, paint);
        }
        for (OnChangeListener onChangeListener : this.mListeners) {
            onChangeListener.onLightweightThemeChanged();
        }
    }

    private void resetLightweightTheme() {
        ThreadUtils.assertOnUiThread((ThreadUtils.AssertBehavior)ThreadUtils.AssertBehavior.NONE);
        if (this.mBitmap == null) {
            return;
        }
        this.mBitmap = null;
        for (OnChangeListener onChangeListener : this.mListeners) {
            onChangeListener.onLightweightThemeReset();
        }
    }

    public boolean isEnabled() {
        return this.mBitmap != null;
    }

    public boolean isLightTheme() {
        return this.mIsLight;
    }

    private Bitmap getCroppedBitmap(View view) {
        ViewParent viewParent;
        if (this.mBitmap == null || view == null) {
            return null;
        }
        Rect rect = new Rect();
        view.getGlobalVisibleRect(rect);
        Rect rect2 = new Rect();
        view.getWindowVisibleDisplayFrame(rect2);
        int n = view.getContext().getResources().getDisplayMetrics().widthPixels;
        int n2 = this.mBitmap.getWidth() - n + rect.left;
        int n3 = this.mBitmap.getWidth() - n + rect.right;
        int n4 = rect.top - rect2.top;
        int n5 = rect.bottom - rect2.top;
        int n6 = 0;
        int n7 = 0;
        View view2 = view;
        do {
            if (AppConstants.Versions.feature11Plus) {
                n6 += (int)view2.getTranslationX() - view2.getScrollX();
                n7 += (int)view2.getTranslationY() - view2.getScrollY();
            } else {
                n6 -= view2.getScrollX();
                n7 -= view2.getScrollY();
            }
            viewParent = view2.getParent();
            if (!(viewParent instanceof View)) continue;
            view2 = (View)viewParent;
        } while (viewParent instanceof View);
        int n8 = (n3 -= n6) - (n2 -= n6);
        int n9 = (n5 -= n7) > this.mBitmap.getHeight() ? this.mBitmap.getHeight() - n4 : n5 - (n4 -= n7);
        try {
            return Bitmap.createBitmap((Bitmap)this.mBitmap, (int)n2, (int)n4, (int)n8, (int)n9);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Drawable getDrawable(View view) {
        Bitmap bitmap = this.getCroppedBitmap(view);
        if (bitmap == null) {
            return null;
        }
        BitmapDrawable bitmapDrawable = new BitmapDrawable(view.getContext().getResources(), bitmap);
        bitmapDrawable.setGravity(53);
        bitmapDrawable.setTileModeXY(Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        return bitmapDrawable;
    }

    public LightweightThemeDrawable getColorDrawable(View view) {
        return this.getColorDrawable(view, this.mColor, false);
    }

    public LightweightThemeDrawable getColorDrawable(View view, int n) {
        return this.getColorDrawable(view, n, false);
    }

    public LightweightThemeDrawable getColorDrawable(View view, int n, boolean bl) {
        Bitmap bitmap = this.getCroppedBitmap(view);
        if (bitmap == null) {
            return null;
        }
        LightweightThemeDrawable lightweightThemeDrawable = new LightweightThemeDrawable(view.getContext().getResources(), bitmap);
        if (bl) {
            lightweightThemeDrawable.setColorWithFilter(n, this.mColor & 0x22FFFFFF);
        } else {
            lightweightThemeDrawable.setColor(n);
        }
        return lightweightThemeDrawable;
    }

    class LightweightThemeRunnable
    implements Runnable {
        private String mHeaderURL;
        private String mColor;
        private String mSavedURL;
        private String mSavedColor;

        LightweightThemeRunnable() {
        }

        LightweightThemeRunnable(String string2, String string3) {
            this.mHeaderURL = string2;
            this.mColor = string3;
        }

        private void loadFromPrefs() {
            SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile((Context)LightweightTheme.this.mApplication);
            this.mSavedURL = sharedPreferences.getString(LightweightTheme.PREFS_URL, null);
            this.mSavedColor = sharedPreferences.getString(LightweightTheme.PREFS_COLOR, null);
        }

        private void saveToPrefs() {
            GeckoSharedPrefs.forProfile((Context)LightweightTheme.this.mApplication).edit().putString(LightweightTheme.PREFS_URL, this.mHeaderURL).putString(LightweightTheme.PREFS_COLOR, this.mColor).apply();
            this.mSavedURL = this.mHeaderURL;
            this.mSavedColor = this.mColor;
        }

        @Override
        public void run() {
            String string2;
            int n;
            this.loadFromPrefs();
            if (TextUtils.isEmpty((CharSequence)this.mHeaderURL)) {
                this.mHeaderURL = this.mSavedURL;
                this.mColor = this.mSavedColor;
                if (TextUtils.isEmpty((CharSequence)this.mHeaderURL)) {
                    return;
                }
            } else {
                if (TextUtils.equals((CharSequence)this.mHeaderURL, (CharSequence)this.mSavedURL)) {
                    return;
                }
                this.saveToPrefs();
            }
            if ((n = (string2 = this.mHeaderURL).indexOf(63)) != -1) {
                string2 = string2.substring(0, n);
            }
            if (string2.startsWith(LightweightTheme.ASSETS_PREFIX)) {
                this.onBitmapLoaded(this.loadFromAssets(string2));
            } else {
                this.onBitmapLoaded(BitmapUtils.decodeUrl(string2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Bitmap loadFromAssets(String string2) {
            InputStream inputStream = null;
            try {
                inputStream = LightweightTheme.this.mApplication.getAssets().open(string2.substring(LightweightTheme.ASSETS_PREFIX.length()));
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                return bitmap;
            }
            catch (IOException iOException) {
                Bitmap bitmap = null;
                return bitmap;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private void onBitmapLoaded(final Bitmap bitmap) {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    LightweightTheme.this.setLightweightTheme(bitmap, LightweightThemeRunnable.this.mColor);
                }
            });
        }
    }

    public static interface OnChangeListener {
        public void onLightweightThemeChanged();

        public void onLightweightThemeReset();
    }
}

