/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.permissions;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.mozilla.gecko.permissions.PermissionBlock;
import org.mozilla.gecko.permissions.PermissionsHelper;
import org.mozilla.gecko.util.ThreadUtils;

public class Permissions {
    private static final Queue<PermissionBlock> waiting = new LinkedList<PermissionBlock>();
    private static final Queue<PermissionBlock> prompt = new LinkedList<PermissionBlock>();
    private static PermissionsHelper permissionHelper = new PermissionsHelper();

    public static PermissionBlock from(@NonNull Context context) {
        return new PermissionBlock(context, permissionHelper);
    }

    public static boolean waitFor(@NonNull Activity activity, String ... stringArray) {
        ThreadUtils.assertNotOnUiThread();
        final FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return true;
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                futureTask.cancel(true);
            }
        };
        Permissions.from((Context)activity).withPermissions(stringArray).andFallback(runnable).run(futureTask);
        try {
            return futureTask.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException exception) {
            return false;
        }
    }

    static void setPermissionHelper(PermissionsHelper permissionsHelper) {
        permissionHelper = permissionsHelper;
    }

    public static synchronized void onRequestPermissionsResult(@NonNull Activity activity, @NonNull String[] stringArray, @NonNull int[] nArray) {
        Permissions.processGrantResults(stringArray, nArray);
        Permissions.processQueue(activity, stringArray, nArray);
    }

    static synchronized void prompt(Activity activity, PermissionBlock permissionBlock) {
        if (prompt.isEmpty()) {
            prompt.add(permissionBlock);
            Permissions.showPrompt(activity);
        } else {
            waiting.add(permissionBlock);
        }
    }

    private static synchronized void processGrantResults(@NonNull String[] stringArray, @NonNull int[] nArray) {
        HashSet<String> hashSet = Permissions.collectGrantedPermissions(stringArray, nArray);
        while (!prompt.isEmpty()) {
            PermissionBlock permissionBlock = prompt.poll();
            if (Permissions.allPermissionsGranted(permissionBlock, hashSet)) {
                permissionBlock.onPermissionsGranted();
                continue;
            }
            permissionBlock.onPermissionsDenied();
        }
    }

    private static synchronized void processQueue(Activity activity, String[] stringArray, int[] nArray) {
        HashSet<String> hashSet = Permissions.collectDeniedPermissions(stringArray, nArray);
        while (!waiting.isEmpty()) {
            PermissionBlock permissionBlock = waiting.poll();
            if (permissionBlock.hasPermissions((Context)activity)) {
                permissionBlock.onPermissionsGranted();
                continue;
            }
            if (Permissions.atLeastOnePermissionDenied(permissionBlock, hashSet)) {
                permissionBlock.onPermissionsDenied();
                continue;
            }
            prompt.add(permissionBlock);
        }
        if (!prompt.isEmpty()) {
            Permissions.showPrompt(activity);
        }
    }

    private static synchronized void showPrompt(Activity activity) {
        HashSet hashSet = new HashSet();
        for (PermissionBlock permissionBlock : prompt) {
            Collections.addAll(hashSet, permissionBlock.getPermissions());
        }
        permissionHelper.prompt(activity, hashSet.toArray(new String[hashSet.size()]));
    }

    private static HashSet<String> collectGrantedPermissions(@NonNull String[] stringArray, @NonNull int[] nArray) {
        return Permissions.filterPermissionsByResult(stringArray, nArray, 0);
    }

    private static HashSet<String> collectDeniedPermissions(@NonNull String[] stringArray, @NonNull int[] nArray) {
        return Permissions.filterPermissionsByResult(stringArray, nArray, -1);
    }

    private static HashSet<String> filterPermissionsByResult(@NonNull String[] stringArray, @NonNull int[] nArray, int n) {
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (nArray[i] != n) continue;
            hashSet.add(stringArray[i]);
        }
        return hashSet;
    }

    private static boolean allPermissionsGranted(PermissionBlock permissionBlock, HashSet<String> hashSet) {
        for (String string2 : permissionBlock.getPermissions()) {
            if (hashSet.contains(string2)) continue;
            return false;
        }
        return true;
    }

    private static boolean atLeastOnePermissionDenied(PermissionBlock permissionBlock, HashSet<String> hashSet) {
        for (String string2 : permissionBlock.getPermissions()) {
            if (!hashSet.contains(string2)) continue;
            return true;
        }
        return false;
    }
}

