/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.webapp;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.StubBrowserDB;
import org.mozilla.gecko.mozglue.ContextUtils;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.webapp.Allocator;
import org.mozilla.gecko.webapp.ApkResources;
import org.mozilla.gecko.webapp.InstallHelper;

public class WebappImpl
extends GeckoApp
implements InstallHelper.InstallCallback {
    private static final String LOGTAG = "GeckoWebappImpl";
    private URI mOrigin;
    private TextView mTitlebarText;
    private View mTitlebar;
    View mSplashscreen;
    private boolean mIsApk = true;
    private ApkResources mApkResources;
    private String mManifestUrl;
    private String mAppName;

    protected int getIndex() {
        return 0;
    }

    @Override
    public int getLayout() {
        return R.layout.web_app;
    }

    public WebappImpl() {
        GeckoProfile.setBrowserDBFactory(new BrowserDB.Factory(){

            @Override
            public BrowserDB get(String string2, File file) {
                return new StubBrowserDB(string2);
            }
        });
    }

    @Override
    public void onCreate(Bundle bundle) {
        boolean bl;
        Object object;
        Bundle bundle2 = this.getIntent().getExtras();
        if (bundle2 == null) {
            bundle2 = bundle;
        }
        if (bundle2 == null) {
            bundle2 = new Bundle();
        }
        boolean bl2 = bundle2.getBoolean("isInstalled", false);
        String string2 = bundle2.getString("packageName");
        if (string2 == null) {
            Log.w((String)LOGTAG, (String)"no package name; treating as legacy shortcut");
            this.mIsApk = false;
            bl2 = true;
            object = this.getIntent().getData();
            if (object == null) {
                Log.wtf((String)LOGTAG, (String)"can't get manifest URL from shortcut data");
                this.setResult(0);
                this.finish();
                return;
            }
            this.mManifestUrl = object.toString();
            String string3 = bundle2.getString("android.intent.extra.shortcut.NAME");
            this.mAppName = string3 != null ? string3 : "Web App";
        } else {
            try {
                this.mApkResources = new ApkResources((Context)this, string2);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.e((String)LOGTAG, (String)("Can't find package for webapp " + string2), (Throwable)nameNotFoundException);
                this.setResult(0);
                this.finish();
                return;
            }
            this.mManifestUrl = this.mApkResources.getManifestUrl();
            this.mAppName = this.mApkResources.getAppName();
        }
        super.onCreate(bundle);
        this.mTitlebarText = (TextView)this.findViewById(R.id.webapp_title);
        this.mTitlebar = this.findViewById(R.id.webapp_titlebar);
        this.mSplashscreen = this.findViewById(R.id.splashscreen);
        object = Allocator.getInstance((Context)this);
        int n = this.getIndex();
        ((Allocator)object).maybeMigrateOldPrefs(n);
        String string4 = ((Allocator)object).getOrigin(n);
        boolean bl3 = bl = string4 == null;
        if (!GeckoThread.isRunning() || !bl2 || bl) {
            this.overridePendingTransition(R.anim.grow_fade_in_center, 0x10A0001);
            this.showSplash();
        } else {
            this.mSplashscreen.setVisibility(8);
        }
        if (!bl2 || bl) {
            InstallHelper installHelper = new InstallHelper(this.getApplicationContext(), this.mApkResources, this);
            if (!bl2) {
                try {
                    installHelper.startInstall(this.getDefaultProfileName());
                }
                catch (IOException iOException) {
                    Log.e((String)LOGTAG, (String)"Couldn't install packaged app", (Throwable)iOException);
                }
            } else {
                Log.i((String)LOGTAG, (String)"Waiting for existing install to complete");
                installHelper.registerGeckoListener();
            }
            return;
        }
        this.launchWebapp(string4);
        this.setTitle(this.mAppName);
    }

    @Override
    protected String getURIFromIntent(ContextUtils.SafeIntent safeIntent) {
        String string2 = super.getURIFromIntent(safeIntent);
        if (string2 != null) {
            return string2;
        }
        if (this.mIsApk) {
            return this.mApkResources.getManifestUrl();
        }
        Log.wtf((String)LOGTAG, (String)"Couldn't get URI from intent nor APK resources");
        return null;
    }

    @Override
    protected void loadStartupTab(int n) {
        this.loadStartupTab(null, null, n);
    }

    @Override
    protected void loadStartupTab(String string2, ContextUtils.SafeIntent safeIntent, int n) {
        n = 131;
        super.loadStartupTab("about:blank", null, n);
    }

    private void showSplash() {
        Object object;
        int n = Allocator.getInstance().getColor(this.getIndex());
        this.setBackgroundGradient(n);
        ImageView imageView = (ImageView)this.findViewById(R.id.splashscreen_icon);
        Drawable drawable2 = null;
        if (this.mIsApk) {
            object = this.mApkResources.getAppIconUri();
            imageView.setImageURI(object);
            drawable2 = imageView.getDrawable();
        } else {
            object = this.getProfile().getDir();
            File file = new File((File)object, "logo.png");
            if (file.exists()) {
                drawable2 = Drawable.createFromPath((String)file.getPath());
                imageView.setImageDrawable(drawable2);
            }
        }
        if (drawable2 != null) {
            object = AnimationUtils.loadAnimation((Context)this, (int)R.anim.grow_fade_in_center);
            object.setStartOffset(500L);
            object.setDuration(1000L);
            imageView.startAnimation((Animation)object);
        }
    }

    public void setBackgroundGradient(int n) {
        int[] nArray = new int[2];
        float[] fArray = new float[3];
        Color.colorToHSV((int)n, (float[])fArray);
        fArray[2] = Math.min(fArray[2] * 2.0f, 1.0f);
        nArray[0] = Color.HSVToColor((int)255, (float[])fArray);
        fArray[2] = (float)((double)fArray[2] * 0.75);
        nArray[1] = Color.HSVToColor((int)255, (float[])fArray);
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TL_BR, nArray);
        gradientDrawable.setGradientType(1);
        Display display = this.getWindowManager().getDefaultDisplay();
        gradientDrawable.setGradientCenter(0.5f, 0.5f);
        gradientDrawable.setGradientRadius((float)Math.max(display.getWidth() / 2, display.getHeight() / 2));
        this.mSplashscreen.setBackgroundDrawable((Drawable)gradientDrawable);
    }

    @Override
    protected String getDefaultProfileName() {
        return "webapp" + this.getIndex();
    }

    @Override
    protected boolean getSessionRestoreState(Bundle bundle) {
        return false;
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case SELECTED: 
            case LOCATION_CHANGE: {
                URI uRI;
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                String string2 = tab.getURL();
                if (string2 != null && string2.equals("about:blank")) {
                    this.mTitlebar.setVisibility(8);
                    return;
                }
                try {
                    uRI = new URI(string2);
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.mTitlebarText.setText((CharSequence)string2);
                    if (string2 != null && !string2.startsWith("app://")) {
                        this.mTitlebar.setVisibility(0);
                    } else {
                        this.mTitlebar.setVisibility(8);
                    }
                    return;
                }
                if (this.mOrigin != null && this.mOrigin.getHost().equals(uRI.getHost())) {
                    this.mTitlebar.setVisibility(8);
                    break;
                }
                this.mTitlebarText.setText((CharSequence)(uRI.getScheme() + "://" + uRI.getHost()));
                this.mTitlebar.setVisibility(0);
                break;
            }
            case LOADED: {
                this.hideSplash();
                break;
            }
            case START: {
                if (this.mSplashscreen == null || this.mSplashscreen.getVisibility() != 0) break;
                View view = this.findViewById(R.id.splashscreen_progress);
                view.setVisibility(0);
                Animation animation = AnimationUtils.loadAnimation((Context)this, (int)0x10A0000);
                animation.setDuration(1000L);
                view.startAnimation(animation);
            }
        }
        super.onTabChanged(tab, tabEvents, object);
    }

    protected void hideSplash() {
        if (this.mSplashscreen != null && this.mSplashscreen.getVisibility() == 0) {
            Animation animation = AnimationUtils.loadAnimation((Context)this, (int)0x10A0001);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationEnd(Animation animation) {
                    WebappImpl.this.mSplashscreen.setVisibility(8);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationStart(Animation animation) {
                }
            });
            this.mSplashscreen.startAnimation(animation);
        }
    }

    @Override
    public void installCompleted(InstallHelper installHelper, String string2, NativeJSObject nativeJSObject) {
        if (string2 == null) {
            return;
        }
        if (string2.equals("Webapps:Postinstall")) {
            String string3 = nativeJSObject.optString("origin", null);
            this.launchWebapp(string3);
        }
    }

    @Override
    public void installErrored(InstallHelper installHelper, Exception exception) {
        Log.e((String)LOGTAG, (String)"Install errored", (Throwable)exception);
    }

    private void setOrigin(String string2) {
        block5: {
            try {
                this.mOrigin = new URI(string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                if (!string2.startsWith("app://")) {
                    return;
                }
                if (this.mIsApk) break block5;
                Log.i((String)LOGTAG, (String)"Origin is app: URL; falling back to intent URL");
                Uri uri = this.getIntent().getData();
                if (uri == null) break block5;
                try {
                    this.mOrigin = new URI(uri.toString());
                }
                catch (URISyntaxException uRISyntaxException2) {
                    Log.e((String)LOGTAG, (String)"Unable to parse intent URL: ", (Throwable)uRISyntaxException);
                }
            }
        }
    }

    public void launchWebapp(String string2) {
        this.setOrigin(string2);
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.putOpt("url", (Object)this.mManifestUrl);
            jSONObject.putOpt("name", (Object)this.mAppName);
            Log.i((String)LOGTAG, (String)("Trying to launch: " + jSONObject));
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Webapps:Load", jSONObject.toString()));
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error populating launch message", (Throwable)jSONException);
        }
    }

    @Override
    protected boolean getIsDebuggable() {
        if (this.mIsApk) {
            return this.mApkResources.isDebuggable();
        }
        return false;
    }

    @Override
    protected GeckoApp.StartupAction getStartupAction(String string2, String string3) {
        return GeckoApp.StartupAction.WEBAPP;
    }
}

