/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.nativecode;

import android.util.Log;
import java.security.GeneralSecurityException;
import org.mozilla.gecko.annotation.RobocopTarget;

@RobocopTarget
public class NativeCrypto {
    public static native byte[] pbkdf2SHA256(byte[] var0, byte[] var1, int var2, int var3) throws GeneralSecurityException;

    public static native byte[] sha1(byte[] var0);

    public static native byte[] sha256init();

    public static native void sha256update(byte[] var0, byte[] var1, int var2);

    public static native byte[] sha256finalize(byte[] var0);

    static {
        try {
            System.loadLibrary("mozglue");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Log.wtf((String)"NativeCrypto", (String)"Couldn't load mozglue. Trying /data/app-lib path.");
            try {
                System.load("/data/app-lib/org.mozilla.fennec/libmozglue.so");
            }
            catch (Throwable throwable) {
                try {
                    Log.wtf((String)"NativeCrypto", (String)("Couldn't load mozglue: " + throwable + ". Trying /data/data path."));
                    System.load("/data/data/org.mozilla.fennec/lib/libmozglue.so");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    Log.wtf((String)"NativeCrypto", (String)"Failed every attempt to load mozglue. Giving up.");
                    throw new RuntimeException("Unable to load mozglue", unsatisfiedLinkError2);
                }
            }
        }
    }
}

