/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.SyncStatusListener;
import org.mozilla.gecko.fxa.authenticator.AccountPickler;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.sync.FxAccountSyncStatusHelper;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.Utils;

public class FirefoxAccounts {
    private static final String LOG_TAG = FirefoxAccounts.class.getSimpleName();

    public static boolean firefoxAccountsExist(Context context) {
        return FirefoxAccounts.getFirefoxAccounts(context).length > 0;
    }

    public static Account[] getFirefoxAccounts(Context context) {
        Account[] accountArray;
        Account[] accountArray2 = AccountManager.get((Context)context).getAccountsByType("org.mozilla.fennec_fxaccount");
        if (accountArray2.length > 0) {
            return accountArray2;
        }
        Account account = FirefoxAccounts.getPickledAccount(context);
        if (account != null) {
            Account[] accountArray3 = new Account[1];
            accountArray = accountArray3;
            accountArray3[0] = account;
        } else {
            accountArray = new Account[]{};
        }
        return accountArray;
    }

    private static Account getPickledAccount(final Context context) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Account[] accountArray = new Account[1];
        ThreadPool.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    File file = context.getFileStreamPath("fxa.account.json");
                    if (!file.exists()) {
                        accountArray[0] = null;
                        return;
                    }
                    AndroidFxAccount androidFxAccount = AccountPickler.unpickle(context, "fxa.account.json");
                    accountArray[0] = androidFxAccount != null ? androidFxAccount.getAndroidAccount() : null;
                }
                finally {
                    countDownLatch.countDown();
                }
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Logger.warn(LOG_TAG, "Foreground thread unexpectedly interrupted while getting pickled account", interruptedException);
            return null;
        }
        return accountArray[0];
    }

    public static Account getFirefoxAccount(Context context) {
        Account[] accountArray = FirefoxAccounts.getFirefoxAccounts(context);
        if (accountArray.length > 0) {
            return accountArray[0];
        }
        return null;
    }

    public static State getFirefoxAccountState(Context context) {
        Account account = FirefoxAccounts.getFirefoxAccount(context);
        if (account == null) {
            return null;
        }
        AndroidFxAccount androidFxAccount = new AndroidFxAccount(context, account);
        try {
            return androidFxAccount.getState();
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Could not get FX account state.", exception);
            return null;
        }
    }

    public static String getFirefoxAccountEmail(Context context) {
        Account account = FirefoxAccounts.getFirefoxAccount(context);
        if (account == null) {
            return null;
        }
        return account.name;
    }

    public static void logSyncOptions(Bundle bundle) {
        boolean bl = bundle.getBoolean("ignore_backoff", false);
        Logger.info(LOG_TAG, "Sync options -- scheduling now: " + bl);
    }

    public static void requestImmediateSync(Account account, String[] stringArray, String[] stringArray2) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("ignore_backoff", true);
        bundle.putBoolean("expedited", true);
        FirefoxAccounts.requestSync(account, bundle, stringArray, stringArray2);
    }

    public static void requestEventualSync(Account account, String[] stringArray, String[] stringArray2) {
        FirefoxAccounts.requestSync(account, Bundle.EMPTY, stringArray, stringArray2);
    }

    protected static void requestSync(final Account account, final Bundle bundle, String[] stringArray, String[] stringArray2) {
        if (account == null) {
            throw new IllegalArgumentException("account must not be null");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("syncOptions must not be null");
        }
        Utils.putStageNamesToSync(bundle, stringArray, stringArray2);
        Logger.info(LOG_TAG, "Requesting sync.");
        FirefoxAccounts.logSyncOptions(bundle);
        ThreadPool.run(new Runnable(){

            @Override
            public void run() {
                for (String string2 : AndroidFxAccount.DEFAULT_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP.keySet()) {
                    ContentResolver.requestSync((Account)account, (String)string2, (Bundle)bundle);
                }
            }
        });
    }

    public static void addSyncStatusListener(SyncStatusListener syncStatusListener) {
        FxAccountSyncStatusHelper.getInstance().startObserving(syncStatusListener);
    }

    public static void removeSyncStatusListener(SyncStatusListener syncStatusListener) {
        FxAccountSyncStatusHelper.getInstance().stopObserving(syncStatusListener);
    }

    public static String getOldSyncUpgradeURL(Resources resources, Locale locale) {
        String string2 = Locales.getLanguageTag((Locale)locale);
        return resources.getString(R.string.fxaccount_link_old_firefox, new Object[]{"47.0a1", "Android", string2});
    }
}

