/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;

public class InfoCollections {
    private static final String LOG_TAG = "InfoCollections";
    final Map<String, Long> timestamps;

    public InfoCollections() {
        this(new ExtendedJSONObject());
    }

    public InfoCollections(ExtendedJSONObject extendedJSONObject) {
        Logger.debug(LOG_TAG, "info/collections is " + extendedJSONObject.toJSONString());
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (Map.Entry<String, Object> entry : extendedJSONObject.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof Double) {
                hashMap.put(string, Utils.decimalSecondsToMilliseconds((Double)object));
                continue;
            }
            if (object instanceof Long) {
                hashMap.put(string, Utils.decimalSecondsToMilliseconds((Long)object));
                continue;
            }
            if (object instanceof Integer) {
                hashMap.put(string, Utils.decimalSecondsToMilliseconds((Integer)object));
                continue;
            }
            Logger.warn(LOG_TAG, "Skipping info/collections entry for " + string);
        }
        this.timestamps = Collections.unmodifiableMap(hashMap);
    }

    public Long getTimestamp(String string) {
        if (this.timestamps == null) {
            return null;
        }
        return this.timestamps.get(string);
    }

    public boolean updateNeeded(String string, long l) {
        Logger.trace(LOG_TAG, "Testing " + string + " for updateNeeded. Local last modified is " + l + ".");
        if (l <= 0L) {
            return true;
        }
        Long l2 = this.getTimestamp(string);
        if (l2 == null) {
            return true;
        }
        return l2 > l;
    }
}

