/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.os.Handler;
import android.os.Looper;
import org.mozilla.gecko.util.ThreadUtils;

final class GeckoBackgroundThread
extends Thread {
    private static final String LOOPER_NAME = "GeckoBackgroundThread";
    private static Handler handler;
    private static Thread thread;
    private Runnable initialRunnable;

    private GeckoBackgroundThread(Runnable runnable) {
        this.initialRunnable = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName(LOOPER_NAME);
        Looper.prepare();
        Class<GeckoBackgroundThread> clazz = GeckoBackgroundThread.class;
        synchronized (GeckoBackgroundThread.class) {
            handler = new Handler();
            GeckoBackgroundThread.class.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.initialRunnable != null) {
                this.initialRunnable.run();
                this.initialRunnable = null;
            }
            Looper.loop();
            return;
        }
    }

    private static void startThread(Runnable runnable) {
        thread = new GeckoBackgroundThread(runnable);
        ThreadUtils.setBackgroundThread(thread);
        thread.setDaemon(true);
        thread.start();
    }

    static synchronized Handler getHandler() {
        if (thread == null) {
            GeckoBackgroundThread.startThread(null);
        }
        while (handler == null) {
            try {
                GeckoBackgroundThread.class.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return handler;
    }

    static synchronized void post(Runnable runnable) {
        if (thread == null) {
            GeckoBackgroundThread.startThread(runnable);
            return;
        }
        GeckoBackgroundThread.getHandler().post(runnable);
    }
}

