/*
 * Decompiled with CFR 0.152.
 */
package com.keepsafe.switchboard;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.keepsafe.switchboard.DeviceUuidFactory;
import com.keepsafe.switchboard.Preferences;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.zip.CRC32;
import org.json.JSONException;
import org.json.JSONObject;

public class SwitchBoard {
    private static final String TAG = "SwitchBoard";
    public static boolean DEBUG = true;
    private static String DYNAMIC_CONFIG_SERVER_URL_UPDATE;
    private static String DYNAMIC_CONFIG_SERVER_DEFAULT_URL;
    public static final String ACTION_CONFIG_FETCHED = ".SwitchBoard.CONFIG_FETCHED";
    private static final String kUpdateServerUrl = "updateServerUrl";
    private static final String kConfigServerUrl = "configServerUrl";
    private static final String IS_EXPERIMENT_ACTIVE = "isActive";
    private static final String EXPERIMENT_VALUES = "values";
    private static String uuidExtra;

    public static void initDefaultServerUrls(String string, String string2, boolean bl) {
        DYNAMIC_CONFIG_SERVER_URL_UPDATE = string;
        DYNAMIC_CONFIG_SERVER_DEFAULT_URL = string2;
        DEBUG = bl;
    }

    public static void setUUIDFromExtra(String string) {
        uuidExtra = string;
    }

    public static void initDefaultServerUrls(String string, String string2, String string3, String string4, boolean bl) {
        if (bl) {
            DYNAMIC_CONFIG_SERVER_URL_UPDATE = string;
            DYNAMIC_CONFIG_SERVER_DEFAULT_URL = string2;
        } else {
            DYNAMIC_CONFIG_SERVER_URL_UPDATE = string3;
            DYNAMIC_CONFIG_SERVER_DEFAULT_URL = string4;
        }
        DEBUG = bl;
    }

    public static void updateConfigServerUrl(Context context) {
        if (DEBUG) {
            Log.d((String)TAG, (String)"start initConfigServerUrl");
        }
        if (DEBUG) {
            Preferences.setDynamicConfigServerUrl(context, DYNAMIC_CONFIG_SERVER_URL_UPDATE, DYNAMIC_CONFIG_SERVER_DEFAULT_URL);
            return;
        }
        String string = Preferences.getDynamicUpdateServerUrl(context);
        if (string == null) {
            string = DYNAMIC_CONFIG_SERVER_URL_UPDATE;
        }
        try {
            String string2 = SwitchBoard.readFromUrlGET(string, "");
            if (DEBUG) {
                Log.d((String)TAG, (String)("Result String: " + string2));
            }
            if (string2 != null) {
                JSONObject jSONObject = new JSONObject(string2);
                Preferences.setDynamicConfigServerUrl(context, (String)jSONObject.get(kUpdateServerUrl), (String)jSONObject.get(kConfigServerUrl));
                if (DEBUG) {
                    Log.d((String)TAG, (String)("Update Server Url: " + (String)jSONObject.get(kUpdateServerUrl)));
                }
                if (DEBUG) {
                    Log.d((String)TAG, (String)("Config Server Url: " + (String)jSONObject.get(kConfigServerUrl)));
                }
            } else {
                SwitchBoard.storeDefaultUrlsInPreferences(context);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"end initConfigServerUrl");
        }
    }

    public static void loadConfig(Context context) {
        SwitchBoard.loadConfig(context, null);
    }

    public static void loadConfig(Context context, String string) {
        Object object;
        try {
            if (string == null) {
                object = new DeviceUuidFactory(context);
                string = ((DeviceUuidFactory)object).getDeviceUuid().toString();
            }
            object = Build.DEVICE;
            String string2 = Build.MANUFACTURER;
            String string3 = "unknown";
            try {
                string3 = Locale.getDefault().getISO3Language();
            }
            catch (MissingResourceException missingResourceException) {
                missingResourceException.printStackTrace();
            }
            String string4 = "unknown";
            try {
                string4 = Locale.getDefault().getISO3Country();
            }
            catch (MissingResourceException missingResourceException) {
                missingResourceException.printStackTrace();
            }
            String string5 = context.getPackageName();
            String string6 = "none";
            try {
                string6 = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
            String string7 = Preferences.getDynamicConfigServerUrl(context);
            if (string7 != null) {
                String string8 = "uuid=" + string + "&device=" + (String)object + "&lang=" + string3 + "&country=" + string4 + "&manufacturer=" + string2 + "&appId=" + string5 + "&version=" + string6;
                if (DEBUG) {
                    Log.d((String)TAG, (String)("Read from server URL: " + string7 + "?" + string8));
                }
                String string9 = SwitchBoard.readFromUrlGET(string7, string8);
                if (DEBUG) {
                    Log.d((String)TAG, (String)string9);
                }
                if (string9 != null) {
                    Preferences.setDynamicConfigJson(context, string9);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        object = new Intent(ACTION_CONFIG_FETCHED);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast((Intent)object);
    }

    public static boolean isInBucket(Context context, int n, int n2) {
        int n3 = SwitchBoard.getUserBucket(context);
        return n3 >= n && n3 < n2;
    }

    public static boolean isInExperiment(Context context, String string) {
        return SwitchBoard.isInExperiment(context, string, false);
    }

    public static boolean isInExperiment(Context context, String string, boolean bl) {
        String string2 = Preferences.getDynamicConfigJson(context);
        if (string2 == null) {
            return false;
        }
        try {
            JSONObject jSONObject = (JSONObject)new JSONObject(string2).get(string);
            if (DEBUG) {
                Log.d((String)TAG, (String)("experiment " + string + " JSON object: " + jSONObject.toString()));
            }
            if (jSONObject == null) {
                return bl;
            }
            boolean bl2 = bl;
            bl2 = jSONObject.getBoolean(IS_EXPERIMENT_ACTIVE);
            return bl2;
        }
        catch (JSONException jSONException) {
            Log.e((String)TAG, (String)("Config: " + string2));
            jSONException.printStackTrace();
            return bl;
        }
    }

    public static List<String> getActiveExperiments(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = Preferences.getDynamicConfigJson(context);
        if (string == null) {
            return arrayList;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                if (!jSONObject2.getBoolean(IS_EXPERIMENT_ACTIVE)) continue;
                arrayList.add(string2);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return arrayList;
    }

    public static boolean hasExperimentValues(Context context, String string) {
        return SwitchBoard.getExperimentValueFromJson(context, string) != null;
    }

    public static JSONObject getExperimentValueFromJson(Context context, String string) {
        String string2 = Preferences.getDynamicConfigJson(context);
        if (string2 == null) {
            return null;
        }
        try {
            JSONObject jSONObject = (JSONObject)new JSONObject(string2).get(string);
            JSONObject jSONObject2 = jSONObject.getJSONObject(EXPERIMENT_VALUES);
            return jSONObject2;
        }
        catch (JSONException jSONException) {
            Log.e((String)TAG, (String)("Config: " + string2));
            jSONException.printStackTrace();
            Log.e((String)TAG, (String)"Could not create JSON object from config string", (Throwable)jSONException);
            return null;
        }
    }

    private static void storeDefaultUrlsInPreferences(Context context) {
        String string = Preferences.getDynamicConfigServerUrl(context);
        String string2 = Preferences.getDynamicUpdateServerUrl(context);
        if (string == null) {
            string = DYNAMIC_CONFIG_SERVER_DEFAULT_URL;
        }
        if (string2 == null) {
            string2 = DYNAMIC_CONFIG_SERVER_URL_UPDATE;
        }
        Preferences.setDynamicConfigServerUrl(context, string2, string);
    }

    private static String readFromUrlGET(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = string + "?" + string2;
        if (DEBUG) {
            Log.d((String)TAG, (String)("readFromUrl(): " + string3));
        }
        try {
            URL uRL = new URL(string3);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setUseCaches(false);
            InputStream inputStream = httpURLConnection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 8192);
            String string4 = "";
            StringBuffer stringBuffer = new StringBuffer();
            while ((string4 = bufferedReader.readLine()) != null) {
                if (DEBUG) {
                    Log.d((String)TAG, (String)string4);
                }
                stringBuffer.append(string4);
            }
            bufferedReader.close();
            if (DEBUG) {
                Log.d((String)TAG, (String)("readFromUrl() result: " + stringBuffer.toString()));
            }
            return stringBuffer.toString();
        }
        catch (ProtocolException protocolException) {
            protocolException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    private static int getUserBucket(Context context) {
        Object object;
        String string = uuidExtra;
        if (string == null) {
            object = new DeviceUuidFactory(context);
            string = ((DeviceUuidFactory)object).getDeviceUuid().toString();
        }
        object = new CRC32();
        object.update(string.getBytes());
        long l = ((CRC32)object).getValue();
        return (int)(l % 100L);
    }

    static {
        uuidExtra = null;
    }
}

