/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.DownloadManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.NfcEvent;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.os.StrictMode;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.NotificationCompat;
import android.support.v4.view.MenuItemCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Base64OutputStream;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import android.widget.ViewFlipper;
import com.keepsafe.switchboard.AsyncConfigLoader;
import com.keepsafe.switchboard.SwitchBoard;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.Vector;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.AccountsHelper;
import org.mozilla.gecko.ActionModeCompat;
import org.mozilla.gecko.ActionModeCompatView;
import org.mozilla.gecko.AdjustConstants;
import org.mozilla.gecko.AndroidGamepadManager;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.DataReportingNotification;
import org.mozilla.gecko.DynamicToolbar;
import org.mozilla.gecko.EditBookmarkDialog;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.FindInPageBar;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoProfileDirectories;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.GuestSession;
import org.mozilla.gecko.LocaleManager;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.MediaCastingBar;
import org.mozilla.gecko.MotionEventInterceptor;
import org.mozilla.gecko.NotificationClient;
import org.mozilla.gecko.OrderedBroadcastHelper;
import org.mozilla.gecko.PrintHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Restrictions;
import org.mozilla.gecko.ScreenshotObserver;
import org.mozilla.gecko.ServiceNotificationClient;
import org.mozilla.gecko.SharedPreferencesHelper;
import org.mozilla.gecko.SnackbarHelper;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.TouchEventInterceptor;
import org.mozilla.gecko.ZoomedView;
import org.mozilla.gecko.adjust.AdjustHelperInterface;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.SuggestedSites;
import org.mozilla.gecko.distribution.Distribution;
import org.mozilla.gecko.dlc.DownloadContentService;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.favicons.decoders.IconDirectoryEntry;
import org.mozilla.gecko.feeds.FeedService;
import org.mozilla.gecko.firstrun.FirstrunAnimationContainer;
import org.mozilla.gecko.gfx.DynamicToolbarAnimator;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.home.BrowserSearch;
import org.mozilla.gecko.home.HomeBanner;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.HomePanelsManager;
import org.mozilla.gecko.javaaddons.JavaAddonManager;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.GeckoMenuItem;
import org.mozilla.gecko.mozglue.ContextUtils;
import org.mozilla.gecko.permissions.Permissions;
import org.mozilla.gecko.preferences.GeckoPreferences;
import org.mozilla.gecko.prompts.Prompt;
import org.mozilla.gecko.prompts.PromptListItem;
import org.mozilla.gecko.reader.ReaderModeUtils;
import org.mozilla.gecko.reader.ReadingListHelper;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.restrictions.RestrictedProfileConfiguration;
import org.mozilla.gecko.search.SearchEngine;
import org.mozilla.gecko.search.SearchEngineManager;
import org.mozilla.gecko.sync.repositories.android.FennecTabsRepository;
import org.mozilla.gecko.tabqueue.TabQueueHelper;
import org.mozilla.gecko.tabqueue.TabQueuePrompt;
import org.mozilla.gecko.tabs.TabHistoryController;
import org.mozilla.gecko.tabs.TabHistoryFragment;
import org.mozilla.gecko.tabs.TabHistoryPage;
import org.mozilla.gecko.tabs.TabsPanel;
import org.mozilla.gecko.telemetry.TelemetryUploadService;
import org.mozilla.gecko.toolbar.AutocompleteHandler;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.toolbar.ToolbarProgressView;
import org.mozilla.gecko.trackingprotection.TrackingProtectionPrompt;
import org.mozilla.gecko.updater.UpdateServiceHelper;
import org.mozilla.gecko.util.ActivityUtils;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.Experiments;
import org.mozilla.gecko.util.FloatUtils;
import org.mozilla.gecko.util.GamepadUtils;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.MenuUtils;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.PrefUtils;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.AnchoredPopup;
import org.mozilla.gecko.widget.GeckoActionProvider;

public class BrowserApp
extends GeckoApp
implements TabsPanel.TabsLayoutChangeListener,
PropertyAnimator.PropertyAnimationListener,
View.OnKeyListener,
LayerView.DynamicToolbarListener,
BrowserSearch.OnSearchListener,
BrowserSearch.OnEditSuggestionListener,
HomePager.OnUrlOpenListener,
HomePager.OnUrlOpenInBackgroundListener,
ReadingListHelper.OnReadingListEventListener,
AnchoredPopup.OnVisibilityChangeListener,
ActionModeCompat.Presenter,
LayoutInflater.Factory {
    private static final String LOGTAG = "GeckoBrowserApp";
    private static final int TABS_ANIMATION_DURATION = 450;
    public static final String GUEST_BROWSING_ARG = "--guest";
    private static final String INTENT_KEY_SWITCHBOARD_UUID = "switchboard-uuid";
    private static final String INTENT_KEY_SWITCHBOARD_HOST = "switchboard-host";
    private static final String DEFAULT_SWITCHBOARD_HOST = "switchboard.services.mozilla.com";
    private static final String STATE_ABOUT_HOME_TOP_PADDING = "abouthome_top_padding";
    private static final String BROWSER_SEARCH_TAG = "browser_search";
    private static final int ACTIVITY_REQUEST_PREFERENCES = 1001;
    private static final int ACTIVITY_REQUEST_TAB_QUEUE = 2001;
    public static final String ACTION_VIEW_MULTIPLE = "org.mozilla.fennec.action.VIEW_MULTIPLE";
    @RobocopTarget
    public static final String EXTRA_SKIP_STARTPANE = "skipstartpane";
    private static final String EOL_NOTIFIED = "eol_notified";
    private BrowserSearch mBrowserSearch;
    private View mBrowserSearchContainer;
    public ViewGroup mBrowserChrome;
    public ViewFlipper mActionBarFlipper;
    public ActionModeCompatView mActionBar;
    private BrowserToolbar mBrowserToolbar;
    private View mDoorhangerOverlay;
    private TabStripInterface mTabStrip;
    private ToolbarProgressView mProgressView;
    private FirstrunAnimationContainer mFirstrunAnimationContainer;
    private HomePager mHomePager;
    private TabsPanel mTabsPanel;
    private ViewGroup mHomePagerContainer;
    private ActionModeCompat mActionMode;
    private TabHistoryController tabHistoryController;
    private ZoomedView mZoomedView;
    private static final int GECKO_TOOLS_MENU = -1;
    private static final int ADDON_MENU_OFFSET = 1000;
    public static final String TAB_HISTORY_FRAGMENT_TAG = "tabHistoryFragment";
    private Vector<MenuItemInfo> mAddonMenuItemsCache;
    private PropertyAnimator mMainLayoutAnimator;
    private static final Interpolator sTabsInterpolator = new Interpolator(){

        public float getInterpolation(float f) {
            return (f -= 1.0f) * f * f * f * f + 1.0f;
        }
    };
    private FindInPageBar mFindInPageBar;
    private MediaCastingBar mMediaCastingBar;
    private static final int FEEDBACK_LAUNCH_COUNT = 15;
    private int mToolbarHeight;
    private SharedPreferencesHelper mSharedPreferencesHelper;
    private OrderedBroadcastHelper mOrderedBroadcastHelper;
    private ReadingListHelper mReadingListHelper;
    private AccountsHelper mAccountsHelper;
    private Integer mTargetTabForEditingMode;
    private final BrowserToolbar.TabEditingState mLastTabEditingState = new BrowserToolbar.TabEditingState();
    private boolean mHideWebContentOnAnimationEnd;
    private final DynamicToolbar mDynamicToolbar = new DynamicToolbar();
    private final ScreenshotObserver mScreenshotObserver = new ScreenshotObserver();
    @NonNull
    private SearchEngineManager searchEngineManager;

    public View onCreateView(String string2, Context context, AttributeSet attributeSet) {
        BrowserToolbar browserToolbar = BrowserToolbar.class.getName().equals(string2) ? BrowserToolbar.create(context, attributeSet) : (TabsPanel.TabsLayout.class.getName().equals(string2) ? TabsPanel.createTabsLayout(context, attributeSet) : super.onCreateView(string2, context, attributeSet));
        return browserToolbar;
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        if (tab == null) {
            if (tabEvents != Tabs.TabEvents.RESTORED) {
                throw new IllegalArgumentException("onTabChanged:" + (Object)((Object)tabEvents) + " must specify a tab.");
            }
            return;
        }
        Log.d((String)LOGTAG, (String)("BrowserApp.onTabChanged: " + tab.getId() + ": " + (Object)((Object)tabEvents)));
        switch (tabEvents) {
            case SELECTED: {
                if (Tabs.getInstance().isSelectedTab(tab) && this.mDynamicToolbar.isEnabled()) {
                    this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
                }
            }
            case LOCATION_CHANGE: {
                if (this.mZoomedView != null) {
                    this.mZoomedView.stopZoomDisplay(false);
                }
                if (Tabs.getInstance().isSelectedTab(tab)) {
                    this.updateHomePagerForTab(tab);
                }
                this.mDynamicToolbar.persistTemporaryVisibility();
                break;
            }
            case START: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.invalidateOptionsMenu();
                if (!this.mDynamicToolbar.isEnabled()) break;
                this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
                break;
            }
            case LOAD_ERROR: 
            case STOP: 
            case MENU_UPDATED: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.invalidateOptionsMenu();
                break;
            }
            case PAGE_SHOW: {
                tab.loadFavicon();
                break;
            }
            case BOOKMARK_ADDED: {
                this.showBookmarkAddedSnackbar();
                break;
            }
            case BOOKMARK_REMOVED: {
                this.showBookmarkRemovedSnackbar();
                break;
            }
            case READING_LIST_ADDED: {
                this.onAddedToReadingList(tab.getURL());
                break;
            }
            case READING_LIST_REMOVED: {
                this.onRemovedFromReadingList(tab.getURL());
                break;
            }
            case UNSELECTED: {
                if (!tab.isEditing()) break;
                tab.getEditingState().copyFrom(this.mLastTabEditingState);
            }
        }
        if (HardwareUtils.isTablet() && tabEvents == Tabs.TabEvents.SELECTED) {
            this.updateEditingModeForTab(tab);
        }
        super.onTabChanged(tab, tabEvents, object);
    }

    private void updateEditingModeForTab(Tab tab) {
        if (!Tabs.getInstance().isSelectedTab(tab)) {
            Log.w((String)LOGTAG, (String)"updateEditingModeForTab: Given tab is expected to be selected tab");
        }
        this.saveTabEditingState(this.mLastTabEditingState);
        if (tab.isEditing()) {
            this.enterEditingMode();
            this.restoreTabEditingState(tab.getEditingState());
        } else {
            this.mBrowserToolbar.cancelEdit();
        }
    }

    private void saveTabEditingState(BrowserToolbar.TabEditingState tabEditingState) {
        this.mBrowserToolbar.saveTabEditingState(tabEditingState);
        tabEditingState.setIsBrowserSearchShown(this.mBrowserSearch.getUserVisibleHint());
    }

    private void restoreTabEditingState(BrowserToolbar.TabEditingState tabEditingState) {
        this.mBrowserToolbar.restoreTabEditingState(tabEditingState);
        if (tabEditingState.isBrowserSearchShown()) {
            this.showBrowserSearch();
        } else {
            this.hideBrowserSearch();
        }
    }

    private void showBookmarkAddedSnackbar() {
        SnackbarHelper.SnackbarCallback snackbarCallback = new SnackbarHelper.SnackbarCallback(){

            public void onClick(View view) {
                Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.TOAST, "bookmark_options");
                BrowserApp.this.showBookmarkDialog();
            }
        };
        SnackbarHelper.showSnackbarWithAction((Activity)this, this.getResources().getString(R.string.bookmark_added), 0, this.getResources().getString(R.string.bookmark_options), snackbarCallback);
    }

    private void showBookmarkRemovedSnackbar() {
        SnackbarHelper.showSnackbar((Activity)this, this.getResources().getString(R.string.bookmark_removed), 0);
    }

    private void showSwitchToReadingListSnackbar(String string2) {
        SnackbarHelper.SnackbarCallback snackbarCallback = new SnackbarHelper.SnackbarCallback(){

            public void onClick(View view) {
                Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.TOAST, "reading_list");
                String string2 = AboutPages.getURLForBuiltinPanelType(HomeConfig.PanelType.READING_LIST);
                Tabs.getInstance().loadUrlInTab(string2);
            }
        };
        SnackbarHelper.showSnackbarWithAction((Activity)this, string2, 0, this.getResources().getString(R.string.switch_button_message), snackbarCallback);
    }

    @Override
    public void onAddedToReadingList(String string2) {
        this.showSwitchToReadingListSnackbar(this.getResources().getString(R.string.reading_list_added));
    }

    @Override
    public void onAlreadyInReadingList(String string2) {
        this.showSwitchToReadingListSnackbar(this.getResources().getString(R.string.reading_list_duplicate));
    }

    @Override
    public void onRemovedFromReadingList(String string2) {
        SnackbarHelper.showSnackbar((Activity)this, this.getResources().getString(R.string.reading_list_removed), 0);
    }

    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        if (AndroidGamepadManager.handleKeyEvent(keyEvent)) {
            return true;
        }
        if (keyEvent.getAction() != 0) {
            return false;
        }
        if ((keyEvent.getSource() & 0x401) == 1025) {
            switch (n) {
                case 100: {
                    if (this.mBrowserChrome.getVisibility() == 0) {
                        if (this.mDynamicToolbar.isEnabled() && !this.isHomePagerVisible()) {
                            this.mDynamicToolbar.setVisible(false, DynamicToolbar.VisibilityTransition.ANIMATE);
                            if (this.mLayerView != null) {
                                this.mLayerView.requestFocus();
                            }
                        } else {
                            this.mBrowserToolbar.requestFocusFromTouch();
                        }
                    } else {
                        this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
                        this.mBrowserToolbar.requestFocusFromTouch();
                    }
                    return true;
                }
                case 102: {
                    Tabs.getInstance().getSelectedTab().doBack();
                    return true;
                }
                case 103: {
                    Tabs.getInstance().getSelectedTab().doForward();
                    return true;
                }
            }
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (AppConstants.Versions.feature11Plus && tab != null && keyEvent.isCtrlPressed()) {
            switch (n) {
                case 71: {
                    tab.doBack();
                    return true;
                }
                case 72: {
                    tab.doForward();
                    return true;
                }
                case 46: {
                    tab.doReload(false);
                    return true;
                }
                case 56: {
                    tab.doStop();
                    return true;
                }
                case 48: {
                    this.addTab();
                    return true;
                }
                case 51: {
                    Tabs.getInstance().closeTab(tab);
                    return true;
                }
                case 34: {
                    this.mFindInPageBar.show();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (!this.mBrowserToolbar.isEditing() && this.onKey(null, n, keyEvent)) {
            return true;
        }
        return super.onKeyDown(n, keyEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (AndroidGamepadManager.handleKeyEvent(keyEvent)) {
            return true;
        }
        return super.onKeyUp(n, keyEvent);
    }

    @Override
    public void onCreate(Bundle bundle) {
        NfcAdapter nfcAdapter;
        if (!HardwareUtils.isSupportedSystem()) {
            super.onCreate(bundle);
            return;
        }
        Intent intent = this.getIntent();
        GeckoProfile geckoProfile = GeckoProfile.get((Context)this);
        if (geckoProfile != null && !geckoProfile.inGuestMode()) {
            GeckoProfile.maybeCleanupGuestProfile((Context)this);
        }
        ((GeckoApplication)this.getApplication()).prepareLightweightTheme();
        super.onCreate(bundle);
        Context context = this.getApplicationContext();
        this.initSwitchboard(intent);
        this.mBrowserChrome = (ViewGroup)this.findViewById(R.id.browser_chrome);
        this.mActionBarFlipper = (ViewFlipper)this.findViewById(R.id.browser_actionbar);
        this.mActionBar = (ActionModeCompatView)this.findViewById(R.id.actionbar);
        this.mBrowserToolbar = (BrowserToolbar)this.findViewById(R.id.browser_toolbar);
        this.mProgressView = (ToolbarProgressView)this.findViewById(R.id.progress);
        this.mBrowserToolbar.setProgressBar(this.mProgressView);
        this.tabHistoryController = new TabHistoryController(new TabHistoryController.OnShowTabHistory(){

            @Override
            public void onShowHistory(final List<TabHistoryPage> list, final int n) {
                BrowserApp.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        TabHistoryFragment tabHistoryFragment = TabHistoryFragment.newInstance(list, n);
                        FragmentManager fragmentManager = BrowserApp.this.getSupportFragmentManager();
                        GeckoAppShell.vibrateOnHapticFeedbackEnabled(BrowserApp.this.getResources().getIntArray(R.array.long_press_vibrate_msec));
                        tabHistoryFragment.show(R.id.tab_history_panel, fragmentManager.beginTransaction(), BrowserApp.TAB_HISTORY_FRAGMENT_TAG);
                    }
                });
            }
        });
        this.mBrowserToolbar.setTabHistoryController(this.tabHistoryController);
        String string2 = intent.getAction();
        if ("android.intent.action.VIEW".equals(string2)) {
            this.mBrowserToolbar.setTitle(intent.getDataString());
            this.showTabQueuePromptIfApplicable(intent);
        } else if ("org.mozilla.gecko.GUEST_SESSION_INPROGRESS".equals(string2)) {
            GuestSession.handleIntent(this, intent);
        } else if ("TAB_QUEUE_LOAD_URLS_ACTION".equals(string2)) {
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.NOTIFICATION, "tabqueue");
        }
        if (HardwareUtils.isTablet()) {
            this.mTabStrip = (TabStripInterface)((ViewStub)this.findViewById(R.id.tablet_tab_strip)).inflate();
        }
        ((GeckoApp.MainLayout)this.mMainLayout).setTouchEventInterceptor(new HideOnTouchListener());
        ((GeckoApp.MainLayout)this.mMainLayout).setMotionEventInterceptor(new MotionEventInterceptor(){

            @Override
            public boolean onInterceptMotionEvent(View view, MotionEvent motionEvent) {
                if (BrowserApp.this.mLayerView != null && !BrowserApp.this.mLayerView.hasFocus() && GamepadUtils.isPanningControl((MotionEvent)motionEvent)) {
                    if (BrowserApp.this.mHomePager == null) {
                        return false;
                    }
                    if (BrowserApp.this.isHomePagerVisible()) {
                        BrowserApp.this.mLayerView.requestFocus();
                    } else {
                        BrowserApp.this.mHomePager.requestFocus();
                    }
                }
                return false;
            }
        });
        this.mHomePagerContainer = (ViewGroup)this.findViewById(R.id.home_pager_container);
        this.mBrowserSearchContainer = this.findViewById(R.id.search_container);
        this.mBrowserSearch = (BrowserSearch)this.getSupportFragmentManager().findFragmentByTag(BROWSER_SEARCH_TAG);
        if (this.mBrowserSearch == null) {
            this.mBrowserSearch = BrowserSearch.newInstance();
            this.mBrowserSearch.setUserVisibleHint(false);
        }
        this.setBrowserToolbarListeners();
        this.mFindInPageBar = (FindInPageBar)this.findViewById(R.id.find_in_page);
        this.mMediaCastingBar = (MediaCastingBar)this.findViewById(R.id.media_casting);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, new String[]{"Gecko:DelayedStartup", "Menu:Open", "Menu:Update", "LightweightTheme:Update", "Search:Keyword", "Prompt:ShowTop"});
        EventDispatcher.getInstance().registerGeckoThreadListener(this, new String[]{"CharEncoding:Data", "CharEncoding:State", "Download:AndroidDownloadManager", "Experiments:GetActive", "Favicon:CacheLoad", "Feedback:MaybeLater", "Menu:Add", "Menu:Remove", "Sanitize:ClearHistory", "Sanitize:ClearSyncedTabs", "Settings:Show", "Telemetry:Gather", "Updater:Launch"});
        Distribution distribution = Distribution.init((Context)this);
        this.searchEngineManager = new SearchEngineManager((Context)this, distribution);
        SuggestedSites suggestedSites = new SuggestedSites(context, distribution);
        BrowserDB browserDB = this.getProfile().getDB();
        browserDB.setSuggestedSites(suggestedSites);
        JavaAddonManager.getInstance().init(context);
        this.mSharedPreferencesHelper = new SharedPreferencesHelper(context);
        this.mOrderedBroadcastHelper = new OrderedBroadcastHelper(context);
        this.mReadingListHelper = new ReadingListHelper(context, this.getProfile(), this);
        this.mAccountsHelper = new AccountsHelper(context, this.getProfile());
        AdjustHelperInterface adjustHelperInterface = AdjustConstants.getAdjustHelper();
        adjustHelperInterface.onCreate((Context)this, AdjustConstants.MOZ_INSTALL_TRACKING_ADJUST_SDK_APP_TOKEN);
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp((Context)this);
        adjustHelperInterface.setEnabled(sharedPreferences.getBoolean(GeckoPreferences.PREFS_HEALTHREPORT_UPLOAD_ENABLED, true));
        if (AppConstants.MOZ_ANDROID_BEAM && (nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this)) != null) {
            nfcAdapter.setNdefPushMessageCallback(new NfcAdapter.CreateNdefMessageCallback(){

                public NdefMessage createNdefMessage(NfcEvent nfcEvent) {
                    Tab tab = Tabs.getInstance().getSelectedTab();
                    if (tab == null || tab.isPrivate()) {
                        return null;
                    }
                    return new NdefMessage(new NdefRecord[]{NdefRecord.createUri((String)tab.getURL())});
                }
            }, (Activity)this, new Activity[0]);
        }
        if (bundle != null) {
            this.mDynamicToolbar.onRestoreInstanceState(bundle);
            this.mHomePagerContainer.setPadding(0, bundle.getInt(STATE_ABOUT_HOME_TOP_PADDING), 0, 0);
        }
        this.mDynamicToolbar.setEnabledChangedListener(new DynamicToolbar.OnEnabledChangedListener(){

            @Override
            public void onEnabledChanged(boolean bl) {
                BrowserApp.this.setDynamicToolbarEnabled(bl);
            }
        });
        this.mScreenshotObserver.setListener(this.getContext(), new ScreenshotObserver.OnScreenshotListener(){

            @Override
            public void onScreenshotTaken(String string2, String string3) {
                Telemetry.sendUIEvent(TelemetryContract.Event.SHARE, TelemetryContract.Method.BUTTON, "screenshot");
                Tab tab = Tabs.getInstance().getSelectedTab();
                if (tab == null) {
                    Log.w((String)BrowserApp.LOGTAG, (String)"Selected tab is null: could not page info to store screenshot.");
                    return;
                }
                BrowserApp.this.getProfile().getDB().getUrlAnnotations().insertScreenshot(BrowserApp.this.getContentResolver(), tab.getURL(), string2);
                SnackbarHelper.showSnackbar((Activity)BrowserApp.this, BrowserApp.this.getResources().getString(R.string.screenshot_added_to_bookmarks), -1);
            }
        });
        IconDirectoryEntry.setMaxBPP(GeckoAppShell.getScreenDepth());
        if (UpdateServiceHelper.isUpdaterEnabled()) {
            Permissions.from((Context)this).withPermissions("android.permission.WRITE_EXTERNAL_STORAGE").doNotPrompt().andFallback(new Runnable(){

                @Override
                public void run() {
                    BrowserApp.this.showUpdaterPermissionSnackbar();
                }
            }).run();
        }
    }

    private void initSwitchboard(Intent intent) {
        String string2;
        String string3;
        if (Experiments.isDisabled(new ContextUtils.SafeIntent(intent))) {
            return;
        }
        String string4 = ContextUtils.getStringExtra((Intent)intent, (String)INTENT_KEY_SWITCHBOARD_HOST);
        String string5 = TextUtils.isEmpty((CharSequence)string4) ? DEFAULT_SWITCHBOARD_HOST : string4;
        try {
            string3 = new URL("https", string5, "urls").toString();
            string2 = new URL("https", string5, "v1").toString();
        }
        catch (MalformedURLException malformedURLException) {
            Log.e((String)LOGTAG, (String)"Error creating Switchboard server URL", (Throwable)malformedURLException);
            return;
        }
        SwitchBoard.initDefaultServerUrls((String)string3, (String)string2, (boolean)true);
        String string6 = ContextUtils.getStringExtra((Intent)intent, (String)INTENT_KEY_SWITCHBOARD_UUID);
        SwitchBoard.setUUIDFromExtra((String)string6);
        new AsyncConfigLoader((Context)this, 1, string6).execute((Object[])new Void[0]);
        new AsyncConfigLoader((Context)this, 2, string6).execute((Object[])new Void[0]);
    }

    private void showUpdaterPermissionSnackbar() {
        SnackbarHelper.SnackbarCallback snackbarCallback = new SnackbarHelper.SnackbarCallback(){

            public void onClick(View view) {
                Permissions.from((Context)BrowserApp.this).withPermissions("android.permission.WRITE_EXTERNAL_STORAGE").run();
            }
        };
        SnackbarHelper.showSnackbarWithAction((Activity)this, this.getString(R.string.updater_permission_text), -2, this.getString(R.string.updater_permission_allow), snackbarCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conditionallyNotifyEOL() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile((Context)this);
            if (!sharedPreferences.contains(EOL_NOTIFIED)) {
                String string2 = this.getString(R.string.eol_notification_url, new Object[]{"48.0a1", "Android", Locales.getLanguageTag((Locale)Locale.getDefault())});
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.BrowserApp");
                intent.setData(Uri.parse((String)string2));
                PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0x8000000);
                Notification notification = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)this.getString(R.string.eol_notification_title)).setContentText((CharSequence)this.getString(R.string.eol_notification_summary)).setSmallIcon(R.drawable.ic_status_logo).setAutoCancel(true).setContentIntent(pendingIntent).build();
                NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
                int n = EOL_NOTIFIED.hashCode();
                notificationManager.notify(n, notification);
                GeckoSharedPrefs.forProfile((Context)this).edit().putBoolean(EOL_NOTIFIED, true).apply();
            }
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFirstrun(Context context, ContextUtils.SafeIntent safeIntent) {
        if (safeIntent.getBooleanExtra(EXTRA_SKIP_STARTPANE, false)) {
            return;
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile((Context)this);
            if (sharedPreferences.getBoolean("startpane_enabled", false)) {
                if (!"android.intent.action.VIEW".equals(safeIntent.getAction())) {
                    this.showFirstrunPager();
                    if (HardwareUtils.isTablet()) {
                        this.mTabStrip.setOnTabChangedListener(new TabStripInterface.OnTabAddedOrRemovedListener(){

                            @Override
                            public void onTabChanged() {
                                BrowserApp.this.hideFirstrunPager(TelemetryContract.Method.BUTTON);
                                BrowserApp.this.mTabStrip.setOnTabChangedListener(null);
                            }
                        });
                    }
                }
                sharedPreferences.edit().putBoolean("startpane_enabled", false).apply();
            }
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private Class<?> getMediaPlayerManager() {
        try {
            return Class.forName("org.mozilla.gecko.MediaPlayerManager");
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"No native casting support", (Throwable)exception);
            return null;
        }
    }

    @Override
    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            super.onBackPressed();
            return;
        }
        if (this.mBrowserToolbar.onBackPressed()) {
            return;
        }
        if (this.mActionMode != null) {
            this.endActionModeCompat();
            return;
        }
        if (this.hideFirstrunPager(TelemetryContract.Method.BACK)) {
            return;
        }
        super.onBackPressed();
    }

    public void onAttachedToWindow() {
        this.mDoorhangerOverlay = this.findViewById(R.id.doorhanger_overlay);
        this.mDoorhangerOverlay.setVisibility(0);
        this.checkFirstrun((Context)this, new ContextUtils.SafeIntent(this.getIntent()));
    }

    @Override
    protected void processTabQueue() {
        if (TabQueueHelper.TAB_QUEUE_ENABLED && this.mInitialized) {
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (TabQueueHelper.shouldOpenTabQueueUrls((Context)BrowserApp.this)) {
                        BrowserApp.this.openQueuedTabs();
                    }
                }
            });
        }
    }

    @Override
    protected void openQueuedTabs() {
        ThreadUtils.assertNotOnUiThread();
        int n = TabQueueHelper.getTabQueueLength((Context)this);
        Telemetry.addToHistogram("FENNEC_TABQUEUE_QUEUESIZE", n);
        Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.INTENT, "tabqueue-delayed");
        TabQueueHelper.openQueuedUrls((Context)this, this.mProfile, "tab_queue_url_list.json", false);
        if (n > 1) {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    BrowserApp.this.showNormalTabs();
                }
            });
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        AdjustConstants.getAdjustHelper().onResume();
        String string2 = ContextUtils.getStringExtra((Intent)this.getIntent(), (String)"args");
        boolean bl = GuestSession.shouldUse((Context)this, string2);
        boolean bl2 = GeckoProfile.get((Context)this).inGuestMode();
        if (bl != bl2) {
            this.doRestart(this.getIntent());
            return;
        }
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, new String[]{"Prompt:ShowTop"});
        this.processTabQueue();
        this.mScreenshotObserver.start();
    }

    @Override
    public void onPause() {
        super.onPause();
        AdjustConstants.getAdjustHelper().onPause();
        EventDispatcher.getInstance().registerGeckoThreadListener(this, new String[]{"Prompt:ShowTop"});
        this.mScreenshotObserver.stop();
    }

    public void onStart() {
        super.onStart();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoProfile geckoProfile = BrowserApp.this.getProfile();
                if (geckoProfile.inGuestMode()) {
                    GuestSession.showNotification((Context)BrowserApp.this);
                } else {
                    GuestSession.hideNotification((Context)BrowserApp.this);
                }
            }
        });
        this.searchEngineManager.getEngine(new UploadTelemetryCallback(this));
    }

    public void onStop() {
        super.onStop();
        GuestSession.hideNotification((Context)this);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.mBrowserToolbar.onParentFocus();
        }
    }

    private void setBrowserToolbarListeners() {
        this.mBrowserToolbar.setOnActivateListener(new BrowserToolbar.OnActivateListener(){

            @Override
            public void onActivate() {
                BrowserApp.this.enterEditingMode();
            }
        });
        this.mBrowserToolbar.setOnCommitListener(new BrowserToolbar.OnCommitListener(){

            @Override
            public void onCommit() {
                BrowserApp.this.commitEditingMode();
            }
        });
        this.mBrowserToolbar.setOnDismissListener(new BrowserToolbar.OnDismissListener(){

            @Override
            public void onDismiss() {
                BrowserApp.this.mBrowserToolbar.cancelEdit();
            }
        });
        this.mBrowserToolbar.setOnFilterListener(new BrowserToolbar.OnFilterListener(){

            @Override
            public void onFilter(String string2, AutocompleteHandler autocompleteHandler) {
                BrowserApp.this.filterEditingMode(string2, autocompleteHandler);
            }
        });
        this.mBrowserToolbar.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl) {
                if (BrowserApp.this.isHomePagerVisible()) {
                    BrowserApp.this.mHomePager.onToolbarFocusChange(bl);
                }
            }
        });
        this.mBrowserToolbar.setOnStartEditingListener(new BrowserToolbar.OnStartEditingListener(){

            @Override
            public void onStartEditing() {
                Tab tab = Tabs.getInstance().getSelectedTab();
                if (tab != null) {
                    tab.setIsEditing(true);
                }
                if (BrowserApp.this.mDoorHangerPopup != null) {
                    BrowserApp.this.mDoorHangerPopup.disable();
                }
            }
        });
        this.mBrowserToolbar.setOnStopEditingListener(new BrowserToolbar.OnStopEditingListener(){

            @Override
            public void onStopEditing() {
                Tab tab = Tabs.getInstance().getSelectedTab();
                if (tab != null) {
                    tab.setIsEditing(false);
                }
                BrowserApp.this.selectTargetTabForEditingMode();
                BrowserApp.this.hideBrowserSearch();
                BrowserApp.this.hideHomePager();
                if (BrowserApp.this.mDoorHangerPopup != null) {
                    BrowserApp.this.mDoorHangerPopup.enable();
                }
            }
        });
        this.mBrowserToolbar.setOnKeyListener(this);
    }

    private void showBookmarkDialog() {
        final Resources resources = this.getResources();
        final Tab tab = Tabs.getInstance().getSelectedTab();
        Prompt prompt = new Prompt((Context)this, new Prompt.PromptCallback(){

            @Override
            public void onPromptFinished(String string2) {
                int n = -1;
                try {
                    n = new JSONObject(string2).getInt("button");
                }
                catch (JSONException jSONException) {
                    Log.e((String)BrowserApp.LOGTAG, (String)"Exception reading bookmark prompt result", (Throwable)jSONException);
                }
                if (tab == null) {
                    return;
                }
                if (n == 0) {
                    String string3 = resources.getResourceEntryName(R.string.contextmenu_edit_bookmark);
                    Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.DIALOG, string3);
                    new EditBookmarkDialog((Context)BrowserApp.this).show(tab.getURL());
                } else if (n == 1) {
                    String string4 = resources.getResourceEntryName(R.string.contextmenu_add_to_launcher);
                    Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.DIALOG, string4);
                    final String string5 = tab.getURL();
                    final String string6 = tab.getDisplayTitle();
                    if (string5 != null && string6 != null) {
                        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                GeckoAppShell.createShortcut(string6, string5);
                            }
                        });
                    }
                }
            }
        });
        PromptListItem[] promptListItemArray = new PromptListItem[]{new PromptListItem(resources.getString(R.string.contextmenu_edit_bookmark)), new PromptListItem(resources.getString(R.string.contextmenu_add_to_launcher))};
        prompt.show("", "", promptListItemArray, 0);
    }

    private void setDynamicToolbarEnabled(boolean bl) {
        ThreadUtils.assertOnUiThread();
        if (bl) {
            if (this.mLayerView != null) {
                this.mLayerView.getDynamicToolbarAnimator().addTranslationListener(this);
            }
            this.setToolbarMargin(0);
            this.mHomePagerContainer.setPadding(0, this.mBrowserChrome.getHeight(), 0, 0);
        } else {
            if (this.mLayerView != null) {
                this.mLayerView.getDynamicToolbarAnimator().removeTranslationListener(this);
            }
            this.mHomePagerContainer.setPadding(0, 0, 0, 0);
            if (this.mBrowserChrome != null) {
                ViewHelper.setTranslationY((View)this.mBrowserChrome, 0.0f);
            }
            if (this.mLayerView != null) {
                this.mLayerView.setSurfaceTranslation(0.0f);
            }
        }
        this.refreshToolbarHeight();
    }

    private static boolean isAboutHome(Tab tab) {
        return AboutPages.isAboutHome(tab.getURL());
    }

    public boolean onSearchRequested() {
        this.enterEditingMode();
        return true;
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        int n = menuItem.getItemId();
        if (n == R.id.pasteandgo) {
            this.hideFirstrunPager(TelemetryContract.Method.CONTEXT_MENU);
            String string2 = Clipboard.getText();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                this.loadUrlOrKeywordSearch(string2);
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.CONTEXT_MENU);
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.CONTEXT_MENU, "pasteandgo");
            }
            return true;
        }
        if (n == R.id.paste) {
            String string3 = Clipboard.getText();
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                this.enterEditingMode(string3);
                this.showBrowserSearch();
                this.mBrowserSearch.filter(string3, null);
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.CONTEXT_MENU, "paste");
            }
            return true;
        }
        if (n == R.id.subscribe) {
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null && tab.hasFeeds()) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("tabId", tab.getId());
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOGTAG, (String)"error building json arguments", (Throwable)jSONException);
                }
                GeckoAppShell.notifyObservers("Feeds:Subscribe", jSONObject.toString());
            }
            return true;
        }
        if (n == R.id.add_search_engine) {
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null && tab.hasOpenSearch()) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("tabId", tab.getId());
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOGTAG, (String)"error building json arguments", (Throwable)jSONException);
                    return true;
                }
                GeckoAppShell.notifyObservers("SearchEngines:Add", jSONObject.toString());
            }
            return true;
        }
        if (n == R.id.copyurl) {
            String string4;
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null && (string4 = ReaderModeUtils.stripAboutReaderUrl(tab.getURL())) != null) {
                Clipboard.setText((CharSequence)string4);
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.CONTEXT_MENU, "copyurl");
            }
            return true;
        }
        if (n == R.id.add_to_launcher) {
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab == null) {
                return true;
            }
            final String string5 = tab.getURL();
            final String string6 = tab.getDisplayTitle();
            if (string5 == null || string6 == null) {
                return true;
            }
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GeckoAppShell.createShortcut(string6, string5);
                }
            });
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.CONTEXT_MENU, this.getResources().getResourceEntryName(n));
            return true;
        }
        return false;
    }

    @Override
    public void setAccessibilityEnabled(boolean bl) {
        this.mDynamicToolbar.setAccessibilityEnabled(bl);
    }

    @Override
    public void onDestroy() {
        NfcAdapter nfcAdapter;
        if (!HardwareUtils.isSupportedSystem()) {
            super.onDestroy();
            return;
        }
        this.mDynamicToolbar.destroy();
        if (this.mBrowserToolbar != null) {
            this.mBrowserToolbar.onDestroy();
        }
        if (this.mFindInPageBar != null) {
            this.mFindInPageBar.onDestroy();
            this.mFindInPageBar = null;
        }
        if (this.mMediaCastingBar != null) {
            this.mMediaCastingBar.onDestroy();
            this.mMediaCastingBar = null;
        }
        if (this.mSharedPreferencesHelper != null) {
            this.mSharedPreferencesHelper.uninit();
            this.mSharedPreferencesHelper = null;
        }
        if (this.mOrderedBroadcastHelper != null) {
            this.mOrderedBroadcastHelper.uninit();
            this.mOrderedBroadcastHelper = null;
        }
        if (this.mReadingListHelper != null) {
            this.mReadingListHelper.uninit();
            this.mReadingListHelper = null;
        }
        if (this.mAccountsHelper != null) {
            this.mAccountsHelper.uninit();
            this.mAccountsHelper = null;
        }
        if (this.mZoomedView != null) {
            this.mZoomedView.destroy();
        }
        this.searchEngineManager.unregisterListeners();
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, new String[]{"Gecko:DelayedStartup", "Menu:Open", "Menu:Update", "LightweightTheme:Update", "Search:Keyword", "Prompt:ShowTop"});
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, new String[]{"CharEncoding:Data", "CharEncoding:State", "Download:AndroidDownloadManager", "Experiments:GetActive", "Favicon:CacheLoad", "Feedback:MaybeLater", "Menu:Add", "Menu:Remove", "Sanitize:ClearHistory", "Sanitize:ClearSyncedTabs", "Settings:Show", "Telemetry:Gather", "Updater:Launch"});
        if (AppConstants.MOZ_ANDROID_BEAM && (nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this)) != null) {
            nfcAdapter.setNdefPushMessageCallback(null, (Activity)this, new Activity[0]);
        }
        super.onDestroy();
    }

    @Override
    protected void initializeChrome() {
        super.initializeChrome();
        this.mDoorHangerPopup.setAnchor(this.mBrowserToolbar.getDoorHangerAnchor());
        this.mDoorHangerPopup.setOnVisibilityChangeListener(this);
        this.mDynamicToolbar.setLayerView(this.mLayerView);
        this.setDynamicToolbarEnabled(this.mDynamicToolbar.isEnabled());
        this.mLayerView.setOnKeyListener(this);
        if (HardwareUtils.isTablet()) {
            this.onCreatePanelMenu(0, null);
            this.invalidateOptionsMenu();
        }
    }

    @Override
    public void onDoorHangerShow() {
        this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.mDoorhangerOverlay, (String)"alpha", (float[])new float[]{1.0f});
        objectAnimator.setDuration(250L);
        objectAnimator.start();
    }

    @Override
    public void onDoorHangerHide() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.mDoorhangerOverlay, (String)"alpha", (float[])new float[]{0.0f});
        objectAnimator.setDuration(200L);
        objectAnimator.start();
    }

    private void handleClearHistory(final boolean bl) {
        final BrowserDB browserDB = this.getProfile().getDB();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                browserDB.clearHistory(BrowserApp.this.getContentResolver(), bl);
            }
        });
    }

    private void handleClearSyncedTabs() {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FennecTabsRepository.deleteNonLocalClientsAndTabs((Context)BrowserApp.this.getContext());
            }
        });
    }

    private void setToolbarMargin(int n) {
        ((RelativeLayout.LayoutParams)this.mGeckoLayout.getLayoutParams()).topMargin = n;
        this.mGeckoLayout.requestLayout();
    }

    @Override
    public void onTranslationChanged(float f, float f2) {
        if (this.mBrowserChrome == null) {
            return;
        }
        ViewGroup viewGroup = this.mBrowserChrome;
        ToolbarProgressView toolbarProgressView = this.mProgressView;
        ViewHelper.setTranslationY((View)viewGroup, -f);
        this.mLayerView.setSurfaceTranslation((float)this.mToolbarHeight - f2);
        float f3 = this.getResources().getDimensionPixelOffset(R.dimen.progress_bar_scroll_offset);
        float f4 = Math.min(f, (float)this.mToolbarHeight - f3);
        ViewHelper.setTranslationY((View)toolbarProgressView, -f4);
        if (this.mFormAssistPopup != null) {
            this.mFormAssistPopup.onTranslationChanged();
        }
    }

    @Override
    public void onMetricsChanged(ImmutableViewportMetrics immutableViewportMetrics) {
        if (this.isHomePagerVisible() || this.mBrowserChrome == null) {
            return;
        }
        if (this.mFormAssistPopup != null) {
            this.mFormAssistPopup.onMetricsChanged(immutableViewportMetrics);
        }
    }

    @Override
    public void onPanZoomStopped() {
        if (!this.mDynamicToolbar.isEnabled() || this.isHomePagerVisible() || this.mBrowserChrome.getVisibility() != 0) {
            return;
        }
        ImmutableViewportMetrics immutableViewportMetrics = this.mLayerView.getViewportMetrics();
        float f = this.mLayerView.getDynamicToolbarAnimator().getToolbarTranslation();
        boolean bl = immutableViewportMetrics.getPageHeight() < immutableViewportMetrics.getHeight();
        boolean bl2 = FloatUtils.fuzzyEquals((float)immutableViewportMetrics.pageRectBottom, (float)immutableViewportMetrics.viewportRectBottom()) && immutableViewportMetrics.pageRectBottom > 2.0f * immutableViewportMetrics.getHeight();
        Log.v((String)LOGTAG, (String)("On pan/zoom stopped, short page: " + bl + "; atBottomOfLongPage: " + bl2));
        if (bl || bl2) {
            this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
        }
    }

    public void refreshToolbarHeight() {
        ThreadUtils.assertOnUiThread();
        int n = 0;
        if (this.mBrowserChrome != null) {
            n = this.mBrowserChrome.getHeight();
        }
        if (!this.mDynamicToolbar.isEnabled() || this.isHomePagerVisible()) {
            if (this.mDynamicToolbar.isEnabled()) {
                this.mHomePagerContainer.setPadding(0, n, 0, 0);
            } else {
                this.setToolbarMargin(n);
                n = 0;
            }
        } else {
            this.setToolbarMargin(0);
        }
        if (this.mLayerView != null && n != this.mToolbarHeight) {
            this.mToolbarHeight = n;
            this.mLayerView.setMaxTranslation(n);
            this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.IMMEDIATE);
        }
    }

    @Override
    void toggleChrome(final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    BrowserApp.this.mBrowserChrome.setVisibility(0);
                } else {
                    BrowserApp.this.mBrowserChrome.setVisibility(8);
                }
            }
        });
        super.toggleChrome(bl);
    }

    @Override
    void focusChrome() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                BrowserApp.this.mBrowserChrome.setVisibility(0);
                BrowserApp.this.mActionBarFlipper.requestFocusFromTouch();
            }
        });
    }

    @Override
    public void refreshChrome() {
        this.invalidateOptionsMenu();
        if (this.mTabsPanel != null) {
            this.mTabsPanel.refresh();
        }
        if (this.mTabStrip != null) {
            this.mTabStrip.refresh();
        }
        this.mBrowserToolbar.refresh();
    }

    @Override
    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        if ("CharEncoding:Data".equals(string2)) {
            NativeJSObject[] nativeJSObjectArray = nativeJSObject.getObjectArray("charsets");
            int n = nativeJSObject.getInt("selected");
            CharSequence[] charSequenceArray = new String[nativeJSObjectArray.length];
            final String[] stringArray = new String[nativeJSObjectArray.length];
            for (int i = 0; i < nativeJSObjectArray.length; ++i) {
                NativeJSObject nativeJSObject2 = nativeJSObjectArray[i];
                charSequenceArray[i] = nativeJSObject2.getString("title");
                stringArray[i] = nativeJSObject2.getString("code");
            }
            final AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setSingleChoiceItems(charSequenceArray, n, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    GeckoAppShell.notifyObservers("CharEncoding:Set", stringArray[n]);
                    dialogInterface.dismiss();
                }
            });
            builder.setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    dialogInterface.dismiss();
                }
            });
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    builder.show();
                }
            });
        } else if ("CharEncoding:State".equals(string2)) {
            final boolean bl = nativeJSObject.getString("visible").equals("true");
            GeckoPreferences.setCharEncodingState(bl);
            final Menu menu2 = this.mMenu;
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (menu2 != null) {
                        menu2.findItem(R.id.char_encoding).setVisible(bl);
                    }
                }
            });
        } else if ("Experiments:GetActive".equals(string2)) {
            List list = SwitchBoard.getActiveExperiments((Context)this);
            JSONArray jSONArray = new JSONArray((Collection)list);
            eventCallback.sendSuccess((Object)jSONArray.toString());
        } else if ("Favicon:CacheLoad".equals(string2)) {
            String string3 = nativeJSObject.getString("url");
            this.getFaviconFromCache(eventCallback, string3);
        } else if ("Feedback:MaybeLater".equals(string2)) {
            this.resetFeedbackLaunchCount();
        } else if ("Menu:Add".equals(string2)) {
            MenuItemInfo menuItemInfo = new MenuItemInfo();
            menuItemInfo.label = nativeJSObject.getString("name");
            menuItemInfo.id = nativeJSObject.getInt("id") + 1000;
            menuItemInfo.checked = nativeJSObject.optBoolean("checked", false);
            menuItemInfo.enabled = nativeJSObject.optBoolean("enabled", true);
            menuItemInfo.visible = nativeJSObject.optBoolean("visible", true);
            menuItemInfo.checkable = nativeJSObject.optBoolean("checkable", false);
            int n = nativeJSObject.optInt("parent", 0);
            menuItemInfo.parent = n <= 0 ? n : n + 1000;
            final MenuItemInfo menuItemInfo2 = menuItemInfo;
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    BrowserApp.this.addAddonMenuItem(menuItemInfo2);
                }
            });
        } else if ("Menu:Remove".equals(string2)) {
            final int n = nativeJSObject.getInt("id") + 1000;
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    BrowserApp.this.removeAddonMenuItem(n);
                }
            });
        } else if ("Sanitize:ClearHistory".equals(string2)) {
            this.handleClearHistory(nativeJSObject.optBoolean("clearSearchHistory", false));
            eventCallback.sendSuccess((Object)true);
        } else if ("Sanitize:ClearSyncedTabs".equals(string2)) {
            this.handleClearSyncedTabs();
            eventCallback.sendSuccess((Object)true);
        } else if ("Settings:Show".equals(string2)) {
            String string4 = nativeJSObject.optString("resource", null);
            Intent intent = new Intent((Context)this, GeckoPreferences.class);
            GeckoPreferences.setResourceToOpen(intent, string4);
            this.startActivityForResult(intent, 1001);
            if (HardwareUtils.IS_KINDLE_DEVICE) {
                this.overridePendingTransition(0, 0);
            }
        } else if ("Telemetry:Gather".equals(string2)) {
            BrowserDB browserDB = this.getProfile().getDB();
            ContentResolver contentResolver = this.getContentResolver();
            Telemetry.addToHistogram("PLACES_PAGES_COUNT", browserDB.getCount(contentResolver, "history"));
            Telemetry.addToHistogram("FENNEC_BOOKMARKS_COUNT", browserDB.getCount(contentResolver, "bookmarks"));
            Telemetry.addToHistogram("FENNEC_READING_LIST_COUNT", browserDB.getReadingListAccessor().getCount(contentResolver));
            Telemetry.addToHistogram("BROWSER_IS_USER_DEFAULT", this.isDefaultBrowser("android.intent.action.VIEW") ? 1 : 0);
            Telemetry.addToHistogram("FENNEC_TABQUEUE_ENABLED", TabQueueHelper.isTabQueueEnabled((Context)this) ? 1 : 0);
            Telemetry.addToHistogram("FENNEC_CUSTOM_HOMEPAGE", TextUtils.isEmpty((CharSequence)this.getHomepage()) ? 0 : 1);
            SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile(this.getContext());
            boolean bl = sharedPreferences.contains("home_panels_with_version") || sharedPreferences.contains("home_panels");
            Telemetry.addToHistogram("FENNEC_HOMEPANELS_CUSTOM", bl ? 1 : 0);
            if (AppConstants.Versions.feature16Plus) {
                Telemetry.addToHistogram("BROWSER_IS_ASSIST_DEFAULT", this.isDefaultBrowser("android.intent.action.ASSIST") ? 1 : 0);
            }
            if (Restrictions.isRestrictedProfile((Context)this)) {
                for (Restrictable restrictable : RestrictedProfileConfiguration.getVisibleRestrictions()) {
                    int n = Restrictions.isAllowed((Context)this, restrictable) ? 1 : 0;
                    Telemetry.addToKeyedHistogram("FENNEC_RESTRICTED_PROFILE_RESTRICTIONS", restrictable.name(), n);
                }
            }
        } else if ("Updater:Launch".equals(string2)) {
            this.handleUpdaterLaunch();
        } else if ("Download:AndroidDownloadManager".equals(string2)) {
            String string5 = nativeJSObject.getString("uri");
            String string6 = nativeJSObject.getString("filename");
            String string7 = nativeJSObject.getString("mimeType");
            DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string5));
            request.setMimeType(string7);
            try {
                request.setDestinationInExternalFilesDir((Context)this, Environment.DIRECTORY_DOWNLOADS, string6);
            }
            catch (IllegalStateException illegalStateException) {
                Log.e((String)LOGTAG, (String)"Cannot create download directory");
                return;
            }
            request.allowScanningByMediaScanner();
            request.setNotificationVisibility(1);
            request.addRequestHeader("User-Agent", HardwareUtils.isTablet() ? AppConstants.USER_AGENT_FENNEC_TABLET : AppConstants.USER_AGENT_FENNEC_MOBILE);
            try {
                DownloadManager downloadManager = (DownloadManager)this.getSystemService("download");
                downloadManager.enqueue(request);
                Log.d((String)LOGTAG, (String)"Enqueued download (Download Manager)");
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)LOGTAG, (String)("Download failed: " + runtimeException));
            }
        } else {
            super.handleMessage(string2, nativeJSObject, eventCallback);
        }
    }

    private void getFaviconFromCache(final EventCallback eventCallback, String string2) {
        OnFaviconLoadedListener onFaviconLoadedListener = new OnFaviconLoadedListener(){

            @Override
            public void onFaviconLoaded(String string2, String string3, final Bitmap bitmap) {
                ThreadUtils.assertOnUiThread();
                ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ByteArrayOutputStream byteArrayOutputStream = null;
                        Base64OutputStream base64OutputStream = null;
                        if (bitmap == null) {
                            eventCallback.sendError((Object)"Failed to get favicon from cache");
                        } else {
                            try {
                                byteArrayOutputStream = new ByteArrayOutputStream();
                                byteArrayOutputStream.write("data:image/png;base64,".getBytes());
                                base64OutputStream = new Base64OutputStream((OutputStream)byteArrayOutputStream, 2);
                                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)base64OutputStream);
                                eventCallback.sendSuccess((Object)new String(byteArrayOutputStream.toByteArray()));
                            }
                            catch (IOException iOException) {
                                Log.w((String)BrowserApp.LOGTAG, (String)"Failed to convert to base64 data URI");
                                eventCallback.sendError((Object)"Failed to convert favicon to a base64 data URI");
                            }
                            finally {
                                try {
                                    if (byteArrayOutputStream != null) {
                                        byteArrayOutputStream.close();
                                    }
                                    if (base64OutputStream != null) {
                                        base64OutputStream.close();
                                    }
                                }
                                catch (IOException iOException) {
                                    Log.w((String)BrowserApp.LOGTAG, (String)"Failed to close the streams");
                                }
                            }
                        }
                    }
                });
            }
        };
        Favicons.getSizedFaviconForPageFromLocal(this.getContext(), string2, onFaviconLoadedListener);
    }

    private boolean isDefaultBrowser(String string2) {
        Intent intent = new Intent(string2, Uri.parse((String)"http://www.mozilla.org"));
        ResolveInfo resolveInfo = this.getPackageManager().resolveActivity(intent, 65536);
        if (resolveInfo == null) {
            return false;
        }
        String string3 = resolveInfo.activityInfo.packageName;
        return TextUtils.equals((CharSequence)string3, (CharSequence)this.getPackageName());
    }

    @Override
    public void handleMessage(String string2, JSONObject jSONObject) {
        block20: {
            try {
                if (string2.equals("Menu:Open")) {
                    if (this.mBrowserToolbar.isEditing()) {
                        this.mBrowserToolbar.cancelEdit();
                    }
                    this.openOptionsMenu();
                    break block20;
                }
                if (string2.equals("Menu:Update")) {
                    final int n = jSONObject.getInt("id") + 1000;
                    final JSONObject jSONObject2 = jSONObject.getJSONObject("options");
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BrowserApp.this.updateAddonMenuItem(n, jSONObject2);
                        }
                    });
                    break block20;
                }
                if (string2.equals("Gecko:DelayedStartup")) {
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BrowserApp.this.ensureTabsPanelExists();
                            if (BrowserApp.this.mZoomedView == null) {
                                ViewStub viewStub = (ViewStub)BrowserApp.this.findViewById(R.id.zoomed_view_stub);
                                BrowserApp.this.mZoomedView = (ZoomedView)viewStub.inflate();
                            }
                        }
                    });
                    Class<?> clazz = this.getMediaPlayerManager();
                    if (clazz != null) {
                        try {
                            clazz.getDeclaredField("MEDIA_PLAYER_TAG").get("");
                            Log.i((String)LOGTAG, (String)"Found tag ");
                            Fragment fragment = this.getSupportFragmentManager().findFragmentByTag("");
                            if (fragment == null) {
                                Method method = clazz.getMethod("newInstance", null);
                                Fragment fragment2 = (Fragment)method.invoke(null, new Object[0]);
                                this.getSupportFragmentManager().beginTransaction().disallowAddToBackStack().add(fragment2, "").commit();
                            }
                        }
                        catch (Exception exception) {
                            Log.e((String)LOGTAG, (String)"Error initializing media manager", (Throwable)exception);
                        }
                    }
                    if (Restrictions.isAllowed((Context)this, Restrictable.DATA_CHOICES)) {
                        ThreadUtils.getBackgroundHandler().postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                GeckoPreferences.broadcastStumblerPref((Context)BrowserApp.this);
                            }
                        }, 1000L);
                    }
                    DownloadContentService.startSync((Context)this);
                    DownloadContentService.startVerification((Context)this);
                    FeedService.setup((Context)this);
                    super.handleMessage(string2, jSONObject);
                    break block20;
                }
                if (string2.equals("Gecko:Ready")) {
                    super.handleMessage(string2, jSONObject);
                    final Menu menu2 = this.mMenu;
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (menu2 != null) {
                                menu2.findItem(R.id.settings).setEnabled(true);
                                menu2.findItem(R.id.help).setEnabled(true);
                            }
                        }
                    });
                    if (Restrictions.isAllowed((Context)this, Restrictable.DATA_CHOICES)) {
                        DataReportingNotification.checkAndNotifyPolicy(GeckoAppShell.getContext());
                    }
                } else if (string2.equals("Search:Keyword")) {
                    this.storeSearchQuery(jSONObject.getString("query"));
                } else if (string2.equals("LightweightTheme:Update")) {
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BrowserApp.this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
                        }
                    });
                } else if (string2.equals("Prompt:ShowTop")) {
                    Intent intent = new Intent();
                    intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.BrowserApp");
                    intent.setFlags(131072);
                    this.startActivity(intent);
                } else {
                    super.handleMessage(string2, jSONObject);
                }
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
            }
        }
    }

    @Override
    public void addTab() {
        Tabs.getInstance().addTab();
    }

    @Override
    public void addPrivateTab() {
        Tabs.getInstance().addPrivateTab();
    }

    public void showTrackingProtectionPromptIfApplicable() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        boolean bl = sharedPreferences.getBoolean("android.not_a_preference.trackingProtectionPromptShown", false);
        if (bl) {
            return;
        }
        sharedPreferences.edit().putBoolean("android.not_a_preference.trackingProtectionPromptShown", true).apply();
        this.startActivity(new Intent((Context)this, TrackingProtectionPrompt.class));
    }

    @Override
    public void showNormalTabs() {
        this.showTabs(TabsPanel.Panel.NORMAL_TABS);
    }

    @Override
    public void showPrivateTabs() {
        this.showTabs(TabsPanel.Panel.PRIVATE_TABS);
    }

    private boolean ensureTabsPanelExists() {
        if (this.mTabsPanel != null) {
            return false;
        }
        ViewStub viewStub = (ViewStub)this.findViewById(R.id.tabs_panel);
        this.mTabsPanel = (TabsPanel)viewStub.inflate();
        this.mTabsPanel.setTabsLayoutChangeListener(this);
        return true;
    }

    private void showTabs(final TabsPanel.Panel panel) {
        if (Tabs.getInstance().getDisplayCount() == 0) {
            return;
        }
        this.hideFirstrunPager(TelemetryContract.Method.BUTTON);
        if (this.ensureTabsPanelExists()) {
            ViewTreeObserver viewTreeObserver = this.mTabsPanel.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        BrowserApp.this.mTabsPanel.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        BrowserApp.this.showTabs(panel);
                    }
                });
            }
        } else {
            if (this.mDoorHangerPopup != null) {
                this.mDoorHangerPopup.disable();
            }
            this.mTabsPanel.show(panel);
            this.mFindInPageBar.hide();
        }
    }

    @Override
    public void hideTabs() {
        this.mTabsPanel.hide();
        if (this.mDoorHangerPopup != null) {
            this.mDoorHangerPopup.enable();
        }
    }

    @Override
    public boolean autoHideTabs() {
        if (this.areTabsShown()) {
            this.hideTabs();
            return true;
        }
        return false;
    }

    @Override
    public boolean areTabsShown() {
        return this.mTabsPanel != null && this.mTabsPanel.isShown();
    }

    @Override
    public String getHomepage() {
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile(this.getContext());
        return sharedPreferences.getString("android.not_a_preference.homepage", null);
    }

    @Override
    public void onTabsLayoutChange(int n, int n2) {
        int n3 = 450;
        if (this.mMainLayoutAnimator != null) {
            n3 = Math.max(1, n3 - (int)this.mMainLayoutAnimator.getRemainingTime());
            this.mMainLayoutAnimator.stop(false);
        }
        if (this.areTabsShown()) {
            this.mTabsPanel.setDescendantFocusability(262144);
            if (AppConstants.Versions.feature16Plus) {
                this.mLayerView.setImportantForAccessibility(2);
            }
        } else if (AppConstants.Versions.feature16Plus) {
            this.mLayerView.setImportantForAccessibility(1);
        }
        this.mMainLayoutAnimator = new PropertyAnimator(n3, sTabsInterpolator);
        this.mMainLayoutAnimator.addPropertyAnimationListener(this);
        this.mMainLayoutAnimator.attach((View)this.mMainLayout, PropertyAnimator.Property.SCROLL_Y, -n2);
        this.mTabsPanel.prepareTabsAnimation(this.mMainLayoutAnimator);
        this.mBrowserToolbar.triggerTabsPanelTransition(this.mMainLayoutAnimator, this.areTabsShown());
        if (this.mDynamicToolbar.isEnabled()) {
            if (n > 0 && n2 > 0) {
                this.mDynamicToolbar.setPinned(true, DynamicToolbarAnimator.PinReason.RELAYOUT);
                this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
            } else {
                this.mDynamicToolbar.setPinned(false, DynamicToolbarAnimator.PinReason.RELAYOUT);
            }
        }
        this.mMainLayoutAnimator.start();
    }

    @Override
    public void onPropertyAnimationStart() {
    }

    @Override
    public void onPropertyAnimationEnd() {
        if (!this.areTabsShown()) {
            this.mTabsPanel.setVisibility(4);
            this.mTabsPanel.setDescendantFocusability(393216);
        } else {
            this.mBrowserToolbar.cancelEdit();
        }
        this.mTabsPanel.finishTabsAnimation();
        this.mMainLayoutAnimator = null;
    }

    @Override
    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        this.mDynamicToolbar.onSaveInstanceState(bundle);
        bundle.putInt(STATE_ABOUT_HOME_TOP_PADDING, this.mHomePagerContainer.getPaddingTop());
    }

    private boolean maybeSwitchToTab(String string2, EnumSet<HomePager.OnUrlOpenListener.Flags> enumSet) {
        if (!enumSet.contains((Object)HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB)) {
            return false;
        }
        Tabs tabs = Tabs.getInstance();
        Tab tab = AboutPages.isAboutReader(string2) ? tabs.getFirstReaderTabForUrl(string2, tabs.getSelectedTab().isPrivate()) : tabs.getFirstTabForUrl(string2, tabs.getSelectedTab().isPrivate());
        if (tab == null) {
            return false;
        }
        return this.maybeSwitchToTab(tab.getId());
    }

    private boolean maybeSwitchToTab(int n) {
        Tabs tabs = Tabs.getInstance();
        Tab tab = tabs.getTab(n);
        if (tab == null) {
            return false;
        }
        Tab tab2 = tabs.getSelectedTab();
        if (tab2 != null) {
            tab2.setIsEditing(false);
        }
        this.mTargetTabForEditingMode = null;
        tabs.selectTab(tab.getId());
        this.mBrowserToolbar.cancelEdit();
        return true;
    }

    private void openUrlAndStopEditing(String string2) {
        this.openUrlAndStopEditing(string2, null, false);
    }

    private void openUrlAndStopEditing(String string2, boolean bl) {
        this.openUrlAndStopEditing(string2, null, bl);
    }

    private void openUrlAndStopEditing(String string2, String string3) {
        this.openUrlAndStopEditing(string2, string3, false);
    }

    private void openUrlAndStopEditing(String string2, String string3, boolean bl) {
        int n = 0;
        if (bl) {
            n |= 1;
            if (Tabs.getInstance().getSelectedTab().isPrivate()) {
                n |= 4;
            }
        }
        Tabs.getInstance().loadUrl(string2, string3, -1, n);
        this.mBrowserToolbar.cancelEdit();
    }

    private boolean isHomePagerVisible() {
        return this.mHomePager != null && this.mHomePager.isVisible() && this.mHomePagerContainer != null && this.mHomePagerContainer.getVisibility() == 0;
    }

    private boolean isFirstrunVisible() {
        return this.mFirstrunAnimationContainer != null && this.mFirstrunAnimationContainer.isVisible() && this.mHomePagerContainer != null && this.mHomePagerContainer.getVisibility() == 0;
    }

    private void enterEditingMode() {
        String string2 = "";
        String string3 = "urlbar-empty";
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            String string4 = tab.getUserRequested();
            String string5 = tab.getURL();
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                string2 = string4;
                string3 = "urlbar-userentered";
            } else if (!TextUtils.isEmpty((CharSequence)string5)) {
                string2 = string5;
                string3 = "urlbar-url";
            }
        }
        this.enterEditingMode(string2);
        Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.ACTIONBAR, string3);
    }

    private void enterEditingMode(@NonNull String string2) {
        boolean bl;
        String string3;
        this.hideFirstrunPager(TelemetryContract.Method.ACTIONBAR);
        if (this.mBrowserToolbar.isEditing() || this.mBrowserToolbar.isAnimating()) {
            return;
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            this.mTargetTabForEditingMode = tab.getId();
            string3 = tab.getMostRecentHomePanel();
        } else {
            this.mTargetTabForEditingMode = null;
            string3 = null;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        propertyAnimator.setUseHardwareLayer(false);
        this.mBrowserToolbar.startEditing(string2, propertyAnimator);
        boolean bl2 = bl = tab != null && !TextUtils.isEmpty((CharSequence)tab.getUserRequested());
        if (bl && SwitchBoard.isInExperiment((Context)this.getContext(), (String)"search-term")) {
            this.showBrowserSearchAfterAnimation(propertyAnimator);
        } else {
            this.showHomePagerWithAnimator(string3, propertyAnimator);
        }
        propertyAnimator.start();
        Telemetry.startUISession(TelemetryContract.Session.AWESOMESCREEN);
    }

    private void commitEditingMode() {
        if (!this.mBrowserToolbar.isEditing()) {
            return;
        }
        Telemetry.stopUISession(TelemetryContract.Session.AWESOMESCREEN, TelemetryContract.Reason.COMMIT);
        String string2 = this.mBrowserToolbar.commitEdit();
        this.hideHomePager(string2);
        this.loadUrlOrKeywordSearch(string2);
        this.clearSelectedTabApplicationId();
    }

    private void clearSelectedTabApplicationId() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            tab.setApplicationId(null);
        }
    }

    private void loadUrlOrKeywordSearch(final String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        if (!StringUtils.isSearchQuery((String)string2, (boolean)true)) {
            Tabs.getInstance().loadUrl(string2, 2);
            Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.ACTIONBAR, "user");
            return;
        }
        final BrowserDB browserDB = this.getProfile().getDB();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string22;
                String string3;
                int n = string2.indexOf(" ");
                if (n == -1) {
                    string3 = string2;
                    string22 = "";
                } else {
                    string3 = string2.substring(0, n);
                    string22 = string2.substring(n + 1);
                }
                String string4 = browserDB.getUrlForKeyword(BrowserApp.this.getContentResolver(), string3);
                if (TextUtils.isEmpty((CharSequence)string4)) {
                    Tabs.getInstance().loadUrl(string2, 2);
                    Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.ACTIONBAR, "user");
                    return;
                }
                BrowserApp.recordSearch(null, "barkeyword");
                String string5 = string4.replace("%s", URLEncoder.encode(string22)).replace("%S", string22);
                Tabs.getInstance().loadUrl(string5, 2);
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.ACTIONBAR, "keyword");
            }
        });
    }

    private static void recordSearch(org.mozilla.gecko.home.SearchEngine searchEngine, String string2) {
    }

    private void storeSearchQuery(final String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        if (string2.length() > 50 || Pattern.matches("^(https?|ftp|file)://.*", string2)) {
            return;
        }
        GeckoProfile geckoProfile = this.getProfile();
        if (geckoProfile.inGuestMode()) {
            return;
        }
        final BrowserDB browserDB = geckoProfile.getDB();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                browserDB.getSearches().insert(BrowserApp.this.getContentResolver(), string2);
            }
        });
    }

    void filterEditingMode(String string2, AutocompleteHandler autocompleteHandler) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.hideBrowserSearch();
        } else {
            this.showBrowserSearch();
            this.mBrowserSearch.filter(string2, autocompleteHandler);
        }
    }

    private void selectTargetTabForEditingMode() {
        if (HardwareUtils.isTablet()) {
            return;
        }
        if (this.mTargetTabForEditingMode != null) {
            Tabs.getInstance().selectTab(this.mTargetTabForEditingMode);
        }
        this.mTargetTabForEditingMode = null;
    }

    private void updateHomePagerForTab(Tab tab) {
        if (this.mBrowserToolbar.isEditing()) {
            return;
        }
        if (BrowserApp.isAboutHome(tab)) {
            String string2 = AboutPages.getPanelIdFromAboutHomeUrl(tab.getURL());
            if (string2 == null) {
                string2 = tab.getMostRecentHomePanel();
            }
            this.showHomePager(string2);
            if (this.mDynamicToolbar.isEnabled()) {
                this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
            }
        } else {
            this.hideHomePager();
        }
    }

    @Override
    public void onLocaleReady(String string2) {
        Log.d((String)LOGTAG, (String)("onLocaleReady: " + string2));
        super.onLocaleReady(string2);
        HomePanelsManager.getInstance().onLocaleReady(string2);
        if (this.mMenu != null) {
            this.mMenu.clear();
            this.onCreateOptionsMenu(this.mMenu);
        }
        if (!AppConstants.Versions.feature14Plus) {
            this.conditionallyNotifyEOL();
        }
    }

    @Override
    public void onActivityResult(int n, int n2, Intent intent) {
        Log.d((String)LOGTAG, (String)("onActivityResult: " + n + ", " + n2 + ", " + intent));
        switch (n) {
            case 1001: {
                if (n2 != 7) {
                    Log.d((String)LOGTAG, (String)"No locale change returning from preferences; nothing to do.");
                    return;
                }
                ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LocaleManager localeManager = BrowserLocaleManager.getInstance();
                        Locale locale = localeManager.getCurrentLocale(BrowserApp.this.getApplicationContext());
                        Log.d((String)BrowserApp.LOGTAG, (String)("Read persisted locale " + locale));
                        if (locale == null) {
                            return;
                        }
                        BrowserApp.this.onLocaleChanged(Locales.getLanguageTag((Locale)locale));
                    }
                });
                break;
            }
            case 2001: {
                TabQueueHelper.processTabQueuePromptResponse(n2, (Context)this);
                break;
            }
            default: {
                super.onActivityResult(n, n2, intent);
            }
        }
    }

    private void showFirstrunPager() {
        if (this.mFirstrunAnimationContainer == null) {
            ViewStub viewStub = (ViewStub)this.findViewById(R.id.firstrun_pager_stub);
            this.mFirstrunAnimationContainer = (FirstrunAnimationContainer)viewStub.inflate();
            this.mFirstrunAnimationContainer.load(this.getApplicationContext(), this.getSupportFragmentManager());
            this.mFirstrunAnimationContainer.registerOnFinishListener(new FirstrunAnimationContainer.OnFinishListener(){

                @Override
                public void onFinish() {
                    if (BrowserApp.this.mFirstrunAnimationContainer.showBrowserHint()) {
                        BrowserApp.this.enterEditingMode();
                    }
                }
            });
        }
        this.mHomePagerContainer.setVisibility(0);
    }

    private void showHomePager(String string2) {
        this.showHomePagerWithAnimator(string2, null);
    }

    private void showHomePagerWithAnimator(String string2, PropertyAnimator propertyAnimator) {
        if (this.isHomePagerVisible()) {
            this.mHomePager.showPanel(string2);
            return;
        }
        this.mFormAssistPopup.hide();
        this.mFindInPageBar.hide();
        this.refreshToolbarHeight();
        if (this.mDynamicToolbar.isEnabled()) {
            this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.IMMEDIATE);
        }
        if (this.mHomePager == null) {
            ViewStub viewStub = (ViewStub)this.findViewById(R.id.home_pager_stub);
            this.mHomePager = (HomePager)viewStub.inflate();
            this.mHomePager.setOnPanelChangeListener(new HomePager.OnPanelChangeListener(){

                @Override
                public void onPanelSelected(String string2) {
                    Tab tab = Tabs.getInstance().getSelectedTab();
                    if (tab != null) {
                        tab.setMostRecentHomePanel(string2);
                    }
                }
            });
            if (!Restrictions.isUserRestricted()) {
                ViewStub viewStub2 = (ViewStub)this.findViewById(R.id.home_banner_stub);
                final HomeBanner homeBanner = (HomeBanner)viewStub2.inflate();
                this.mHomePager.setBanner(homeBanner);
                homeBanner.setOnDismissListener(new HomeBanner.OnDismissListener(){

                    @Override
                    public void onDismiss() {
                        BrowserApp.this.mHomePager.setBanner(null);
                        BrowserApp.this.mHomePagerContainer.removeView((View)homeBanner);
                    }
                });
            }
        }
        this.mHomePagerContainer.setVisibility(0);
        this.mHomePager.load(this.getSupportLoaderManager(), this.getSupportFragmentManager(), string2, propertyAnimator);
        this.hideWebContentOnPropertyAnimationEnd(propertyAnimator);
    }

    private void hideWebContentOnPropertyAnimationEnd(PropertyAnimator propertyAnimator) {
        if (propertyAnimator == null) {
            this.hideWebContent();
            return;
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
                BrowserApp.this.mHideWebContentOnAnimationEnd = true;
            }

            @Override
            public void onPropertyAnimationEnd() {
                if (BrowserApp.this.mHideWebContentOnAnimationEnd) {
                    BrowserApp.this.hideWebContent();
                }
            }
        });
    }

    private void hideWebContent() {
        this.mLayerView.setVisibility(4);
    }

    private boolean hideFirstrunPager(TelemetryContract.Method method) {
        if (!this.isFirstrunVisible()) {
            return false;
        }
        Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, method, "firstrun-pane");
        this.mFirstrunAnimationContainer.registerOnFinishListener(null);
        this.mFirstrunAnimationContainer.hide();
        return true;
    }

    private void hideHomePager() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        String string2 = tab != null ? tab.getURL() : null;
        this.hideHomePager(string2);
    }

    private void hideHomePager(String string2) {
        if (!this.isHomePagerVisible() || AboutPages.isAboutHome(string2)) {
            return;
        }
        this.mHideWebContentOnAnimationEnd = false;
        this.mLayerView.setVisibility(0);
        this.mHomePagerContainer.setVisibility(8);
        if (this.mHomePager != null) {
            this.mHomePager.unload();
        }
        this.mBrowserToolbar.setNextFocusDownId(R.id.layer_view);
        this.refreshToolbarHeight();
    }

    private void showBrowserSearchAfterAnimation(PropertyAnimator propertyAnimator) {
        if (propertyAnimator == null) {
            this.showBrowserSearch();
            return;
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
            }

            @Override
            public void onPropertyAnimationEnd() {
                BrowserApp.this.showBrowserSearch();
            }
        });
    }

    private void showBrowserSearch() {
        if (this.mBrowserSearch.getUserVisibleHint()) {
            return;
        }
        this.mBrowserSearchContainer.setVisibility(0);
        this.hideWebContent();
        this.mHomePagerContainer.setVisibility(4);
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        fragmentManager.executePendingTransactions();
        Fragment fragment = fragmentManager.findFragmentById(R.id.search_container);
        if (fragment != null) {
            fragmentManager.beginTransaction().show(fragment).commitAllowingStateLoss();
            this.mBrowserSearch.resetScrollState();
        } else {
            fragmentManager.beginTransaction().add(R.id.search_container, (Fragment)this.mBrowserSearch, BROWSER_SEARCH_TAG).commitAllowingStateLoss();
        }
        this.mBrowserSearch.setUserVisibleHint(true);
        this.getActivity().getWindow().setBackgroundDrawableResource(17170443);
    }

    private void hideBrowserSearch() {
        if (!this.mBrowserSearch.getUserVisibleHint()) {
            return;
        }
        this.showHomePager(Tabs.getInstance().getSelectedTab().getMostRecentHomePanel());
        this.mBrowserSearchContainer.setVisibility(4);
        this.getSupportFragmentManager().beginTransaction().hide((Fragment)this.mBrowserSearch).commitAllowingStateLoss();
        this.mBrowserSearch.setUserVisibleHint(false);
        this.getWindow().setBackgroundDrawable(null);
    }

    private static Menu findParentMenu(Menu menu2, MenuItem menuItem) {
        int n = menuItem.getItemId();
        int n2 = menu2 != null ? menu2.size() : 0;
        for (int i = 0; i < n2; ++i) {
            Menu menu3;
            MenuItem menuItem2 = menu2.getItem(i);
            if (menuItem2.getItemId() == n) {
                return menu2;
            }
            if (!menuItem2.hasSubMenu() || (menu3 = BrowserApp.findParentMenu((Menu)menuItem2.getSubMenu(), menuItem)) == null) continue;
            return menu3;
        }
        return null;
    }

    private void addAddonMenuItemToMenu(Menu menu2, final MenuItemInfo menuItemInfo) {
        MenuItem menuItem;
        Object object;
        menuItemInfo.added = true;
        if (menuItemInfo.parent == 0) {
            object = menu2;
        } else if (menuItemInfo.parent == -1) {
            object = AppConstants.Versions.feature11Plus ? ((menuItem = menu2.findItem(R.id.tools)) != null ? menuItem.getSubMenu() : menu2) : menu2;
        } else {
            menuItem = menu2.findItem(menuItemInfo.parent);
            if (menuItem == null) {
                return;
            }
            Menu menu3 = BrowserApp.findParentMenu(menu2, menuItem);
            if (!menuItem.hasSubMenu()) {
                menu3.removeItem(menuItem.getItemId());
                object = menu3.addSubMenu(0, menuItem.getItemId(), 0, menuItem.getTitle());
                if (menuItem.getIcon() != null) {
                    ((SubMenu)object).getItem().setIcon(menuItem.getIcon());
                }
            } else {
                object = menuItem.getSubMenu();
            }
        }
        menuItem = object.add(0, menuItemInfo.id, 0, (CharSequence)menuItemInfo.label);
        menuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                GeckoAppShell.notifyObservers("Menu:Clicked", Integer.toString(menuItemInfo.id - 1000));
                return true;
            }
        });
        menuItem.setCheckable(menuItemInfo.checkable);
        menuItem.setChecked(menuItemInfo.checked);
        menuItem.setEnabled(menuItemInfo.enabled);
        menuItem.setVisible(menuItemInfo.visible);
    }

    private void addAddonMenuItem(MenuItemInfo menuItemInfo) {
        if (this.mAddonMenuItemsCache == null) {
            this.mAddonMenuItemsCache = new Vector();
        }
        menuItemInfo.added = this.mMenu != null;
        this.mAddonMenuItemsCache.add(menuItemInfo);
        if (this.mMenu == null) {
            return;
        }
        this.addAddonMenuItemToMenu(this.mMenu, menuItemInfo);
    }

    private void removeAddonMenuItem(int n) {
        if (this.mAddonMenuItemsCache != null && !this.mAddonMenuItemsCache.isEmpty()) {
            for (MenuItemInfo menuItemInfo : this.mAddonMenuItemsCache) {
                if (menuItemInfo.id != n) continue;
                this.mAddonMenuItemsCache.remove(menuItemInfo);
                break;
            }
        }
        if (this.mMenu == null) {
            return;
        }
        MenuItem menuItem = this.mMenu.findItem(n);
        if (menuItem != null) {
            this.mMenu.removeItem(n);
        }
    }

    private void updateAddonMenuItem(int n, JSONObject jSONObject) {
        if (this.mAddonMenuItemsCache != null && !this.mAddonMenuItemsCache.isEmpty()) {
            for (MenuItemInfo menuItemInfo : this.mAddonMenuItemsCache) {
                if (menuItemInfo.id != n) continue;
                menuItemInfo.label = jSONObject.optString("name", menuItemInfo.label);
                menuItemInfo.checkable = jSONObject.optBoolean("checkable", menuItemInfo.checkable);
                menuItemInfo.checked = jSONObject.optBoolean("checked", menuItemInfo.checked);
                menuItemInfo.enabled = jSONObject.optBoolean("enabled", menuItemInfo.enabled);
                menuItemInfo.visible = jSONObject.optBoolean("visible", menuItemInfo.visible);
                menuItemInfo.added = this.mMenu != null;
                break;
            }
        }
        if (this.mMenu == null) {
            return;
        }
        MenuItem menuItem = this.mMenu.findItem(n);
        if (menuItem != null) {
            menuItem.setTitle((CharSequence)jSONObject.optString("name", menuItem.getTitle().toString()));
            menuItem.setCheckable(jSONObject.optBoolean("checkable", menuItem.isCheckable()));
            menuItem.setChecked(jSONObject.optBoolean("checked", menuItem.isChecked()));
            menuItem.setEnabled(jSONObject.optBoolean("enabled", menuItem.isEnabled()));
            menuItem.setVisible(jSONObject.optBoolean("visible", menuItem.isVisible()));
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        super.onCreateOptionsMenu(menu2);
        if (menu2 instanceof GeckoMenu && HardwareUtils.isTablet()) {
            ((GeckoMenu)menu2).setActionItemBarPresenter(this.mBrowserToolbar);
        }
        MenuInflater menuInflater = this.getMenuInflater();
        menuInflater.inflate(R.menu.browser_app_menu, this.mMenu);
        if (this.mAddonMenuItemsCache != null && !this.mAddonMenuItemsCache.isEmpty()) {
            for (MenuItemInfo object : this.mAddonMenuItemsCache) {
                this.addAddonMenuItemToMenu(this.mMenu, object);
            }
        }
        if (AppConstants.Versions.feature14Plus) {
            GeckoMenuItem geckoMenuItem = (GeckoMenuItem)this.mMenu.findItem(R.id.share);
            GeckoMenuItem geckoMenuItem2 = (GeckoMenuItem)this.mMenu.findItem(R.id.quickshare);
            GeckoActionProvider geckoActionProvider = GeckoActionProvider.getForType("text/plain", (Context)this);
            geckoMenuItem.setActionProvider(geckoActionProvider);
            geckoMenuItem2.setActionProvider(geckoActionProvider);
        }
        return true;
    }

    public void openOptionsMenu() {
        this.hideFirstrunPager(TelemetryContract.Method.MENU);
        if (this.mBrowserToolbar.isEditing() && !HardwareUtils.isTablet()) {
            return;
        }
        if (ActivityUtils.isFullScreen((Activity)this)) {
            return;
        }
        if (this.areTabsShown()) {
            this.mTabsPanel.showMenu();
            return;
        }
        if (this.mMenuPanel != null) {
            this.mMenuPanel.scrollTo(0, 0);
        }
        if (this.mMenu instanceof GeckoMenu) {
            ((GeckoMenu)this.mMenu).setSelection(0);
        }
        if (!this.mBrowserToolbar.openOptionsMenu()) {
            super.openOptionsMenu();
        }
        if (this.mDynamicToolbar.isEnabled()) {
            this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
        }
    }

    public void closeOptionsMenu() {
        if (!this.mBrowserToolbar.closeOptionsMenu()) {
            super.closeOptionsMenu();
        }
    }

    @Override
    public void setFullScreen(final boolean bl) {
        super.setFullScreen(bl);
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    if (BrowserApp.this.mDynamicToolbar.isEnabled()) {
                        BrowserApp.this.mDynamicToolbar.setVisible(false, DynamicToolbar.VisibilityTransition.IMMEDIATE);
                        BrowserApp.this.mDynamicToolbar.setPinned(true, DynamicToolbarAnimator.PinReason.FULL_SCREEN);
                    } else {
                        BrowserApp.this.setToolbarMargin(0);
                    }
                    BrowserApp.this.mBrowserChrome.setVisibility(8);
                } else {
                    BrowserApp.this.mBrowserChrome.setVisibility(0);
                    if (BrowserApp.this.mDynamicToolbar.isEnabled()) {
                        BrowserApp.this.mDynamicToolbar.setPinned(false, DynamicToolbarAnimator.PinReason.FULL_SCREEN);
                        BrowserApp.this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.IMMEDIATE);
                    } else {
                        BrowserApp.this.setToolbarMargin(BrowserApp.this.mBrowserChrome.getHeight());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onPrepareOptionsMenu(Menu menu2) {
        BitmapDrawable bitmapDrawable;
        String string2;
        String string3;
        View view;
        if (menu2 == null) {
            return false;
        }
        TabHistoryFragment tabHistoryFragment = (TabHistoryFragment)this.getSupportFragmentManager().findFragmentByTag(TAB_HISTORY_FRAGMENT_TAG);
        if (tabHistoryFragment != null) {
            tabHistoryFragment.dismiss();
        }
        if (!GeckoThread.isRunning()) {
            menu2.findItem(R.id.settings).setEnabled(false);
            menu2.findItem(R.id.help).setEnabled(false);
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        MenuItem menuItem = menu2.findItem(R.id.bookmark);
        MenuItem menuItem2 = menu2.findItem(R.id.reading_list);
        MenuItem menuItem3 = menu2.findItem(R.id.back);
        MenuItem menuItem4 = menu2.findItem(R.id.forward);
        MenuItem menuItem5 = menu2.findItem(R.id.share);
        MenuItem menuItem6 = menu2.findItem(R.id.quickshare);
        MenuItem menuItem7 = menu2.findItem(R.id.bookmarks_list);
        MenuItem menuItem8 = menu2.findItem(R.id.history_list);
        MenuItem menuItem9 = menu2.findItem(R.id.save_as_pdf);
        MenuItem menuItem10 = menu2.findItem(R.id.print);
        MenuItem menuItem11 = menu2.findItem(R.id.char_encoding);
        MenuItem menuItem12 = menu2.findItem(R.id.find_in_page);
        MenuItem menuItem13 = menu2.findItem(R.id.desktop_mode);
        MenuItem menuItem14 = menu2.findItem(R.id.new_guest_session);
        MenuItem menuItem15 = menu2.findItem(R.id.exit_guest_session);
        boolean bl = AppConstants.Versions.preICS || HardwareUtils.isTelevision() || !PrefUtils.getStringSet((SharedPreferences)GeckoSharedPrefs.forProfile((Context)this), (String)"android.not_a_preference.history.clear_on_exit", new HashSet()).isEmpty();
        menu2.findItem(R.id.quit).setVisible(bl);
        if (tab == null || tab.getURL() == null) {
            menuItem.setEnabled(false);
            menuItem2.setEnabled(false);
            menuItem3.setEnabled(false);
            menuItem4.setEnabled(false);
            menuItem5.setEnabled(false);
            menuItem6.setEnabled(false);
            menuItem9.setEnabled(false);
            menuItem10.setEnabled(false);
            menuItem12.setEnabled(false);
            if (AppConstants.Versions.feature11Plus) {
                MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.page, (boolean)false);
            }
            MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.subscribe, (boolean)false);
            MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.add_search_engine, (boolean)false);
            MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.add_to_launcher, (boolean)false);
            return true;
        }
        boolean bl2 = GeckoProfile.get((Context)this).inGuestMode();
        boolean bl3 = AboutPages.isAboutReader(tab.getURL());
        menuItem.setEnabled(!bl3);
        menuItem.setVisible(!bl2);
        menuItem.setCheckable(true);
        menuItem.setChecked(tab.isBookmark());
        menuItem.setTitle(this.resolveBookmarkTitleID(tab.isBookmark()));
        menuItem2.setEnabled(bl3 || !AboutPages.isAboutPage(tab.getURL()));
        menuItem2.setVisible(!bl2);
        menuItem2.setCheckable(true);
        boolean bl4 = tab.isInReadingList();
        menuItem2.setChecked(bl4);
        menuItem2.setTitle(this.resolveReadingListTitleID(bl4));
        if (AppConstants.Versions.feature11Plus) {
            menuItem.setIcon(this.resolveBookmarkIconID(tab.isBookmark()));
            menuItem2.setIcon(this.resolveReadingListIconID(bl4));
        }
        menuItem3.setEnabled(tab.canDoBack());
        menuItem4.setEnabled(tab.canDoForward());
        menuItem13.setChecked(tab.getDesktopMode());
        View view2 = MenuItemCompat.getActionView((MenuItem)menuItem3);
        if (view2 != null) {
            view2.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View view) {
                    Tab tab = Tabs.getInstance().getSelectedTab();
                    if (tab != null) {
                        BrowserApp.this.closeOptionsMenu();
                        return BrowserApp.this.tabHistoryController.showTabHistory(tab, TabHistoryController.HistoryAction.BACK);
                    }
                    return false;
                }
            });
        }
        if ((view = MenuItemCompat.getActionView((MenuItem)menuItem4)) != null) {
            view.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View view) {
                    Tab tab = Tabs.getInstance().getSelectedTab();
                    if (tab != null) {
                        BrowserApp.this.closeOptionsMenu();
                        return BrowserApp.this.tabHistoryController.showTabHistory(tab, TabHistoryController.HistoryAction.FORWARD);
                    }
                    return false;
                }
            });
        }
        if (AboutPages.isAboutReader(string3 = tab.getURL()) && (string2 = ReaderModeUtils.getUrlFromAboutReader(string3)) != null) {
            string3 = string2;
        }
        boolean bl5 = Restrictions.isAllowed((Context)this, Restrictable.SHARE);
        menuItem5.setVisible(bl5);
        boolean bl6 = StringUtils.isShareableUrl((String)string3) && bl5;
        menuItem5.setEnabled(bl6);
        MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.downloads, (boolean)Restrictions.isAllowed((Context)this, Restrictable.DOWNLOAD));
        if (AppConstants.Versions.feature11Plus) {
            MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.page, (!BrowserApp.isAboutHome(tab) ? 1 : 0) != 0);
        }
        MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.subscribe, (boolean)tab.hasFeeds());
        MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.add_search_engine, (boolean)tab.hasOpenSearch());
        MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.add_to_launcher, (!BrowserApp.isAboutHome(tab) ? 1 : 0) != 0);
        if (AppConstants.Versions.feature14Plus) {
            menuItem6.setVisible(bl5);
            menuItem6.setEnabled(bl6);
            GeckoActionProvider geckoActionProvider = ((GeckoMenuItem)menuItem5).getGeckoActionProvider();
            if (geckoActionProvider != null) {
                Intent intent = geckoActionProvider.getIntent();
                if (intent == null) {
                    intent = new Intent("android.intent.action.SEND");
                    intent.setType("text/plain");
                    geckoActionProvider.setIntent(intent);
                }
                intent.putExtra("android.intent.extra.TEXT", string3);
                intent.putExtra("android.intent.extra.SUBJECT", tab.getDisplayTitle());
                intent.putExtra("android.intent.extra.TITLE", tab.getDisplayTitle());
                intent.putExtra("org.mozilla.fennec.intent.extra.DEVICES_ONLY", true);
                intent.removeExtra("share_screenshot_uri");
                bitmapDrawable = tab.getThumbnail();
                if (bitmapDrawable != null) {
                    File file;
                    Bitmap bitmap = bitmapDrawable.getBitmap();
                    if (Build.MANUFACTURER.equals("Kobo") && bitmap != null && (file = this.getExternalCacheDir()) != null) {
                        File file2 = new File(file, "thumbnail.png");
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(file2);
                            try {
                                bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)fileOutputStream);
                            }
                            finally {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            Log.e((String)LOGTAG, (String)"File not found", (Throwable)fileNotFoundException);
                        }
                        intent.putExtra("share_screenshot_uri", (Parcelable)Uri.parse((String)file2.getPath()));
                    }
                }
            }
        }
        boolean bl7 = Restrictions.isAllowed((Context)this, Restrictable.PRIVATE_BROWSING);
        MenuUtils.safeSetVisible((Menu)menu2, (int)R.id.new_private_tab, (boolean)bl7);
        boolean bl8 = !BrowserApp.isAboutHome(tab) && !tab.getContentType().equals("application/vnd.mozilla.xul+xml") && !tab.getContentType().startsWith("video/");
        menuItem9.setEnabled(bl8);
        menuItem10.setEnabled(bl8);
        menuItem10.setVisible(AppConstants.Versions.feature19Plus);
        menuItem12.setEnabled(!BrowserApp.isAboutHome(tab));
        menuItem11.setVisible(GeckoPreferences.getCharEncodingState());
        if (this.mProfile.inGuestMode()) {
            menuItem15.setVisible(true);
        } else {
            menuItem14.setVisible(true);
        }
        if (!Restrictions.isAllowed((Context)this, Restrictable.GUEST_BROWSING)) {
            MenuUtils.safeSetVisible((Menu)menu2, (int)R.id.new_guest_session, (boolean)false);
        }
        if (!Restrictions.isAllowed((Context)this, Restrictable.INSTALL_EXTENSION)) {
            MenuUtils.safeSetVisible((Menu)menu2, (int)R.id.addons, (boolean)false);
        }
        if (!SwitchBoard.isInExperiment((Context)this, (String)"bookmark-history-menu")) {
            menuItem7.setVisible(false);
            menuItem8.setVisible(false);
        } else {
            bitmapDrawable = GeckoSharedPrefs.forProfile(this.getContext());
            menuItem7.setVisible(bitmapDrawable.getBoolean("bookmarksPanelEnabled", true));
            menuItem8.setVisible(bitmapDrawable.getBoolean("historyPanelEnabled", true));
        }
        return true;
    }

    private int resolveBookmarkIconID(boolean bl) {
        if (bl) {
            return R.drawable.star_blue;
        }
        return R.drawable.ic_menu_bookmark_add;
    }

    private int resolveBookmarkTitleID(boolean bl) {
        return bl ? R.string.bookmark_remove : R.string.bookmark;
    }

    private int resolveReadingListIconID(boolean bl) {
        return bl ? R.drawable.ic_menu_reader_remove : R.drawable.ic_menu_reader_add;
    }

    private int resolveReadingListTitleID(boolean bl) {
        return bl ? R.string.reading_list_remove : R.string.overlay_share_reading_list_btn_label;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        Tab tab = null;
        Intent intent = null;
        int n = menuItem.getItemId();
        String string2 = this.getResources().getResourceEntryName(n);
        if (TextUtils.equals((CharSequence)string2, (CharSequence)"new_private_tab")) {
            string2 = "new_tab";
        }
        Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.MENU, string2);
        this.mBrowserToolbar.cancelEdit();
        if (n == R.id.bookmark) {
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                if (menuItem.isChecked()) {
                    Telemetry.sendUIEvent(TelemetryContract.Event.UNSAVE, TelemetryContract.Method.MENU, "bookmark");
                    tab.removeBookmark();
                    menuItem.setTitle(this.resolveBookmarkTitleID(false));
                    if (AppConstants.Versions.feature11Plus) {
                        menuItem.setIcon(this.resolveBookmarkIconID(false));
                    }
                } else {
                    Telemetry.sendUIEvent(TelemetryContract.Event.SAVE, TelemetryContract.Method.MENU, "bookmark");
                    tab.addBookmark();
                    menuItem.setTitle(this.resolveBookmarkTitleID(true));
                    if (AppConstants.Versions.feature11Plus) {
                        menuItem.setIcon(this.resolveBookmarkIconID(true));
                    }
                }
            }
            return true;
        }
        if (n == R.id.reading_list) {
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                if (menuItem.isChecked()) {
                    Telemetry.sendUIEvent(TelemetryContract.Event.UNSAVE, TelemetryContract.Method.MENU, "reading_list");
                    tab.removeFromReadingList();
                    menuItem.setTitle(this.resolveReadingListTitleID(false));
                    if (AppConstants.Versions.feature11Plus) {
                        menuItem.setIcon(this.resolveReadingListIconID(false));
                    }
                } else {
                    Telemetry.sendUIEvent(TelemetryContract.Event.SAVE, TelemetryContract.Method.MENU, "reading_list");
                    tab.addToReadingList();
                    menuItem.setTitle(this.resolveReadingListTitleID(true));
                    if (AppConstants.Versions.feature11Plus) {
                        menuItem.setIcon(this.resolveReadingListIconID(true));
                    }
                }
            }
            return true;
        }
        if (n == R.id.share) {
            String string3;
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null && (string3 = tab.getURL()) != null) {
                if (AboutPages.isAboutReader(string3)) {
                    string3 = ReaderModeUtils.getUrlFromAboutReader(string3);
                }
                Telemetry.sendUIEvent(TelemetryContract.Event.SHARE, TelemetryContract.Method.LIST, "menu");
                GeckoAppShell.openUriExternal(string3, "text/plain", "", "", "android.intent.action.SEND", tab.getDisplayTitle(), false);
            }
            return true;
        }
        if (n == R.id.reload) {
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                tab.doReload(false);
            }
            return true;
        }
        if (n == R.id.back) {
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                tab.doBack();
            }
            return true;
        }
        if (n == R.id.forward) {
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                tab.doForward();
            }
            return true;
        }
        if (n == R.id.bookmarks_list) {
            String string4 = AboutPages.getURLForBuiltinPanelType(HomeConfig.PanelType.BOOKMARKS);
            Tabs.getInstance().loadUrl(string4);
            Telemetry.startUISession(TelemetryContract.Session.EXPERIMENT, "bookmark-history-menu");
            return true;
        }
        if (n == R.id.history_list) {
            String string5 = AboutPages.getURLForBuiltinPanelType(HomeConfig.PanelType.HISTORY);
            Tabs.getInstance().loadUrl(string5);
            Telemetry.startUISession(TelemetryContract.Session.EXPERIMENT, "bookmark-history-menu");
            return true;
        }
        if (n == R.id.save_as_pdf) {
            Telemetry.sendUIEvent(TelemetryContract.Event.SAVE, TelemetryContract.Method.MENU, "pdf");
            GeckoAppShell.notifyObservers("SaveAs:PDF", null);
            return true;
        }
        if (n == R.id.print) {
            Telemetry.sendUIEvent(TelemetryContract.Event.SAVE, TelemetryContract.Method.MENU, "print");
            PrintHelper.printPDF((Context)this);
            return true;
        }
        if (n == R.id.settings) {
            intent = new Intent((Context)this, GeckoPreferences.class);
            this.startActivityForResult(intent, 1001);
            return true;
        }
        if (n == R.id.help) {
            String string6 = Locales.getLanguageTag((Locale)Locale.getDefault());
            String string7 = this.getResources().getString(R.string.help_link, new Object[]{"48.0a1", "Android", string6});
            Tabs.getInstance().loadUrlInTab(string7);
            return true;
        }
        if (n == R.id.addons) {
            Tabs.getInstance().loadUrlInTab("about:addons");
            return true;
        }
        if (n == R.id.logins) {
            Tabs.getInstance().loadUrlInTab("about:logins");
            return true;
        }
        if (n == R.id.downloads) {
            Tabs.getInstance().loadUrlInTab("about:downloads");
            return true;
        }
        if (n == R.id.char_encoding) {
            GeckoAppShell.notifyObservers("CharEncoding:Get", null);
            return true;
        }
        if (n == R.id.find_in_page) {
            this.mFindInPageBar.show();
            return true;
        }
        if (n == R.id.desktop_mode) {
            Tab tab2 = Tabs.getInstance().getSelectedTab();
            if (tab2 == null) {
                return true;
            }
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("desktopMode", !menuItem.isChecked());
                jSONObject.put("tabId", tab2.getId());
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"error building json arguments", (Throwable)jSONException);
            }
            GeckoAppShell.notifyObservers("DesktopMode:Change", jSONObject.toString());
            return true;
        }
        if (n == R.id.new_tab) {
            this.addTab();
            return true;
        }
        if (n == R.id.new_private_tab) {
            this.addPrivateTab();
            return true;
        }
        if (n == R.id.new_guest_session) {
            this.showGuestModeDialog(GuestModeDialog.ENTERING);
            return true;
        }
        if (n == R.id.exit_guest_session) {
            this.showGuestModeDialog(GuestModeDialog.LEAVING);
            return true;
        }
        if (this.onContextItemSelected(menuItem)) {
            return true;
        }
        return super.onOptionsItemSelected(menuItem);
    }

    @Override
    public boolean onMenuItemLongClick(MenuItem menuItem) {
        if (menuItem.getItemId() == R.id.reload) {
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                tab.doReload(true);
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.MENU, "reload_force");
            }
            return true;
        }
        return super.onMenuItemLongClick(menuItem);
    }

    public void showGuestModeDialog(final GuestModeDialog guestModeDialog) {
        Prompt prompt = new Prompt((Context)this, new Prompt.PromptCallback(){

            @Override
            public void onPromptFinished(String string2) {
                try {
                    int n = new JSONObject(string2).getInt("button");
                    if (n == 0) {
                        String string3 = "";
                        if (guestModeDialog == GuestModeDialog.ENTERING) {
                            string3 = BrowserApp.GUEST_BROWSING_ARG;
                        } else {
                            GeckoProfile.leaveGuestSession((Context)BrowserApp.this);
                            GuestSession.hideNotification((Context)BrowserApp.this);
                        }
                        BrowserApp.this.doRestart(string3);
                    }
                }
                catch (JSONException jSONException) {
                    Log.e((String)BrowserApp.LOGTAG, (String)"Exception reading guest mode prompt result", (Throwable)jSONException);
                }
            }
        });
        Resources resources = this.getResources();
        prompt.setButtons(new String[]{resources.getString(R.string.guest_session_dialog_continue), resources.getString(R.string.guest_session_dialog_cancel)});
        int n = 0;
        int n2 = 0;
        if (guestModeDialog == GuestModeDialog.ENTERING) {
            n = R.string.new_guest_session_title;
            n2 = R.string.new_guest_session_text;
        } else {
            n = R.string.exit_guest_session_title;
            n2 = R.string.exit_guest_session_text;
        }
        prompt.show(resources.getString(n), resources.getString(n2), null, 0);
    }

    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        if (n == 4) {
            TabHistoryFragment tabHistoryFragment = (TabHistoryFragment)this.getSupportFragmentManager().findFragmentByTag(TAB_HISTORY_FRAGMENT_TAG);
            if (tabHistoryFragment != null) {
                return false;
            }
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null && !tab.isEditing()) {
                return this.tabHistoryController.showTabHistory(tab, TabHistoryController.HistoryAction.ALL);
            }
        }
        return super.onKeyLongPress(n, keyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onNewIntent(Intent intent) {
        Object object;
        String string2 = intent.getAction();
        boolean bl = "android.intent.action.VIEW".equals(string2);
        boolean bl2 = "org.mozilla.gecko.BOOKMARK".equals(string2);
        boolean bl3 = "TAB_QUEUE_LOAD_URLS_ACTION".equals(string2);
        boolean bl4 = ACTION_VIEW_MULTIPLE.equals(string2);
        if (this.mInitialized && (bl || bl2)) {
            this.mBrowserToolbar.cancelEdit();
            this.hideFirstrunPager(TelemetryContract.Method.NONE);
            if (bl2) {
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.HOMESCREEN);
            }
        }
        this.showTabQueuePromptIfApplicable(intent);
        super.onNewIntent(intent);
        if (AppConstants.MOZ_ANDROID_BEAM && "android.nfc.action.NDEF_DISCOVERED".equals(string2)) {
            object = intent.getDataString();
            GeckoAppShell.sendEventToGecko(GeckoEvent.createURILoadEvent((String)object));
        }
        if ("org.mozilla.gecko.GUEST_SESSION_INPROGRESS".equals(string2)) {
            GuestSession.handleIntent(this, intent);
        }
        if (TabQueueHelper.TAB_QUEUE_ENABLED && this.mInitialized && bl3) {
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.NOTIFICATION, "tabqueue");
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    BrowserApp.this.openQueuedTabs();
                }
            });
        }
        if (bl4) {
            object = intent.getStringArrayListExtra("urls");
            if (object != null) {
                this.openUrls((List<String>)object);
            }
            if (intent.hasExtra("content-notification")) {
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.NOTIFICATION, "content_update");
            }
        }
        if (!this.mInitialized || !"android.intent.action.MAIN".equals(string2)) {
            return;
        }
        object = this.getPackageName() + ".feedback_launch_count";
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            SharedPreferences sharedPreferences = this.getPreferences(0);
            int n = sharedPreferences.getInt((String)object, 0);
            if (n < 15) {
                sharedPreferences.edit().putInt((String)object, ++n).apply();
                if (n == 15) {
                    GeckoAppShell.notifyObservers("Feedback:Show", null);
                }
            }
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private void openUrls(List<String> list) {
        try {
            JSONArray jSONArray = new JSONArray();
            for (String string2 : list) {
                jSONArray.put((Object)string2);
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("urls", (Object)jSONArray);
            GeckoAppShell.notifyObservers("Tabs:OpenMultiple", jSONObject.toString());
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Unable to create JSON for opening multiple URLs");
        }
    }

    private void showTabQueuePromptIfApplicable(final Intent intent) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (TabQueueHelper.TAB_QUEUE_ENABLED && BrowserApp.this.mInitialized && "android.intent.action.VIEW".equals(intent.getAction()) && !intent.getBooleanExtra("skip_tab_queue", false) && TabQueueHelper.shouldShowTabQueuePrompt((Context)BrowserApp.this)) {
                    Intent intent2 = new Intent((Context)BrowserApp.this, TabQueuePrompt.class);
                    BrowserApp.this.startActivityForResult(intent2, 2001);
                }
            }
        });
    }

    @Override
    protected NotificationClient makeNotificationClient() {
        return new ServiceNotificationClient(this.getApplicationContext());
    }

    private void resetFeedbackLaunchCount() {
        SharedPreferences sharedPreferences = this.getPreferences(0);
        sharedPreferences.edit().putInt(this.getPackageName() + ".feedback_launch_count", 0).apply();
    }

    @Override
    public void onUrlOpen(String string2, EnumSet<HomePager.OnUrlOpenListener.Flags> enumSet) {
        if (enumSet.contains((Object)HomePager.OnUrlOpenListener.Flags.OPEN_WITH_INTENT)) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)string2));
            this.startActivity(intent);
        } else if (!this.maybeSwitchToTab(string2, enumSet)) {
            this.openUrlAndStopEditing(string2);
            this.clearSelectedTabApplicationId();
        }
    }

    @Override
    public void onUrlOpenInBackground(String string2, EnumSet<HomePager.OnUrlOpenInBackgroundListener.Flags> enumSet) {
        if (string2 == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        if (enumSet == null) {
            throw new IllegalArgumentException("flags must not be null");
        }
        boolean bl = enumSet.contains((Object)HomePager.OnUrlOpenInBackgroundListener.Flags.PRIVATE);
        int n = 65;
        if (bl) {
            n |= 4;
        }
        Tab tab = Tabs.getInstance().loadUrl(string2, n);
        final int n2 = tab.getId();
        SnackbarHelper.SnackbarCallback snackbarCallback = new SnackbarHelper.SnackbarCallback(){

            public void onClick(View view) {
                Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.TOAST, "switchtab");
                BrowserApp.this.maybeSwitchToTab(n2);
            }
        };
        String string3 = bl ? this.getResources().getString(R.string.new_private_tab_opened) : this.getResources().getString(R.string.new_tab_opened);
        String string4 = this.getResources().getString(R.string.switch_button_message);
        SnackbarHelper.showSnackbarWithAction((Activity)this, string3, 0, string4, snackbarCallback);
    }

    @Override
    public void onSearch(org.mozilla.gecko.home.SearchEngine searchEngine, String string2) {
        if (!Tabs.getInstance().getSelectedTab().isPrivate()) {
            this.storeSearchQuery(string2);
        }
        BrowserApp.recordSearch(searchEngine, "barsuggest");
        this.openUrlAndStopEditing(string2, searchEngine.name);
    }

    @Override
    public void onEditSuggestion(String string2) {
        this.mBrowserToolbar.onEditSuggestion(string2);
    }

    @Override
    public int getLayout() {
        return R.layout.gecko_app;
    }

    @Override
    protected String getDefaultProfileName() throws GeckoProfileDirectories.NoMozillaDirectoryException {
        return GeckoProfile.getDefaultProfileName((Context)this);
    }

    @RobocopTarget
    public ReadingListHelper getReadingListHelper() {
        return this.mReadingListHelper;
    }

    protected boolean handleUpdaterLaunch() {
        Tabs.getInstance().loadUrlInTab("about:");
        return true;
    }

    @Override
    public void startActionModeCompat(ActionModeCompat.Callback callback) {
        if (this.mActionMode == null) {
            this.mActionBarFlipper.showNext();
            DynamicToolbarAnimator dynamicToolbarAnimator = this.mLayerView.getDynamicToolbarAnimator();
            if (this.mDynamicToolbar.isEnabled() && dynamicToolbarAnimator.getToolbarTranslation() != 0.0f) {
                this.mDynamicToolbar.setTemporarilyVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
            } else {
                this.mActionBar.animateIn();
            }
            this.mDynamicToolbar.setPinned(true, DynamicToolbarAnimator.PinReason.ACTION_MODE);
        } else {
            this.mActionMode.finish();
        }
        this.mActionMode = new ActionModeCompat(this, callback, this.mActionBar);
        if (callback.onCreateActionMode(this.mActionMode, this.mActionMode.getMenu())) {
            this.mActionMode.invalidate();
        }
    }

    @Override
    public void endActionModeCompat() {
        if (this.mActionMode == null) {
            return;
        }
        this.mActionMode.finish();
        this.mActionMode = null;
        this.mDynamicToolbar.setPinned(false, DynamicToolbarAnimator.PinReason.ACTION_MODE);
        this.mActionBarFlipper.showPrevious();
        this.mDynamicToolbar.setTemporarilyVisible(false, DynamicToolbar.VisibilityTransition.IMMEDIATE);
    }

    @WorkerThread
    private static void uploadTelemetry(Context context, GeckoProfile geckoProfile, SearchEngine searchEngine) {
        if (!TelemetryUploadService.isUploadEnabledByProfileConfig(context, geckoProfile)) {
            return;
        }
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfileName(context, geckoProfile.getName());
        int n = sharedPreferences.getInt("telemetry-seqCount", 1);
        sharedPreferences.edit().putInt("telemetry-seqCount", n + 1).commit();
        Intent intent = new Intent("uploadCore");
        intent.setClass(context, TelemetryUploadService.class);
        intent.putExtra("defaultSearchEngine", searchEngine.getIdentifier());
        intent.putExtra("docId", UUID.randomUUID().toString());
        intent.putExtra("geckoProfileName", geckoProfile.getName());
        intent.putExtra("geckoProfilePath", geckoProfile.getDir().getAbsolutePath());
        intent.putExtra("seq", n);
        context.startService(intent);
    }

    @Override
    protected GeckoApp.StartupAction getStartupAction(String string2, String string3) {
        boolean bl = GeckoProfile.get((Context)this).inGuestMode();
        if (bl) {
            return GeckoApp.StartupAction.GUEST;
        }
        if (Restrictions.isRestrictedProfile((Context)this)) {
            return GeckoApp.StartupAction.RESTRICTED;
        }
        if ("org.mozilla.gecko.BOOKMARK".equals(string3)) {
            return GeckoApp.StartupAction.SHORTCUT;
        }
        return string2 == null ? GeckoApp.StartupAction.NORMAL : GeckoApp.StartupAction.URL;
    }

    public static interface TabStripInterface {
        public void refresh();

        public void setOnTabChangedListener(OnTabAddedOrRemovedListener var1);

        public static interface OnTabAddedOrRemovedListener {
            public void onTabChanged();
        }
    }

    private static class UploadTelemetryCallback
    implements SearchEngineManager.SearchEngineCallback {
        private final WeakReference<BrowserApp> activityWeakReference;

        public UploadTelemetryCallback(BrowserApp browserApp) {
            this.activityWeakReference = new WeakReference<BrowserApp>(browserApp);
        }

        @Override
        public void execute(final SearchEngine searchEngine) {
            if (this.activityWeakReference.get() == null) {
                return;
            }
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                @WorkerThread
                public void run() {
                    BrowserApp browserApp = (BrowserApp)UploadTelemetryCallback.this.activityWeakReference.get();
                    if (browserApp == null) {
                        return;
                    }
                    BrowserApp.uploadTelemetry((Context)browserApp, browserApp.getProfile(), searchEngine);
                }
            });
        }
    }

    private class HideOnTouchListener
    implements TouchEventInterceptor {
        private boolean mIsHidingTabs;
        private final Rect mTempRect = new Rect();

        private HideOnTouchListener() {
        }

        @Override
        public boolean onInterceptTouchEvent(View view, MotionEvent motionEvent) {
            if (motionEvent.getActionMasked() == 0) {
                SnackbarHelper.dismissCurrentSnackbar();
            }
            if (view.getScrollX() != 0 || view.getScrollY() != 0) {
                view.getHitRect(this.mTempRect);
                this.mTempRect.offset(-view.getScrollX(), -view.getScrollY());
                int[] nArray = new int[2];
                view.getLocationOnScreen(nArray);
                int n = (int)motionEvent.getRawX() - nArray[0];
                int n2 = (int)motionEvent.getRawY() - nArray[1];
                if (!this.mTempRect.contains(n, n2)) {
                    return false;
                }
            }
            if (motionEvent.getActionMasked() == 0 && BrowserApp.this.autoHideTabs()) {
                this.mIsHidingTabs = true;
                return true;
            }
            return false;
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (this.mIsHidingTabs) {
                int n = motionEvent.getActionMasked();
                if (n == 1 || n == 3) {
                    this.mIsHidingTabs = false;
                }
                return true;
            }
            return false;
        }
    }

    public static enum GuestModeDialog {
        ENTERING,
        LEAVING;

    }

    private static class MenuItemInfo {
        public int id;
        public String label;
        public boolean checkable;
        public boolean checked;
        public boolean enabled = true;
        public boolean visible = true;
        public int parent;
        public boolean added;

        private MenuItemInfo() {
        }
    }
}

