/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.FilePickerResultHandler;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.GeckoEventListener;

public class FilePicker
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoFilePicker";
    private static FilePicker sFilePicker;
    private final Context context;

    public static void init(Context context) {
        if (sFilePicker == null) {
            sFilePicker = new FilePicker(context.getApplicationContext());
        }
    }

    protected FilePicker(Context context) {
        this.context = context;
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "FilePicker:Show");
    }

    public void handleMessage(String string2, final JSONObject jSONObject) {
        if (string2.equals("FilePicker:Show")) {
            String string3 = "*/*";
            String string4 = jSONObject.optString("mode");
            int n = jSONObject.optInt("tabId", -1);
            String string5 = jSONObject.optString("title");
            if ("mimeType".equals(string4)) {
                string3 = jSONObject.optString("mimeType");
            } else if ("extension".equals(string4)) {
                string3 = GeckoAppShell.getMimeTypeFromExtensions(jSONObject.optString("extensions"));
            }
            this.showFilePickerAsync(string5, string3, new ResultHandler(){

                @Override
                public void gotFile(String string2) {
                    try {
                        jSONObject.put("file", (Object)string2);
                    }
                    catch (JSONException jSONException) {
                        Log.i((String)FilePicker.LOGTAG, (String)("Can't add filename to message " + string2));
                    }
                    GeckoAppShell.notifyObservers("FilePicker:Result", jSONObject.toString());
                }
            }, n);
        }
    }

    private void addActivities(Intent intent, HashMap<String, Intent> hashMap, HashMap<String, Intent> hashMap2) {
        PackageManager packageManager = this.context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 0);
        for (ResolveInfo resolveInfo : list) {
            ComponentName componentName = new ComponentName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name);
            if (hashMap2 == null || hashMap2.containsKey(componentName.toString())) continue;
            Intent intent2 = new Intent(intent);
            intent2.setComponent(componentName);
            hashMap.put(componentName.toString(), intent2);
        }
    }

    private Intent getIntent(String string2) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType(string2);
        intent.addCategory("android.intent.category.OPENABLE");
        return intent;
    }

    private List<Intent> getIntentsForFilePicker(String string2, FilePickerResultHandler filePickerResultHandler) {
        Intent intent;
        Intent intent2;
        HashMap<String, Intent> hashMap = new HashMap<String, Intent>();
        HashMap<String, Intent> hashMap2 = new HashMap<String, Intent>();
        if ("audio/*".equals(string2)) {
            intent2 = this.getIntent(string2);
            this.addActivities(intent2, hashMap, null);
        } else if ("image/*".equals(string2)) {
            intent2 = new Intent("android.media.action.IMAGE_CAPTURE");
            intent2.putExtra("output", (Parcelable)Uri.fromFile((File)new File(Environment.getExternalStorageDirectory(), filePickerResultHandler.generateImageName())));
            this.addActivities(intent2, hashMap, null);
            this.addActivities(this.getIntent(string2), hashMap2, hashMap);
        } else if ("video/*".equals(string2)) {
            intent2 = new Intent("android.media.action.VIDEO_CAPTURE");
            this.addActivities(intent2, hashMap, null);
            this.addActivities(this.getIntent(string2), hashMap2, hashMap);
        } else {
            intent2 = this.getIntent("*/*");
            this.addActivities(intent2, hashMap, null);
            intent = new Intent("android.media.action.IMAGE_CAPTURE");
            intent.putExtra("output", (Parcelable)Uri.fromFile((File)new File(Environment.getExternalStorageDirectory(), filePickerResultHandler.generateImageName())));
            this.addActivities(intent, hashMap2, hashMap);
            intent = new Intent("android.media.action.VIDEO_CAPTURE");
            this.addActivities(intent, hashMap2, hashMap);
        }
        if (hashMap.size() == 0 && hashMap2.size() == 0) {
            hashMap2.clear();
            intent2 = this.getIntent("*/*");
            this.addActivities(intent2, hashMap, null);
        }
        intent = new ArrayList(hashMap2.values());
        intent.add(0, intent2);
        return intent;
    }

    private String getFilePickerTitle(String string2) {
        if (string2.equals("audio/*")) {
            return this.context.getString(R.string.filepicker_audio_title);
        }
        if (string2.equals("image/*")) {
            return this.context.getString(R.string.filepicker_image_title);
        }
        if (string2.equals("video/*")) {
            return this.context.getString(R.string.filepicker_video_title);
        }
        return this.context.getString(R.string.filepicker_title);
    }

    private void getFilePickerIntentAsync(String string2, String string3, FilePickerResultHandler filePickerResultHandler, IntentHandler intentHandler) {
        List<Intent> list = this.getIntentsForFilePicker(string3, filePickerResultHandler);
        if (list.size() == 0) {
            Log.i((String)LOGTAG, (String)"no activities for the file picker!");
            intentHandler.gotIntent(null);
            return;
        }
        Intent intent = list.remove(0);
        if (list.size() == 0) {
            intentHandler.gotIntent(intent);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = this.getFilePickerTitle(string3);
        }
        Intent intent2 = Intent.createChooser((Intent)intent, (CharSequence)string2);
        intent2.putExtra("android.intent.extra.INITIAL_INTENTS", list.toArray(new Parcelable[list.size()]));
        intentHandler.gotIntent(intent2);
    }

    protected void showFilePickerAsync(String string2, String string3, final ResultHandler resultHandler, int n) {
        final FilePickerResultHandler filePickerResultHandler = new FilePickerResultHandler(resultHandler, this.context, n);
        this.getFilePickerIntentAsync(string2, string3, filePickerResultHandler, new IntentHandler(){

            @Override
            public void gotIntent(Intent intent) {
                if (resultHandler == null) {
                    return;
                }
                if (intent == null) {
                    resultHandler.gotFile("");
                    return;
                }
                ActivityHandlerHelper.startIntent(intent, filePickerResultHandler);
            }
        });
    }

    private static interface IntentHandler {
        public void gotIntent(Intent var1);
    }

    public static interface ResultHandler {
        public void gotFile(String var1);
    }
}

