/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Process;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mozilla.gecko.FilePicker;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.ThreadUtils;

class FilePickerResultHandler
implements ActivityResultHandler {
    private static final String LOGTAG = "GeckoFilePickerResultHandler";
    private static final String UPLOADS_DIR = "uploads";
    private final FilePicker.ResultHandler handler;
    private final int tabId;
    private final File cacheDir;
    private String mImageName = "";

    public FilePickerResultHandler(FilePicker.ResultHandler resultHandler, Context context, int n) {
        this.tabId = n;
        this.cacheDir = new File(context.getCacheDir(), UPLOADS_DIR);
        this.handler = resultHandler;
    }

    void sendResult(String string2) {
        if (this.handler != null) {
            this.handler.gotFile(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityResult(int n, Intent intent) {
        if (n != -1) {
            this.sendResult("");
            return;
        }
        if (intent == null || intent.getAction() == null && intent.getData() == null) {
            if (this.mImageName != null) {
                File file = new File(Environment.getExternalStorageDirectory(), this.mImageName);
                this.sendResult(file.getAbsolutePath());
            } else {
                this.sendResult("");
            }
            return;
        }
        Uri uri = intent.getData();
        if (uri == null) {
            this.sendResult("");
            return;
        }
        if ("file".equals(uri.getScheme())) {
            String string2 = uri.getPath();
            this.sendResult(string2 == null ? "" : string2);
            return;
        }
        FragmentActivity fragmentActivity = (FragmentActivity)GeckoAppShell.getGeckoInterface().getActivity();
        LoaderManager loaderManager = fragmentActivity.getSupportLoaderManager();
        try (Cursor cursor = null;){
            ContentResolver contentResolver = fragmentActivity.getContentResolver();
            cursor = contentResolver.query(uri, new String[]{"_data"}, null, null, null);
            int n2 = cursor.getColumnIndex("_data");
            if (n2 >= 0) {
                loaderManager.initLoader(intent.hashCode(), null, (LoaderManager.LoaderCallbacks)new VideoLoaderCallbacks(uri));
                return;
            }
        }
        loaderManager.initLoader(uri.hashCode(), null, (LoaderManager.LoaderCallbacks)new FileLoaderCallbacks(uri, this.cacheDir, this.tabId));
    }

    public String generateImageName() {
        Time time = new Time();
        time.setToNow();
        this.mImageName = time.format("%Y-%m-%d %H.%M.%S") + ".jpg";
        return this.mImageName;
    }

    private class FileLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor>,
    Tabs.OnTabsChangedListener {
        private final Uri uri;
        private final File cacheDir;
        private final int tabId;
        String tempFile;

        public FileLoaderCallbacks(Uri uri, File file, int n) {
            this.uri = uri;
            this.cacheDir = file;
            this.tabId = n;
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            FragmentActivity fragmentActivity = (FragmentActivity)GeckoAppShell.getGeckoInterface().getActivity();
            return new CursorLoader((Context)fragmentActivity, this.uri, new String[]{"_display_name"}, null, null, null);
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            if (cursor.moveToFirst()) {
                String string2;
                Object object;
                int n;
                String string3 = cursor.getString(0);
                String string4 = "tmp_" + Process.myPid() + "-";
                FragmentActivity fragmentActivity = (FragmentActivity)GeckoAppShell.getGeckoInterface().getActivity();
                ContentResolver contentResolver = fragmentActivity.getContentResolver();
                if (string3 == null || (n = string3.lastIndexOf(46)) == -1) {
                    object = contentResolver.getType(this.uri);
                    string2 = "." + GeckoAppShell.getExtensionFromMimeType((String)object);
                } else {
                    string2 = string3.substring(n);
                    string4 = string4 + string3.substring(0, n);
                }
                try {
                    this.cacheDir.mkdir();
                    object = File.createTempFile(string4, string2, this.cacheDir);
                    FileOutputStream fileOutputStream = new FileOutputStream((File)object);
                    InputStream inputStream = contentResolver.openInputStream(this.uri);
                    byte[] byArray = new byte[4096];
                    int n2 = inputStream.read(byArray);
                    while (n2 != -1) {
                        fileOutputStream.write(byArray, 0, n2);
                        n2 = inputStream.read(byArray);
                    }
                    fileOutputStream.close();
                    inputStream.close();
                    this.tempFile = ((File)object).getAbsolutePath();
                    FilePickerResultHandler.this.sendResult(this.tempFile == null ? "" : this.tempFile);
                    if (this.tabId > -1 && !TextUtils.isEmpty((CharSequence)this.tempFile)) {
                        Tabs.registerOnTabsChangedListener(this);
                    }
                }
                catch (IOException iOException) {
                    Log.i((String)FilePickerResultHandler.LOGTAG, (String)"Error writing file", (Throwable)iOException);
                }
            } else {
                FilePickerResultHandler.this.sendResult("");
            }
        }

        public void onLoaderReset(Loader<Cursor> loader) {
        }

        @Override
        public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
            if (tab == null || tab.getId() != this.tabId) {
                return;
            }
            if (tabEvents == Tabs.TabEvents.LOCATION_CHANGE || tabEvents == Tabs.TabEvents.CLOSED) {
                ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        File file = new File(FileLoaderCallbacks.this.tempFile);
                        file.delete();
                    }
                });
                Tabs.unregisterOnTabsChangedListener(this);
            }
        }
    }

    private class VideoLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private final Uri uri;

        public VideoLoaderCallbacks(Uri uri) {
            this.uri = uri;
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            FragmentActivity fragmentActivity = (FragmentActivity)GeckoAppShell.getGeckoInterface().getActivity();
            return new CursorLoader((Context)fragmentActivity, this.uri, new String[]{"_data"}, null, null, null);
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    this.tryFileLoaderCallback();
                    return;
                }
                FilePickerResultHandler.this.sendResult(string2);
            } else {
                this.tryFileLoaderCallback();
            }
        }

        private void tryFileLoaderCallback() {
            FragmentActivity fragmentActivity = (FragmentActivity)GeckoAppShell.getGeckoInterface().getActivity();
            LoaderManager loaderManager = fragmentActivity.getSupportLoaderManager();
            loaderManager.initLoader(this.uri.hashCode(), null, (LoaderManager.LoaderCallbacks)new FileLoaderCallbacks(this.uri, FilePickerResultHandler.this.cacheDir, FilePickerResultHandler.this.tabId));
        }

        public void onLoaderReset(Loader<Cursor> loader) {
        }
    }
}

