/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.json.JSONObject;
import org.mozilla.gecko.CustomEditText;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.GeckoRequest;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;

public class FindInPageBar
extends LinearLayout
implements TextWatcher,
View.OnClickListener,
GeckoEventListener {
    private static final String LOGTAG = "GeckoFindInPageBar";
    private static final String REQUEST_ID = "FindInPageBar";
    private final Context mContext;
    private CustomEditText mFindText;
    private TextView mStatusText;
    private boolean mInflated;

    public FindInPageBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.setFocusable(true);
    }

    public void inflateContent() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        View view = layoutInflater.inflate(R.layout.find_in_page_content, (ViewGroup)this);
        view.findViewById(R.id.find_prev).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.find_next).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.find_close).setOnClickListener((View.OnClickListener)this);
        view.setOnClickListener((View.OnClickListener)this);
        this.mFindText = (CustomEditText)view.findViewById(R.id.find_text);
        this.mFindText.addTextChangedListener(this);
        this.mFindText.setOnKeyPreImeListener(new CustomEditText.OnKeyPreImeListener(){

            @Override
            public boolean onKeyPreIme(View view, int n, KeyEvent keyEvent) {
                if (n == 4) {
                    FindInPageBar.this.hide();
                    return true;
                }
                return false;
            }
        });
        this.mStatusText = (TextView)view.findViewById(R.id.find_status);
        this.mInflated = true;
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "TextSelection:Data");
    }

    public void show() {
        if (!this.mInflated) {
            this.inflateContent();
        }
        this.setVisibility(0);
        this.mFindText.requestFocus();
        GeckoAppShell.notifyObservers("TextSelection:Get", REQUEST_ID);
        GeckoAppShell.notifyObservers("FindInPage:Opened", null);
    }

    public void hide() {
        if (!this.mInflated || this.getVisibility() == 8) {
            return;
        }
        this.mFindText.setText("");
        if (this.mFindText.isFocused()) {
            this.getInputMethodManager((View)this.mFindText).hideSoftInputFromWindow(this.mFindText.getWindowToken(), 0);
        }
        this.setVisibility(8);
        GeckoAppShell.notifyObservers("FindInPage:Closed", null);
    }

    private InputMethodManager getInputMethodManager(View view) {
        Context context = view.getContext();
        return (InputMethodManager)context.getSystemService("input_method");
    }

    public void onDestroy() {
        if (!this.mInflated) {
            return;
        }
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "TextSelection:Data");
    }

    public void afterTextChanged(Editable editable) {
        this.sendRequestToFinderHelper("FindInPage:Find", editable.toString());
    }

    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    public void onClick(View view) {
        int n = view.getId();
        String string2 = this.getResources().getResourceEntryName(n);
        Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.BUTTON, string2);
        if (n == R.id.find_prev) {
            this.sendRequestToFinderHelper("FindInPage:Prev", this.mFindText.getText().toString());
            this.getInputMethodManager((View)this.mFindText).hideSoftInputFromWindow(this.mFindText.getWindowToken(), 0);
            return;
        }
        if (n == R.id.find_next) {
            this.sendRequestToFinderHelper("FindInPage:Next", this.mFindText.getText().toString());
            this.getInputMethodManager((View)this.mFindText).hideSoftInputFromWindow(this.mFindText.getWindowToken(), 0);
            return;
        }
        if (n == R.id.find_close) {
            this.hide();
        }
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        if (!string2.equals("TextSelection:Data") || !REQUEST_ID.equals(jSONObject.optString("requestId"))) {
            return;
        }
        final String string3 = jSONObject.optString("text");
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    FindInPageBar.this.mFindText.setText(string3);
                }
            });
            return;
        }
        if (this.mFindText.hasWindowFocus()) {
            this.getInputMethodManager((View)this.mFindText).showSoftInput((View)this.mFindText, 0);
        } else {
            this.mFindText.setOnWindowFocusChangeListener(new CustomEditText.OnWindowFocusChangeListener(){

                @Override
                public void onWindowFocusChanged(boolean bl) {
                    if (!bl) {
                        return;
                    }
                    FindInPageBar.this.mFindText.setOnWindowFocusChangeListener(null);
                    FindInPageBar.this.getInputMethodManager((View)FindInPageBar.this.mFindText).showSoftInput((View)FindInPageBar.this.mFindText, 0);
                }
            });
        }
    }

    private void sendRequestToFinderHelper(String string2, final String string3) {
        GeckoAppShell.sendRequestToGecko(new GeckoRequest(string2, string3){

            public void onResponse(NativeJSObject nativeJSObject) {
                int n = nativeJSObject.optInt("total", 0);
                if (n == -1) {
                    int n2 = nativeJSObject.optInt("limit", 0);
                    this.updateResult(Integer.toString(n2) + "+");
                } else if (n > 0) {
                    int n3 = nativeJSObject.optInt("current", 0);
                    this.updateResult(Integer.toString(n3) + "/" + Integer.toString(n));
                } else {
                    this.updateResult("");
                }
            }

            public void onError(NativeJSObject nativeJSObject) {
                Log.d((String)FindInPageBar.LOGTAG, (String)("No response from Gecko on request to match string: [" + string3 + "]"));
                this.updateResult("");
            }

            private void updateResult(final String string2) {
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FindInPageBar.this.mStatusText.setVisibility(string2.isEmpty() ? 8 : 0);
                        FindInPageBar.this.mStatusText.setText((CharSequence)string2);
                    }
                });
            }
        });
    }
}

