/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.AlarmManager;
import android.app.IntentService;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;

public class GeckoService
extends IntentService {
    private static final String LOGTAG = "GeckoService";
    private static final boolean DEBUG = false;
    private static final EventListener EVENT_LISTENER = new EventListener();

    public GeckoService() {
        super(LOGTAG);
    }

    public static void register() {
        EventDispatcher.getInstance().registerGeckoThreadListener(EVENT_LISTENER, "Gecko:ScheduleRun");
    }

    public static void unregister() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(EVENT_LISTENER, "Gecko:ScheduleRun");
    }

    public void onCreate() {
        GeckoAppShell.ensureCrashHandling();
        GeckoAppShell.setApplicationContext(this.getApplicationContext());
        super.onCreate();
        GeckoThread.ensureInit(null, null);
        GeckoThread.launch();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    protected void onHandleIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        switch (intent.getAction()) {
            case "update-addons": {
                break;
            }
            default: {
                Log.w((String)LOGTAG, (String)("Unknown request: " + intent));
            }
        }
    }

    private static class EventListener
    implements NativeEventListener {
        private EventListener() {
        }

        private PendingIntent getIntentForAction(Context context, String string2) {
            Intent intent = new Intent(string2, null, context, GeckoService.class);
            return PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x10000000);
        }

        public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
            Context context = GeckoAppShell.getApplicationContext();
            switch (string2) {
                case "Gecko:ScheduleRun": {
                    AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
                    alarmManager.setInexactRepeating(3, (long)nativeJSObject.getInt("trigger"), (long)nativeJSObject.getInt("interval"), this.getIntentForAction(context, nativeJSObject.getString("action")));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(string2);
                }
            }
        }
    }
}

