/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.support.v4.util.SimpleArrayMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.annotation.WrapForJNI;

public final class PrefsHelper {
    private static final String LOGTAG = "GeckoPrefsHelper";
    private static final SimpleArrayMap<String, Object> OBSERVERS = new SimpleArrayMap();
    private static final HashSet<String> INT_TO_STRING_PREFS = new HashSet(8);
    private static final HashSet<String> INT_TO_BOOL_PREFS = new HashSet(2);
    @WrapForJNI
    private static final int PREF_INVALID = -1;
    @WrapForJNI
    private static final int PREF_FINISH = 0;
    @WrapForJNI
    private static final int PREF_BOOL = 1;
    @WrapForJNI
    private static final int PREF_INT = 2;
    @WrapForJNI
    private static final int PREF_STRING = 3;

    @WrapForJNI(stubName="GetPrefs")
    private static native void nativeGetPrefs(String[] var0, PrefHandler var1);

    @WrapForJNI(stubName="SetPref")
    private static native void nativeSetPref(String var0, boolean var1, int var2, boolean var3, int var4, String var5);

    @WrapForJNI(stubName="AddObserver")
    private static native void nativeAddObserver(String[] var0, PrefHandler var1, String[] var2);

    @WrapForJNI(stubName="RemoveObserver")
    private static native void nativeRemoveObserver(String[] var0);

    @RobocopTarget
    public static void getPrefs(String[] stringArray, PrefHandler prefHandler) {
        if (GeckoThread.isStateAtLeast(GeckoThread.State.PROFILE_READY)) {
            PrefsHelper.nativeGetPrefs(stringArray, prefHandler);
        } else {
            GeckoThread.queueNativeCallUntil(GeckoThread.State.PROFILE_READY, PrefsHelper.class, "nativeGetPrefs", String[].class, stringArray, PrefHandler.class, prefHandler);
        }
    }

    public static void getPref(String string2, PrefHandler prefHandler) {
        PrefsHelper.getPrefs(new String[]{string2}, prefHandler);
    }

    public static void getPrefs(ArrayList<String> arrayList, PrefHandler prefHandler) {
        PrefsHelper.getPrefs(arrayList.toArray(new String[arrayList.size()]), prefHandler);
    }

    @RobocopTarget
    public static void setPref(String string2, Object object, boolean bl) {
        int n;
        boolean bl2 = false;
        int n2 = 0;
        String string3 = null;
        if (INT_TO_STRING_PREFS.contains(string2)) {
            n = 2;
            n2 = Integer.parseInt(String.valueOf(object));
        } else if (INT_TO_BOOL_PREFS.contains(string2)) {
            n = 2;
            n2 = (Boolean)object != false ? 1 : 0;
        } else if (object instanceof Boolean) {
            n = 1;
            bl2 = (Boolean)object;
        } else if (object instanceof Integer) {
            n = 2;
            n2 = (Integer)object;
        } else {
            n = 3;
            string3 = String.valueOf(object);
        }
        if (GeckoThread.isStateAtLeast(GeckoThread.State.PROFILE_READY)) {
            PrefsHelper.nativeSetPref(string2, bl, n, bl2, n2, string3);
        } else {
            GeckoThread.queueNativeCallUntil(GeckoThread.State.PROFILE_READY, PrefsHelper.class, "nativeSetPref", String.class, string2, bl, n, bl2, n2, String.class, string3);
        }
    }

    public static void setPref(String string2, Object object) {
        PrefsHelper.setPref(string2, object, false);
    }

    @RobocopTarget
    public static synchronized void addObserver(String[] stringArray, PrefHandler prefHandler) {
        ArrayList<String> arrayList = null;
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            ArrayList<PrefHandler> arrayList2;
            String string2 = stringArray2[i];
            Object object = OBSERVERS.get((Object)string2);
            if (object == null) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>(stringArray.length);
                }
                arrayList.add(string2);
                OBSERVERS.put((Object)string2, (Object)prefHandler);
                continue;
            }
            if (object instanceof PrefHandler) {
                arrayList2 = new ArrayList<PrefHandler>(2);
                arrayList2.add((PrefHandler)object);
                arrayList2.add(prefHandler);
                OBSERVERS.put((Object)string2, arrayList2);
                continue;
            }
            arrayList2 = (ArrayList<PrefHandler>)object;
            arrayList2.add(prefHandler);
        }
        String[] stringArray3 = stringArray2 = arrayList == null ? null : arrayList.toArray(new String[arrayList.size()]);
        if (GeckoThread.isStateAtLeast(GeckoThread.State.PROFILE_READY)) {
            PrefsHelper.nativeAddObserver(stringArray, prefHandler, stringArray2);
        } else {
            GeckoThread.queueNativeCallUntil(GeckoThread.State.PROFILE_READY, PrefsHelper.class, "nativeAddObserver", String[].class, stringArray, PrefHandler.class, prefHandler, String[].class, stringArray2);
        }
    }

    @RobocopTarget
    public static synchronized void removeObserver(PrefHandler prefHandler) {
        ArrayList<Object> arrayList = null;
        for (int i = OBSERVERS.size() - 1; i >= 0; --i) {
            List list;
            Object object = OBSERVERS.valueAt(i);
            boolean bl = false;
            if (object == prefHandler) {
                bl = true;
            } else if (!(object instanceof PrefHandler) && (list = (List)object).remove(prefHandler) && list.isEmpty()) {
                bl = true;
            }
            if (!bl) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
            }
            arrayList.add(OBSERVERS.keyAt(i));
            OBSERVERS.removeAt(i);
        }
        if (arrayList == null) {
            return;
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        if (GeckoThread.isStateAtLeast(GeckoThread.State.PROFILE_READY)) {
            PrefsHelper.nativeRemoveObserver(stringArray);
        } else {
            GeckoThread.queueNativeCallUntil(GeckoThread.State.PROFILE_READY, PrefsHelper.class, "nativeRemoveObserver", String[].class, stringArray);
        }
    }

    @WrapForJNI
    private static void callPrefHandler(PrefHandler prefHandler, int n, String string2, boolean bl, int n2, String string3) {
        if (INT_TO_STRING_PREFS.contains(string2)) {
            n = 3;
            string3 = String.valueOf(n2);
        } else if (INT_TO_BOOL_PREFS.contains(string2)) {
            n = 1;
            bl = n2 == 1;
        }
        switch (n) {
            case 0: {
                prefHandler.finish();
                return;
            }
            case 1: {
                prefHandler.prefValue(string2, bl);
                return;
            }
            case 2: {
                prefHandler.prefValue(string2, n2);
                return;
            }
            case 3: {
                prefHandler.prefValue(string2, string3);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @WrapForJNI
    private static synchronized void onPrefChange(String string2, int n, boolean bl, int n2, String string3) {
        PrefHandler prefHandler;
        Iterator iterator;
        Object object = OBSERVERS.get((Object)string2);
        if (object == null) {
            return;
        }
        if (object instanceof PrefHandler) {
            iterator = null;
            prefHandler = (PrefHandler)object;
        } else {
            List list = (List)object;
            if (list.isEmpty()) {
                return;
            }
            iterator = list.iterator();
            prefHandler = (PrefHandler)iterator.next();
        }
        do {
            PrefsHelper.callPrefHandler(prefHandler, n, string2, bl, n2, string3);
            prefHandler.finish();
        } while ((prefHandler = iterator != null && iterator.hasNext() ? (PrefHandler)iterator.next() : null) != null);
    }

    static {
        INT_TO_STRING_PREFS.add("browser.chrome.titlebarMode");
        INT_TO_STRING_PREFS.add("network.cookie.cookieBehavior");
        INT_TO_STRING_PREFS.add("font.size.inflation.minTwips");
        INT_TO_STRING_PREFS.add("home.sync.updateMode");
        INT_TO_STRING_PREFS.add("browser.image_blocking");
        INT_TO_BOOL_PREFS.add("browser.display.use_document_fonts");
    }

    public static abstract class PrefHandlerBase
    implements PrefHandler {
        @Override
        public void prefValue(String string2, boolean bl) {
            throw new UnsupportedOperationException("Unhandled boolean pref " + string2 + "; wrong type?");
        }

        @Override
        public void prefValue(String string2, int n) {
            throw new UnsupportedOperationException("Unhandled int pref " + string2 + "; wrong type?");
        }

        @Override
        public void prefValue(String string2, String string3) {
            throw new UnsupportedOperationException("Unhandled String pref " + string2 + "; wrong type?");
        }

        @Override
        public void finish() {
        }
    }

    public static interface PrefHandler {
        public void prefValue(String var1, boolean var2);

        public void prefValue(String var1, int var2);

        public void prefValue(String var1, String var2);

        public void finish();
    }
}

