/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.animation;

import android.os.Handler;
import android.support.v4.view.ViewCompat;
import android.view.Choreographer;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.animation.AnimatorProxy;

public class PropertyAnimator
implements Runnable {
    private static final String LOGTAG = "GeckoPropertyAnimator";
    private final Interpolator mInterpolator;
    private long mStartTime;
    private final long mDuration;
    private final float mDurationReciprocal;
    private final List<ElementHolder> mElementsList;
    private List<PropertyAnimationListener> mListeners;
    FramePoster mFramePoster;
    private boolean mUseHardwareLayer;

    public PropertyAnimator(long l) {
        this(l, (Interpolator)new DecelerateInterpolator());
    }

    public PropertyAnimator(long l, Interpolator interpolator) {
        this.mDuration = l;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
        this.mInterpolator = interpolator;
        this.mElementsList = new ArrayList<ElementHolder>();
        this.mFramePoster = FramePoster.create(this);
        this.mUseHardwareLayer = true;
    }

    public void setUseHardwareLayer(boolean bl) {
        this.mUseHardwareLayer = bl;
    }

    public void attach(View view, Property property, float f) {
        ElementHolder elementHolder = new ElementHolder();
        elementHolder.view = view;
        elementHolder.proxy = AnimatorProxy.create(view);
        elementHolder.property = property;
        elementHolder.to = f;
        this.mElementsList.add(elementHolder);
    }

    public void addPropertyAnimationListener(PropertyAnimationListener propertyAnimationListener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<PropertyAnimationListener>();
        }
        this.mListeners.add(propertyAnimationListener);
    }

    public long getDuration() {
        return this.mDuration;
    }

    public long getRemainingTime() {
        int n = (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
        return this.mDuration - (long)n;
    }

    @Override
    public void run() {
        int n = (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
        if ((long)n >= this.mDuration) {
            this.stop();
            return;
        }
        float f = this.mInterpolator.getInterpolation((float)n * this.mDurationReciprocal);
        for (ElementHolder elementHolder : this.mElementsList) {
            float f2 = elementHolder.from + (elementHolder.to - elementHolder.from) * f;
            this.invalidate(elementHolder, f2);
        }
        this.mFramePoster.postNextAnimationFrame();
    }

    public void start() {
        if (this.mDuration == 0L) {
            return;
        }
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        for (ElementHolder object2 : this.mElementsList) {
            if (object2.property == Property.ALPHA) {
                object2.from = object2.proxy.getAlpha();
            } else if (object2.property == Property.TRANSLATION_Y) {
                object2.from = object2.proxy.getTranslationY();
            } else if (object2.property == Property.TRANSLATION_X) {
                object2.from = object2.proxy.getTranslationX();
            } else if (object2.property == Property.SCROLL_Y) {
                object2.from = object2.proxy.getScrollY();
            } else if (object2.property == Property.SCROLL_X) {
                object2.from = object2.proxy.getScrollX();
            } else if (object2.property == Property.WIDTH) {
                object2.from = object2.proxy.getWidth();
            } else if (object2.property == Property.HEIGHT) {
                object2.from = object2.proxy.getHeight();
            }
            ViewCompat.setHasTransientState((View)object2.view, (boolean)true);
            if (this.shouldEnableHardwareLayer(object2)) {
                object2.view.setLayerType(2, null);
                continue;
            }
            object2.view.setDrawingCacheEnabled(true);
        }
        Object object3 = this.mElementsList.size() > 0 ? this.mElementsList.get((int)0).view.getViewTreeObserver() : null;
        ViewTreeObserver.OnPreDrawListener onPreDrawListener = new ViewTreeObserver.OnPreDrawListener((ViewTreeObserver)object3){
            final /* synthetic */ ViewTreeObserver val$treeObserver;
            {
                this.val$treeObserver = viewTreeObserver;
            }

            public boolean onPreDraw() {
                if (this.val$treeObserver.isAlive()) {
                    this.val$treeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                }
                PropertyAnimator.this.mFramePoster.postFirstAnimationFrame();
                return true;
            }
        };
        if (AppConstants.Versions.feature11Plus && object3 != null && object3.isAlive()) {
            object3.addOnPreDrawListener(onPreDrawListener);
        } else {
            this.mFramePoster.postFirstAnimationFrame();
        }
        if (this.mListeners != null) {
            for (PropertyAnimationListener propertyAnimationListener : this.mListeners) {
                propertyAnimationListener.onPropertyAnimationStart();
            }
        }
    }

    public void stop(boolean bl) {
        this.mFramePoster.cancelAnimationFrame();
        for (ElementHolder object : this.mElementsList) {
            if (bl) {
                this.invalidate(object, object.to);
            }
            ViewCompat.setHasTransientState((View)object.view, (boolean)false);
            if (this.shouldEnableHardwareLayer(object)) {
                object.view.setLayerType(0, null);
                continue;
            }
            object.view.setDrawingCacheEnabled(false);
        }
        this.mElementsList.clear();
        if (this.mListeners != null) {
            if (bl) {
                for (PropertyAnimationListener propertyAnimationListener : this.mListeners) {
                    propertyAnimationListener.onPropertyAnimationEnd();
                }
            }
            this.mListeners.clear();
            this.mListeners = null;
        }
    }

    public void stop() {
        this.stop(true);
    }

    private boolean shouldEnableHardwareLayer(ElementHolder elementHolder) {
        if (!this.mUseHardwareLayer) {
            return false;
        }
        if (!(elementHolder.view instanceof ViewGroup)) {
            return false;
        }
        return elementHolder.property == Property.ALPHA || elementHolder.property == Property.TRANSLATION_Y || elementHolder.property == Property.TRANSLATION_X;
    }

    private void invalidate(ElementHolder elementHolder, float f) {
        View view = elementHolder.view;
        if (view.getHandler() == null) {
            return;
        }
        if (elementHolder.property == Property.ALPHA) {
            elementHolder.proxy.setAlpha(f);
        } else if (elementHolder.property == Property.TRANSLATION_Y) {
            elementHolder.proxy.setTranslationY(f);
        } else if (elementHolder.property == Property.TRANSLATION_X) {
            elementHolder.proxy.setTranslationX(f);
        } else if (elementHolder.property == Property.SCROLL_Y) {
            elementHolder.proxy.scrollTo(elementHolder.proxy.getScrollX(), (int)f);
        } else if (elementHolder.property == Property.SCROLL_X) {
            elementHolder.proxy.scrollTo((int)f, elementHolder.proxy.getScrollY());
        } else if (elementHolder.property == Property.WIDTH) {
            elementHolder.proxy.setWidth((int)f);
        } else if (elementHolder.property == Property.HEIGHT) {
            elementHolder.proxy.setHeight((int)f);
        }
    }

    private static class FramePosterPostJB
    extends FramePoster {
        private final Choreographer mChoreographer = Choreographer.getInstance();
        private final Choreographer.FrameCallback mCallback;

        public FramePosterPostJB(final Runnable runnable) {
            this.mCallback = new Choreographer.FrameCallback(){

                public void doFrame(long l) {
                    runnable.run();
                }
            };
        }

        @Override
        public void postFirstAnimationFrame() {
            this.postNextAnimationFrame();
        }

        @Override
        public void postNextAnimationFrame() {
            this.mChoreographer.postFrameCallback(this.mCallback);
        }

        @Override
        public void cancelAnimationFrame() {
            this.mChoreographer.removeFrameCallback(this.mCallback);
        }
    }

    private static class FramePosterPreJB
    extends FramePoster {
        private static final int INTERVAL = 10;
        private final Handler mHandler = new Handler();
        private final Runnable mRunnable;

        public FramePosterPreJB(Runnable runnable) {
            this.mRunnable = runnable;
        }

        @Override
        public void postFirstAnimationFrame() {
            this.mHandler.post(this.mRunnable);
        }

        @Override
        public void postNextAnimationFrame() {
            this.mHandler.postDelayed(this.mRunnable, 10L);
        }

        @Override
        public void cancelAnimationFrame() {
            this.mHandler.removeCallbacks(this.mRunnable);
        }
    }

    private static abstract class FramePoster {
        private FramePoster() {
        }

        public static FramePoster create(Runnable runnable) {
            if (AppConstants.Versions.feature16Plus) {
                return new FramePosterPostJB(runnable);
            }
            return new FramePosterPreJB(runnable);
        }

        public abstract void postFirstAnimationFrame();

        public abstract void postNextAnimationFrame();

        public abstract void cancelAnimationFrame();
    }

    public static interface PropertyAnimationListener {
        public void onPropertyAnimationStart();

        public void onPropertyAnimationEnd();
    }

    private class ElementHolder {
        View view;
        AnimatorProxy proxy;
        Property property;
        float from;
        float to;

        private ElementHolder() {
        }
    }

    public static enum Property {
        ALPHA,
        TRANSLATION_X,
        TRANSLATION_Y,
        SCROLL_X,
        SCROLL_Y,
        WIDTH,
        HEIGHT;

    }
}

