/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.MatrixCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.NullCipher;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.SharedBrowserDatabaseProvider;
import org.mozilla.gecko.sync.Utils;

public class LoginsProvider
extends SharedBrowserDatabaseProvider {
    private static final int LOGINS = 100;
    private static final int LOGINS_ID = 101;
    private static final int DELETED_LOGINS = 102;
    private static final int DELETED_LOGINS_ID = 103;
    private static final int DISABLED_HOSTS = 104;
    private static final int DISABLED_HOSTS_HOSTNAME = 105;
    private static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    private static final HashMap<String, String> LOGIN_PROJECTION_MAP;
    private static final HashMap<String, String> DELETED_LOGIN_PROJECTION_MAP;
    private static final HashMap<String, String> DISABLED_HOSTS_PROJECTION_MAP;
    private static final String DEFAULT_LOGINS_SORT_ORDER = "hostname ASC";
    private static final String DEFAULT_DELETED_LOGINS_SORT_ORDER = "timeDeleted ASC";
    private static final String DEFAULT_DISABLED_HOSTS_SORT_ORDER = "hostname ASC";
    private static final String WHERE_GUID_IS_NULL = "guid IS NULL";
    private static final String WHERE_GUID_IS_VALUE = "guid = ?";
    protected static final String INDEX_LOGINS_HOSTNAME = "login_hostname_index";
    protected static final String INDEX_LOGINS_HOSTNAME_FORM_SUBMIT_URL = "login_hostname_formSubmitURL_index";
    protected static final String INDEX_LOGINS_HOSTNAME_HTTP_REALM = "login_hostname_httpRealm_index";

    private static String projectColumn(String string2, String string3) {
        return string2 + "." + string3;
    }

    private static String selectColumn(String string2, String string3) {
        return LoginsProvider.projectColumn(string2, string3) + " = ?";
    }

    @Override
    protected Uri insertInTransaction(Uri uri, ContentValues contentValues) {
        long l;
        LoginsProvider.trace("Calling insert in transaction on URI: " + uri);
        int n = URI_MATCHER.match(uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        this.setupDefaultValues(contentValues, uri);
        switch (n) {
            case 100: {
                this.removeDeletedLoginsByGUIDInTransaction(contentValues, sQLiteDatabase);
                this.encryptContentValueFields(contentValues);
                String string2 = contentValues.getAsString("guid");
                LoginsProvider.debug("Inserting login in database with GUID: " + string2);
                l = sQLiteDatabase.insertOrThrow("logins", "guid", contentValues);
                break;
            }
            case 102: {
                String string3 = contentValues.getAsString("guid");
                LoginsProvider.debug("Inserting deleted-login in database with GUID: " + string3);
                l = sQLiteDatabase.insertOrThrow("deleted_logins", "guid", contentValues);
                break;
            }
            case 104: {
                String string4 = contentValues.getAsString("hostname");
                LoginsProvider.debug("Inserting disabled-host in database with hostname: " + string4);
                l = sQLiteDatabase.insertOrThrow("logins_disabled_hosts", "hostname", contentValues);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown insert URI " + uri);
            }
        }
        LoginsProvider.debug("Inserted ID in database: " + l);
        if (l >= 0L) {
            return ContentUris.withAppendedId((Uri)uri, (long)l);
        }
        return null;
    }

    @Override
    protected int deleteInTransaction(Uri uri, String string2, String[] stringArray) {
        String string3;
        LoginsProvider.trace("Calling delete in transaction on URI: " + uri);
        int n = URI_MATCHER.match(uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        this.beginWrite(sQLiteDatabase);
        switch (n) {
            case 101: {
                LoginsProvider.trace("Delete on LOGINS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, LoginsProvider.selectColumn("logins", "_id"));
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
                String string4 = this.getLoginGUIDByID(string2, stringArray, sQLiteDatabase);
                if (string4 == null) {
                    return 0;
                }
                boolean bl = this.storeDeletedLoginForGUIDInTransaction(string4, sQLiteDatabase);
                if (!bl) {
                    return 0;
                }
            }
            case 100: {
                LoginsProvider.trace("Delete on LOGINS: " + uri);
                string3 = "logins";
                break;
            }
            case 103: {
                LoginsProvider.trace("Delete on DELETED_LOGINS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, LoginsProvider.selectColumn("deleted_logins", "_id"));
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 102: {
                LoginsProvider.trace("Delete on DELETED_LOGINS_ID: " + uri);
                string3 = "deleted_logins";
                break;
            }
            case 105: {
                LoginsProvider.trace("Delete on DISABLED_HOSTS_HOSTNAME: " + uri);
                string2 = DBUtils.concatenateWhere(string2, LoginsProvider.selectColumn("logins_disabled_hosts", "hostname"));
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{uri.getLastPathSegment()});
            }
            case 104: {
                LoginsProvider.trace("Delete on DISABLED_HOSTS: " + uri);
                string3 = "logins_disabled_hosts";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown delete URI " + uri);
            }
        }
        LoginsProvider.debug("Deleting " + string3 + " for URI: " + uri);
        return sQLiteDatabase.delete(string3, string2, stringArray);
    }

    @Override
    protected int updateInTransaction(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        String string3;
        LoginsProvider.trace("Calling update in transaction on URI: " + uri);
        int n = URI_MATCHER.match(uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        this.beginWrite(sQLiteDatabase);
        switch (n) {
            case 101: {
                LoginsProvider.trace("Update on LOGINS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, LoginsProvider.selectColumn("logins", "_id"));
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 100: {
                LoginsProvider.trace("Update on LOGINS: " + uri);
                string3 = "logins";
                this.encryptContentValueFields(contentValues);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown update URI " + uri);
            }
        }
        LoginsProvider.trace("Updating " + string3 + " on URI: " + uri);
        return sQLiteDatabase.update(string3, contentValues, string2, stringArray);
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        LoginsProvider.trace("Calling query on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getReadableDatabase(uri);
        int n = URI_MATCHER.match(uri);
        String string4 = null;
        SQLiteQueryBuilder sQLiteQueryBuilder = new SQLiteQueryBuilder();
        String string5 = uri.getQueryParameter("limit");
        switch (n) {
            case 101: {
                LoginsProvider.trace("Query is on LOGINS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, LoginsProvider.selectColumn("logins", "_id"));
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 100: {
                LoginsProvider.trace("Query is on LOGINS: " + uri);
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = "hostname ASC";
                } else {
                    LoginsProvider.debug("Using sort order " + string3 + ".");
                }
                sQLiteQueryBuilder.setProjectionMap(LOGIN_PROJECTION_MAP);
                sQLiteQueryBuilder.setTables("logins");
                break;
            }
            case 103: {
                LoginsProvider.trace("Query is on DELETED_LOGINS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, LoginsProvider.selectColumn("deleted_logins", "_id"));
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 102: {
                LoginsProvider.trace("Query is on DELETED_LOGINS: " + uri);
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = DEFAULT_DELETED_LOGINS_SORT_ORDER;
                } else {
                    LoginsProvider.debug("Using sort order " + string3 + ".");
                }
                sQLiteQueryBuilder.setProjectionMap(DELETED_LOGIN_PROJECTION_MAP);
                sQLiteQueryBuilder.setTables("deleted_logins");
                break;
            }
            case 105: {
                LoginsProvider.trace("Query is on DISABLED_HOSTS_HOSTNAME: " + uri);
                string2 = DBUtils.concatenateWhere(string2, LoginsProvider.selectColumn("logins_disabled_hosts", "hostname"));
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{uri.getLastPathSegment()});
            }
            case 104: {
                LoginsProvider.trace("Query is on DISABLED_HOSTS: " + uri);
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = "hostname ASC";
                } else {
                    LoginsProvider.debug("Using sort order " + string3 + ".");
                }
                sQLiteQueryBuilder.setProjectionMap(DISABLED_HOSTS_PROJECTION_MAP);
                sQLiteQueryBuilder.setTables("logins_disabled_hosts");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown query URI " + uri);
            }
        }
        LoginsProvider.trace("Running built query.");
        Cursor cursor = sQLiteQueryBuilder.query(sQLiteDatabase, stringArray, string2, stringArray2, string4, null, string3, string5);
        cursor = this.decryptManyCursorRows(cursor);
        cursor.setNotificationUri(this.getContext().getContentResolver(), BrowserContract.LOGINS_AUTHORITY_URI);
        return cursor;
    }

    public String getType(@NonNull Uri uri) {
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 100: {
                return "vnd.android.cursor.dir/logins";
            }
            case 101: {
                return "vnd.android.cursor.item/logins";
            }
            case 102: {
                return "vnd.android.cursor.dir/deleted-logins";
            }
            case 103: {
                return "vnd.android.cursor.item/deleted-logins";
            }
            case 104: {
                return "vnd.android.cursor.dir/logins-disabled-hosts";
            }
            case 105: {
                return "vnd.android.cursor.item/logins-disabled-hosts";
            }
        }
        throw new UnsupportedOperationException("Unknown type " + uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLoginGUIDByID(String string2, String[] stringArray, SQLiteDatabase sQLiteDatabase) {
        try (Cursor cursor = sQLiteDatabase.query("logins", new String[]{"guid"}, string2, stringArray, null, null, "hostname ASC");){
            if (!cursor.moveToFirst()) {
                String string3 = null;
                return string3;
            }
            String string4 = cursor.getString(cursor.getColumnIndexOrThrow("guid"));
            return string4;
        }
    }

    private boolean storeDeletedLoginForGUIDInTransaction(String string2, SQLiteDatabase sQLiteDatabase) {
        if (string2 == null) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("guid", string2);
        contentValues.put("timeDeleted", Long.valueOf(System.currentTimeMillis()));
        return sQLiteDatabase.insert("deleted_logins", "guid", contentValues) > 0L;
    }

    private void removeDeletedLoginsByGUIDInTransaction(ContentValues contentValues, SQLiteDatabase sQLiteDatabase) {
        if (contentValues.containsKey("guid")) {
            String string2 = contentValues.getAsString("guid");
            if (string2 == null) {
                sQLiteDatabase.delete("deleted_logins", WHERE_GUID_IS_NULL, null);
            } else {
                String[] stringArray = new String[]{string2};
                sQLiteDatabase.delete("deleted_logins", WHERE_GUID_IS_VALUE, stringArray);
            }
        }
    }

    private void setupDefaultValues(ContentValues contentValues, Uri uri) throws IllegalArgumentException {
        int n = URI_MATCHER.match(uri);
        long l = System.currentTimeMillis();
        switch (n) {
            case 102: {
                contentValues.put("timeDeleted", Long.valueOf(l));
                if (contentValues.containsKey("guid")) break;
                throw new IllegalArgumentException("Must provide GUID for deleted-login");
            }
            case 100: {
                String string2;
                contentValues.put("timeCreated", Long.valueOf(l));
                if (!contentValues.containsKey("guid")) {
                    string2 = Utils.generateGuid();
                    contentValues.put("guid", string2);
                }
                string2 = Long.toString(l);
                DBUtils.replaceKey(contentValues, null, "httpRealm", null);
                DBUtils.replaceKey(contentValues, null, "formSubmitURL", null);
                DBUtils.replaceKey(contentValues, null, "encType", "0");
                DBUtils.replaceKey(contentValues, null, "timeLastUsed", string2);
                DBUtils.replaceKey(contentValues, null, "timePasswordChanged", string2);
                DBUtils.replaceKey(contentValues, null, "timesUsed", "0");
                break;
            }
            case 104: {
                if (contentValues.containsKey("hostname")) break;
                throw new IllegalArgumentException("Must provide hostname for disabled-host");
            }
            default: {
                throw new UnsupportedOperationException("Unknown URI in setupDefaultValues " + uri);
            }
        }
    }

    private void encryptContentValueFields(ContentValues contentValues) {
        String string2;
        if (contentValues.containsKey("encryptedPassword")) {
            string2 = this.encrypt(contentValues.getAsString("encryptedPassword"));
            contentValues.put("encryptedPassword", string2);
        }
        if (contentValues.containsKey("encryptedUsername")) {
            string2 = this.encrypt(contentValues.getAsString("encryptedUsername"));
            contentValues.put("encryptedUsername", string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cursor decryptManyCursorRows(Cursor cursor) {
        int n = cursor.getColumnIndex("encryptedPassword");
        int n2 = cursor.getColumnIndex("encryptedUsername");
        if (n == -1 && n2 == -1) {
            return cursor;
        }
        MatrixCursor matrixCursor = new MatrixCursor(cursor.getColumnNames(), cursor.getColumnCount());
        try {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                String string2;
                ContentValues contentValues = new ContentValues();
                DatabaseUtils.cursorRowToContentValues((Cursor)cursor, (ContentValues)contentValues);
                if (n > -1) {
                    string2 = this.decrypt(contentValues.getAsString("encryptedPassword"));
                    contentValues.put("encryptedPassword", string2);
                }
                if (n2 > -1) {
                    string2 = this.decrypt(contentValues.getAsString("encryptedUsername"));
                    contentValues.put("encryptedUsername", string2);
                }
                string2 = matrixCursor.newRow();
                for (String string3 : cursor.getColumnNames()) {
                    string2.add(contentValues.get(string3));
                }
                cursor.moveToNext();
            }
        }
        finally {
            cursor.close();
        }
        return matrixCursor;
    }

    private String encrypt(@NonNull String string2) {
        try {
            Cipher cipher = this.getCipher(1);
            return Base64.encodeToString((byte[])cipher.doFinal(string2.getBytes("UTF-8")), (int)8);
        }
        catch (Exception exception) {
            LoginsProvider.debug("encryption failed : " + exception);
            throw new IllegalStateException("Logins encryption failed", exception);
        }
    }

    private String decrypt(@NonNull String string2) {
        try {
            Cipher cipher = this.getCipher(2);
            return new String(cipher.doFinal(Base64.decode((byte[])string2.getBytes("UTF-8"), (int)8)));
        }
        catch (Exception exception) {
            LoginsProvider.debug("Decryption failed : " + exception);
            throw new IllegalStateException("Logins decryption failed", exception);
        }
    }

    private Cipher getCipher(int n) throws UnsupportedEncodingException, GeneralSecurityException {
        return new NullCipher();
    }

    static {
        URI_MATCHER.addURI("org.mozilla.fennec.db.logins", "logins", 100);
        URI_MATCHER.addURI("org.mozilla.fennec.db.logins", "logins/#", 101);
        URI_MATCHER.addURI("org.mozilla.fennec.db.logins", "deleted-logins", 102);
        URI_MATCHER.addURI("org.mozilla.fennec.db.logins", "deleted-logins/#", 103);
        URI_MATCHER.addURI("org.mozilla.fennec.db.logins", "logins-disabled-hosts", 104);
        URI_MATCHER.addURI("org.mozilla.fennec.db.logins", "logins-disabled-hosts/hostname/*", 105);
        LOGIN_PROJECTION_MAP = new HashMap();
        LOGIN_PROJECTION_MAP.put("_id", "_id");
        LOGIN_PROJECTION_MAP.put("hostname", "hostname");
        LOGIN_PROJECTION_MAP.put("httpRealm", "httpRealm");
        LOGIN_PROJECTION_MAP.put("formSubmitURL", "formSubmitURL");
        LOGIN_PROJECTION_MAP.put("usernameField", "usernameField");
        LOGIN_PROJECTION_MAP.put("passwordField", "passwordField");
        LOGIN_PROJECTION_MAP.put("encryptedUsername", "encryptedUsername");
        LOGIN_PROJECTION_MAP.put("encryptedPassword", "encryptedPassword");
        LOGIN_PROJECTION_MAP.put("guid", "guid");
        LOGIN_PROJECTION_MAP.put("encType", "encType");
        LOGIN_PROJECTION_MAP.put("timeCreated", "timeCreated");
        LOGIN_PROJECTION_MAP.put("timeLastUsed", "timeLastUsed");
        LOGIN_PROJECTION_MAP.put("timePasswordChanged", "timePasswordChanged");
        LOGIN_PROJECTION_MAP.put("timesUsed", "timesUsed");
        DELETED_LOGIN_PROJECTION_MAP = new HashMap();
        DELETED_LOGIN_PROJECTION_MAP.put("_id", "_id");
        DELETED_LOGIN_PROJECTION_MAP.put("guid", "guid");
        DELETED_LOGIN_PROJECTION_MAP.put("timeDeleted", "timeDeleted");
        DISABLED_HOSTS_PROJECTION_MAP = new HashMap();
        DISABLED_HOSTS_PROJECTION_MAP.put("_id", "_id");
        DISABLED_HOSTS_PROJECTION_MAP.put("hostname", "hostname");
    }
}

