/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.Context;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import java.io.File;
import java.util.HashMap;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.db.DBUtils;

public class PerProfileDatabases<T extends SQLiteOpenHelper> {
    private final HashMap<String, T> mStorages = new HashMap();
    private final Context mContext;
    private final String mDatabaseName;
    private final DatabaseHelperFactory<T> mHelperFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        PerProfileDatabases perProfileDatabases = this;
        synchronized (perProfileDatabases) {
            for (SQLiteOpenHelper sQLiteOpenHelper : this.mStorages.values()) {
                try {
                    sQLiteOpenHelper.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public PerProfileDatabases(Context context, String string2, DatabaseHelperFactory<T> databaseHelperFactory) {
        this.mContext = context;
        this.mDatabaseName = string2;
        this.mHelperFactory = databaseHelperFactory;
    }

    public String getDatabasePathForProfile(String string2) {
        File file = GeckoProfile.get(this.mContext, string2).getDir();
        if (file == null) {
            return null;
        }
        return new File(file, this.mDatabaseName).getAbsolutePath();
    }

    public T getDatabaseHelperForProfile(String string2) {
        return this.getDatabaseHelperForProfile(string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getDatabaseHelperForProfile(String string2, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = GeckoProfile.get(this.mContext).getName();
        }
        PerProfileDatabases perProfileDatabases = this;
        synchronized (perProfileDatabases) {
            String string3;
            if (this.mStorages.containsKey(string2)) {
                return (T)((SQLiteOpenHelper)this.mStorages.get(string2));
            }
            String string4 = string3 = bl ? this.mDatabaseName : this.getDatabasePathForProfile(string2);
            if (string3 == null) {
                throw new IllegalStateException("Database path is null for profile: " + string2);
            }
            SQLiteOpenHelper sQLiteOpenHelper = (SQLiteOpenHelper)this.mHelperFactory.makeDatabaseHelper(this.mContext, string3);
            DBUtils.ensureDatabaseIsNotLocked(sQLiteOpenHelper, string3);
            this.mStorages.put(string2, sQLiteOpenHelper);
            return (T)sQLiteOpenHelper;
        }
    }

    public static interface DatabaseHelperFactory<T> {
        public T makeDatabaseHelper(Context var1, String var2);
    }
}

