/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Restrictions;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.distribution.Distribution;
import org.mozilla.gecko.util.RawResource;
import org.mozilla.gecko.util.ThreadUtils;

@RobocopTarget
public class SuggestedSites {
    private static final String LOGTAG = "GeckoSuggestedSites";
    public static final String PREF_SUGGESTED_SITES_HIDDEN = "suggestedSites.hidden";
    public static final String PREF_SUGGESTED_SITES_LOCALE = "suggestedSites.locale";
    private static final String FILENAME = "suggestedsites.json";
    private static final String[] COLUMNS = new String[]{"_id", "url", "title"};
    private static final String JSON_KEY_URL = "url";
    private static final String JSON_KEY_TITLE = "title";
    private static final String JSON_KEY_IMAGE_URL = "imageurl";
    private static final String JSON_KEY_BG_COLOR = "bgcolor";
    private static final String JSON_KEY_RESTRICTED = "restricted";
    final Context context;
    final Distribution distribution;
    private File cachedFile;
    private Map<String, Site> cachedSites;
    private Set<String> cachedBlacklist;

    public SuggestedSites(Context context) {
        this(context, null);
    }

    public SuggestedSites(Context context, Distribution distribution) {
        this(context, distribution, null);
    }

    public SuggestedSites(Context context, Distribution distribution, File file) {
        this.context = context;
        this.distribution = distribution;
        this.cachedFile = file;
    }

    synchronized File getFile() {
        if (this.cachedFile == null) {
            this.cachedFile = GeckoProfile.get(this.context).getFile(FILENAME);
        }
        return this.cachedFile;
    }

    private static boolean isNewLocale(Context context, Locale locale) {
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile(context);
        String string2 = sharedPreferences.getString(PREF_SUGGESTED_SITES_LOCALE, null);
        if (string2 == null) {
            SuggestedSites.updateSuggestedSitesLocale(context);
            return true;
        }
        return !TextUtils.equals((CharSequence)locale.toString(), (CharSequence)string2);
    }

    private static List<Locale> getAcceptableLocales() {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        Locale locale = Locale.getDefault();
        arrayList.add(locale);
        if (!locale.equals(Locale.US)) {
            arrayList.add(Locale.US);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Site> loadSites(File file) throws IOException {
        try (Scanner scanner = null;){
            scanner = new Scanner(file, "UTF-8");
            Map<String, Site> map = SuggestedSites.loadSites(scanner.useDelimiter("\\A").next());
            return map;
        }
    }

    private static Map<String, Site> loadSites(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        LinkedHashMap<String, Site> linkedHashMap = null;
        try {
            JSONArray jSONArray = new JSONArray(string2);
            linkedHashMap = new LinkedHashMap<String, Site>(jSONArray.length());
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                Site site = new Site(jSONArray.getJSONObject(i));
                linkedHashMap.put(site.url, site);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Failed to refresh suggested sites", (Throwable)exception);
            return null;
        }
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveSites(File file, Map<String, Site> map) {
        ThreadUtils.assertNotOnUiThread();
        if (map == null || map.isEmpty()) {
            return;
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            JSONArray jSONArray = new JSONArray();
            for (Site site : map.values()) {
                jSONArray.put((Object)site.toJSON());
            }
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            String string2 = jSONArray.toString();
            outputStreamWriter.write(string2, 0, string2.length());
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Failed to save suggested sites", (Throwable)exception);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void maybeWaitForDistribution() {
        if (this.distribution == null) {
            return;
        }
        this.distribution.addOnDistributionReadyCallback(new Distribution.ReadyCallback(){

            @Override
            public void distributionNotFound() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void distributionFound(Distribution distribution) {
                File file;
                Log.d((String)SuggestedSites.LOGTAG, (String)"Running post-distribution task: suggested sites.");
                Map<String, Site> map = SuggestedSites.loadFromDistribution(distribution);
                if (map == null) {
                    map = new LinkedHashMap<String, Site>();
                }
                map.putAll(SuggestedSites.this.loadFromResource());
                SuggestedSites.this.setCachedSites(map);
                File file2 = file = SuggestedSites.this.getFile();
                synchronized (file2) {
                    SuggestedSites.saveSites(file, map);
                }
                file2 = SuggestedSites.this.context.getContentResolver();
                file2.notifyChange(BrowserContract.SuggestedSites.CONTENT_URI, null);
            }

            @Override
            public void distributionArrivedLate(Distribution distribution) {
                this.distributionFound(distribution);
            }
        });
    }

    static Map<String, Site> loadFromDistribution(Distribution distribution) {
        for (Locale locale : SuggestedSites.getAcceptableLocales()) {
            try {
                String string2 = Locales.getLanguageTag((Locale)locale);
                String string3 = String.format("suggestedsites/locales/%s/%s", string2, FILENAME);
                File file = distribution.getDistributionFile(string3);
                if (file == null) {
                    Log.d((String)LOGTAG, (String)("No suggested sites for locale: " + string2));
                    continue;
                }
                return SuggestedSites.loadSites(file);
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)("Failed to open suggested sites for locale " + locale + " in distribution."), (Throwable)exception);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Site> loadFromProfile() {
        try {
            File file;
            File file2 = file = this.getFile();
            synchronized (file2) {
                return SuggestedSites.loadSites(file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.maybeWaitForDistribution();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    Map<String, Site> loadFromResource() {
        try {
            return SuggestedSites.loadSites(RawResource.getAsString((Context)this.context, (int)R.raw.suggestedsites));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private synchronized void setCachedSites(Map<String, Site> map) {
        this.cachedSites = Collections.unmodifiableMap(map);
        SuggestedSites.updateSuggestedSitesLocale(this.context);
    }

    private void refresh() {
        Log.d((String)LOGTAG, (String)"Refreshing suggested sites from file");
        Map<String, Site> map = this.loadFromProfile();
        if (map == null) {
            map = this.loadFromResource();
        }
        if (map != null) {
            this.setCachedSites(map);
        }
    }

    private static void updateSuggestedSitesLocale(Context context) {
        SharedPreferences.Editor editor = GeckoSharedPrefs.forProfile(context).edit();
        editor.putString(PREF_SUGGESTED_SITES_LOCALE, Locale.getDefault().toString());
        editor.apply();
    }

    private synchronized Site getSiteForUrl(String string2) {
        if (this.cachedSites == null) {
            return null;
        }
        return this.cachedSites.get(string2);
    }

    public Cursor get(int n) {
        return this.get(n, Locale.getDefault());
    }

    public Cursor get(int n, Locale locale) {
        return this.get(n, locale, null);
    }

    public Cursor get(int n, List<String> list) {
        return this.get(n, Locale.getDefault(), list);
    }

    public synchronized Cursor get(int n, Locale locale, List<String> list) {
        MatrixCursor matrixCursor = new MatrixCursor(COLUMNS);
        boolean bl = SuggestedSites.isNewLocale(this.context, locale);
        if (bl) {
            this.getFile().delete();
        }
        if (this.cachedSites == null || bl) {
            Log.d((String)LOGTAG, (String)"No cached sites, refreshing.");
            this.refresh();
        }
        if (this.cachedSites == null || this.cachedSites.isEmpty()) {
            return matrixCursor;
        }
        list = this.includeBlacklist(list);
        int n2 = this.cachedSites.size();
        Log.d((String)LOGTAG, (String)("Number of suggested sites: " + n2));
        int n3 = Math.min(n, n2);
        for (Site site : this.cachedSites.values()) {
            boolean bl2;
            if (matrixCursor.getCount() == n3) break;
            if (list != null && list.contains(site.url) || (bl2 = Restrictions.isRestrictedProfile(this.context)) != site.restricted) continue;
            MatrixCursor.RowBuilder rowBuilder = matrixCursor.newRow();
            rowBuilder.add((Object)-1);
            rowBuilder.add((Object)site.url);
            rowBuilder.add((Object)site.title);
        }
        matrixCursor.setNotificationUri(this.context.getContentResolver(), BrowserContract.SuggestedSites.CONTENT_URI);
        return matrixCursor;
    }

    public boolean contains(String string2) {
        return this.getSiteForUrl(string2) != null;
    }

    public String getImageUrlForUrl(String string2) {
        Site site = this.getSiteForUrl(string2);
        return site != null ? site.imageUrl : null;
    }

    public String getBackgroundColorForUrl(String string2) {
        Site site = this.getSiteForUrl(string2);
        return site != null ? site.bgColor : null;
    }

    private Set<String> loadBlacklist() {
        Log.d((String)LOGTAG, (String)"Loading blacklisted suggested sites from SharedPreferences.");
        HashSet<String> hashSet = new HashSet<String>();
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile(this.context);
        String string2 = sharedPreferences.getString(PREF_SUGGESTED_SITES_HIDDEN, null);
        if (string2 != null) {
            for (String string3 : string2.trim().split(" ")) {
                hashSet.add(Uri.decode((String)string3));
            }
        }
        return hashSet;
    }

    private List<String> includeBlacklist(List<String> list) {
        if (this.cachedBlacklist == null) {
            this.cachedBlacklist = this.loadBlacklist();
        }
        if (this.cachedBlacklist.isEmpty()) {
            return list;
        }
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.addAll(this.cachedBlacklist);
        return list;
    }

    public synchronized boolean hideSite(String string2) {
        ThreadUtils.assertNotOnUiThread();
        if (this.cachedSites == null) {
            this.refresh();
            if (this.cachedSites == null) {
                Log.w((String)LOGTAG, (String)"Could not load suggested sites!");
                return false;
            }
        }
        if (this.cachedSites.containsKey(string2)) {
            if (this.cachedBlacklist == null) {
                this.cachedBlacklist = this.loadBlacklist();
            }
            if (!this.cachedBlacklist.contains(string2)) {
                this.saveToBlacklist(string2);
                this.cachedBlacklist.add(string2);
                return true;
            }
        }
        return false;
    }

    private void saveToBlacklist(String string2) {
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile(this.context);
        String string3 = sharedPreferences.getString(PREF_SUGGESTED_SITES_HIDDEN, "");
        String string4 = string3.concat(" " + Uri.encode((String)string2));
        sharedPreferences.edit().putString(PREF_SUGGESTED_SITES_HIDDEN, string4).apply();
    }

    private static class Site {
        public final String url;
        public final String title;
        public final String imageUrl;
        public final String bgColor;
        public final boolean restricted;

        public Site(JSONObject jSONObject) throws JSONException {
            this.restricted = !jSONObject.isNull(SuggestedSites.JSON_KEY_RESTRICTED);
            this.url = jSONObject.getString(SuggestedSites.JSON_KEY_URL);
            this.title = jSONObject.getString(SuggestedSites.JSON_KEY_TITLE);
            this.imageUrl = jSONObject.getString(SuggestedSites.JSON_KEY_IMAGE_URL);
            this.bgColor = jSONObject.getString(SuggestedSites.JSON_KEY_BG_COLOR);
            this.validate();
        }

        public Site(String string2, String string3, String string4, String string5) {
            this.url = string2;
            this.title = string3;
            this.imageUrl = string4;
            this.bgColor = string5;
            this.restricted = false;
            this.validate();
        }

        private void validate() {
            if (TextUtils.isEmpty((CharSequence)this.url) || TextUtils.isEmpty((CharSequence)this.title) || TextUtils.isEmpty((CharSequence)this.imageUrl) || TextUtils.isEmpty((CharSequence)this.bgColor)) {
                throw new IllegalStateException("Suggested sites must have a URL, title, image URL, and background color.");
            }
        }

        public String toString() {
            return "{ url = " + this.url + "\n" + "restricted = " + this.restricted + "\n" + "title = " + this.title + "\n" + "imageUrl = " + this.imageUrl + "\n" + "bgColor = " + this.bgColor + " }";
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject jSONObject = new JSONObject();
            if (this.restricted) {
                jSONObject.put(SuggestedSites.JSON_KEY_RESTRICTED, true);
            }
            jSONObject.put(SuggestedSites.JSON_KEY_URL, (Object)this.url);
            jSONObject.put(SuggestedSites.JSON_KEY_TITLE, (Object)this.title);
            jSONObject.put(SuggestedSites.JSON_KEY_IMAGE_URL, (Object)this.imageUrl);
            jSONObject.put(SuggestedSites.JSON_KEY_BG_COLOR, (Object)this.bgColor);
            return jSONObject;
        }
    }
}

