/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.firstrun;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import java.util.List;
import org.mozilla.gecko.Restrictions;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.firstrun.FirstrunAnimationContainer;
import org.mozilla.gecko.firstrun.FirstrunPagerConfig;
import org.mozilla.gecko.firstrun.FirstrunPanel;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.TabMenuStrip;

public class FirstrunPager
extends ViewPager {
    private Context context;
    protected FirstrunPanel.PagerNavigation pagerNavigation;
    private HomePager.Decor mDecor;
    private View mTabStrip;

    public FirstrunPager(Context context) {
        this(context, null);
    }

    public FirstrunPager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.context = context;
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        if (view instanceof HomePager.Decor) {
            ((ViewPager.LayoutParams)layoutParams).isDecor = true;
            this.mDecor = (HomePager.Decor)view;
            this.mTabStrip = view;
            this.mDecor.setOnTitleClickListener(new TabMenuStrip.OnTitleClickListener(){

                @Override
                public void onTitleClicked(int n) {
                    FirstrunPager.this.setCurrentItem(n, true);
                }
            });
        }
        super.addView(view, n, layoutParams);
    }

    public void load(Context context, FragmentManager fragmentManager, final FirstrunAnimationContainer.OnFinishListener onFinishListener) {
        List<FirstrunPagerConfig.FirstrunPanelConfig> list;
        if (Restrictions.isUserRestricted(this.context)) {
            list = FirstrunPagerConfig.getRestricted();
        } else {
            list = FirstrunPagerConfig.getDefault(context);
            if (list.size() == 1) {
                this.mTabStrip.setVisibility(8);
            }
        }
        this.setAdapter((PagerAdapter)new ViewPagerAdapter(fragmentManager, list));
        this.pagerNavigation = new FirstrunPanel.PagerNavigation(){

            @Override
            public void next() {
                int n = FirstrunPager.this.getCurrentItem();
                if (n < FirstrunPager.this.getAdapter().getCount() - 1) {
                    FirstrunPager.this.setCurrentItem(n + 1);
                }
            }

            @Override
            public void finish() {
                if (onFinishListener != null) {
                    onFinishListener.onFinish();
                }
            }
        };
        this.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int n, float f, int n2) {
                FirstrunPager.this.mDecor.onPageScrolled(n, f, n2);
            }

            public void onPageSelected(int n) {
                FirstrunPager.this.mDecor.onPageSelected(n);
                Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.PANEL, "onboarding." + n);
            }

            public void onPageScrollStateChanged(int n) {
            }
        });
        this.animateLoad();
        Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.PANEL, "onboarding.0");
    }

    public void cleanup() {
        this.setAdapter(null);
    }

    private void animateLoad() {
        this.setTranslationY(500.0f);
        this.setAlpha(0.0f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{0.0f});
        objectAnimator.setDuration(400L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{1.0f});
        objectAnimator2.setStartDelay(200L);
        objectAnimator2.setDuration(600L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator2, objectAnimator});
        animatorSet.setStartDelay(400L);
        animatorSet.start();
    }

    protected class ViewPagerAdapter
    extends FragmentPagerAdapter {
        private final List<FirstrunPagerConfig.FirstrunPanelConfig> panels;
        private final Fragment[] fragments;

        public ViewPagerAdapter(FragmentManager fragmentManager, List<FirstrunPagerConfig.FirstrunPanelConfig> list) {
            super(fragmentManager);
            this.panels = list;
            this.fragments = new Fragment[list.size()];
            for (FirstrunPagerConfig.FirstrunPanelConfig firstrunPanelConfig : list) {
                FirstrunPager.this.mDecor.onAddPagerView(FirstrunPager.this.context.getString(firstrunPanelConfig.getTitleRes()));
            }
            if (list.size() > 0) {
                FirstrunPager.this.mDecor.onPageSelected(0);
            }
        }

        public Fragment getItem(int n) {
            Fragment fragment = this.fragments[n];
            if (fragment == null) {
                FirstrunPagerConfig.FirstrunPanelConfig firstrunPanelConfig = this.panels.get(n);
                fragment = Fragment.instantiate((Context)FirstrunPager.this.context, (String)firstrunPanelConfig.getClassname(), (Bundle)firstrunPanelConfig.getArgs());
                ((FirstrunPanel)fragment).setPagerNavigation(FirstrunPager.this.pagerNavigation);
                this.fragments[n] = fragment;
            }
            return fragment;
        }

        public int getCount() {
            return this.panels.size();
        }

        public CharSequence getPageTitle(int n) {
            return FirstrunPager.this.context.getString(this.panels.get(n).getTitleRes()).toUpperCase();
        }
    }
}

