/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.util.Log;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.gfx.GeckoLayerClient;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.NativePanZoomController;
import org.mozilla.gecko.mozglue.JNIObject;
import org.mozilla.gecko.util.ThreadUtils;

public class GLController
extends JNIObject {
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final String LOGTAG = "GeckoGLController";
    LayerView mView;
    private boolean mServerSurfaceValid;
    private int mWidth;
    private int mHeight;
    private volatile boolean mCompositorCreated;
    private static EGL10 sEGL;
    private static EGLDisplay sEGLDisplay;
    private static EGLConfig sEGLConfig;
    private EGLSurface mEGLSurfaceForCompositor;
    private static final int LOCAL_EGL_OPENGL_ES2_BIT = 4;
    private static final int[] CONFIG_SPEC_16BPP;
    private static final int[] CONFIG_SPEC_24BPP;

    @WrapForJNI
    protected native void disposeNative();

    @WrapForJNI
    native void attachToJava(GeckoLayerClient var1, NativePanZoomController var2);

    @WrapForJNI
    native void onSizeChanged(int var1, int var2, int var3, int var4);

    @WrapForJNI
    private native void createCompositor(int var1, int var2);

    @WrapForJNI
    private native void pauseCompositor();

    @WrapForJNI
    private native void syncResumeResizeCompositor(int var1, int var2);

    @WrapForJNI
    private native void syncInvalidateAndScheduleComposite();

    synchronized void serverSurfaceDestroyed() {
        ThreadUtils.assertOnUiThread();
        this.mServerSurfaceValid = false;
        if (this.mEGLSurfaceForCompositor != null) {
            sEGL.eglDestroySurface(sEGLDisplay, this.mEGLSurfaceForCompositor);
            this.mEGLSurfaceForCompositor = null;
        }
        if (this.mCompositorCreated) {
            this.pauseCompositor();
        }
    }

    synchronized void serverSurfaceChanged(int n, int n2) {
        ThreadUtils.assertOnUiThread();
        this.mWidth = n;
        this.mHeight = n2;
        this.mServerSurfaceValid = true;
        this.mView.post(new Runnable(){

            @Override
            public void run() {
                GLController.this.updateCompositor();
            }
        });
    }

    void updateCompositor() {
        ThreadUtils.assertOnUiThread();
        if (this.mCompositorCreated) {
            this.resumeCompositor(this.mWidth, this.mHeight);
            return;
        }
        if (!this.AttemptPreallocateEGLSurfaceForCompositor()) {
            return;
        }
        if (this.mView.getLayerClient().isGeckoReady()) {
            this.createCompositor(this.mWidth, this.mHeight);
        }
    }

    void compositorCreated() {
        this.mCompositorCreated = true;
    }

    public boolean isServerSurfaceValid() {
        return this.mServerSurfaceValid;
    }

    private static void initEGL() {
        if (sEGL != null) {
            return;
        }
        sEGL = (EGL10)EGLContext.getEGL();
        sEGLDisplay = sEGL.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (sEGLDisplay == EGL10.EGL_NO_DISPLAY) {
            Log.w((String)LOGTAG, (String)"can't get EGL display!");
            return;
        }
        int[] nArray = new int[2];
        if (!sEGL.eglInitialize(sEGLDisplay, nArray)) {
            Log.w((String)LOGTAG, (String)"eglInitialize failed");
            return;
        }
        sEGLConfig = GLController.chooseConfig();
    }

    private static EGLConfig chooseConfig() {
        int n;
        int n2;
        int n3;
        int[] nArray;
        int[] nArray2 = new int[1];
        switch (GeckoAppShell.getScreenDepth()) {
            case 24: {
                nArray = CONFIG_SPEC_24BPP;
                n3 = 8;
                n2 = 8;
                n = 8;
                break;
            }
            default: {
                nArray = CONFIG_SPEC_16BPP;
                n = 5;
                n2 = 6;
                n3 = 5;
            }
        }
        if (!sEGL.eglChooseConfig(sEGLDisplay, nArray, null, 0, nArray2) || nArray2[0] <= 0) {
            throw new GLControllerException("No available EGL configurations " + GLController.getEGLError());
        }
        EGLConfig[] eGLConfigArray = new EGLConfig[nArray2[0]];
        if (!sEGL.eglChooseConfig(sEGLDisplay, nArray, eGLConfigArray, nArray2[0], nArray2)) {
            throw new GLControllerException("No EGL configuration for that specification " + GLController.getEGLError());
        }
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        for (EGLConfig eGLConfig : eGLConfigArray) {
            sEGL.eglGetConfigAttrib(sEGLDisplay, eGLConfig, 12324, nArray3);
            sEGL.eglGetConfigAttrib(sEGLDisplay, eGLConfig, 12323, nArray4);
            sEGL.eglGetConfigAttrib(sEGLDisplay, eGLConfig, 12322, nArray5);
            if (nArray3[0] != n || nArray4[0] != n2 || nArray5[0] != n3) continue;
            return eGLConfig;
        }
        throw new GLControllerException("No suitable EGL configuration found");
    }

    private synchronized boolean AttemptPreallocateEGLSurfaceForCompositor() {
        if (this.mEGLSurfaceForCompositor == null) {
            GLController.initEGL();
            try {
                this.mEGLSurfaceForCompositor = sEGL.eglCreateWindowSurface(sEGLDisplay, sEGLConfig, this.mView.getNativeWindow(), null);
                if (this.mEGLSurfaceForCompositor == EGL10.EGL_NO_SURFACE) {
                    this.mEGLSurfaceForCompositor = null;
                }
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"eglCreateWindowSurface threw", (Throwable)exception);
            }
        }
        if (this.mEGLSurfaceForCompositor == null) {
            Log.w((String)LOGTAG, (String)"eglCreateWindowSurface returned no surface!");
        }
        return this.mEGLSurfaceForCompositor != null;
    }

    @WrapForJNI(allowMultithread=true)
    private synchronized EGLSurface createEGLSurface() {
        this.compositorCreated();
        this.AttemptPreallocateEGLSurfaceForCompositor();
        EGLSurface eGLSurface = this.mEGLSurfaceForCompositor;
        this.mEGLSurfaceForCompositor = null;
        return eGLSurface;
    }

    private static String getEGLError() {
        return "Error " + (sEGL == null ? "(no sEGL)" : Integer.valueOf(sEGL.eglGetError()));
    }

    void resumeCompositor(int n, int n2) {
        if (this.mCompositorCreated) {
            this.syncResumeResizeCompositor(n, n2);
            this.mView.requestRender();
        }
    }

    void invalidateAndScheduleComposite() {
        if (this.mCompositorCreated) {
            this.syncInvalidateAndScheduleComposite();
        }
    }

    @WrapForJNI
    private void destroy() {
        this.mCompositorCreated = false;
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GLController.this.disposeNative();
            }
        });
    }

    static {
        CONFIG_SPEC_16BPP = new int[]{12324, 5, 12323, 6, 12322, 5, 12339, 4, 12352, 4, 12344};
        CONFIG_SPEC_24BPP = new int[]{12324, 8, 12323, 8, 12322, 8, 12339, 4, 12352, 4, 12344};
    }

    public static class GLControllerException
    extends RuntimeException {
        public static final long serialVersionUID = 1L;

        GLControllerException(String string2) {
            super(string2);
        }
    }
}

