/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.Configuration;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import java.util.List;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.home.BookmarksListAdapter;
import org.mozilla.gecko.home.BookmarksListView;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.SimpleCursorLoader;

public class BookmarksPanel
extends HomeFragment {
    public static final String LOGTAG = "GeckoBookmarksPanel";
    private static final int LOADER_ID_BOOKMARKS_LIST = 0;
    private static final String BOOKMARKS_FOLDER_INFO = "folder_info";
    private static final String BOOKMARKS_REFRESH_TYPE = "refresh_type";
    private BookmarksListView mList;
    private BookmarksListAdapter mListAdapter;
    private List<BookmarksListAdapter.FolderInfo> mSavedParentStack;
    private View mEmptyView;
    private CursorLoaderCallbacks mLoaderCallbacks;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.home_bookmarks_panel, viewGroup, false);
        this.mList = (BookmarksListView)view.findViewById(R.id.bookmarks_list);
        this.mList.setContextMenuInfoFactory(new HomeContextMenuInfo.Factory(){

            @Override
            public HomeContextMenuInfo makeInfoForCursor(View view, int n, long l, Cursor cursor) {
                int n2 = cursor.getInt(cursor.getColumnIndexOrThrow("type"));
                if (n2 == 0) {
                    return null;
                }
                HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, l);
                homeContextMenuInfo.url = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                homeContextMenuInfo.title = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                homeContextMenuInfo.bookmarkId = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
                homeContextMenuInfo.itemType = HomeContextMenuInfo.RemoveItemType.BOOKMARKS;
                return homeContextMenuInfo;
            }
        });
        return view;
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        HomePager.OnUrlOpenListener onUrlOpenListener = null;
        try {
            onUrlOpenListener = (HomePager.OnUrlOpenListener)this.getActivity();
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(this.getActivity().toString() + " must implement HomePager.OnUrlOpenListener");
        }
        this.mList.setTag("bookmarks");
        this.mList.setOnUrlOpenListener(onUrlOpenListener);
        this.registerForContextMenu((View)this.mList);
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        FragmentActivity fragmentActivity = this.getActivity();
        this.mListAdapter = new BookmarksListAdapter((Context)fragmentActivity, null, this.mSavedParentStack);
        this.mListAdapter.setOnRefreshFolderListener(new BookmarksListAdapter.OnRefreshFolderListener(){

            @Override
            public void onRefreshFolder(BookmarksListAdapter.FolderInfo folderInfo, BookmarksListAdapter.RefreshType refreshType) {
                Bundle bundle = new Bundle();
                bundle.putParcelable(BookmarksPanel.BOOKMARKS_FOLDER_INFO, (Parcelable)folderInfo);
                bundle.putParcelable(BookmarksPanel.BOOKMARKS_REFRESH_TYPE, (Parcelable)refreshType);
                BookmarksPanel.this.getLoaderManager().restartLoader(0, bundle, (LoaderManager.LoaderCallbacks)BookmarksPanel.this.mLoaderCallbacks);
            }
        });
        this.mList.setAdapter((ListAdapter)this.mListAdapter);
        this.mLoaderCallbacks = new CursorLoaderCallbacks();
        this.loadIfVisible();
    }

    public void onDestroyView() {
        this.mList = null;
        this.mListAdapter = null;
        this.mEmptyView = null;
        super.onDestroyView();
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.isVisible()) {
            this.mSavedParentStack = this.mListAdapter.getParentStack();
        }
    }

    @Override
    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mLoaderCallbacks);
    }

    private void updateUiFromCursor(Cursor cursor) {
        if ((cursor == null || cursor.getCount() == 0) && this.mEmptyView == null) {
            ViewStub viewStub = (ViewStub)this.getView().findViewById(R.id.home_empty_view_stub);
            this.mEmptyView = viewStub.inflate();
            ImageView imageView = (ImageView)this.mEmptyView.findViewById(R.id.home_empty_image);
            imageView.setImageResource(R.drawable.icon_bookmarks_empty);
            TextView textView = (TextView)this.mEmptyView.findViewById(R.id.home_empty_text);
            textView.setText(R.string.home_bookmarks_empty);
            this.mList.setEmptyView(this.mEmptyView);
        }
    }

    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            if (bundle == null) {
                return new BookmarksLoader((Context)BookmarksPanel.this.getActivity());
            }
            BookmarksListAdapter.FolderInfo folderInfo = (BookmarksListAdapter.FolderInfo)bundle.getParcelable(BookmarksPanel.BOOKMARKS_FOLDER_INFO);
            BookmarksListAdapter.RefreshType refreshType = (BookmarksListAdapter.RefreshType)bundle.getParcelable(BookmarksPanel.BOOKMARKS_REFRESH_TYPE);
            return new BookmarksLoader((Context)BookmarksPanel.this.getActivity(), folderInfo, refreshType);
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            BookmarksLoader bookmarksLoader = (BookmarksLoader)loader;
            BookmarksPanel.this.mListAdapter.swapCursor(cursor, bookmarksLoader.getFolderInfo(), bookmarksLoader.getRefreshType());
            BookmarksPanel.this.updateUiFromCursor(cursor);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            if (BookmarksPanel.this.mList != null) {
                BookmarksPanel.this.mListAdapter.swapCursor(null);
            }
        }
    }

    private static class BookmarksLoader
    extends SimpleCursorLoader {
        private final BookmarksListAdapter.FolderInfo mFolderInfo;
        private final BookmarksListAdapter.RefreshType mRefreshType;
        private final BrowserDB mDB;

        public BookmarksLoader(Context context) {
            this(context, new BookmarksListAdapter.FolderInfo(0, context.getResources().getString(R.string.bookmarks_title)), BookmarksListAdapter.RefreshType.CHILD);
        }

        public BookmarksLoader(Context context, BookmarksListAdapter.FolderInfo folderInfo, BookmarksListAdapter.RefreshType refreshType) {
            super(context);
            this.mFolderInfo = folderInfo;
            this.mRefreshType = refreshType;
            this.mDB = GeckoProfile.get(context).getDB();
        }

        @Override
        public Cursor loadCursor() {
            return this.mDB.getBookmarksInFolder(this.getContext().getContentResolver(), this.mFolderInfo.id);
        }

        public void onContentChanged() {
            this.mDB.invalidate();
            super.onContentChanged();
        }

        public BookmarksListAdapter.FolderInfo getFolderInfo() {
            return this.mFolderInfo;
        }

        public BookmarksListAdapter.RefreshType getRefreshType() {
            return this.mRefreshType;
        }
    }
}

