/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.PanelBackItemView;
import org.mozilla.gecko.home.PanelHeaderView;
import org.mozilla.gecko.home.PanelItemView;
import org.mozilla.gecko.home.PanelLayout;

public class PanelRecyclerViewAdapter
extends RecyclerView.Adapter<PanelViewHolder> {
    private static final int VIEW_TYPE_ITEM = 0;
    private static final int VIEW_TYPE_BACK = 1;
    private static final int VIEW_TYPE_HEADER = 2;
    private final Context context;
    private final HomeConfig.ViewConfig viewConfig;
    private PanelLayout.FilterManager filterManager;
    private Cursor cursor;

    public PanelRecyclerViewAdapter(Context context, HomeConfig.ViewConfig viewConfig) {
        this.context = context;
        this.viewConfig = viewConfig;
    }

    public void setFilterManager(PanelLayout.FilterManager filterManager) {
        this.filterManager = filterManager;
    }

    private boolean isShowingBack() {
        return this.filterManager != null && this.filterManager.canGoBack();
    }

    public void swapCursor(Cursor cursor) {
        this.cursor = cursor;
        this.notifyDataSetChanged();
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public int getItemViewType(int n) {
        if (this.viewConfig.hasHeaderConfig() && n == 0) {
            return 2;
        }
        if (this.isShowingBack() && n == this.getBackPosition()) {
            return 1;
        }
        return 0;
    }

    public PanelViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        switch (n) {
            case 2: {
                return PanelViewHolder.create((View)new PanelHeaderView(this.context, this.viewConfig.getHeaderConfig()));
            }
            case 1: {
                return PanelViewHolder.create((View)new PanelBackItemView(this.context, this.viewConfig.getBackImageUrl()));
            }
            case 0: {
                return PanelViewHolder.create((View)PanelItemView.create(this.context, this.viewConfig.getItemType()));
            }
        }
        throw new IllegalArgumentException("Unknown view type: " + n);
    }

    public void onBindViewHolder(PanelViewHolder panelViewHolder, int n) {
        View view = ((FrameLayout)panelViewHolder.itemView).getChildAt(0);
        if (this.viewConfig.hasHeaderConfig() && n == 0) {
            return;
        }
        if (this.isShowingBack() && n == this.getBackPosition()) {
            PanelBackItemView panelBackItemView = (PanelBackItemView)view;
            panelBackItemView.updateFromFilter(this.filterManager.getPreviousFilter());
            return;
        }
        int n2 = n - (this.isShowingBack() ? 1 : 0) - (this.viewConfig.hasHeaderConfig() ? 1 : 0);
        this.cursor.moveToPosition(n2);
        PanelItemView panelItemView = (PanelItemView)view;
        panelItemView.updateFromCursor(this.cursor);
    }

    private int getBackPosition() {
        return this.viewConfig.hasHeaderConfig() ? 1 : 0;
    }

    public int getItemCount() {
        if (this.cursor == null) {
            return 0;
        }
        return this.cursor.getCount() + (this.isShowingBack() ? 1 : 0) + (this.viewConfig.hasHeaderConfig() ? 1 : 0);
    }

    public static class PanelViewHolder
    extends RecyclerView.ViewHolder {
        public static PanelViewHolder create(View view) {
            FrameLayout frameLayout = (FrameLayout)LayoutInflater.from((Context)view.getContext()).inflate(R.layout.panel_item_container, null);
            frameLayout.addView(view, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            return new PanelViewHolder((View)frameLayout);
        }

        private PanelViewHolder(View view) {
            super(view);
        }
    }
}

