/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.RemoteClientsDialogFragment;
import org.mozilla.gecko.RemoteTabsExpandableListAdapter;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.db.RemoteTab;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.RemoteTabsBaseFragment;
import org.mozilla.gecko.home.TwoLinePageRow;

public class RemoteTabsSplitPlaneFragment
extends RemoteTabsBaseFragment {
    private static final String LOGTAG = "GeckoSplitPlaneFragment";
    private ArrayAdapter<RemoteTab> mTabsAdapter;
    private ArrayAdapter<RemoteClient> mClientsAdapter;
    private DataSetObserver mObserver;
    private HomeListView mClientList;
    private HomeListView mTabList;

    public static RemoteTabsSplitPlaneFragment newInstance() {
        return new RemoteTabsSplitPlaneFragment();
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_remote_tabs_split_plane_panel, viewGroup, false);
    }

    @Override
    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.mClientList = (HomeListView)view.findViewById(R.id.clients_list);
        this.mTabList = (HomeListView)view.findViewById(R.id.tabs_list);
        this.mClientList.setTag("remote_tabs");
        this.mTabList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                RemoteTab remoteTab = (RemoteTab)adapterView.getItemAtPosition(n);
                if (remoteTab == null) {
                    return;
                }
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM, "remote_tabs");
                RemoteTabsSplitPlaneFragment.this.mUrlOpenListener.onUrlOpen(remoteTab.url, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
            }
        });
        this.mClientList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                RemoteClient remoteClient = (RemoteClient)adapterView.getItemAtPosition(n);
                if (remoteClient != null) {
                    RemoteTabsBaseFragment.sState.setClientAsSelected(remoteClient.guid);
                    RemoteTabsSplitPlaneFragment.this.mTabsAdapter.clear();
                    for (RemoteTab remoteTab : remoteClient.tabs) {
                        RemoteTabsSplitPlaneFragment.this.mTabsAdapter.add((Object)remoteTab);
                    }
                    RemoteTabsSplitPlaneFragment.this.mClientsAdapter.notifyDataSetChanged();
                    RemoteTabsSplitPlaneFragment.this.mTabsAdapter.notifyDataSetChanged();
                }
            }
        });
        this.mTabList.setContextMenuInfoFactory(new HomeContextMenuInfo.ListFactory(){

            @Override
            public HomeContextMenuInfo makeInfoForCursor(View view, int n, long l, Cursor cursor) {
                return null;
            }

            @Override
            public HomeContextMenuInfo makeInfoForAdapter(View view, int n, long l, ListAdapter listAdapter) {
                RemoteTab remoteTab = (RemoteTab)listAdapter.getItem(n);
                HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, l);
                homeContextMenuInfo.url = remoteTab.url;
                homeContextMenuInfo.title = remoteTab.title;
                return homeContextMenuInfo;
            }
        });
        this.mClientList.setContextMenuInfoFactory(new HomeContextMenuInfo.ListFactory(){

            @Override
            public HomeContextMenuInfo makeInfoForCursor(View view, int n, long l, Cursor cursor) {
                return null;
            }

            @Override
            public HomeContextMenuInfo makeInfoForAdapter(View view, int n, long l, ListAdapter listAdapter) {
                RemoteClient remoteClient = (RemoteClient)listAdapter.getItem(n);
                return new RemoteTabsBaseFragment.RemoteTabsClientContextMenuInfo(view, n, l, remoteClient);
            }
        });
        this.registerForContextMenu((View)this.mClientList);
        this.registerForContextMenu((View)this.mTabList);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        this.mClientList.setOnItemClickListener(null);
        this.mTabList.setOnItemClickListener(null);
        this.mClientList = null;
        this.mTabList = null;
        this.mEmptyView = null;
        this.mAdapter.unregisterDataSetObserver(this.mObserver);
        this.mObserver = null;
    }

    @Override
    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mFooterView = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.home_remote_tabs_hidden_devices_footer, (ViewGroup)this.mClientList, false);
        View view = this.mFooterView.findViewById(R.id.hidden_devices);
        view.setClickable(true);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                RemoteClientsDialogFragment remoteClientsDialogFragment = RemoteClientsDialogFragment.newInstance(RemoteTabsSplitPlaneFragment.this.getResources().getString(R.string.home_remote_tabs_hidden_devices_title), RemoteTabsSplitPlaneFragment.this.getResources().getString(R.string.home_remote_tabs_unhide_selected_devices), RemoteClientsDialogFragment.ChoiceMode.MULTIPLE, new ArrayList<RemoteClient>(RemoteTabsSplitPlaneFragment.this.mHiddenClients));
                remoteClientsDialogFragment.setTargetFragment(RemoteTabsSplitPlaneFragment.this, 0);
                remoteClientsDialogFragment.show(RemoteTabsSplitPlaneFragment.this.getActivity().getSupportFragmentManager(), "dialog_tag_remote_tabs");
            }
        });
        this.mClientList.addFooterView(this.mFooterView, null, true);
        this.mAdapter = new RemoteTabsExpandableListAdapter(R.layout.home_remote_tabs_group, R.layout.home_remote_tabs_child, null, false);
        this.mTabsAdapter = new RemoteTabsAdapter((Context)this.getActivity(), R.layout.home_remote_tabs_child);
        this.mClientsAdapter = new RemoteClientAdapter((Context)this.getActivity(), R.layout.home_remote_tabs_group, this.mAdapter);
        this.mTabsAdapter.setNotifyOnChange(false);
        this.mClientsAdapter.setNotifyOnChange(false);
        this.mTabList.setAdapter((ListAdapter)this.mTabsAdapter);
        this.mClientList.setAdapter((ListAdapter)this.mClientsAdapter);
        this.mObserver = new RemoteTabDataSetObserver();
        this.mAdapter.registerDataSetObserver(this.mObserver);
        this.mClientList.removeFooterView(this.mFooterView);
        this.mClientList.setOnTouchListener(new ListTouchListener((AbsListView)this.mClientList));
        this.mTabList.setOnTouchListener(new ListTouchListener((AbsListView)this.mTabList));
        this.mCursorLoaderCallbacks = new RemoteTabsBaseFragment.CursorLoaderCallbacks(this);
        this.loadIfVisible();
    }

    @Override
    protected void updateUiFromClients(List<RemoteClient> list, List<RemoteClient> list2) {
        TextView textView;
        if (this.getView() == null) {
            return;
        }
        boolean bl = false;
        if (list2 == null || list2.isEmpty()) {
            this.mClientList.removeFooterView(this.mFooterView);
        } else {
            bl = true;
            textView = (TextView)this.mFooterView.findViewById(R.id.hidden_devices);
            if (list2.size() == 1) {
                textView.setText((CharSequence)this.getResources().getString(R.string.home_remote_tabs_one_hidden_device));
            } else {
                textView.setText((CharSequence)this.getResources().getString(R.string.home_remote_tabs_many_hidden_devices, new Object[]{list2.size()}));
            }
            if (this.mClientList.getFooterViewsCount() < 1) {
                this.mClientList.addFooterView(this.mFooterView);
            }
        }
        if (list != null && !list.isEmpty()) {
            bl = true;
        }
        if (bl) {
            return;
        }
        if (this.mEmptyView == null) {
            textView = (ViewStub)this.getView().findViewById(R.id.home_empty_view_stub);
            this.mEmptyView = textView.inflate();
            ImageView imageView = (ImageView)this.mEmptyView.findViewById(R.id.home_empty_image);
            imageView.setImageResource(R.drawable.icon_remote_tabs_empty);
            TextView textView2 = (TextView)this.mEmptyView.findViewById(R.id.home_empty_text);
            textView2.setText(R.string.home_remote_tabs_empty);
            this.mClientList.setEmptyView(this.mEmptyView);
        }
    }

    private class ListTouchListener
    implements View.OnTouchListener {
        private final AbsListView listView;

        public ListTouchListener(AbsListView absListView) {
            this.listView = absListView;
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            int n = motionEvent.getAction();
            switch (n) {
                case 0: {
                    RemoteTabsSplitPlaneFragment.this.mRefreshLayout.setEnabled(this.listView.getCount() <= 0 || this.listView.getFirstVisiblePosition() <= 0 && this.listView.getChildAt(0).getTop() >= 0);
                    break;
                }
                case 1: 
                case 3: {
                    RemoteTabsSplitPlaneFragment.this.mRefreshLayout.setEnabled(true);
                }
            }
            return false;
        }
    }

    private class RemoteClientAdapter
    extends ArrayAdapter<RemoteClient> {
        private final Context context;
        private final int resource;
        private final RemoteTabsExpandableListAdapter adapter;

        public RemoteClientAdapter(Context context, int n, RemoteTabsExpandableListAdapter remoteTabsExpandableListAdapter) {
            super(context, n);
            this.context = context;
            this.resource = n;
            this.adapter = remoteTabsExpandableListAdapter;
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            Object object;
            View view2;
            if (view != null) {
                view2 = view;
            } else {
                object = LayoutInflater.from((Context)this.context);
                view2 = object.inflate(this.resource, viewGroup, false);
                RemoteTabsExpandableListAdapter.GroupViewHolder groupViewHolder = new RemoteTabsExpandableListAdapter.GroupViewHolder(view2);
                view2.setTag((Object)groupViewHolder);
            }
            object = (RemoteClient)this.getItem(n);
            boolean bl = object.guid.equals(RemoteTabsBaseFragment.sState.selectedClient);
            this.adapter.updateClientsItemView(bl, this.context, view2, (RemoteClient)this.getItem(n));
            return view2;
        }
    }

    private static class RemoteTabsAdapter
    extends ArrayAdapter<RemoteTab> {
        private final Context context;
        private final int resource;

        public RemoteTabsAdapter(Context context, int n) {
            super(context, n);
            this.context = context;
            this.resource = n;
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            Object object;
            TwoLinePageRow twoLinePageRow;
            if (view != null) {
                twoLinePageRow = (TwoLinePageRow)view;
            } else {
                object = LayoutInflater.from((Context)this.context);
                twoLinePageRow = (TwoLinePageRow)object.inflate(this.resource, viewGroup, false);
            }
            object = (RemoteTab)this.getItem(n);
            twoLinePageRow.update(object.title, object.url);
            return twoLinePageRow;
        }
    }

    private class RemoteTabDataSetObserver
    extends DataSetObserver {
        private RemoteTabDataSetObserver() {
        }

        public void onChanged() {
            super.onChanged();
            RemoteTabsSplitPlaneFragment.this.mClientsAdapter.clear();
            RemoteTabsSplitPlaneFragment.this.mTabsAdapter.clear();
            RemoteClient remoteClient = null;
            for (int i = 0; i < RemoteTabsSplitPlaneFragment.this.mAdapter.getGroupCount(); ++i) {
                RemoteClient remoteClient2 = (RemoteClient)RemoteTabsSplitPlaneFragment.this.mAdapter.getGroup(i);
                RemoteTabsSplitPlaneFragment.this.mClientsAdapter.add((Object)remoteClient2);
                if (i == 0) {
                    remoteClient = remoteClient2;
                }
                if (!remoteClient2.guid.equals(RemoteTabsBaseFragment.sState.selectedClient)) continue;
                remoteClient = remoteClient2;
            }
            ArrayList arrayList = remoteClient != null ? remoteClient.tabs : new ArrayList();
            for (RemoteTab remoteTab : arrayList) {
                RemoteTabsSplitPlaneFragment.this.mTabsAdapter.add((Object)remoteTab);
            }
            RemoteTabsBaseFragment.sState.setClientAsSelected(remoteClient != null ? remoteClient.guid : null);
            RemoteTabsSplitPlaneFragment.this.mTabsAdapter.notifyDataSetChanged();
            RemoteTabsSplitPlaneFragment.this.mClientsAdapter.notifyDataSetChanged();
        }

        public void onInvalidated() {
            super.onInvalidated();
            RemoteTabsSplitPlaneFragment.this.mClientsAdapter.clear();
            RemoteTabsSplitPlaneFragment.this.mTabsAdapter.clear();
            RemoteTabsSplitPlaneFragment.this.mTabsAdapter.notifyDataSetChanged();
            RemoteTabsSplitPlaneFragment.this.mClientsAdapter.notifyDataSetChanged();
        }
    }
}

